/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "progress.h"

#include "default.h"
#include "resource.h"
#include "handler.h"
#include "main_gui.h"
#include "wysiwyg.h"

static FL_FORM    *pfForm=NULL;
static FL_OBJECT  *pfMessage;
static FL_OBJECT  *pfFrame;
static FL_OBJECT  *pfSTitle;
static FL_OBJECT  *pfSektion;
static FL_OBJECT  *pfATitle;
static FL_OBJECT  *pfActual;
static FL_OBJECT  *pfAbort;

static FL_OBJECT  *obj;
static int        abortProgress;

static double     minA,maxA,stepA,actA;
static double     minB,maxB,stepB,actB;

static int        lockProgress=0;

/* lock progress */
void xwLockProgress(void)
{
   lockProgress=1;
   return;
}

/* unlock progress */
void xwUnLockProgress(void)
{
   lockProgress=0;
   return;
}

/* Open Progressbar */
int xwOpenProgress(double aMin,double aMax,double aStep,double bMin,double bMax,double bStep)
{
   if (xwAskRealMode()==0)
   {
      if (lockProgress<=1)
      {
         if (lockProgress!=0) lockProgress=2;

         abortProgress=-1;

         minA=aMin; maxA=aMax; stepA=aStep; actA=minA;
         minB=bMin; maxB=bMax; stepB=bStep; actB=minB;

         pfForm = fl_bgn_form(FL_UP_BOX, 610,95+25+25+10);
         fl_set_border_width(1);

         /* Message */
         pfMessage = fl_add_box(FL_DOWN_BOX,5,5,600,20,"");

         pfFrame = fl_add_frame(FL_DOWN_FRAME,6,31,598,93,""); 

         pfSTitle = fl_add_box(FL_DOWN_BOX,10,35,590,20,xwGR(1,"pf.Section","Section..."));

         pfSektion=fl_add_slider(FL_HOR_FILL_SLIDER,10,55,590,20,"");
         fl_set_object_lalign(pfSektion,FL_ALIGN_TOP);
         fl_set_object_lsize(pfSektion,FL_SMALL_SIZE);
         fl_set_slider_bounds(pfSektion,minA,maxA);
         fl_set_slider_step(pfSektion,stepA);
         fl_set_slider_value(pfSektion,actA);
         fl_set_object_color(pfSektion,FL_COL1,FL_BLUE);

         pfATitle = fl_add_box(FL_DOWN_BOX,10,80,590,20,xwGR(1,"pf.Actual","Actual..."));

         pfActual=fl_add_slider(FL_HOR_FILL_SLIDER,10,100,590,20,"");
         fl_set_object_lalign(pfActual,FL_ALIGN_TOP);
         fl_set_object_lsize(pfActual,FL_SMALL_SIZE);
         fl_set_slider_bounds(pfActual,minB,maxB);
         fl_set_slider_step(pfActual,stepB);
         fl_set_slider_value(pfActual,actB);
         fl_set_object_color(pfActual,FL_COL1,FL_BLUE);

         pfAbort = fl_add_button(FL_NORMAL_BUTTON,205,130,200,20,xwGR(1,"pf.Abort","Abort"));

         fl_end_form();

         if (xwGetPrefValue(xwgWinPos)==0)
         {
            fl_prepare_form_window(pfForm,FL_PLACE_MOUSE,FL_TRANSIENT,xwGR(1,"pf.Progress","Progress..."));
         }
         else
         {
            fl_prepare_form_window(pfForm,FL_PLACE_CENTER,FL_TRANSIENT,xwGR(1,"pf.Progress","Progress..."));
         }

         fl_set_form_dblbuffer(pfForm,0);
         fl_show_form_window(pfForm);

         fl_set_app_mainform(pfForm);

         /* Exit Handler */
         fl_set_form_atclose(pfForm,nclose_cb,(void *) "1");

         fl_deactivate_object(pfMessage);
         fl_deactivate_object(pfFrame);
         fl_deactivate_object(pfSTitle);
         fl_deactivate_object(pfSektion);
         fl_deactivate_object(pfATitle);
         fl_deactivate_object(pfActual);
      }
   }
   else
   {
      printf("xwGUI: Realmode active !!!\n");
   }
   
   return(0);
}

/* Get Progress Widget */
FL_OBJECT *xwGetPW(int number)
{
   if (xwAskRealMode()==1) return(NULL);
   
   if (number==0) return(pfSektion);
   else if (number==1) return(pfActual);
   
   return(NULL);
}

/* Set new Values */
void xwSetProgress(double ab,double ac)
{
   if (xwAskRealMode()==0)
   {
      if (ab<noUse) actA=ab;
      if (ac<noUse) actB=ac;

      fl_set_slider_value(pfSektion,actA);
      fl_set_slider_value(pfActual,actB);
           
      obj=fl_check_forms();
      if (obj==pfAbort)
      {
         abortProgress=0;
         fl_set_object_label(pfAbort,xwGR(1,"pf.Aborting","Aborting..."));
      }
   }
   
   return;
}

/* Set Bounds */
void xwSetAProgress(double min,double max,double step)
{
   if (xwAskRealMode()==0)
   {
      fl_set_slider_bounds(pfSektion,min,max);
      fl_set_slider_step(pfSektion,step);

      obj=fl_check_forms();
      if (obj==pfAbort)
      {
         abortProgress=0;
         fl_set_object_label(pfAbort,xwGR(1,"pf.Aborting","Aborting..."));
      }
   }
   
   return;
}

/* Set Bounds */
void xwSetBProgress(double min,double max,double step)
{
   if (xwAskRealMode()==0)
   {
      minB=min; maxB=max; stepB=step; actB=minA;

      fl_set_slider_bounds(pfActual,minB,maxB);
      fl_set_slider_step(pfActual,stepB);
      fl_set_slider_value(pfActual,actB);

      obj=fl_check_forms();
      if (obj==pfAbort)
      {
         abortProgress=0;
         fl_set_object_label(pfAbort,xwGR(1,"pf.Aborting","Aborting..."));
      }
   }
   
   return;
}

/* Close Progressbar */
void xwCloseProgress(void)
{
   if ((lockProgress==0) && (pfForm!=NULL))
   {
      fl_hide_form(pfForm);
      fl_free_form(pfForm);
      
      pfForm=NULL;

      /*fl_set_app_mainform(xwGetMainGui());*/
   }
   
   return;
}

/* Set Titles */
void xwSetLabelProgress(const char *message,const char *titleA,const char *titleB)
{
   if (xwAskRealMode()==0)
   {
      if (strlen(message)>0) fl_set_object_label(pfMessage,message);
      if (strlen(titleA)>0) fl_set_object_label(pfSTitle,titleA);
      if (strlen(titleB)>0) fl_set_object_label(pfATitle,titleB);
   }
   
   return;
}

/* Check Progress Abort */
int xwCheckProgress(void)
{
   return(abortProgress);
}

/* Check Progress Abort A */
int xwCheckProgressA(void)
{
   if (pfForm!=NULL) 
   {
      obj=fl_check_forms();
      if ( (obj==pfAbort) && (obj!=NULL) )
      {
         abortProgress=0;
         fl_set_object_label(pfAbort,xwGR(1,"pf.Aborting","Aborting..."));
      }
   }
   else
   {
      abortProgress=-1;
   }
   
   return(abortProgress);
}