/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "printer.h"

#include "base.h"
#include "driver_turboprint.h"
#include "driver_xwtools.h"
#include "error.h"
#include "gfx.h"
#include "handler.h"
#include "paper.h"
#include "pref_printer.h"
#include "progress.h"
#include "prtmanager.h"
#include "resource.h"
#include "variable.h"

static char       strCache[2048]="";
static int        spoolMode=0;

void xwPrintOut(int count,char *source,char *dest)
{
   xwOpenProgress(0,1,1,0,1,1);

   /* If NOT Aborted */
   if (xwCheckProgress()!=0)
   {
      if (count<0)
      {
         xwSetLabelProgress(xwGR(1,"prtf.convert","Convert Image to PNG...")," "," ");

         /* Convert Picture */
         xwGFXPPMTOPNG(source,dest);
      }
      else
      {
         xwSetLabelProgress(xwGR(1,"prtf.print","Print Image/s...")," "," ");

         /* Print Picture */
         xwPrintIt(count,source);
      }
   }

   xwCloseProgress();

   return;
}

/* Print Picture */
void xwPrintIt(int count,char *source)
{
   char           astr[1024];
   char           bstr[1024];
   int            actCount;
   FL_OBJECT      *obj;
   int            ready;
   char           *strptr;

   char           command[1024];

   /* Exec Datas */
   char           cmdD[1024];
   static long    pid;
   static char    args[100][80]; /* Arg Array */
   static char    *argv[100];
   int            prtA,prtB;
   int            status;
   int            bug;

   FILE           *fh;
   FILE           *fhh;
   char           errorMessage[1024];

   char           buf[10240];
   int            size;

   /* Progressbar for Spool-Mode */
   int            spoolActual;
   int            spoolCount;
   struct stat    attribut;

   /* IMAGEMAGIC */
   int            XLPDPI;
   int            YLPDPI;

   float          xwDPI;

   int            total;
   int            act;

   xwDPI=(25.4*(float) xwMM());

   ready=0;

   spoolMode=0;   /* Normal Print */

   /* Set Internal Variables */
   /* Paper and Image Datas in mm */
   xwSetIVarDef("PAPERX",xwGetPaperXSize()/xwMM());
   xwSetIVarDef("PAPERY",xwGetPaperYSize()/xwMM());
   xwSetIVarDef("PICTUREX",xwGetPaperXB()/xwMM());
   xwSetIVarDef("PICTUREY",xwGetPaperYB()/xwMM());
   xwSetIVarDef("LBORDER",xwGetPaperLB()/xwMM());
   xwSetIVarDef("RBORDER",xwGetPaperRB()/xwMM());
   xwSetIVarDef("TBORDER",xwGetPaperTB()/xwMM());
   xwSetIVarDef("BBORDER",xwGetPaperBB()/xwMM());
   /* Paper and Image Datas in Pixel 72 DPI */
   xwSetIVarDef("PAPERXP",(int) (xwGetPaperXSize()/xwDPI)*72);
   xwSetIVarDef("PAPERYP",(int) (xwGetPaperYSize()/xwDPI)*72);
   xwSetIVarDef("PICTUREXP",(int) (xwGetPaperXB()/xwDPI)*72);
   xwSetIVarDef("PICTUREYP",(int) (xwGetPaperYB()/xwDPI)*72);
   xwSetIVarDef("LBORDERP",(int) (xwGetPaperLB()/xwDPI)*72);
   xwSetIVarDef("RBORDERP",(int) (xwGetPaperRB()/xwDPI)*72);
   xwSetIVarDef("TBORDERP",(int) (xwGetPaperTB()/xwDPI)*72);
   xwSetIVarDef("BBORDERP",(int) (xwGetPaperBB()/xwDPI)*72);
   /* Special Variables for ImageMagic */
   strcpy(astr,xwGetVarDef("IMDPI"));
   if (strlen(astr)>0)
   {
      /* Remove this later */
      strptr=strchr(astr,'x');
      strptr[0]=0x00;
      strcpy(bstr,astr);
      XLPDPI=atoi(bstr);
      strptr=strptr+1;
      strcpy(bstr,strptr);
      YLPDPI=atoi(bstr);
   }
   else
   {
      XLPDPI=720;
      YLPDPI=720;
   }
   xwSetIVarDef("XSIZEP",(int) (xwGetPaperXB()/xwDPI)*XLPDPI);
   xwSetIVarDef("YSIZEP",(int) (xwGetPaperYB()/xwDPI)*YLPDPI);

   /* File Datas */
   xwSetVarDef("FILE",source);
   xwSetVarDef("EXECSCRIPT",xwGetFile("","working.script"));
   strcpy(astr,xwGetFile("",""));
   strcat(astr,"/");
   xwSetVarDef("HOME",astr);

   /* Create Script File - working.script */
   if (strcmp(xwGetVarDef("TURBOPRINT"),"TURBOPRINT") == 0)
   {
      /* TurboPrint */
      tpPrintScript();
   }
   else
   {
      /* xwTool's & LP Print Service */
      xwCreatePrinterScript();
   }

   /* external command */
   strcpy(command,xwGetVarDef("EXEC"));
   if (strlen(command)>0)
   {
      strcpy(command,xwGetPrtCommand(command));
      if (strlen(command)>0) strcpy(command,xwInsertVarDef(command));
   }

   /*printf("Command: %s\n\n",command);*/

   /* Standart Script Executation */
   /*strcpy(command,"");*/
   if (strlen(command)==0)
   {
      strcpy(command,"sh ");
      strcat(command,xwGetFile("","working.script"));
   }

   /* Count of Prints */
   fl_set_slider_bounds(xwGetPW(0),0,count);
   fl_set_slider_step(xwGetPW(0),1);
   fl_set_slider_value(xwGetPW(0),0);
   obj=fl_check_forms();
   if (obj!=NULL)
   {
      ready=-1;
   }
   else
   {
      for (actCount=1 ; actCount<=count ; actCount++)
      {
         strcpy(astr,xwGR(1,"prtf.printpage","Print Page #"));
         strcat(astr,IntStr(actCount));
         strcat(astr," / ");
         strcat(astr,IntStr(count));
         xwSetLabelProgress("",astr,"");

         strcpy(astr,xwGR(1,"prtf.progress","Print in Progress..."));
         xwSetLabelProgress("","",astr);

         fl_set_slider_value(xwGetPW(0),actCount);
         obj=fl_check_forms();
         if (obj!=NULL)
         {
            ready=-1;
         }

         /* Print Picture */
         if (ready==0)
         {
            /* Normal Print */
            if (spoolMode==0)
            {
               strcpy(cmdD,command);

               /* Build ArgList */
               prtA=0;
               prtB=0;
               strptr = StrGet(cmdD);
               while (strlen(strptr)>0)
               {
                  strcpy(args[prtA],strptr);

                  if (prtA>-1)
                  {
                     argv[prtB] = args[prtA];
                     prtB++;
                     argv[prtB]=NULL;
                  }
                  prtA++;

                  strptr = StrGet(NULL);
               }

               pid=0;
               bug=0;
               /* create Process */
               if ( (pid=fork()) == 0)
               {
                  unlink(xwGetFile("","error.log"));
                  freopen(xwGetFile("","error.log"),"w",stderr);
                  bug=execvp(args[0],argv);
                  if (bug!=0)
                  {
                     printf("Command  : %s\nErrorCode: %i\n",command,bug);
                  }
                  freopen("/dev/tty","a",stderr);
                  exit(0);
               }

               /* Waiting for end of print */
               while (waitpid(pid,&status,WNOHANG)!=-1)
               {
                  /* Abort Process */
                  if (xwCheckProgressA()==0)
                  {
                     ready=-1;
                     kill(pid,SIGINT);
                     kill(pid,SIGTERM);
                  }

                  /* Display Progressbar */
                  xwToolsProgress(xwGetPW(1));
               }

               /* Error Displaying */
               if ( (fh=fopen(xwGetFile("","error.log"),"rb")) != NULL )
               {
                  if (fgets(errorMessage,1023,fh) != NULL)
                  {
                     fclose(fh);
                     
                     if (strcmp(errorMessage,"ERROR:\n") != 0)
                     {
                        if (strlen(errorMessage)>0) xwDisplayMessage(NULL,errorMessage);
                     }
                  }
                  else
                  {
                     fclose(fh);
                  }
               }
            }
            else
            {
               /* Spoolmode */
            
               spoolCount=0;

               /* Get File Size */
               if (stat(source,&attribut) == 0)
               {
                  spoolCount=attribut.st_size;
               }

               /* Print via Pipe */
               if ( (fh=fopen(source,"rb")) != NULL )
               {
                  spoolActual=0;

                  fl_set_slider_bounds(xwGetPW(1),0,spoolCount);
                  fl_set_slider_step(xwGetPW(1),1);
                  fl_set_slider_value(xwGetPW(1),0);

                  /* Error Stream */
                  strcat(command," 2>");
                  strcat(command,xwGetFile("","error.log"));

                  unlink(xwGetFile("","error.log"));

                  /*printf("%s\n",command);*/

                  if ( (fhh=popen(command,"w")) != NULL )
                  {
                     signal(SIGPIPE,sig_handler);
                     while ( (size=fread(buf,1,sizeof(buf),fh)) > 0)
                     {
                        spoolActual=spoolActual+size;
                        fl_set_slider_value(xwGetPW(1),spoolActual);

                        fl_check_forms();
                        total=0;
                        do
                        {
                           if ((act=fwrite(buf+total,1,size-total,fhh)) >=0)
                           {
                              total +=act;
                           }
                           fl_check_forms();
                        } while (total !=size);

                     }
                     bug=pclose(fhh);
                     bug=bug>>8;
                     printf("%d\n",bug);
                  }
                  fclose(fh);
               }

               /* Error Displaying */
               if ( (fh=fopen(xwGetFile("","error.log"),"rb")) != NULL )
               {
                  if (fgets(errorMessage,1023,fh) != NULL)
                  {
                     fclose(fh);
                     if (strlen(errorMessage)>0) xwDisplayMessage(NULL,errorMessage);
                  }
                  else
                  {
                     fclose(fh);
                  }
               }
            }
         }
      }
   }

   return;
}

/* Extract Command */
char *xwGetPrtCommand(char *astr)
{
   strcpy(strCache,astr);
   xwGetPrtCommands();

   return(strCache);
}

/* Extract Command's */
void xwGetPrtCommands(void)
{
   static char       strResult[2048];
   static char       strVariable[2048];
   unsigned char     *strptr;

   int               strFlag;

   strcpy(strResult,"");
   strcpy(strVariable,"");

   strFlag=0;

   /* search begin of variable */
   strptr=strchr(strCache,'$');
   if (strptr!=NULL)
   {
      strFlag=1;

      /* first part of string */
      strptr[0]='\0';
      strcpy(strResult,strCache);
      strptr=strptr+1;
      strcpy(strVariable,strptr);

      /* search end of variable */
      strptr=strchr(strVariable,'$');
      if (strptr!=NULL)
      {
         /* terminate variable */
         strptr[0]='\0';

         /* Call Special Features from Drivers */
         strUpper(strVariable);

         /* xwTools */
         if (strcmp(strVariable,"XWTOOLS") == 0) xwToolsInfo();

         /* SPOOL */
         if (strcmp(strVariable,"SPOOL") == 0) spoolMode=1;

         /* rest of string */
         strptr=strptr+1;
         strcat(strResult,strptr);

         strcpy(strCache,strResult);
      }
   }

   /* Next Variable, please */
   if (strFlag==1) xwGetPrtCommands();

   return;
}
