/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "pref_xwgui.h"

#include "base.h"
#include "default.h"
#include "error.h"
#include "fileselect.h"
#include "font.h"
#include "frame.h"
#include "gimp_plugin.h"
#include "handler.h"
#include "help.h"
#include "interpreter.h"
#include "language.h"
#include "limits.h"
#include "main_gui.h"
#include "page.h"
#include "paper.h"
#include "pbcache.h"
#include "picture.h"
#include "prtmanager.h"
#include "resource.h"
#include "selectfp.h"
#include "variable.h"
#include "wysiwyg.h"

static prefxwguiform pf;

static struct globalsetting gs[]=
{
/*  Name             Tab Type       Token */
   {"generalset"     , 0,gsNone     ,999},   /* General Settings */
   {"assistent"      , 1,gsChoice   , 12},   /* Assistent starts on startup */
   {"frameset"       , 1,gsFS       , 13},   /* load FrameSet on startup */
   {"picbrowserpath" , 1,gsFS       , 14},   /* Picture Browser Path */
   /*{"usermode"     , 1,gsChoice   , 11},*/   /* User Mode Setting */
   {"guilayout"      , 1,gsChoice   ,  6},   /* GUI Layout */
   {"language"       , 1,gsButton   ,  0},   /* Language Setting */
   {"windowpos"      , 1,gsChoice   ,  2},   /* Window Position */
   {"geoinfo"        , 1,gsChoice   ,  4},   /* Geometry Info */
   {"precision"      , 1,gsChoice   ,  5},   /* xwGUI Precision */
   {"wysiwyg"        , 1,gsChoice   ,  7},   /* WYSIWYG */
   {"gfxset"         , 0,gsNone     ,999},   /* Grafik Settings */
   {"imagequality"   , 1,gsChoice   ,  8},   /* Image Quality Setting */
   {"scalling"       , 1,gsChoice   , 10},   /* Scalling Quality */
   {"pbcache"        , 1,gsButton   ,  9},   /* Delete Picture Browser Cache */
   {"font"           , 1,gsButton   , 15},   /* Font Settings */
   {"viewer"         , 1,gsFS       ,  3},   /* Picture Viewer */
   {"helpset"        , 0,gsNone     ,999},   /* Help Settings */
   {"browser"        , 1,gsFS       ,  1},   /* Browser Setting */

   {""               ,-1,         -1, -1}
};

static int        actSetting=-1; /* Actual Entry Widgets */

static char             afTitleFont[1024]="Courier";
static int              afTitleFontSize=17;
static int              afTitleFontUnderline=0;

void xwPrefxwGUISetup(void)
{
   char           astr[1024],bstr[1024],cstr[1024];

   int            setting;          /* For Entry Numbers */

   int            GUISetting;       /* GUI Setting */
   int            GUILanguage[256]; /* GUI Language */

   char           filename[1024];

   int            wysiwygFlag;      /* Recalculate WYSIWYG Picture */

   /* WYSIWYG Flag */
   wysiwygFlag=0;

   actSetting=-1;

   GUISetting=xwGetPrefValue(xwgGUI);
   strcpy(GUILanguage,xwGetLang());

   pf.form = NULL;
   pf.ready = 0;

   pf.form = fl_bgn_form(FL_UP_BOX, 660,365);
   fl_set_border_width(1);

   /* Paper Browser */
   pf.FrameA = fl_add_frame(FL_DOWN_FRAME,5,5,650,330,"");
   pf.Settings = fl_add_browser(FL_HOLD_BROWSER,10,10,640,300,"");
   fl_set_browser_fontstyle(pf.Settings,FL_FIXED_STYLE);
   fl_set_browser_fontsize(pf.Settings,FL_NORMAL_SIZE);

   pf.Info = fl_add_box(FL_DOWN_BOX,10,312,640,20,xwGR(1,"xwgui.Info","Select an entry for modification, please !!!"));
   fl_set_object_lsize(pf.Info,FL_NORMAL_SIZE);

   pf.OK = fl_add_button(FL_NORMAL_BUTTON,280,340,100,20,xwGR(1,"xwgui.OK","OK"));
   pf.HELP = fl_add_button(FL_NORMAL_BUTTON,555,340,100,20,xwGR(1,"help.HELP","Help"));

   /* Choice Widget 10 */
   pf.Choice = fl_add_choice(FL_DROPLIST_CHOICE,180,312,400,20,"");
   fl_set_object_boxtype(pf.Choice,FL_UP_BOX);
   fl_set_choice_fontstyle(pf.Choice,FL_FIXED_STYLE);
   fl_set_choice_fontsize(pf.Choice,FL_NORMAL_SIZE);

   /* Input */
   pf.FSInput = fl_add_input(FL_NORMAL_INPUT,170,312,400,20,"");
   fl_set_object_lstyle(pf.FSInput,FL_FIXED_STYLE);
   fl_set_object_lsize(pf.FSInput,FL_NORMAL_SIZE);
#ifdef xwWhiteInput
   fl_set_object_color(pf.FSInput,FL_WHITE,FL_WHITE);
#endif
   pf.FS = fl_add_button(FL_NORMAL_BUTTON,570,312,20,20,"@6<");
   fl_set_object_lstyle(pf.FS,FL_FIXED_STYLE);
   fl_set_object_lsize(pf.FS,FL_NORMAL_SIZE);

   /* Button */
   pf.Button = fl_add_button(FL_NORMAL_BUTTON,170,312,400,20,"");
   fl_set_object_lstyle(pf.Button,FL_FIXED_STYLE);
   fl_set_object_lsize(pf.Button,FL_NORMAL_SIZE);

   fl_hide_object(pf.Choice);
   fl_hide_object(pf.FSInput);
   fl_hide_object(pf.FS);
   fl_hide_object(pf.Button);

   fl_end_form();

   if (xwGetPrefValue(xwgWinPos)==0)
   {
      fl_prepare_form_window(pf.form,FL_PLACE_MOUSE,FL_TRANSIENT,xwGR(1,"xwgui.xwGUIPref","xwGUI Pref"));
   }
   else
   {
      fl_prepare_form_window(pf.form,FL_PLACE_CENTER,FL_TRANSIENT,xwGR(1,"xwgui.xwGUIPref","xwGUI Pref"));
   }

   fl_set_form_dblbuffer(pf.form,0);
   fl_show_form_window(pf.form);

   fl_set_app_mainform(pf.form);

   /* Exit Handler */
   fl_set_form_atclose(pf.form,nclose_cb,(void *) "1");

   /* create xwGUI Entrys for browser */
   xwSetxwGUIBrowser(0);

   while (pf.ready==0)
   {
      pf.obj = fl_do_forms();

      /* Get Input Widget */
      if (actSetting>-1)
      {
         if (gs[actSetting].type==gsFS)
         {
            /* Picture Viewer */
            if (gs[actSetting].token==3)
            {
               strcpy(astr,fl_get_input(pf.FSInput));
               if ( (strcmp(xwGetPrefName(xwgPicViewer),astr) != 0) && (strlen(astr)>0) )
               {
                  xwSetPrefName(xwgPicViewer,astr);
               }
            }
            /* Help Browser */
            else if (gs[actSetting].token==1)
            {
               strcpy(astr,fl_get_input(pf.FSInput));
               if ( (strcmp(xwGetHelpBrowser(),astr) != 0) && (strlen(astr)>0) )
               {
                  xwSetHelpBrowser(astr);
               }
            }
            /* FrameSet */
            else if (gs[actSetting].token==13)
            {
               strcpy(astr,fl_get_input(pf.FSInput));
               if ( (strcmp(xwGetPrefName(xwgFrameSet),astr) != 0) && (strlen(astr)>0) )
               {
                  xwSetPrefName(xwgFrameSet,astr);
               }
            }
            /* Picture Browser */
            else if (gs[actSetting].token==14)
            {
               strcpy(astr,fl_get_input(pf.FSInput));
               if ( (strcmp(xwGetPrefName(xwgBrowserPath),astr) != 0) && (strlen(astr)>0) )
               {
                  xwSetPrefName(xwgBrowserPath,astr);
               }
            }
            
            
         }
      }

      /* Accept Paper Setup */
      if (pf.obj == pf.OK)
      {
         pf.ready=-1;
      }

      /* Display Help */
      else if (pf.obj == pf.HELP)
      {
         xwDisplayHelp(PrefxwGUI);
      }

      /* Select Entry */
      else if (pf.obj == pf.Settings)
      {
         actSetting=fl_get_browser(pf.Settings)-1;
         xwSetxwGUIBrowser(1);

         /* Hide All Custom Widgets */
         fl_hide_object(pf.Choice);
         fl_hide_object(pf.FSInput);
         fl_hide_object(pf.FS);
         fl_hide_object(pf.Button);
         fl_show_object(pf.Info);

         if ( (actSetting>-1) && (gs[actSetting].tab!=0) )
         {
            /* Show Type of Widgets */
            if (gs[actSetting].type==gsChoice)
            {
               fl_hide_object(pf.Info);
               fl_show_object(pf.Choice);
               fl_clear_choice(pf.Choice);
            }
            else if (gs[actSetting].type==gsFS)
            {
               fl_hide_object(pf.Info);
               fl_show_object(pf.FSInput);
               fl_show_object(pf.FS);
               fl_set_input(pf.FSInput,"");
            }
            else if (gs[actSetting].type==gsButton)
            {
               fl_hide_object(pf.Info);
               fl_show_object(pf.Button);
               fl_set_object_label(pf.Button,"");
            }

            /* Pref Token */

            /* Assistent on StartUp */
            if (gs[actSetting].token==12)
            {
               strcpy(astr,"xwgui.");
               strcat(astr,gs[actSetting].name);
               fl_set_object_label(pf.Choice,xwGR(1,astr,astr));

               fl_addto_choice(pf.Choice,xwGR(1,"xwgui.asstartup","by startup"));
               fl_addto_choice(pf.Choice,"-----");
               fl_set_choice(pf.Choice,xwGetPrefValue(xwgAssistent)+1);
            }

            /* FrameSet */
            if (gs[actSetting].token==13)
            {
               strcpy(astr,"xwgui.");
               strcat(astr,gs[actSetting].name);
               fl_set_object_label(pf.FSInput,xwGR(1,astr,astr));

               fl_set_input(pf.FSInput,xwGetPrefName(xwgFrameSet));
            }
            
            /* Picture Browser Path */
            if (gs[actSetting].token==14)
            {
               strcpy(astr,"xwgui.");
               strcat(astr,gs[actSetting].name);
               fl_set_object_label(pf.FSInput,xwGR(1,astr,astr));

               fl_set_input(pf.FSInput,xwGetPrefName(xwgBrowserPath));
            }

            /* Usermode */
            else if (gs[actSetting].token==11)
            {
               strcpy(astr,"xwgui.");
               strcat(astr,gs[actSetting].name);
               fl_set_object_label(pf.Choice,xwGR(1,astr,astr));

               fl_addto_choice(pf.Choice,xwGR(1,"xwgui.umbeginner","Beginner"));
               fl_addto_choice(pf.Choice,xwGR(1,"xwgui.umadvanced","Advanced"));
               fl_addto_choice(pf.Choice,xwGR(1,"xwgui.umexpert","Expert"));
               fl_set_choice(pf.Choice,xwGetPrefValue(xwgUsermode)+1);
            }

            /* GUI Layout */
            else if (gs[actSetting].token==6)
            {
               strcpy(astr,"xwgui.");
               strcat(astr,gs[actSetting].name);
               fl_set_object_label(pf.Choice,xwGR(1,astr,astr));

               fl_addto_choice(pf.Choice,xwGR(1,"xwgui.guitextbased","Textbased GUI"));
               fl_addto_choice(pf.Choice,xwGR(1,"xwgui.guiiconbased","Iconbased GUI"));
               fl_set_choice(pf.Choice,xwGetPrefValue(xwgGUI)+1);
            }

            /* Language */
            else if (gs[actSetting].token==0)
            {
               fl_set_object_label(pf.Button,xwGR(1,"xwgui.languageSelect","Langage Selection"));
            
               /*
               strcpy(astr,"xwgui.");
               strcat(astr,gs[actSetting].name);
               fl_set_object_label(pf.Choice,xwGR(1,astr,astr));

               anzCounter=atoi(xwGR(1,"langcount","0"));
               if (anzCounter>0)
               {
                  setting=-1;
                  for (counter=1 ; counter<=anzCounter ; counter++)
                  {
                     strcpy(astr,"lang");
                     strcat(astr,IntStr(counter));
                     fl_addto_choice(pf.Choice,xwGR(1,astr,IntStr(counter)));

                     strcpy(astr,"langcode");
                     strcat(astr,IntStr(counter));
                     strcpy(bstr,xwGR(1,astr,IntStr(counter)));
                     if (strcmp(xwGetLang(),bstr) == 0)
                     {
                        setting=counter;
                     }
                  }
                  if (setting>-1) fl_set_choice(pf.Choice,setting);
               }
               */
            }
            /* Window Position */
            else if (gs[actSetting].token==2)
            {
               strcpy(astr,"xwgui.");
               strcat(astr,gs[actSetting].name);
               fl_set_object_label(pf.Choice,xwGR(1,astr,astr));

               fl_addto_choice(pf.Choice,xwGR(1,"xwgui.windowmouse","Mouse orientate"));
               fl_addto_choice(pf.Choice,xwGR(1,"xwgui.windowcenter","Center"));
               fl_set_choice(pf.Choice,xwGetPrefValue(xwgWinPos)+1);
            }
            /* Geometry Information */
            else if (gs[actSetting].token==4)
            {
               strcpy(astr,"xwgui.");
               strcat(astr,gs[actSetting].name);
               fl_set_object_label(pf.Choice,xwGR(1,astr,astr));

               fl_addto_choice(pf.Choice,xwGR(1,"xwgui.geonodisplay","Hide Information"));
               fl_addto_choice(pf.Choice,xwGR(1,"xwgui.geodisplay","Display Information"));
               fl_set_choice(pf.Choice,xwGetPrefValue(xwgOneLiner)+1);
            }
            /* WYSIWYG */
            else if (gs[actSetting].token==7)
            {
               strcpy(astr,"xwgui.");
               strcat(astr,gs[actSetting].name);
               fl_set_object_label(pf.Choice,xwGR(1,astr,astr));

               fl_addto_choice(pf.Choice,xwGR(1,"xwgui.normalview","Normal (fast)"));
               fl_addto_choice(pf.Choice,xwGR(1,"xwgui.pseudoview","Pseudo (LQ WYSIWYG)"));
               fl_addto_choice(pf.Choice,xwGR(1,"xwgui.realview","Real (HQ WYSIWYG)"));
               fl_set_choice(pf.Choice,xwGetPrefValue(xwgWYSIWYG)+1);
            }
            /* xwGUI Precision */
            else if (gs[actSetting].token==5)
            {
               strcpy(astr,"xwgui.");
               strcat(astr,gs[actSetting].name);
               fl_set_object_label(pf.Choice,xwGR(1,astr,astr));

               fl_addto_choice(pf.Choice,"1 mm");
               fl_addto_choice(pf.Choice,"1/10 mm");
               if (xwGetPrefValue(xwgMM)==1)
               {
                  fl_set_choice(pf.Choice,1);
               }
               else
               {
                  fl_set_choice(pf.Choice,2);
               }
            }
            /* Image Quality */
            else if (gs[actSetting].token==8)
            {
               strcpy(astr,"xwgui.");
               strcat(astr,gs[actSetting].name);
               fl_set_object_label(pf.Choice,xwGR(1,astr,astr));

               fl_addto_choice(pf.Choice,xwGR(1,"xwgui.iqlowlow","lowest quality"));
               fl_addto_choice(pf.Choice,xwGR(1,"xwgui.iqlow","low quality"));
               fl_addto_choice(pf.Choice,xwGR(1,"xwgui.iqmiddle","middle quality"));
               fl_addto_choice(pf.Choice,xwGR(1,"xwgui.iqhigh","high quality"));
               fl_addto_choice(pf.Choice,xwGR(1,"xwgui.iqhighhigh","highest quality"));
               fl_set_choice(pf.Choice,xwGetPrefValue(xwgImgQuality));
            }
            /* Scalling Quality */
            else if (gs[actSetting].token==10)
            {
               strcpy(astr,"xwgui.");
               strcat(astr,gs[actSetting].name);
               fl_set_object_label(pf.Choice,xwGR(1,astr,astr));

               fl_addto_choice(pf.Choice,xwGR(1,"xwgui.easyscall","Simple Scalling"));
               fl_addto_choice(pf.Choice,xwGR(1,"xwgui.interscall","Interpolate Scalling"));
               fl_set_choice(pf.Choice,xwGetPrefValue(xwgScalling)+1);
            }
            /* Delete Picture Browser Cache */
            else if (gs[actSetting].token==9)
            {
               fl_set_object_label(pf.Button,xwGR(1,"xwgui.deletePBC","Delete Picture Browser Cache"));
            }
            /* Configure Font  */
            else if (gs[actSetting].token==15)
            {
               fl_set_object_label(pf.Button,xwGR(1,"xwgui.configfont","Configure Fonts"));
            }
            /* Picture Viewer */
            else if (gs[actSetting].token==3)
            {
               strcpy(astr,"xwgui.");
               strcat(astr,gs[actSetting].name);
               fl_set_object_label(pf.FSInput,xwGR(1,astr,astr));

               fl_set_input(pf.FSInput,xwGetPrefName(xwgPicViewer));
            }
            /* Help Browser */
            else if (gs[actSetting].token==1)
            {
               strcpy(astr,"xwgui.");
               strcat(astr,gs[actSetting].name);
               fl_set_object_label(pf.FSInput,xwGR(1,astr,astr));

               fl_set_input(pf.FSInput,xwGetHelpBrowser());
            }
         }
      }

      /* Results */
      if (actSetting>-1)
      {
         /* Choice */
         if (pf.obj == pf.Choice)
         {
            if (gs[actSetting].type==gsChoice)
            {
               /* Assistent */
               if (gs[actSetting].token==12)
               {
                  xwSetPrefValue(xwgAssistent,fl_get_choice(pf.Choice)-1);
                  xwSetxwGUIBrowser(1);
               }

               /* Usermode */
               if (gs[actSetting].token==11)
               {
                  xwSetPrefValue(xwgUsermode,fl_get_choice(pf.Choice)-1);
                  xwSetxwGUIBrowser(1);
               }

               /* GUI Layout */
               else if ((gs[actSetting].token==6) && (xwGetPrefValue(xwgDepth)>6))
               {
                  xwSetPrefValue(xwgGUI,fl_get_choice(pf.Choice)-1);
                  xwSetxwGUIBrowser(1);
               }
               /* Language */
               else if (gs[actSetting].token==0)
               {
                  setting=fl_get_choice(pf.Choice);
                  strcpy(astr,"langcode");
                  strcat(astr,IntStr(setting));
                  strcpy(bstr,xwGR(1,astr,"en"));
                  xwSetLang(bstr);
                  xwSetxwGUIBrowser(1);
               }
               /* Window Position */
               else if (gs[actSetting].token==2)
               {
                  xwSetPrefValue(xwgWinPos,fl_get_choice(pf.Choice)-1);
                  xwSetxwGUIBrowser(1);
               }
               /* Geometry Information */
               else if (gs[actSetting].token==4)
               {
                  xwSetPrefValue(xwgOneLiner,fl_get_choice(pf.Choice)-1);
                  xwSetxwGUIBrowser(1);
               }
               /* WYSIWYG */
               else if (gs[actSetting].token==7)
               {
                  xwSetPrefValue(xwgWYSIWYG,fl_get_choice(pf.Choice)-1);
                  xwSetxwGUIBrowser(1);
                  wysiwygFlag=1;
               }
               /* xwGUI Precision */
               else if (gs[actSetting].token==5)
               {
                  if (fl_get_choice(pf.Choice)==1)
                  {
                     if (xwGetPrefValue(xwgMM)!=1)
                     {
                        xwConvertMM(0.1);
                        xwSetPrefValue(xwgMM,1);;
                     }
                  }
                  else if (fl_get_choice(pf.Choice)==2)
                  {
                     if (xwGetPrefValue(xwgMM)==1)
                     {
                        xwConvertMM(10);
                        xwSetPrefValue(xwgMM,10);
                     }
                  }
                  xwSetxwGUIBrowser(1);
               }
               /* Image Quality */
               else if (gs[actSetting].token==8)
               {
                  xwSetPrefValue(xwgImgQuality,fl_get_choice(pf.Choice));
                  xwDrawPage(pgRecalc);
                  xwSetxwGUIBrowser(1);
               }
               /* Scalling Quality */
               else if (gs[actSetting].token==10)
               {
                  xwSetPrefValue(xwgScalling,fl_get_choice(pf.Choice)-1);
                  xwDrawPage(pgRecalc);
                  xwSetxwGUIBrowser(1);
               }
            }
         }

         /* Input */
         else if (pf.obj == pf.FSInput)
         {
            if (gs[actSetting].type==gsFS)
            {
               /* Help Browser */
               if (gs[actSetting].token==1)
               {
                  strcpy(astr,fl_get_input(pf.FSInput));
                  if (strlen(astr)<1023) xwSetHelpBrowser(astr);
                  xwSetxwGUIBrowser(1);
               }
               /* Picture Viewer */
               else if (gs[actSetting].token==3)
               {
                  strcpy(astr,fl_get_input(pf.FSInput));
                  if (strlen(astr)<1023) xwSetPrefName(xwgPicViewer,astr);
                  xwSetxwGUIBrowser(1);
               }
               /* FrameSet */
               else if (gs[actSetting].token==13)
               {
                  strcpy(astr,fl_get_input(pf.FSInput));
                  if (strlen(astr)<1023) xwSetPrefName(xwgFrameSet,astr);
                  xwSetxwGUIBrowser(1);
               }
               /* Picture Browser */
               else if (gs[actSetting].token==14)
               {
                  strcpy(astr,fl_get_input(pf.FSInput));
                  if (strlen(astr)<1023) xwSetPrefName(xwgBrowserPath,astr);
                  xwSetxwGUIBrowser(1);
               }
            }

         }
         /* FileSelect */
         else if (pf.obj == pf.FS)
         {
            if (gs[actSetting].type==gsFS)
            {
               /* Help Browser - FileSelect */
               if (gs[actSetting].token==1)
               {
                  xwSetFSPattern("");
                  strcpy(astr,xwGR(1,"fs.SelectFile","Select File, please..."));
                  strcpy(bstr,xwGR(1,"fs.OK","OK"));
                  strcpy(cstr,xwGR(1,"fs.Abort","Abort"));
                  strcpy(filename,xwFileSelect(fsFileAll,"",astr,bstr,cstr));
                  fl_set_app_mainform(pf.form);
                  if (strlen(filename)>0)
                  {
                     xwSetHelpBrowser(filename);
                     fl_set_input(pf.FSInput,xwGetHelpBrowser());
                  }
                  xwSetxwGUIBrowser(1);
               }
               /* Pic Viewer - FileSelect */
               else if (gs[actSetting].token==3)
               {
                  xwSetFSPattern("");
                  strcpy(astr,xwGR(1,"fs.SelectFile","Select File, please..."));
                  strcpy(bstr,xwGR(1,"fs.OK","OK"));
                  strcpy(cstr,xwGR(1,"fs.Abort","Abort"));
                  strcpy(filename,xwFileSelect(fsFileAll,"",astr,bstr,cstr));
                  fl_set_app_mainform(pf.form);
                  if (strlen(filename)>0)
                  {
                     xwSetPrefName(xwgPicViewer,filename);
                     fl_set_input(pf.FSInput,xwGetPrefName(xwgPicViewer));
                  }
                  xwSetxwGUIBrowser(1);
               }
               /* Frameset */
               else if (gs[actSetting].token==13)
               {
                  xwSetFSPattern("frameset");
                  strcpy(astr,xwGR(1,"fs.SelectFile","Select File, please..."));
                  strcpy(bstr,xwGR(1,"fs.OK","OK"));
                  strcpy(cstr,xwGR(1,"fs.Abort","Abort"));
                  strcpy(filename,xwFileSelect(fsFile,"",astr,bstr,cstr));
                  fl_set_app_mainform(pf.form);
                  if (strlen(filename)>0)
                  {
                     xwSetPrefName(xwgFrameSet,filename);
                     fl_set_input(pf.FSInput,xwGetPrefName(xwgFrameSet));
                  }
                  xwSetxwGUIBrowser(1);
               }
               /* Picture Browser Path */
               else if (gs[actSetting].token==14)
               {
                  xwSetFSPattern("");
                  strcpy(astr,xwGR(1,"fs.SelectFile","Select File, please..."));
                  strcpy(bstr,xwGR(1,"fs.OK","OK"));
                  strcpy(cstr,xwGR(1,"fs.Abort","Abort"));
                  strcpy(filename,xwFileSelect(fsPathAll,"",astr,bstr,cstr));
                  fl_set_app_mainform(pf.form);
                  if (strlen(filename)>0)
                  {
                     xwSetPrefName(xwgBrowserPath,filename);
                     fl_set_input(pf.FSInput,xwGetPrefName(xwgBrowserPath));
                  }
                  xwSetxwGUIBrowser(1);
               }
            }
         }
         /* Button */
         else if (pf.obj == pf.Button)
         {
            if (gs[actSetting].type==gsButton)
            {
               /* Delete Picture Browser Cache */
               if (gs[actSetting].token==9)
               {
                  xwDeletePBCache();
                  xwDisplayMessage(pf.form,xwGR(1,"xwgui.PBCready","All Picture Browser Cache Entrys deleted !"));
               }

               /* Configure Fonts */
               else if (gs[actSetting].token==15)
               {
                  fl_deactivate_form(pf.form);
                  xwFontSelect(xwfConfig,afTitleFont,&afTitleFontSize,&afTitleFontUnderline);
                  fl_activate_form(pf.form);  
               }

               /* Language */
               else if (gs[actSetting].token==0)
               {
                  fl_deactivate_form(pf.form);
                  xwSelectLanguage();
                  fl_activate_form(pf.form);  
                  xwSetxwGUIBrowser(1);
               }

            }

         }

      }
   }

   fl_hide_form(pf.form);
   fl_free_form(pf.form);

   if (xwGetPrefValue(xwgAssLock)==0) fl_set_app_mainform(xwGetMainGui());

   /* GUI Change */
   if ((xwGetPrefValue(xwgAssLock)==0) && (GUISetting!=xwGetPrefValue(xwgGUI)))
   {
      if (GUISetting==0) xwSetPrefValue(xwgGUI,0);
      xwCloseMainGui();
      if (GUISetting==0) xwSetPrefValue(xwgGUI,1);
      xwOpenMainGui();

      /* Open Layer Window */
      if (xwGetPrefValue(xwgLayer)>0) xwOpenFP();

      if (xwCheckMainGui()==1)
      {
         /* Gimp Mode */
         if (xwGimpMode()==0)
         {
            /* Load Picture */
            xwFPLoad(xwGetFile("","gimp.data"));
         }

         /* ReDraw Page */
         if (wysiwygFlag==1)
         {
            xwDrawPage(pgRecalc);
         }
         else
         {
            xwDrawPage(pgRedraw);
         }
      }
      else
      {
         xwCloseMainGui();
         printf("xwGUI 2: Fatal Error !!!\nCan't open GUI !!!\n");
         exit(-1);
      }
   }
   else
   {
      /* Language Selection */
      if ((xwGetPrefValue(xwgAssLock)==0) && (strcmp(GUILanguage,xwGetLang()) != 0))
      {
         /* Set Language for Main GUI */
         if (xwGetPrefValue(xwgGUI)!=0)
         {
            xwSetGuiLanguage();
         }
         else
         {
            xwCloseMainGui();
            xwOpenMainGui();

            /* Open Layer Window */
            if (xwGetPrefValue(xwgLayer)>0) xwOpenFP();

            if (xwCheckMainGui()==1)
            {
               /* Gimp Mode */
               if (xwGimpMode()==0)
               {
                  /* Load Picture */
                  xwFPLoad(xwGetFile("","gimp.data"));
               }

               /* ReDraw Page */
               if (wysiwygFlag==1)
               {
                  xwDrawPage(pgRecalc);
               }
               else
               {
                  xwDrawPage(pgRedraw);
               }
            }
            else
            {
               xwCloseMainGui();
               printf("xwGUI 2: Fatal Error !!!\nCan't open GUI !!!\n");
               exit(-1);
            }
         }
      }
      else
      {
         if (wysiwygFlag==1)
         {
            xwDrawPage(pgRecalc);
         }
         else
         {
            xwDrawPage(pgRedraw);
         }
      }
   }

   return;
}

/* Init Browser */
void xwSetxwGUIBrowser(int mo)
{
   char           astr[1024],bstr[1024];
   int            count;
   int            token;

   fl_freeze_form(pf.form);

   fl_clear_browser(pf.Settings);

   fl_set_object_label(pf.Info,xwGR(1,"xwgui.Info","Select an entry for modification, please !!!"));

   token=0;
   count=0;
   while (token>-1)
   {
      token=gs[count].token;
      if (token>-1)
      {
         strcpy(astr,"xwgui.");
         strcat(astr,gs[count].name);
         strcpy(bstr,xwGR(1,astr,gs[count].name));
         if (gs[count].tab!=0)
         {
            strcpy(astr,"  ");
            strcat(astr,bstr);
            strcpy(bstr,astr);
         }

         strcat(bstr,spaces);
         bstr[30]=0x00;

         /* Token Analyse */

         /* Assistent */
         if (token==12)
         {
            if (xwGetPrefValue(xwgAssistent)==0)
            {
               strcat(bstr,xwGR(1,"xwgui.asstartup","by startup"));
            }
            else if (xwGetPrefValue(xwgAssistent)==1)
            {
               strcat(bstr,"-----");
            }
         }

         /* Frameset on StartUp */
         if (token==13)
         {
            strcat(bstr,xwGetPrefName(xwgFrameSet));
         }
         
         /* Picture Browser Patth */
         if (token==14)
         {
            strcat(bstr,xwGetPrefName(xwgBrowserPath));
         }

         /* Usermode */
         else if (token==11)
         {
            if (xwGetPrefValue(xwgUsermode)==0)
            {
               strcat(bstr,xwGR(1,"xwgui.umbeginner","Beginner"));
            }
            else if (xwGetPrefValue(xwgUsermode)==1)
            {
               strcat(bstr,xwGR(1,"xwgui.umadvanced","Advanced"));
            }
            else if (xwGetPrefValue(xwgUsermode)==2)
            {
               strcat(bstr,xwGR(1,"xwgui.umexpert","Expert"));
            }
         }

         /* GUI Design */
         else if (token==6)
         {
            if (xwGetPrefValue(xwgGUI)==0)
            {
               strcat(bstr,xwGR(1,"xwgui.guitextbased","Textbased GUI"));
            }
            else
            {
               strcat(bstr,xwGR(1,"xwgui.guiiconbased","Iconbased GUI"));
            }
         }

         /* Language */
         else if (token==0) strcat(bstr,xwGetLang());

         /* Browser Entry */
         else if (token==1) strcat(bstr,xwGetHelpBrowser());

         /* Window Position */
         else if (token==2)
         {
            if (xwGetPrefValue(xwgWinPos)==0)
            {
               strcat(bstr,xwGR(1,"xwgui.windowmouse","Mouse orientate"));
            }
            else
            {
               strcat(bstr,xwGR(1,"xwgui.windowcenter","Center"));
            }
         }

         /* Pic Viewer */
         else if (token==3) strcat(bstr,xwGetPrefName(xwgPicViewer));

         /* Geometry Information */
         else if (token==4)
         {
            if (xwGetPrefValue(xwgOneLiner)==0)
            {
               strcat(bstr,xwGR(1,"xwgui.geonodisplay","Hide Information"));
            }
            else
            {
               strcat(bstr,xwGR(1,"xwgui.geodisplay","Display Information"));
            }
         }

         /* WYSIWYG */
         else if (token==7)
         {
            if (xwGetPrefValue(xwgWYSIWYG)==wmNormal)
            {
               strcat(bstr,xwGR(1,"xwgui.normalview","Normal (fast)"));
            }
            else if (xwGetPrefValue(xwgWYSIWYG)==wmLWYSIWYG)
            {
               strcat(bstr,xwGR(1,"xwgui.pseudoview","Pseudo (LQ WYSIWYG)"));
            }
            else if (xwGetPrefValue(xwgWYSIWYG)==wmHWYSIWYG)
            {
               strcat(bstr,xwGR(1,"xwgui.realview","Real (WYSIWYG)"));
            }
         }


         /* xwGUI Precision */
         else if (token==5)
         {
            if (xwGetPrefValue(xwgMM)==1)
            {
               strcat(bstr,"1 mm");
            }
            else
            {
               strcat(bstr,"1/10 mm");
            }
         }

         /* Image Quality */
         else if (token==8)
         {
            if (xwGetPrefValue(xwgImgQuality)==1)
            {
               strcat(bstr,xwGR(1,"xwgui.iqlowlow","lowest quality"));
            }
            else if (xwGetPrefValue(xwgImgQuality)==2)
            {
               strcat(bstr,xwGR(1,"xwgui.iqlow","low quality"));
            }
            else if (xwGetPrefValue(xwgImgQuality)==3)
            {
               strcat(bstr,xwGR(1,"xwgui.iqmiddle","middle quality"));
            }
            else if (xwGetPrefValue(xwgImgQuality)==4)
            {
               strcat(bstr,xwGR(1,"xwgui.iqhigh","high quality"));
            }
            else if (xwGetPrefValue(xwgImgQuality)==5)
            {
               strcat(bstr,xwGR(1,"xwgui.iqhighhigh","highest quality"));
            }
         }

         /* Scalling Quality */
         else if (token==10)
         {
            if (xwGetPrefValue(xwgScalling)==0)
            {
               strcat(bstr,xwGR(1,"xwgui.easyscall","simple scalling"));
            }
            else if (xwGetPrefValue(xwgScalling)==1)
            {
               strcat(bstr,xwGR(1,"xwgui.interscall","interpolate scalling"));
            }
         }

         fl_addto_browser(pf.Settings,bstr);

         count++;
      }
   }

   if ( (actSetting>-1) && (mo==1) ) fl_select_browser_line(pf.Settings,actSetting+1);

   fl_unfreeze_form(pf.form);

   return;
}

/* Convert Settings mm <-> 1/10 mm */
void xwConvertMM(float factor)
{
   int            count;
   int            az;

   /* Convert Paper Datas */
   xwSetPaperX(((float) xwGetPaperXSize())*factor);
   xwSetPaperY(((float) xwGetPaperYSize())*factor);
   xwSetPaperLB((int) ( ( ((float) xwGetPaperLB()) *factor) +0.5));
   xwSetPaperRB((int) ( ( ((float) xwGetPaperRB()) *factor) +0.5));
   xwSetPaperTB((int) ( ( ((float) xwGetPaperTB()) *factor) +0.5));
   xwSetPaperBB((int) ( ( ((float) xwGetPaperBB()) *factor) +0.5));

   /* Convert Frames */
   count=xwGetFrameCount();
   if (count>-1)
   {
      for (az=0 ; az<=count ; az++)
      {
         xwSetFrameGeo( az,
                        (int) ( ( ((float) xwGetFrameX(az)) *factor) +0.5),
                        (int) ( ( ((float) xwGetFrameY(az)) *factor) +0.5),
                        (int) ( ( ((float) xwGetFrameW(az)) *factor) +0.5),
                        (int) ( ( ((float) xwGetFrameH(az)) *factor) +0.5));
      }
   }

   /* Convert Pictures */
   count=xwGetPictureCount();
   if (count>-1)
   {
      for (az=0 ; az<=count ; az++)
      {
         xwSetPictureGeo( az,
                          (int) ( ( ((float) xwGetPictureX(az)) *factor) +0.5),
                          (int) ( ( ((float) xwGetPictureY(az)) *factor) +0.5),
                          (int) ( ( ((float) xwGetPictureW(az)) *factor) +0.5),
                          (int) ( ( ((float) xwGetPictureH(az)) *factor) +0.5));
      }
   }

   return;
}