/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWPREFPRINTER_H
#define _XWPREFPRINTER_H

#include <forms.h>
#include <dirent.h>
#include <sys/stat.h>
#include <ctype.h>
#include <unistd.h>
#include <locale.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#define NonePrinterGUI           0
#define InitPrinterGUI           1

typedef struct prefprinterform
{
   /* Main-Form data */
   FL_FORM           *form;
   /* Event Loop */
   FL_OBJECT         *obj;
   int               ready;

   FL_OBJECT         *FrameA;
   FL_OBJECT         *FrameB;
   FL_OBJECT         *FrameC;
   
   FL_OBJECT         *Driver;
   FL_OBJECT         *Printer;

   FL_OBJECT         *SelPrinter;

   FL_OBJECT         *SelA;
   FL_OBJECT         *SelB;
   FL_OBJECT         *SelC;
   FL_OBJECT         *SelD;

   FL_OBJECT         *LOAD;
   FL_OBJECT         *SAVE;
   FL_OBJECT         *DELETE;
   FL_OBJECT         *RESET;
   
   FL_OBJECT         *OK;
   FL_OBJECT         *HELP;   
} prefprinterform;


void xwPrefPrinterSetup(void);


/* Check Driver, Printer und Settings */
void xwCheckPrinterSetup(int mo);


/* ########## Driver Files ########## */

/* Get Driver File */
char *xwGetPrefDriver(void);
/* Set Driver File */
void xwSetPrefDriver(char *file);
/* Read Def Files */
void xwReadPrinterDef(FL_OBJECT *widget);
/* read Directory */
void xwPrinterScan(void);
/* Compare for Sort */
int xwPrinterSort(const void *Z1,const void *Z2);

/* ########## Printer ########## */

/* Get Printer File */
char *xwGetPrefPrinter(void);
/* Set Printer File */
void xwSetPrefPrinter(char *file);

/* ########## setting File ########## */

/* Get Setting File */
char *xwGetPrefSetting(void);
/* Set Setting File */
void xwSetPrefSetting(char *file);


#endif