/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "pref_printer.h"

#include "base.h"
#include "default.h"
#include "error.h"
#include "fileselect.h"
#include "handler.h"
#include "help.h"
#include "interpreter.h"
#include "main_gui.h"
#include "prtgui.h"
#include "prtmanager.h"
#include "resource.h"
#include "variable.h"

static prefprinterform pf;

/* Directory Buffer */
static char                *dbuf[1024];
static int                 dentrys=-1;

/* Internal Pref Datas */
static char                DriverFile[1024]="";
static char                PrinterModel[256]="";
static int                 PrinterEntry=-1;
static char                PrinterSetting[256]="Default";

static int                 PrinterGUI=-1;

void xwPrefPrinterSetup(void)
{
   int            err;

   /* FileSelection */
   char           astr[80],bstr[80],cstr[80];
   const char     *filename;
   int            az;

   /* Init Prt GUI Datas */
   xwInitGUI();

   PrinterGUI=-1;
   
   pf.form = NULL;
   pf.ready = 0;

   pf.form = fl_bgn_form(FL_UP_BOX,690,550);
   fl_set_border_width(1);

   /* Paper Browser */
   pf.FrameA = fl_add_frame(FL_DOWN_FRAME,5,5,170,515,"");
   pf.Driver = fl_add_browser(FL_HOLD_BROWSER,10,10,160,100,"");
   pf.Printer = fl_add_browser(FL_HOLD_BROWSER,10,110,160,405,"");

   pf.FrameB = fl_add_frame(FL_DOWN_FRAME,180,5,505,515,"");

   pf.SelPrinter = fl_add_box(FL_DOWN_BOX,185,10,495,20,"");
   pf.SelA = fl_add_button(FL_NORMAL_BUTTON,185,35,123,20,"");
   pf.SelB = fl_add_button(FL_NORMAL_BUTTON,308,35,124,20,"");
   pf.SelC = fl_add_button(FL_NORMAL_BUTTON,432,35,125,20,"");
   pf.SelD = fl_add_button(FL_NORMAL_BUTTON,557,35,123,20,"");

   pf.FrameC =  fl_add_frame(FL_DOWN_FRAME,186,57,492,432,""); /* 540 */

   pf.LOAD   = fl_add_button(FL_NORMAL_BUTTON,185,494,123,20,xwGR(1,"prtp.Load","Load"));
   pf.SAVE   = fl_add_button(FL_NORMAL_BUTTON,308,494,124,20,xwGR(1,"prtp.Save","Save"));
   pf.DELETE = fl_add_button(FL_NORMAL_BUTTON,432,494,125,20,xwGR(1,"prtp.Delete","Delete"));
   pf.RESET  = fl_add_button(FL_NORMAL_BUTTON,557,494,123,20,xwGR(1,"prtp.Reset","Reset"));

   pf.OK = fl_add_button(FL_NORMAL_BUTTON,295,525,100,20,xwGR(1,"prtp.OK","OK"));
   pf.HELP = fl_add_button(FL_NORMAL_BUTTON,585,525,100,20,xwGR(1,"help.HELP","Help"));

   fl_end_form();

   /* Read Printer Def Files */
   xwReadPrinterDef(pf.Driver);

   if (xwGetPrefValue(xwgWinPos)==0)
   {
      fl_prepare_form_window(pf.form,FL_PLACE_MOUSE,FL_TRANSIENT,xwGR(1,"prtp.PrinterPref","Printer Pref"));
   }
   else
   {
      fl_prepare_form_window(pf.form,FL_PLACE_CENTER,FL_TRANSIENT,xwGR(1,"prtp.PrinterPref","Printer Pref"));
   }

   fl_set_form_dblbuffer(pf.form,0);
   fl_show_form_window(pf.form);

   fl_freeze_form(pf.form);

   /* Activate Selected Entrys */
   xwCheckPrinterSetup(InitPrinterGUI);

   fl_unfreeze_form(pf.form);

   fl_set_app_mainform(pf.form);

   /* Exit Handler */
   fl_set_form_atclose(pf.form,nclose_cb,(void *) "1");

   while (pf.ready==0)
   {
      pf.obj = fl_do_forms();

      xwCheckGUI(pf.obj,PrinterGUI,PrinterEntry);

      /* Accept Paper Setup */
      if (pf.obj == pf.OK)
      {
         pf.ready=-1;
         /* save settings */
         xwSavePrinterSetting(DriverFile,PrinterModel,PrinterSetting,PrinterEntry);
      }

      /* Display Help */
      else if (pf.obj == pf.HELP)
      {
         xwDisplayHelp(PrefPrint);
      }

      /* ----------------------------------------- */

      /* Select Driver File */
      else if (pf.obj == pf.Driver)
      {
         /* save settings */
         xwSavePrinterSetting(DriverFile,PrinterModel,PrinterSetting,PrinterEntry);

         /* Remove GUI */
         xwDeleteGUI();

         /* Delete all Variables */
         xwDInitVarDef();
         /* Delete all Printer Datas */
         xwDInitPrtManager();

         /* Interpret Selected File */
         strcpy(DriverFile,xwGetIP(NULL));
         strcat(DriverFile,"/");
         strcat(DriverFile,fl_get_browser_line(pf.Driver,fl_get_browser(pf.Driver)));
         err=xwInterpret(DriverFile,pf.form);

         /* Delete Printer Model */
         strcpy(PrinterModel,"");

         /* Initialize Index */
         xwCreatePrinterIndex();

         /* Activate Selected Entrys */
         xwCheckPrinterSetup(NonePrinterGUI);
      }

      /* Select Printer Model */
      else if (pf.obj == pf.Printer)
      {
         /* save settings */
         xwSavePrinterSetting(DriverFile,PrinterModel,PrinterSetting,PrinterEntry);

         /* Remove GUI */
         xwDeleteGUI();
         PrinterGUI=-1;

         /* Delete all Variables */
         xwDInitVarDef();

         /* Selected Printer Model */
         strcpy(PrinterModel,fl_get_browser_line(pf.Printer,fl_get_browser(pf.Printer)));

         /* Activate Selected Entrys */
         xwCheckPrinterSetup(NonePrinterGUI);

         /* Set Setting-File to Default */
         strcpy(PrinterSetting,"Default");

         /* Set Settings to Default */
         xwSetDefaults(PrinterEntry);

         /* Load User Settings */
         xwLoadPrinterSetting(DriverFile,PrinterModel,PrinterSetting);
         
         /* Activate Selected Entrys */
         fl_freeze_form(pf.form);
         xwCheckPrinterSetup(InitPrinterGUI);
         fl_unfreeze_form(pf.form);
      }

      /* ----------------------------------------- */

      /* Select an Printer GUI */
      else if (pf.obj == pf.SelA)
      {
         /* Remove GUI */
         fl_freeze_form(pf.form);
         xwDeleteGUI();
         fl_set_object_color(pf.SelA,FL_YELLOW,FL_MCOL);
         fl_set_object_color(pf.SelB,FL_COL1,FL_MCOL);
         fl_set_object_color(pf.SelC,FL_COL1,FL_MCOL);
         fl_set_object_color(pf.SelD,FL_COL1,FL_MCOL);
         PrinterGUI=1;
         xwCreateGUI(PrinterEntry,1,pf.form,186,57);
         fl_unfreeze_form(pf.form);
      }
      else if (pf.obj == pf.SelB)
      {
         /* Remove GUI */
         fl_freeze_form(pf.form);
         xwDeleteGUI();
         fl_set_object_color(pf.SelA,FL_COL1,FL_MCOL);
         fl_set_object_color(pf.SelB,FL_YELLOW,FL_MCOL);
         fl_set_object_color(pf.SelC,FL_COL1,FL_MCOL);
         fl_set_object_color(pf.SelD,FL_COL1,FL_MCOL);
         PrinterGUI=2;
         xwCreateGUI(PrinterEntry,2,pf.form,186,57);
         fl_unfreeze_form(pf.form);
      }
      else if (pf.obj == pf.SelC)
      {
         /* Remove GUI */
         fl_freeze_form(pf.form);
         xwDeleteGUI();
         fl_set_object_color(pf.SelA,FL_COL1,FL_MCOL);
         fl_set_object_color(pf.SelB,FL_COL1,FL_MCOL);
         fl_set_object_color(pf.SelC,FL_YELLOW,FL_MCOL);
         fl_set_object_color(pf.SelD,FL_COL1,FL_MCOL);
         PrinterGUI=3;
         xwCreateGUI(PrinterEntry,3,pf.form,186,57);
         fl_unfreeze_form(pf.form);
      }
      else if (pf.obj == pf.SelD)
      {
         /* Remove GUI */
         fl_freeze_form(pf.form);
         xwDeleteGUI();
         fl_set_object_color(pf.SelA,FL_COL1,FL_MCOL);
         fl_set_object_color(pf.SelB,FL_COL1,FL_MCOL);
         fl_set_object_color(pf.SelC,FL_COL1,FL_MCOL);
         fl_set_object_color(pf.SelD,FL_YELLOW,FL_MCOL);
         PrinterGUI=4;
         xwCreateGUI(PrinterEntry,4,pf.form,186,57);
         fl_unfreeze_form(pf.form);
      }

      /* ----------------------------------------- */

      /* Load Setting */
      else if (pf.obj == pf.LOAD)
      {
         /* save settings */
         xwSavePrinterSetting(DriverFile,PrinterModel,PrinterSetting,PrinterEntry);

         fl_deactivate_form(pf.form);

         /* Create Path */
         strcpy(astr,xwGetFile("",""));
         strcat(astr,"/");
         strcat(astr,strrchr(DriverFile,'/')+1);
         strcat(astr,"/");
         strcat(astr,PrinterModel);
         for (az=0 ; az<strlen(astr) ; az++)
         {
            if (astr[az]==0x20) astr[az]='-';
         }

         xwSetFSPath(astr);
         xwSetFSCustom("xwGUI2",astr);

         xwSetFSPattern("");
         strcpy(astr,xwGR(1,"fs.SelectSetting","Select Setting, please..."));
         strcpy(bstr,xwGR(1,"fs.Load","Load"));
         strcpy(cstr,xwGR(1,"fs.Abort","Abort"));
         filename=xwFileSelect(fsFileAll,"",astr,bstr,cstr);
         fl_activate_form(pf.form);
         fl_set_app_mainform(pf.form);
         if (strlen(filename)>0)
         {
            xwDeleteGUI();

            strcpy(PrinterSetting,strrchr(filename,'/')+1);
            /* display settings file */
            if (strlen(PrinterSetting)>0)
            {
               strcpy(astr,xwGR(1,"prtp.SettingFile","Setting-File: "));
               strcat(astr,PrinterSetting);
               fl_set_object_label(pf.SelPrinter,astr);
            }
            else
            {
               strcpy(astr,xwGR(1,"prtp.SettingFile","Setting-File: "));
               strcat(astr,"-----");
               fl_set_object_label(pf.SelPrinter,astr);
            }

            xwLoadPrinterSetting(DriverFile,PrinterModel,PrinterSetting);

            xwCreateGUI(PrinterEntry,PrinterGUI,pf.form,186,57);
         }
      }

      /* Save Setting */
      else if (pf.obj == pf.SAVE)
      {
         /* save settings */
         xwSavePrinterSetting(DriverFile,PrinterModel,PrinterSetting,PrinterEntry);

         fl_deactivate_form(pf.form);

         /* Create Path */
         strcpy(astr,xwGetFile("",""));
         strcat(astr,"/");
         strcat(astr,strrchr(DriverFile,'/')+1);
         strcat(astr,"/");
         strcat(astr,PrinterModel);
         for (az=0 ; az<strlen(astr) ; az++)
         {
            if (astr[az]==0x20) astr[az]='-';
         }

         xwSetFSPath(astr);
         xwSetFSCustom("xwGUI2",astr);

         xwSetFSPattern("");
         strcpy(astr,xwGR(1,"fs.SelectSetting","Select Setting, please..."));
         strcpy(bstr,xwGR(1,"fs.Save","Save"));
         strcpy(cstr,xwGR(1,"fs.Abort","Abort"));
         filename=xwFileSelect(fsFileAll,PrinterSetting,astr,bstr,cstr);
         fl_activate_form(pf.form);
         fl_set_app_mainform(pf.form);
         if (strlen(filename)>0)
         {
            strcpy(PrinterSetting,strrchr(filename,'/')+1);
            /* display settings file */
            if (strlen(PrinterSetting)>0)
            {
               strcpy(astr,xwGR(1,"prtp.SettingFile","Setting-File: "));
               strcat(astr,PrinterSetting);
               fl_set_object_label(pf.SelPrinter,astr);
            }
            else
            {
               strcpy(astr,xwGR(1,"prtp.SettingFile","Setting-File: "));
               strcat(astr,"-----");
               fl_set_object_label(pf.SelPrinter,astr);
            }

            xwSavePrinterSetting(DriverFile,PrinterModel,PrinterSetting,PrinterEntry);
         }
      }
      
       /* Delete Setting */
      else if (pf.obj == pf.DELETE)
      {
         /* save settings */
         xwSavePrinterSetting(DriverFile,PrinterModel,PrinterSetting,PrinterEntry);

         fl_deactivate_form(pf.form);

         /* Create Path */
         strcpy(astr,xwGetFile("",""));
         strcat(astr,"/");
         strcat(astr,strrchr(DriverFile,'/')+1);
         strcat(astr,"/");
         strcat(astr,PrinterModel);
         for (az=0 ; az<strlen(astr) ; az++)
         {
            if (astr[az]==0x20) astr[az]='-';
         }

         xwSetFSPath(astr);
         xwSetFSCustom("xwGUI2",astr);

         xwSetFSPattern("");
         strcpy(astr,xwGR(1,"fs.DeleteSetting","Delete Setting, please..."));
         strcpy(bstr,xwGR(1,"fs.Delete","Delete"));
         strcpy(cstr,xwGR(1,"fs.Abort","Abort"));
         filename=xwFileSelect(fsFileAll,PrinterSetting,astr,bstr,cstr);
         fl_activate_form(pf.form);
         fl_set_app_mainform(pf.form);
         if (strlen(filename)>0) unlink(filename);
      }

      /* Set Printer Settings to Default */
      else if (pf.obj == pf.RESET)
      {
         if (xwAskMessage(pf.form,xwGR(1,"prtp.ResetPrinter","Set all printer settings to defaults.\nAre you sure ???"))==xwYesMessage)
         {
            /* Remove GUI */
            xwDeleteGUI();

            /* Set Defaults */
            xwSetDefaults(PrinterEntry);

            /* ReOpen GUI */
            /* 
            xwCreateGUI(PrinterEntry,PrinterGUI,pf.form,186,57);
            */
            
            /* Activate Selected Entrys ### */
            fl_freeze_form(pf.form);
            xwCheckPrinterSetup(InitPrinterGUI);
            fl_unfreeze_form(pf.form);
         }
      }

   }

   fl_hide_form(pf.form);
   fl_free_form(pf.form);

   if (xwGetPrefValue(xwgAssLock)==0) fl_set_app_mainform(xwGetMainGui());

   return;
}

/* Check Driver, Printer und Settings */
void xwCheckPrinterSetup(int mo)
{
   int            az,bz,cz;
   char           puffer[1024];

   int            mode;
   
   mode=mo;

   /* Check Driver */
   if (strlen(DriverFile)>0)
   {
      bz=-1;
      cz=fl_get_browser_maxline(pf.Driver);
      for (az=1 ; az<=cz ; az++)
      {
         strcpy(puffer,xwGetIP(NULL));
         strcat(puffer,"/");
         strcat(puffer,fl_get_browser_line(pf.Driver,az));
         if (strcmp(puffer,DriverFile) == 0)
         {
            fl_select_browser_line(pf.Driver,az);
         }
      }
   }

   /* Display Printer Models */
   az=xwGetPrinterCount();
   if (az>-1)
   {
      /* Display Printer Models */
      fl_freeze_form(pf.form);
      fl_clear_browser(pf.Printer);
      for (bz=0 ; bz<=az ; bz++)
      {
         if (xwGetHidePrinter(bz)==0) fl_add_browser_line(pf.Printer,xwGetPrinterName(bz));
      }
      fl_unfreeze_form(pf.form);

      PrinterEntry=-1;
      /* Check Printer */
      if (strlen(PrinterModel)>0)
      {
         cz=fl_get_browser_maxline(pf.Printer);
         for (az=1 ; az<=cz ; az++)
         {
            strcpy(puffer,fl_get_browser_line(pf.Printer,az));
            if (strcmp(puffer,PrinterModel) == 0)
            {
               if (PrinterEntry==-1)
               {
                  PrinterEntry=xwGetPrinterNumber(puffer);
                  fl_select_browser_line(pf.Printer,az);
               }
            }
         }
      }

      /* Initialize GUI Widgets */
      if (PrinterEntry>-1)
      {
         if (xwGetPrinterGUI(1,PrinterEntry)!=NULL)
         {
            strcpy(puffer,"prtp.");
            strcat(puffer,xwGetPrinterGUI(1,PrinterEntry));
            strcpy(puffer,xwGR(1,puffer,xwGetPrinterGUI(1,PrinterEntry)));
            fl_set_object_label(pf.SelA,puffer);
            if (mode==InitPrinterGUI)
            {
               PrinterGUI=1;
               xwCreateGUI(PrinterEntry,PrinterGUI,pf.form,186,57);            
               fl_set_object_color(pf.SelA,FL_YELLOW,FL_MCOL);
               mode=NonePrinterGUI;
            }
            else
            {
               fl_set_object_color(pf.SelA,FL_COL1,FL_MCOL);
            }
         }
         else
         {
            fl_set_object_label(pf.SelA,"");
            fl_set_object_color(pf.SelA,FL_COL1,FL_MCOL);
         }
         
         if (xwGetPrinterGUI(2,PrinterEntry)!=NULL)
         {
            strcpy(puffer,"prtp.");
            strcat(puffer,xwGetPrinterGUI(2,PrinterEntry));
            strcpy(puffer,xwGR(1,puffer,xwGetPrinterGUI(2,PrinterEntry)));
            fl_set_object_label(pf.SelB,puffer);
            if (mode==InitPrinterGUI)
            {
               PrinterGUI=2;
               xwCreateGUI(PrinterEntry,PrinterGUI,pf.form,186,57);            
               fl_set_object_color(pf.SelB,FL_YELLOW,FL_MCOL);
               mode=NonePrinterGUI;
            }
            else
            {
               fl_set_object_color(pf.SelB,FL_COL1,FL_MCOL);
            }            
         }
         else
         {
            fl_set_object_label(pf.SelB,"");
            fl_set_object_color(pf.SelB,FL_COL1,FL_MCOL);
         }
         
         if (xwGetPrinterGUI(3,PrinterEntry)!=NULL)
         {
            strcpy(puffer,"prtp.");
            strcat(puffer,xwGetPrinterGUI(3,PrinterEntry));
            strcpy(puffer,xwGR(1,puffer,xwGetPrinterGUI(3,PrinterEntry)));
            fl_set_object_label(pf.SelC,puffer);
            if (mode==InitPrinterGUI)
            {
               PrinterGUI=3;
               xwCreateGUI(PrinterEntry,PrinterGUI,pf.form,186,57);            
               fl_set_object_color(pf.SelC,FL_YELLOW,FL_MCOL);
               mode=NonePrinterGUI;
            }
            else
            {
               fl_set_object_color(pf.SelC,FL_COL1,FL_MCOL);
            }
         }
         else
         {
            fl_set_object_label(pf.SelC,"");
            fl_set_object_color(pf.SelC,FL_COL1,FL_MCOL);
         }

         if (xwGetPrinterGUI(4,PrinterEntry)!=NULL)
         {
            strcpy(puffer,"prtp.");
            strcat(puffer,xwGetPrinterGUI(4,PrinterEntry));
            strcpy(puffer,xwGR(1,puffer,xwGetPrinterGUI(4,PrinterEntry)));
            fl_set_object_label(pf.SelD,puffer);
            if (mode==InitPrinterGUI)
            {
               PrinterGUI=4;
               xwCreateGUI(PrinterEntry,PrinterGUI,pf.form,186,57);            
               fl_set_object_color(pf.SelD,FL_YELLOW,FL_MCOL);
               mode=NonePrinterGUI;
            }
            else
            {
               fl_set_object_color(pf.SelD,FL_COL1,FL_MCOL);
            }
         }
         else
         {
            fl_set_object_label(pf.SelD,"");
            fl_set_object_color(pf.SelD,FL_COL1,FL_MCOL);         
         }

         /* display settings file */
         if (strlen(PrinterSetting)>0)
         {
            strcpy(puffer,xwGR(1,"prtp.SettingFile","Setting-File: "));
            strcat(puffer,PrinterSetting);
            fl_set_object_label(pf.SelPrinter,puffer);
         }
         else
         {
            strcpy(puffer,xwGR(1,"prtp.SettingFile","Setting-File: "));
            strcat(puffer,"-----");
            fl_set_object_label(pf.SelPrinter,puffer);
         }

      }
      else
      {
         fl_set_object_label(pf.SelA,"");
         fl_set_object_color(pf.SelA,FL_COL1,FL_MCOL);
         fl_set_object_label(pf.SelB,"");
         fl_set_object_color(pf.SelB,FL_COL1,FL_MCOL);
         fl_set_object_label(pf.SelC,"");
         fl_set_object_color(pf.SelC,FL_COL1,FL_MCOL);
         fl_set_object_label(pf.SelD,"");
         fl_set_object_color(pf.SelD,FL_COL1,FL_MCOL);

         /* display settings file */
         if (strlen(PrinterSetting)>0)
         {
            strcpy(puffer,xwGR(1,"prtp.SettingFile","Setting-File: "));
            strcat(puffer,PrinterSetting);
            fl_set_object_label(pf.SelPrinter,puffer);
         }
         else
         {
            strcpy(puffer,xwGR(1,"prtp.SettingFile","Setting-File: "));
            strcat(puffer,"-----");
            fl_set_object_label(pf.SelPrinter,puffer);
         }
      }

   }

   return;
}


/* ########## Driver Files ########## */

/* Get Driver File */
char *xwGetPrefDriver(void)
{
   return(DriverFile);
}

/* Set Driver File */
void xwSetPrefDriver(char *file)
{
   strcpy(DriverFile,file);
   return;
}

/* Read Def Files */
void xwReadPrinterDef(FL_OBJECT *widget)
{
   int               a;

   fl_freeze_form(pf.form);

   if (widget!=NULL)
   {
      fl_clear_browser(widget);

      /* Scan Directory */
      dentrys=-1;

      /* Scan Directory */
      xwPrinterScan();

      /* sort directory */
      if (dentrys > -1) qsort(dbuf,dentrys+1,sizeof(dbuf[0]),xwPrinterSort);

      /* copy direntrys into browser */
      for (a=0 ; a<=dentrys ; a++)
      {
         fl_add_browser_line(widget,dbuf[a]);

         free(dbuf[a]);
         dbuf[a] = NULL;
      }
      dentrys=-1;
   }

   fl_unfreeze_form(pf.form);

   return;
}

/* read Directory */
void xwPrinterScan(void)
{
   DIR               *dirz;
   struct dirent     *direntz;
   struct stat       attribut;
   struct stat       attribB;

   char              fname[256];
   char              pattern[8];
   char              *strptr;

   int               flag=0;

   char              path[1024];

   strcpy(path,xwGetIP(NULL));
   if ( (dirz = opendir(path)) != NULL )
   {
      while ( (direntz = readdir(dirz)) != NULL)
      {
         flag=0;

         strcpy(path,xwGetIP(NULL));
         strcat(path,"/");
         strcat(path,direntz->d_name);

         strcpy(fname,direntz->d_name);
         if ( stat(path,&attribut) == 0)
         {
            if (lstat(path,&attribB) == 0)
            {
               if (S_ISLNK(attribB.st_mode))
               {
                  if (S_ISREG(attribut.st_mode))
                  {
                     strptr=fname;
                     strptr=strptr+(strlen(fname)-4);
                     strcpy(pattern,strptr);
                     strUpper(pattern);
                     if (strlen(fname)>4)
                     {
                        if ( strcmp( pattern,".DEF" ) == 0 ) flag=strlen(fname);
                     }
                  }
               }
               else
               {
                  if (S_ISREG(attribut.st_mode))
                  {
                     strptr=fname;
                     strptr=strptr+(strlen(fname)-4);
                     strcpy(pattern,strptr);
                     strUpper(pattern);
                     if (strlen(fname)>4)
                     {
                        if ( strcmp( pattern,".DEF" ) == 0 ) flag=strlen(fname);
                     }
                  }
               }
            }
         }

         /* write into array */
         if ( (flag > 0) && (dentrys<1023) )
         {
            dentrys++;
            dbuf[dentrys] = (char*) malloc(strlen(fname)+1);
            if (dbuf[dentrys] != NULL) strcpy(dbuf[dentrys],fname);
         }
      }

      closedir(dirz);
   }

   return;
}

/* Compare for Sort */
int xwPrinterSort(const void *Z1,const void *Z2)
{
   const char        **z1=(const char **) Z1;
   const char        **z2=(const char **) Z2;
   char              aas[1024],bbs[1024];

   strcpy(aas,*z1);
   strcpy(bbs,*z2);

   return(strcmp(aas,bbs));
}

/* ########## Printer ########## */

/* Get Printer File */
char *xwGetPrefPrinter(void)
{
   return(PrinterModel);
}

/* Set Printer File */
void xwSetPrefPrinter(char *file)
{
   strcpy(PrinterModel,file);
   PrinterEntry=xwGetPrinterNumber(PrinterModel);

   return;
}

/* ########## setting File ########## */

/* Get Setting File */
char *xwGetPrefSetting(void)
{
   return(PrinterSetting);
}

/* Set Setting File */
void xwSetPrefSetting(char *file)
{
   strcpy(PrinterSetting,file);
   return;
}

