/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Pue.hANYANYANYANYblic License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "pref_paper.h"

#include "base.h"
#include "default.h"
#include "frame.h"
#include "handler.h"
#include "help.h"
#include "limits.h"
#include "main_gui.h"
#include "page.h"
#include "paper.h"
#include "resource.h"

static paperform    pf;

/* Paper SetUp */
void xwPrefPaperSetup(void)
{
   /* Settings Buffer */
   /* Paper Datas */
   float          xpage,ypage;
   int            epage;

   /* Border Datas */
   int            lb,rb,tb,bb;

   const char     *strptr;
   char           astr[80],bstr[80];
   int            az;

   /* get Settings */
   xpage=xwGetPaperXSize();
   ypage=xwGetPaperYSize();
   epage=xwGetEntryNumber(xwGetID());

   pf.form = NULL;
   pf.ready = 0;

   lb=xwGetPaperLB();
   rb=xwGetPaperRB();
   tb=xwGetPaperTB();
   bb=xwGetPaperBB();

   pf.form = fl_bgn_form(FL_UP_BOX, 525,196);
   fl_set_border_width(1);

   /* Paper Browser */
   pf.PaperBrowserFrame=fl_add_frame(FL_DOWN_BOX,5,5,310,161,"");
   pf.PaperBrowser = fl_add_browser(FL_HOLD_BROWSER,10,10,300,126,"");

   /* Create Paper List */
   strptr=xwGetPaperName();
   strcpy(astr,strptr);
   while (strlen(astr)>0)
   {
      strcpy(bstr,"@c");
      strcat(bstr,astr);
      fl_add_browser_line(pf.PaperBrowser,bstr);

      strptr=xwGetNextPaperName();
      strcpy(astr,strptr);
   }

   fl_select_browser_line(pf.PaperBrowser,epage+1);

   /* Paper Geometry Input Fields */
   pf.PaperWidth=fl_add_input(FL_FLOAT_INPUT,110,141,50,20,xwGR(1,"pf.PaperWidth","Paper Width (mm):"));
   sprintf(astr,"%.2f",xpage/xwMM()); /* mm */
   fl_set_input(pf.PaperWidth,astr);
   fl_set_input_color(pf.PaperWidth,FL_BLACK,FL_BLUE);
#ifdef xwWhiteInput
   fl_set_object_color(pf.PaperWidth,FL_WHITE,FL_WHITE);
#endif

   pf.PaperHeight=fl_add_input(FL_FLOAT_INPUT,260,141,50,20,xwGR(1,"pf.PaperHeight","Paper Height (mm):"));
   sprintf(astr,"%.2f",ypage/xwMM()); /* mm */
   fl_set_input(pf.PaperHeight,astr);
#ifdef xwWhiteInput
   fl_set_object_color(pf.PaperHeight,FL_WHITE,FL_WHITE);
#endif

   /* Paper Borders */
   pf.PaperFrame=fl_add_frame(FL_DOWN_BOX,320,5,200,161,"");

   pf.PaperLeft=fl_add_input(FL_INT_INPUT,465,10,50,20,xwGR(1,"pf.LeftBorder","Left Border (mm):"));
   sprintf(astr,"%i",lb/xwMM()); /* mm */
   fl_set_input(pf.PaperLeft,astr);
#ifdef xwWhiteInput
   fl_set_object_color(pf.PaperLeft,FL_WHITE,FL_WHITE);
#endif

   pf.PaperRight=fl_add_input(FL_INT_INPUT,465,35,50,20,xwGR(1,"pf.RightBorder","Right Border (mm):"));
   sprintf(astr,"%i",rb/xwMM()); /* mm */
   fl_set_input(pf.PaperRight,astr);
#ifdef xwWhiteInput
   fl_set_object_color(pf.PaperRight,FL_WHITE,FL_WHITE);
#endif

   pf.PaperTop=fl_add_input(FL_INT_INPUT,465,60,50,20,xwGR(1,"pf.TopBorder","Top Border (mm):"));
   sprintf(astr,"%i",tb/xwMM()); /* mm */
   fl_set_input(pf.PaperTop,astr);
#ifdef xwWhiteInput
   fl_set_object_color(pf.PaperTop,FL_WHITE,FL_WHITE);
#endif

   pf.PaperBottom=fl_add_input(FL_INT_INPUT,465,85,50,20,xwGR(1,"pf.BottomBorder","Bottom Border (mm):"));
   sprintf(astr,"%i",bb/xwMM()); /* mm */
   fl_set_input(pf.PaperBottom,astr);
#ifdef xwWhiteInput
   fl_set_object_color(pf.PaperBottom,FL_WHITE,FL_WHITE);
#endif

   pf.OK = fl_add_button(FL_NORMAL_BUTTON,160,171,100,20,xwGR(1,"pf.OK","OK"));
   pf.CANCEL = fl_add_button(FL_NORMAL_BUTTON,265,171,100,20,xwGR(1,"pf.Cancel","Cancel"));
   pf.HELP = fl_add_button(FL_NORMAL_BUTTON,420,171,100,20,xwGR(1,"help.HELP","Help"));

   fl_end_form();

   if (xwGetPrefValue(xwgWinPos)==0)
   {
      fl_prepare_form_window(pf.form,FL_PLACE_MOUSE,FL_TRANSIENT,xwGR(1,"pf.PaperPref","Paper Pref"));
   }
   else
   {
      fl_prepare_form_window(pf.form,FL_PLACE_CENTER,FL_TRANSIENT,xwGR(1,"pf.PaperPref","Paper Pref"));
   }
   
   fl_set_form_dblbuffer(pf.form,0);
   fl_show_form_window(pf.form);

   fl_set_app_mainform(pf.form);

   /* Exit Handler */
   fl_set_form_atclose(pf.form,nclose_cb,(void *) "1");
   
   while (pf.ready==0)
   {
      pf.obj = fl_do_forms();

      /* Check Input Fields */
      /* Paper Geometry */
      strptr=fl_get_input(pf.PaperWidth);
      strcpy(astr,strptr);
      xpage=atof(astr)*(float) xwMM();

      strptr = fl_get_input(pf.PaperHeight);
      strcpy(astr,strptr);
      ypage=atof(astr)*(float) xwMM();

      /* Paper Borders */
      strptr = fl_get_input(pf.PaperLeft);
      strcpy(astr,strptr);
      lb=atoi(astr)*xwMM();

      strptr = fl_get_input(pf.PaperRight);
      strcpy(astr,strptr);
      rb=atoi(astr)*xwMM();

      strptr = fl_get_input(pf.PaperTop);
      strcpy(astr,strptr);
      tb=atoi(astr)*xwMM();

      strptr = fl_get_input(pf.PaperBottom);
      strcpy(astr,strptr);
      bb=atoi(astr)*xwMM();

      /* Accept Paper Setup */
      if (pf.obj == pf.OK)
      {
         pf.ready=-1;
      }

      /* Cancel Paper Setup */
      else if (pf.obj == pf.CANCEL) pf.ready=1;

      /* Display Help */
      else if (pf.obj == pf.HELP) xwDisplayHelp(PrefPaper);

      /* Get Selected Paper */
      else if (pf.obj == pf.PaperBrowser)
      {
         az=fl_get_browser(pf.PaperBrowser)-1;
         if (az>-1)
         {
            /* Get Paper Geometry */
            xpage=xwGetPaperWidth(az);
            ypage=xwGetPaperHeight(az);
            epage=az;

            sprintf(astr,"%.2f",xpage/(float) xwMM()); /* mm */
            fl_set_input(pf.PaperWidth,astr);
            sprintf(astr,"%.2f",ypage/(float) xwMM()); /* mm */
            fl_set_input(pf.PaperHeight,astr);
         }
      }

   }

   fl_hide_form(pf.form);
   fl_free_form(pf.form);

   /* Check Paper-Settings */
   if (pf.ready==-1)
   {
/*
      printf("Min. X: %i\n",xwGetLowXFrame());
      printf("Min. Y: %i\n",xwGetLowYFrame());
      printf("Max. X: %i\n",xwGetHighXFrame());
      printf("Max. Y: %i\n",xwGetHighYFrame());
*/
      /* With Frames or Pictures */
      if ( (xwGetLowXFrame()>=lb) &&
           (xwGetHighXFrame()<=xpage-rb) &&
           (xwGetLowYFrame()>=tb) &&
           (xwGetHighYFrame()<=ypage-bb) )
      {
         xwSetPaperX(xpage);
         xwSetPaperY(ypage);
         xwSetID(xwGetIDNumber(epage));
         xwSetPaperLB(lb);
         xwSetPaperRB(rb);
         xwSetPaperTB(tb);
         xwSetPaperBB(bb);
         xwDrawPage(pgRecalc);
      }

      /* No Frames and Pictures */
      if ( (xwGetLowXFrame()==-1) &&
           (xwGetHighXFrame()==-1) &&
           (xwGetLowYFrame()==-1) &&
           (xwGetHighYFrame()==-1) &&
           (lb+rb<xpage) &&
           (tb+bb<ypage) )
      {   
         xwSetPaperX(xpage);
         xwSetPaperY(ypage);
         xwSetID(xwGetIDNumber(epage));
         xwSetPaperLB(lb);
         xwSetPaperRB(rb);
         xwSetPaperTB(tb);
         xwSetPaperBB(bb);
         xwDrawPage(pgRecalc);
      }

   }

   if (xwGetPrefValue(xwgAssLock)==0) fl_set_app_mainform(xwGetMainGui());

   return;
}
