/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "picviewer.h"

#include "base.h"
#include "default.h"
#include "error.h"
#include "main_gui.h"
#include "resource.h"

/* View Picture */
void xwViewPicture(char *file)
{
   /* Exec Datas */
   char           cmdD[2048];
   static long    pid;
   static char    args[100][80]; /* Arg Array */
   static char    *argv[100];
   int            prtA,prtB;
   int            bug;

   char           *strptr;

   if (strlen(file)>0)
   {
      if (xwExist(file)==0)
      {
         strcpy(cmdD,xwGetPrefName(xwgPicViewer));
         strcat(cmdD," ");
         strcat(cmdD,file);

         /* Build ArgList */
         prtA=0;
         prtB=0;
         strptr = StrGet(cmdD);
         while (strlen(strptr)>0)
         {
            strcpy(args[prtA],strptr);

            if (prtA>-1)
            {
               argv[prtB] = args[prtA];
               prtB++;
               argv[prtB]=NULL;
            }
            prtA++;

            strptr = StrGet(NULL);
         }
      
         pid=0;
         bug=0;
         /* create Process */
         if ( (pid=fork()) == 0)
         {
            bug=execvp(args[0],argv);
            exit(0);
         }  
      }
      else
      {
         xwDisplayMessage(xwGetMainGui(),xwGR(1,"viewpicture","Can't display this picture !!!"));
      }
   }
   else
   {
      xwDisplayMessage(xwGetMainGui(),xwGR(1,"viewpicture","Can't display this picture !!!"));
   }

   return;
}