/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWPICTURE_H
#define _XWPICTURE_H

#include <forms.h>
#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

typedef struct picturedatas
{
   /* Picture Size */
   int            xpic;
   int            ypic;
   float          paspect;

   /* Picture Position */
   int            xpos;
   int            ypos;

   /* Picture Size */
   int            xsize;
   int            ysize;

/* ################################################################### */
/* WYSIWYG Pixmap */

   int         pFlag;      /* 0 - No Pixmap / 1 - Pixmap */
   int         pXSize;
   int         pYSize;
   Pixmap      pPixmap;

/* ################################################################### */
/* Special Features */

   /* Rotation -180,-90,0,90,180 Grad */
   int            rotate;

   /* Picture Border Flag */
   double         borderSize;
   int            borderColor;
   double         frameSize;
   /* Picture Border Color */
   int            frmrgb;

   /* Transparenz */
   int            transparenz;
   
   /* Transparenz Mode */
   int            transMode;

   /* Picture Filename */
   char           filename[4];

} picturedatas;

/* ################################################################### */
/* Picture Managment */

/* Init Picture Setting */
void xwInitPicture(void);
/* Free Picture Settings */
void xwFreePicture(int pNr);
/* Swap Picture */
void xwSwapPicture(int pNrA,int pNrB);
/* Modify Picture Rotation */
void xwSetPictureRotation(int rotate);

/* ################################################################### */
/* Pixmap Verwaltung */

/* Set Pixmap */
void xwSetPicturePixmap(int pNr,Pixmap pixmap);
/* Clear Pixmap */
void xwClearPicturePixmap(int pNr);
/* Get Pixmap */
Pixmap xwGetPicturePixmap(int pNr);
/* Get Pixmap Datas */
void xwGetPicturePMDatas(int pNr,int *w,int *h);
/* Set Pixmap Datas */
void xwSetPicturePMDatas(int pNr,int w,int h);

/* ################################################################### */
/* Active and Picture Count Datas */

/* Get Active Picture Nr. */
int xwGetActivePicture(void); 
/* Set Active Picture Nr. */
void xwSetActivePicture(int pNr);
/* Get Count of Picture */
int xwGetPictureCount(void);

/* ################################################################### */
/* Picture Geometry in Pixels */

/* Get Picture XPos */
int xwGetPictureX(int pNr);
/* Get Picture YPos */
int xwGetPictureY(int pNr);
/* Get Picture XSize */
int xwGetPictureW(int pNr);
/* Get Picture YSize */
int xwGetPictureH(int pNr);
/* Set Picture Geometry */
void xwSetPictureGeo(int pNr,int xpos,int ypos,int xsize,int ysize);

/* ################################################################### */
/* Real Picture Datas */

/* Get Picture Real XSize */
int xwGetPictureRW(int pNr);
/* Get Picture Real YSize */
int xwGetPictureRH(int pNr);
/* Get Picture Aspect */
float xwGetPictureA(int pNr);

/* ################################################################### */
/* Picture Rotation */

/* Get Picture Rotation */
int xwGetPictureR(int pNr);
/* Set Picture Rotation */
void xwSetPictureR(int pNr,int rotate);

/* ################################################################### */
/* Border Datas */

/* Get Picture Border Size */
double xwGetPictureB(int pNr);
/* Get Picture Border Color */
int xwGetPictureBC(int pNr);
/* Get Picture Frame Size */
double xwGetPictureF(int pNr);
/* Get Picture Frame Color */
int xwGetPictureC(int pNr);
/* Get Picture Transparentz */
int xwGetPictureT(int pNr);
/* Get Picture Transparentz Mode */
int xwGetPictureTM(int pNr);

/* Set Picture Border Size */
void xwSetPictureB(int pNr,double size);
/* Set Picture Border Color */
void xwSetPictureBC(int pNr,int mo);
/* Set Picture Frame Size */
void xwSetPictureF(int pNr,double size);
/* Set Picture Frame Color */
void xwSetPictureC(int pNr,int rgb);
/* Set Picture Transparency */
void xwSetPictureT(int pNr,int trans);
/* Set Picture Transparency Mode */
void xwSetPictureTM(int pNr,int mo);

/* ################################################################### */
/* Picture Add and Get Filename */

/* Load Picture */
int xwPLoad(const char *filename,int xpos,int ypos,int xsize,int ysize);
/* Get Picture Filename */
const char *xwGetPictureFile(int pNr);

/* ################################################################### */

/* Scale Picture into Frame */
void xwScalePicture(int pNr,int xpos,int ypos,int xsize,int ysize);
/* Draw Picture */
void xwDrawPicture(int pNr);
/* Print any Picture Information */
void xwPrintPictureDatas(int picNr,int mode,int xsize,int ysize);
/* Create Picture Choice */
void xwCreatePictureChoice(FL_OBJECT *gd);
/* MovePictureToBack */
void xwMovePictureToBack(void);
/* MovePictureToFront */
void xwMovePictureToFront(void);
/* Rotate Picture */
void xwRotatePicture(int direction,int xpos,int ypos,int xsize,int ysize);
/* Resize Picture */
void xwPictureResize(int mode);
/* Move Picture */
void xwPictureMove(int xpos,int ypos);

/* Page Information Routines */

/* Get lowest X-Picture-Position */
int xwGetLowXPicture(void);
/* Get lowest Y-Picture-Position */
int xwGetLowYPicture(void);
/* Get highest X-Picture-Position */
int xwGetHighXPicture(void);
/* Get highest Y-Picture-Position */
int xwGetHighYPicture(void);

/* ################################################################### */
/* View Picture */
void xwDisplayPicture(void);

#endif