/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWPICBROWSER_H
#define _XWPICBROWSER_H

#include <forms.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>
#include <ctype.h>

#define pbXSize         100
#define pbYSize         20

#define pbCount         30

typedef struct picbrowserform
{
   /* Main-Form data */
   FL_FORM           *form;
   /* Event Loop */
   FL_OBJECT         *obj;
   int               ready;

   Pixmap            PBPixmap;
   int               PBFlag;
   int               PBXRes;
   int               PBYRes;

   FL_OBJECT         *PathBrowser;
   FL_OBJECT         *FrameA;
   FL_OBJECT         *View;
   FL_OBJECT         *Picture;
   FL_OBJECT         *FrameB;
   FL_OBJECT         *FrameBB;
   FL_OBJECT         *Slider;
    
   FL_OBJECT         *Drawer;
   FL_OBJECT         *File;
   
   FL_OBJECT         *Progress;
   
   FL_OBJECT         *OK;
   FL_OBJECT         *CANCEL;
   FL_OBJECT         *HELP;
} picbrowserform;


/* Set Picture Browser Path */
void xwSetPicBrowserPath(char *astr);

/* Picture Browser */
char *xwPictureBrowser(FL_FORM *form);

/* Picture Browser Handler */
int xwPBHandler(FL_OBJECT *obj, int event, FL_Coord mx, FL_Coord my, int key,void *xev);


/* Scrollbar Analyse */
void pbAction(FL_OBJECT *obj,long data);
/* Get Picture Browser Path */
char *xwGetPBPath(void);
/* Set Picture Browser Path */
void xwSetPBPath(char *path);

/* ################################################################### */

/* Display Directory */
void xwDisplayPBDir(int mo);
/* Display Files */
void xwDisplayPBFiles(void);

/* read Directory */
void xwPBDirScan(void);
/* Compare for Sort */
int xwPBDirSort(const void *Z1,const void *Z2);

/* View Preview Picture */
void xwPBViewPicture(void);

/* ------------------------------------------------------------------- */

/* Create Pixmap Directory */
void xwCreatePixmapDir(void);
/* View Preview Picture */
void xwPBViewPicture(void);

/* ------------------------------------------------------------------- */

/* Load Pixmaps for Overview */
void xwPBLoad(void);

#endif