/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "picbrowser.h"

#include "base.h"
#include "default.h"
#include "error.h"
#include "fileio.h"
#include "font.h"
#include "gfx.h"
#include "handler.h"
#include "limits.h"
#include "main_gui.h"
#include "pbcache.h"
#include "resource.h"
#include "x11.h"
#include "xpm.h"

#include "time.h"

/* Picture View */
#include "pixmaps/FSError.xpm"
#include "pixmaps/FSParent.xpm"
#include "pixmaps/FSDrawer.xpm"
#include "pixmaps/FSEmpty190.xpm"

extern struct mainform     mf;

static picbrowserform      pbf;

static char       pbPath[1024]="";     /* Directory Path */
static char       pbFile[256]="";      /* Selected File */
static char       pbSelect[1300]="";   /* Selection */

static int        xfsize,yfsize;       /* Current Window Size */
static int        xwsize,ywsize;       /* New Window Size */
static int        xcount,ycount;       /* Lines and Raws of Pictures */

static int        pbXSave=5+200+5+5+20+5;
static int        pbYSave=5+5+5+5+20+5+20+5;

/* Directory Buffer */
static char       *dbuf[4096];
static int        dflag[4096];
static int        dentrys=-1;
static int        dflagCount;          /* Count of Pictures */
static int        dposCount;           /* Position of Picture Count */
static int        tempCount;           /* Temp Count */
static int        tempPos;             /* Temp Position - First Position of First Image */

static int        dOffset=0;           /* Offset for File Display */
static int        dTotal=0;            /* Initialize bey openning browser */

static int        scNew=0;
static int        scLast=0;

/* Default Pixmaps */
static Pixmap     pixError;
static Pixmap     pixParent;
static Pixmap     pixDrawer;

/* Picture Browser Resizing Manager */
static int        pbhResizeX=-1,pbhResizeY=-1;

/* Picture Browser Handler */
static int        xwPBHandlerLock=0;
static int        mmx,mmy;
static int        eevent;
static int        kkey;
static int        lock=0;

static int        pbhAX,pbhAY;
static int        pbhAZ,pbhAAZ,pbhBBZ;
static char       pbhASTR[1500],pbhBSTR[1500];
static const char  *pbhStrPtr;

static long       pid;
static int        pidLED=0;

/* Filename Rendering */
static char             afTitleFont[1024]="Courier";
static int              afTitleFontSize=15;
static int              afTitleFontUnderline=0;

/* Set Picture Browser Path */
void xwSetPicBrowserPath(char *astr)
{
   if (strlen(astr)<1023)
   {
      strcpy(pbPath,astr);
   }

   return;
}

/* Picture Browser */
char *xwPictureBrowser(FL_FORM *form)
{
   int         az,bz;
   int         aaz;
   int         brwline;

   int         pixWidth,pixHeight;

   const char  *strptr;

   int         status;

   tempCount=-1;

   /* Internal Pixmaps */
   pixError=fl_create_from_pixmapdata(fl_default_window(),FSError_xpm,&pixWidth,&pixHeight,NULL,&bz,&bz,FL_WHITE);
   pixParent=fl_create_from_pixmapdata(fl_default_window(),FSParent_xpm,&pixWidth,&pixHeight,NULL,&bz,&bz,FL_WHITE);
   pixDrawer=fl_create_from_pixmapdata(fl_default_window(),FSDrawer_xpm,&pixWidth,&pixHeight,NULL,&bz,&bz,FL_WHITE);

   if (xwGFXCreateTemp(100*pbCount,100)==xwTrue)
   {
      xwGFXSetMaskLColor(0,0,0);
      xwGFXSetPicMask(0,0,0,0,0);
      xwGFXUseMask(0);

      /* No Selection */
      strcpy(pbSelect,"");
      strcpy(pbFile,"");

      /* Get Form Size */
      fl_get_winsize(form->window,&xfsize,&yfsize);

      /* Calculate new Windowsize */
      xcount=(xfsize-pbXSave)/pbXSize;
      ycount=(yfsize-pbYSave)/(pbXSize+pbYSize);

      if ( (xcount!=pbhResizeX) || (ycount!=pbhResizeY) )
      {
         pbhResizeX=xcount;
         pbhResizeY=ycount;

         dOffset=0;
         dTotal=0;
      }

      xwsize=(xcount*pbXSize)+pbXSave;
      ywsize=(ycount*(pbXSize+pbYSize))+pbYSave;

      pbf.PBFlag=0;
      pbf.PBPixmap=0;

      pbf.form = NULL;
      pbf.ready = 0;

      pbf.form = fl_bgn_form(FL_UP_BOX,xwsize,ywsize);
      fl_set_border_width(1);

      pbf.PathBrowser = fl_add_browser(FL_SELECT_BROWSER,5,5,200,(ywsize-(pbYSave-10))-(220+7),"");
      fl_set_browser_fontstyle(pbf.PathBrowser,FL_FIXED_STYLE);

      pbf.FrameA =fl_add_frame(FL_DOWN_BOX,6,(ywsize-(pbYSave-10))-(220-6),198,218,"");

      pbf.View = fl_add_button(FL_NORMAL_BUTTON,6,(ywsize-(pbYSave-10))-(220-5),198,20,xwGR(1,"pbf.Zoom","Zoom Picture"));

      pbf.Picture = fl_add_pixmapbutton(FL_NORMAL_BITMAP,10,(ywsize-(pbYSave-10))-(200-6)+5,190,190,"");
      fl_set_object_boxtype(pbf.Picture,FL_NO_BOX);
      fl_set_pixmap_data(pbf.Picture,FSError_xpm);

      /* Picture Area */
      pbf.FrameB = fl_add_frame(FL_DOWN_BOX,206,6,(xwsize-(pbXSave+2))+10,ywsize-((pbYSave+2)-10),"");
      /*fl_set_object_posthandler(pbf.FrameB,xwPBHandler);*/

      pbf.FrameBB = fl_add_button(FL_NORMAL_BUTTON,206,6,(xwsize-(pbXSave+2))+10,ywsize-((pbYSave+2)-10),"");
      fl_set_object_boxtype(pbf.FrameBB,FL_NO_BOX);
      fl_set_object_posthandler(pbf.FrameBB,xwPBHandler);

      pbf.Slider = fl_add_scrollbar(FL_VERT_BASIC_SCROLLBAR,xwsize-25,5,20,ywsize-(pbYSave-10),"");
      /* Set Scrollbar Return */
      fl_set_scrollbar_return(pbf.Slider,FL_RETURN_CHANGED);
      fl_set_object_callback(pbf.Slider,pbAction,0);

      pbf.Progress = fl_add_box(FL_DOWN_BOX,5,ywsize-50,xwsize-10,45,xwGR(1,"pbf.Progress","xwGUI in Progress...\nConvert pictures..."));
      fl_set_object_lsize(pbf.Progress,FL_NORMAL_SIZE);
      fl_hide_object(pbf.Progress);

      pbf.Drawer = fl_add_input(FL_NORMAL_INPUT,55,ywsize-50,xwsize-(110+55),20,xwGR(1,"pbf.Path","Path:"));
      fl_set_input_maxchars(pbf.Drawer,1023);
      fl_set_input_return(pbf.Drawer,FL_RETURN_CHANGED);
   #ifdef xwWhiteInput
      fl_set_object_color(pbf.Drawer,FL_WHITE,FL_WHITE);
   #endif

      pbf.File = fl_add_input(FL_NORMAL_INPUT,55,ywsize-25,xwsize-(110+55),20,xwGR(1,"pbf.File","File:"));
      fl_set_input_maxchars(pbf.File,255);
      fl_set_input_return(pbf.File,FL_RETURN_CHANGED);
   #ifdef xwWhiteInput
      fl_set_object_color(pbf.File,FL_WHITE,FL_WHITE);
   #endif

      pbf.OK = fl_add_button(FL_NORMAL_BUTTON,xwsize-105,ywsize-50,100,20,xwGR(1,"pbf.Ok","OK"));
      pbf.CANCEL = fl_add_button(FL_NORMAL_BUTTON,xwsize-105,ywsize-25,100,20,xwGR(1,"pbf.Cancel","Cancel"));

      fl_end_form();

      if (xwGetPrefValue(xwgWinPos)==0)
      {
         fl_prepare_form_window(pbf.form,FL_PLACE_MOUSE,FL_TRANSIENT,xwGR(1,"pbf.PicBrowser","Picture Browser"));
      }
      else
      {
         fl_prepare_form_window(pbf.form,FL_PLACE_CENTER,FL_TRANSIENT,xwGR(1,"pbf.PicBrowser","Picture Browser"));
      }

      fl_set_form_dblbuffer(pbf.form,0);
      fl_show_form_window(pbf.form);

      fl_set_app_mainform(pbf.form);

      /* Exit Handler */
      fl_set_form_atclose(pbf.form,nclose_cb,(void *) "1");

      xwDisplayPBDir(0);

      fl_set_scrollbar_value(pbf.Slider,dOffset);

      /*xwDisplayPBFiles();*/
      if (pbf.PBFlag!=0) XCopyArea(fl_display,pbf.PBPixmap,pbf.form->window,fl_get_gc(),0,dOffset,xcount*pbXSize,ycount*(pbXSize+pbYSize),210,10);

      while (pbf.ready==0)
      {
         fl_winset(pbf.form->window);
         if (waitpid(pid,&status,WNOHANG)!=-1)
         {
            if (pidLED==0)
            {
               fl_drw_box(FL_DOWN_BOX,5,(ywsize-(pbYSave-10))-(220+2) ,200,7,FL_PALEGREEN,1);
               pidLED=1;
            }
            else
            {
               fl_drw_box(FL_DOWN_BOX,5,(ywsize-(pbYSave-10))-(220+2) ,200,7,FL_INDIANRED,1);
               pidLED=0;
            }
            xwPBLoad();
         }
         else
         {
            fl_drw_box(FL_DOWN_BOX,5,(ywsize-(pbYSave-10))-(220+2)  ,200,7,FL_COL1,1);
            xwPBLoad();
         }

         /* Normal Event Loop */
         if (tempCount==-1)
         {
            /*printf("FL_DO_FORMS()\n");*/
            pbf.obj=fl_do_forms();
         }
         else
         {
            /*printf("FL_CHECK_FORMS()\n");*/
            pbf.obj = fl_check_forms();
         }

         if (pbf.obj!=NULL)
         {

            /* Accept Editor Setup */
            if (pbf.obj == pbf.OK)
            {
               if (strlen(pbPath)+strlen(pbFile)+2<1300)
               {
                  if (strlen(pbFile)>0)
                  {
                     strcpy(pbSelect,pbPath);
                     if (strlen(pbSelect)>1) strcat(pbSelect,"/");
                     strcat(pbSelect,pbFile);
                  }
                  else
                  {
                     strcpy(pbSelect,"");
                  }
               }
               else
               {
                  printf("xwGUI II: (PictureBrowser) String To Long !!! Can't accept puffer overflows !!!\n");
               }
               pbf.ready=-1;
            }

            /* Cancel */
            else if (pbf.obj == pbf.CANCEL)
            {
               strcpy(pbSelect,"");
               pbf.ready=-1;
            }

            /* Path Browser */
            else if (pbf.obj == pbf.PathBrowser)
            {
               brwline = fl_get_browser(pbf.PathBrowser);
               strcpy(pbPath,"/");
               if (brwline > 1)
               {
                  for (az=2 ; az<=brwline ; az++)
                  {
                     strcat(pbPath,fl_get_browser_line(pbf.PathBrowser,az));
                     strcat(pbPath,"/");
                  }
               }
               pbPath[strlen(pbPath)-1]='\0';
               if (strlen(pbPath)==0) strcpy(pbPath,"/");

               scNew=0;
               scLast=scNew;
               dOffset=scNew;

               xwDisplayPBDir(0);
               if (pbf.PBFlag!=0) XCopyArea(fl_display,pbf.PBPixmap,pbf.form->window,fl_get_gc(),0,dOffset,xcount*pbXSize,ycount*(pbXSize+pbYSize),210,10);
            }

            /* Zoom Picture */
            else if (pbf.obj == pbf.View)
            {
               xwPBViewPicture();
            }

            /* Dir Input */
            else if (pbf.obj == pbf.Drawer)
            {
               strptr = fl_get_input(pbf.Drawer);
               if (strlen(strptr)<1023)
               {
                  strcpy(pbSelect,strptr);
                  if  ( strcmp(pbSelect,pbPath)!=0 )
                  {
                     strcpy(pbPath,pbSelect);
                     xwDisplayPBDir(1);
                     if (pbf.PBFlag!=0) XCopyArea(fl_display,pbf.PBPixmap,pbf.form->window,fl_get_gc(),0,dOffset,xcount*pbXSize,ycount*(pbXSize+pbYSize),210,10);
                  }
               }
            }

            /* File Input */
            else if (pbf.obj == pbf.File)
            {
               strptr = fl_get_input(pbf.File);
               if (strlen(strptr)<255)
               {
                  strcpy(pbSelect,strptr);
                  if  ( strcmp(pbSelect,pbFile)!=0 )
                  {
                     strcpy(pbFile,pbSelect);
                  }
               }
            }
         }
      }

     /* Waiting for end of PBCache process */
      while (waitpid(pid,&status,WNOHANG)!=-1)
      {
         kill(pid,SIGINT);
         kill(pid,SIGTERM);
         usleep(100000);
      }

      /* destroy directory pixmap */
      if (pbf.PBFlag!=0)
      {
         XFreePixmap(fl_display,pbf.PBPixmap);
         pbf.PBFlag=0;
      }

      fl_hide_form(pbf.form);
      fl_free_form(pbf.form);

      /* remove last directory entrys */
      if (dentrys>-1)
      {
         for (aaz=0 ; aaz<=dentrys ; aaz++)
         {
            free(dbuf[aaz]);
            dbuf[aaz] = NULL;
         }
         dentrys=-1;
      }

      fl_set_app_mainform(xwGetMainGui());

      xwGFXRemoveTemp();
   }

   return(pbSelect);
}

/* Picture Browser Handler */
int xwPBHandler(FL_OBJECT *obj, int event, FL_Coord mx, FL_Coord my, int key,void *xev)
{
   if (xwPBHandlerLock==0)
   {
      mmx=mx;
      mmy=my;
      eevent=event;
      kkey=key;

      /* Lock Handler */
      xwPBHandlerLock=1;

      /* Redraw Page */
      if (eevent==FL_DRAW)
      {
         if (pbf.PBFlag!=0) XCopyArea(fl_display,pbf.PBPixmap,pbf.form->window,fl_get_gc(),0,dOffset,xcount*pbXSize,ycount*(pbXSize+pbYSize),210,10);
      }

      /* Mouse Actions */
      else if (eevent==FL_RELEASE)
      {
         if ( (pbhAAZ>-1) && (pbhAAZ<=dentrys) && (pbf.PBFlag!=0) )
         {
            fl_winset(pbf.PBPixmap);

            pbhAY=IRound(pbhAAZ/xcount);
            pbhAX=pbhAAZ-(pbhAY*xcount);

            fl_drw_box(FL_UP_BOX,(pbhAX*pbXSize),(pbhAY*(pbXSize+pbYSize))+pbXSize,pbXSize,pbYSize,FL_COL1,1);

            /* Filename */
            pbhStrPtr=dbuf[pbhAAZ];
            pbhStrPtr=pbhStrPtr+7;
            if (strlen(pbhStrPtr)<255)
            {
               strcpy(pbhASTR,pbhStrPtr);
            }
            else
            {
               strcpy(pbhASTR,"???");
            }

            while ( fl_get_string_width(FL_NORMAL_STYLE,FL_NORMAL_SIZE,pbhASTR,strlen(pbhASTR)) >= 96)
            {
               pbhASTR[strlen(pbhASTR)-1]=0x00;
            }

            fl_drw_text(FL_ALIGN_CENTER,(pbhAX*pbXSize),(pbhAY*(pbXSize+pbYSize))+pbXSize,pbXSize,pbYSize,FL_BLACK,FL_NORMAL_STYLE,FL_NORMAL_SIZE,pbhASTR);

            if (pbf.PBFlag) XCopyArea(fl_display,pbf.PBPixmap,pbf.form->window,fl_get_gc(),0,dOffset,xcount*pbXSize,ycount*(pbXSize+pbYSize),210,10);

            fl_winset(pbf.form->window);
         }

         pbhBBZ=-1;
         pbhAZ=0;
         for (pbhAY=0 ; pbhAY<dTotal ; pbhAY++)
         {
            for (pbhAX=0 ; pbhAX<xcount ; pbhAX++)
            {
               if ( (mmx-210>=(pbXSize*pbhAX)) && (mmx-210<=(pbXSize*pbhAX)+pbXSize) && ((mmy-10)+dOffset>=((pbXSize+pbYSize)*pbhAY)) && ((mmy-10)+dOffset<=((pbXSize+pbYSize)*pbhAY)+pbXSize+pbYSize) )
               {
                  pbhBBZ=pbhAZ;
               }

               pbhAZ++;
            }
         }

         /*printf("%i\n",kkey);*/
         /*if (kkey==1)*/
         {
            /* File/Drawer Selected */
            if ( (pbhAAZ>-1) && (pbhAAZ==pbhBBZ) && (pbhAAZ<=dentrys) )
            {
               /* Parent */
               if (strcmp(dbuf[pbhAAZ],"<DIR.> ..")==0)
               {
                  pbhAZ=strlen(pbPath)-1;
                  while ( (pbhAZ>-1) && (pbPath[pbhAZ]!='/') )
                  {
                     pbPath[pbhAZ]='\0';
                     pbhAZ--;
                  }
                  pbPath[pbhAZ]='\0';

                  if (strlen(pbPath)==0) strcpy(pbPath,"/");

                  dOffset=0;
                  scNew=0;
                  scLast=0;
                  xwDisplayPBDir(0);

                  if (pbf.PBFlag!=0) XCopyArea(fl_display,pbf.PBPixmap,pbf.form->window,fl_get_gc(),0,dOffset,xcount*pbXSize,ycount*(pbXSize+pbYSize),210,10);
               }

               /* File - Drawer */
               else if (strlen(dbuf[pbhAAZ])<255)
               {
                  strcpy(pbhASTR,dbuf[pbhAAZ]);
                  pbhASTR[6]=0x00;
                  pbhStrPtr=dbuf[pbhAAZ];
                  pbhStrPtr=pbhStrPtr+7;
                  strcpy(pbhBSTR,pbhStrPtr);
                  if (strcmp(pbhASTR,"<FILE>") == 0)
                  {
                     strcpy(pbFile,pbhBSTR);
                     /* Set File Input Field */
                     fl_set_input(pbf.File,pbFile);
                  }
                  else if (strcmp(pbhASTR,"<DIR.>") == 0)
                  {
                     if (strlen(pbPath)>1)
                     {
                        strcat(pbPath,"/");
                     }
                     strcat(pbPath,pbhBSTR);

                     dOffset=0;
                     scNew=0;
                     scLast=0;
                     xwDisplayPBDir(0);
                     if (pbf.PBFlag!=0) XCopyArea(fl_display,pbf.PBPixmap,pbf.form->window,fl_get_gc(),0,dOffset,xcount*pbXSize,ycount*(pbXSize+pbYSize),210,10);
                  }
               }
            }
         }

         lock=0;
         pbhAAZ=-1;
         /*usleep(10000);*/
      }

      /* Mouse Actions */
      else if ( (eevent==FL_MOUSE) || (eevent==FL_MOTION) )
      {
         if ( (kkey==1) && (lock==0) )
         {
            pbhAAZ=-1;
            pbhAZ=0;
            for (pbhAY=0 ; pbhAY<dTotal ; pbhAY++)
            {
               for (pbhAX=0 ; pbhAX<xcount ; pbhAX++)
               {
                  if ( (mmx-210>=(pbXSize*pbhAX)) && (mmx-210<=(pbXSize*pbhAX)+pbXSize) && ((mmy-10)+dOffset>=((pbXSize+pbYSize)*pbhAY)) && ((mmy-10)+dOffset<=((pbXSize+pbYSize)*pbhAY)+pbXSize+pbYSize) )
                  {
                     pbhAAZ=pbhAZ;
                     lock=1; /*1;*/
                  }

                  pbhAZ++;
               }
            }

            if ( (pbhAAZ>-1) && (pbhAAZ<=dentrys) && (pbf.PBFlag!=0) )
            {
               fl_winset(pbf.PBPixmap);

               pbhAY=IRound(pbhAAZ/xcount);
               pbhAX=pbhAAZ-(pbhAY*xcount);

               fl_drw_box(FL_DOWN_BOX,(pbhAX*pbXSize),(pbhAY*(pbXSize+pbYSize))+pbXSize,pbXSize,pbYSize,FL_MCOL,1);

               /* Filename */
               pbhStrPtr=dbuf[pbhAAZ];
               pbhStrPtr=pbhStrPtr+7;
               if (strlen(pbhStrPtr)<255)
               {
                  strcpy(pbhASTR,pbhStrPtr);
               }
               else
               {
                  strcpy(pbhASTR,"???");
               }

               while ( fl_get_string_width(FL_NORMAL_STYLE,FL_NORMAL_SIZE,pbhASTR,strlen(pbhASTR)) >= 96)
               {
                  pbhASTR[strlen(pbhASTR)-1]=0x00;
               }

               fl_drw_text(FL_ALIGN_CENTER,(pbhAX*pbXSize),(pbhAY*(pbXSize+pbYSize))+pbXSize,pbXSize,pbYSize,FL_BLACK,FL_NORMAL_STYLE,FL_NORMAL_SIZE,pbhASTR);

               if (pbf.PBFlag!=0) XCopyArea(fl_display,pbf.PBPixmap,pbf.form->window,fl_get_gc(),0,dOffset,xcount*pbXSize,ycount*(pbXSize+pbYSize),210,10);

               fl_winset(pbf.form->window);
            }
         }

      }

      /* UnLock Handler */
      xwPBHandlerLock=0;
   }
   else
   {
      /*printf("xwGUI2: Handler Threaded (PicBrowser Handler)\n");*/
   }

   return(0);
}

/* Scrollbar Analyse */
void pbAction(FL_OBJECT *obj,long data)
{
   /* Scroolsbar */
   scNew=(int) fl_get_scrollbar_value(pbf.Slider);

   if (scNew<0) scNew=0;

   /* View Entrys */
   if (scLast != scNew)
   {
      scLast=scNew;
      dOffset=scNew;

      if (pbf.PBFlag!=0) XCopyArea(fl_display,pbf.PBPixmap,pbf.form->window,fl_get_gc(),0,dOffset,xcount*pbXSize,ycount*(pbXSize+pbYSize),210,10);
   }

   return;
}

/* Get Picture Browser Path */
char *xwGetPBPath(void)
{
   return(pbPath);
}

/* Set Picture Browser Path */
void xwSetPBPath(char *path)
{
   if (strlen(path)<1023)
   {
      strcpy(pbPath,path);
   }

   return;
}

/* ################################################################### */

/* Display Directory */
void xwDisplayPBDir(int mo)
{
   char              path[1024];
   char              *strptr;
   int               status;

   fl_deactivate_form(pbf.form);

   fl_freeze_form(pbf.form);

   /* Waiting for end of PBCache process */
   while (waitpid(pid,&status,WNOHANG)!=-1)
   {
      kill(pid,SIGINT);
      kill(pid,SIGTERM);
      usleep(100000);
   }

   /* Set Drawer Input Field */
   if (mo==0) fl_set_input(pbf.Drawer,pbPath);

   /* Path Browser */
   fl_clear_browser(pbf.PathBrowser);

   strcpy(path,pbPath);

   fl_addto_browser(pbf.PathBrowser,"/");
   if (strlen(path)>1)
   {
      strptr = strtok(path,"/");
      while (strptr != NULL)
      {
         fl_addto_browser(pbf.PathBrowser,strptr);
         strptr = strtok(NULL,"/");
      }
   }

   xwPBDirScan();

   /* File Browser Initialize */
   dTotal=(dentrys+1)/xcount;   /* Count of Lines */
   if (dTotal*xcount<dentrys+1) dTotal++;

   fl_set_scrollbar_bounds(pbf.Slider,0,(dTotal*(pbXSize+pbYSize))-(ycount*(pbXSize+pbYSize)));
   fl_set_scrollbar_value(pbf.Slider,dOffset);/*  0 */
   fl_set_scrollbar_step(pbf.Slider,1);
   fl_set_scrollbar_increment(pbf.Slider,ycount*(pbXSize+pbYSize),5);

   if (dTotal<=ycount)
   {
      fl_set_scrollbar_size(pbf.Slider,1);
   }
   else
   {
      fl_set_scrollbar_size(pbf.Slider,(float) (ycount*(pbXSize+pbYSize))/(float) (dTotal*(pbXSize+pbYSize)));
   }
   fl_unfreeze_form(pbf.form);

   fl_activate_form(pbf.form);

   /* Start PBCache Converting */
   if ( (pid=fork()) == 0)
   {
      xwCreatePBCacheTask(pbPath);
      exit(0);
   }

   return;
}


/* read Directory */
void xwPBDirScan(void)
{
   DIR               *dirz;
   struct dirent     *direntz;
   struct stat       attribut;
   struct stat       attribB;

   char              fname[256];

   char              path[1024];

   int               aaz;

   /* remove last directory entrys */
   if (dentrys>-1)
   {
      for (aaz=0 ; aaz<=dentrys ; aaz++)
      {
         free(dbuf[aaz]);
         dbuf[aaz] = NULL;
      }
      dentrys=-1;
   }

   strcpy(fname,"<DIR.> ..");
   dentrys++;
   dbuf[dentrys] = (char*) malloc(strlen(fname)+1);
   if (dbuf[dentrys] != NULL) strcpy(dbuf[dentrys],fname);

   if ( (dirz = opendir(pbPath)) != NULL )
   {
      while ( (direntz = readdir(dirz)) != NULL)
      {
         if ( strcmp(direntz->d_name,".") && strcmp(direntz->d_name,"..") )
         {
            if ( *direntz->d_name != '.' )
            {
               strcpy(path,pbPath);
               if (strlen(path)>1) strcat(path,"/");
               strcat(path,direntz->d_name);

               strcpy(fname,"");
               if ( stat(path,&attribut) == 0)
               {
                  if (lstat(path,&attribB) == 0)
                  {
                     if (S_ISLNK(attribB.st_mode))
                     {
                        if (S_ISREG(attribut.st_mode))
                        {
                           /* Dateityp erkennung */
                           if (xwCheckGFXFile(path)==0)
                           {
                              strcpy(fname,"<FILE> ");
                              strcat(fname,direntz->d_name);
                           }
                        }
                        else if (S_ISDIR(attribut.st_mode))
                        {
                           strcpy(fname,"<DIR.> ");
                           strcat(fname,direntz->d_name);
                        }
                     }
                     else
                     {
                        if (S_ISREG(attribut.st_mode))
                        {
                           /* Dateityp erkennung */
                           if (xwCheckGFXFile(path)==0)
                           {
                              strcpy(fname,"<FILE> ");
                              strcat(fname,direntz->d_name);
                           }
                        }
                        else if (S_ISDIR(attribut.st_mode))
                        {
                           strcpy(fname,"<DIR.> ");
                           strcat(fname,direntz->d_name);
                        }

                     }
                  }
               }

               /* write into array */
               if (strlen(fname) > 0)
               {
                  if (dentrys<4095)
                  {
                     dentrys++;
                     dbuf[dentrys] = (char*) malloc(strlen(fname)+1);
                     if (dbuf[dentrys] != NULL)
                     {
                        strcpy(dbuf[dentrys],fname);
                     }
                     else
                     {
                        dentrys--;
                     }
                     dflag[dentrys]=0;
                  }
               }
            }
         }
      }

      closedir(dirz);
   }

   if (dentrys > -1)
   {
      qsort(dbuf,dentrys+1,sizeof(dbuf[0]),xwPBDirSort);

      xwCreatePixmapDir();
   }

   return;
}

/* Compare for Sort */
int xwPBDirSort(const void *Z1,const void *Z2)
{
   const char        **z1=(const char **) Z1;
   const char        **z2=(const char **) Z2;
   const char        *strptr;
   unsigned int      zpos;
   char              aas[1024],bbs[1024],ccs[1024];

   strcpy(aas,*z1);
   strcpy(bbs,*z2);

   zpos=0;
   while ( (zpos<strlen(aas)) && (aas[zpos]!='<') ) zpos++;
   strptr = &aas[zpos];
   strcpy(ccs,strptr);
   strcpy(aas,"<");
   strcat(aas,ccs);

   zpos=0;
   while ( (zpos<strlen(bbs)) && (bbs[zpos]!='<') ) zpos++;
   strptr = &bbs[zpos];
   strcpy(ccs,strptr);
   strcpy(bbs,"<");
   strcat(bbs,ccs);

   return(strcmp(aas,bbs));
}

/* ------------------------------------------------------------------- */

/* Create Pixmap Directory */
void xwCreatePixmapDir(void)
{
   int            az;
   int            pos;
   int            xz,yz;

   char           astr[256],bstr[256],cstr[256];

   char           *strptr;

   /* destroy directory pixmap */
   if (pbf.PBFlag!=0)
   {
      XFreePixmap(fl_display,pbf.PBPixmap);
      pbf.PBFlag=0;

      xwGFXRemovePaper();
   }

   /* Calculate new Pixmap Size */
   pbf.PBXRes=xcount*pbXSize;

   az=(dentrys+1)/xcount;   /* Count of Lines */
   if (az*xcount<dentrys+1) az++;

   pbf.PBYRes=az*(pbXSize+pbYSize);

   if ( (pbf.PBXRes<pbf.FrameB->w) && (pbf.PBYRes<pbf.FrameB->h) )
   {
      pbf.PBXRes=pbf.FrameB->w;
      pbf.PBYRes=pbf.FrameB->h;
   }

/* ######################################################################################################################################## */
/* \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/ */

   /*xwTime("--> Start of Drawing");*/

   /* Create Pixmap */
   pbf.PBPixmap = XCreatePixmap(fl_display,fl_root,pbf.PBXRes,pbf.PBYRes,fl_get_visual_depth());

   if (pbf.PBPixmap>0)
   {
      pbf.PBFlag=1;

      /* Draw all Filenames in Pixmap */
      fl_winset(pbf.PBPixmap);

      fl_rectf(0,0,pbf.PBXRes,pbf.PBYRes,FL_COL1);

      dflagCount=-1;

      /* first entry */
      pos=0;
      for (yz=0 ; yz<=az ; yz++)
      {
         for (xz=0 ; xz<xcount ; xz++)
         {
            if (pos<=dentrys)
            {
               fl_drw_box(FL_UP_BOX,(xz*pbXSize),(yz*(pbXSize+pbYSize))+pbXSize,pbXSize,pbYSize,FL_COL1,1);

               /* Filename */
               strptr=dbuf[pos];
               strptr=strptr+7;
               if (strlen(strptr)<255)
               {
                  strcpy(astr,strptr);
               }
               else
               {
                  strcpy(astr,"???");
               }

               /* FileType */
               strcpy(bstr,dbuf[pos]);
               bstr[7]=0x00;

               /* Filename */
               strcpy(cstr,astr);

               /* Parent Directory */
               if ( (strcmp(bstr,"<DIR.> ")==0) && (strcmp(cstr,"..")==0) && (pixParent>0) )
               {
                  XCopyArea(fl_display,pixParent,pbf.PBPixmap,fl_get_gc(),0,0,100,100,xz*pbXSize,yz*(pbXSize+pbYSize));
               }
               /* Normal Directory */
               else if ( (strcmp(bstr,"<DIR.> ")==0) && (pixDrawer>0) )
               {
                  XCopyArea(fl_display,pixDrawer,pbf.PBPixmap,fl_get_gc(),0,0,100,100,xz*pbXSize,yz*(pbXSize+pbYSize));
               }
               /* Normal File */
               else if (strcmp(bstr,"<FILE> ")==0)
               {
                  dflag[pos]=1;
                  dflagCount++;
                  XCopyArea(fl_display,pixError,pbf.PBPixmap,fl_get_gc(),0,0,100,100,xz*pbXSize,yz*(pbXSize+pbYSize));
               }

               while ( fl_get_string_width(FL_NORMAL_STYLE,FL_NORMAL_SIZE,astr,strlen(astr)) >= 96)
               {
                  astr[strlen(astr)-1]=0x00;
               }

               fl_drw_text(FL_ALIGN_CENTER,(xz*pbXSize),(yz*(pbXSize+pbYSize))+pbXSize,pbXSize,pbYSize,FL_BLACK,FL_NORMAL_STYLE,FL_NORMAL_SIZE,astr);
            }

            pos++;
         }
      }

      dposCount=0;

      tempPos=0;
      tempCount=0;
      xwGFXPaintPicture(memTemp,204,204,204);

      XCopyArea(fl_display,pbf.PBPixmap,pbf.form->window,fl_get_gc(),0,0,xcount*pbXSize,ycount*(pbXSize+pbYSize),210,10);

      fl_winset(pbf.form->window);

      /* Start PBCache Converting */
      /*
      if ( (pidd=fork()) == 0)
      {
         xwPBLoad();
         exit(0);
      }
      */
   }

   return;
}

/* View Preview Picture */
void xwPBViewPicture(void)
{
   int         pos,xsize,ysize;
   float       aspect;

   char        astr[1500],bstr[1500];

   xwGFXSaveTemp();

   fl_hide_object(pbf.Drawer);
   fl_hide_object(pbf.File);
   fl_hide_object(pbf.OK);
   fl_hide_object(pbf.CANCEL);
   fl_show_object(pbf.Progress);

   fl_deactivate_form(pbf.form);

   /* Convert Picture to XPM */
   if (strlen(pbFile)>0)
   {
      strcpy(pbSelect,pbPath);
      if (strlen(pbSelect)>1) strcat(pbSelect,"/");
      strcat(pbSelect,pbFile);

      fl_check_forms();

      strcpy(astr,pbSelect);
      strcpy(bstr,xwGetFile("","imageA.ppm"));
      if (xwGFXImport(astr,bstr)<0)
      {
         xwDisplayMessage(pbf.form,"xwGUI: image import failed !!!");
         unlink(xwGetFile("","imageA.ppm"));
      }
      else
      {
         fl_check_forms();

         /* Get Source Datas */
         if (checkppm(xwGetFile("","imageA.ppm"))==0)
         {
            pos=xwGetGFXP();
            xsize=xwGetGFXX();
            ysize=xwGetGFXY();
            aspect=(float) xsize /(float) ysize;

            /* Check High */
            if (((int) (190/aspect))<190)
            {
               xsize=190;
               ysize=(int) (190/aspect);
            }
            /* Check Width */
            else if (((int) (190*aspect))<190)
            {
               xsize=(int) (190*aspect);
               ysize=190;
            }
            else
            {
               xsize=190;
               ysize=190;
            }

            fl_check_forms();

            /* Scalling */
            strcpy(astr,xwGetFile("","imageA.ppm"));
            strcpy(bstr,xwGetFile("","imageB.ppm"));
            if (xwGFXLoadPicture(astr)==xwTrue)
            {
               xwGFXSetTrans(0);
               xwGFXScalePicture(memPicture,createTemp,0,0,xsize,ysize,0);
               xwGFXSavePicture(bstr);
               xwGFXRemovePicture();

               fl_check_forms();

               unlink(xwGetFile("","imageA.ppm"));
               strcpy(astr,xwGetFile("","imageB.ppm"));
               strcpy(bstr,xwGetFile("","preview.xpm"));
               xwGFXXPM(astr,bstr);
               unlink(xwGetFile("","imageB.ppm"));

               fl_free_pixmapbutton_pixmap(pbf.Picture);
               fl_set_pixmap_data(pbf.Picture,FSEmpty190_xpm);
               fl_free_pixmapbutton_pixmap(pbf.Picture);
               fl_set_pixmap_file(pbf.Picture,xwGetFile("","preview.xpm"));
               unlink(xwGetFile("","preview.xpm"));
            }

         }
      }
   }

   fl_activate_form(pbf.form);

   fl_hide_object(pbf.Progress);
   fl_show_object(pbf.Drawer);
   fl_show_object(pbf.File);
   fl_show_object(pbf.OK);
   fl_show_object(pbf.CANCEL);

   xwGFXLoadTemp();

   return;
}

/* ------------------------------------------------------------------- */

/* Load Pixmaps for Overview */
void xwPBLoad(void)
{
   double            factor;
   int               ax,ay,az;
   static char       path[2048];
   static char       file[256];
   char              *strptr;

   Pixmap            pixmap;

   if (dposCount<=dentrys)
   {
      /* Entry is an File */
      if (dflag[dposCount]==1)
      {
         strcpy(path,pbPath);
         if (strlen(path)>1) strcat(path,"/");
         strptr=dbuf[dposCount];
         strptr=strptr+7;
         strcat(path,strptr);

         xwGetFileID(path,file);

         strcpy(path,xwGetFile("","PBCache/"));
         strcat(path,file);

         if (xwExist(path)==xwTrue)
         {
            if (xwGFXLoadPicture(path)==xwTrue)
            {
               xwGFXCopyPicture(memPicture,memTemp,(100*tempCount)+(100-xwGFXGetPictureX())/2,(100-xwGFXGetPictureY())/2);
               if (tempCount==0) tempPos=dposCount;
               tempCount++;

               /*xwGFXCopySpecial(0,0,100,100,204,204,204);*/

               if (tempCount==pbCount)
               {
                  pixmap=xwGFXCreatePixmap(memTemp);
                  if (pixmap>=0)
                  {
                     for (az=0 ; az<tempCount ; az++)
                     {
                        ay=IRound(tempPos/xcount);
                        ax=tempPos-(ay*xcount);
                        XCopyArea(fl_display,pixmap,pbf.PBPixmap,fl_get_gc(),(100*az),0,100,100,ax*pbXSize,ay*(pbXSize+pbYSize));

                        tempPos++;

                        dflagCount--;
                        dflag[dposCount]=2;
                     }
                     XFreePixmap(fl_display,pixmap);
                     XCopyArea(fl_display,pbf.PBPixmap,pbf.form->window,fl_get_gc(),0,dOffset,xcount*pbXSize,ycount*(pbXSize+pbYSize),210,10);

                     xwGFXPaintPicture(memTemp,204,204,204);

                     tempCount=0;
                  }
               }

               xwGFXRemovePicture();

               dposCount++;
            }
         }
         else
         {
            usleep(10000);
         }
      }
      else
      {
         dposCount++;
      }

   }
   else
   {
      if (tempCount>0)
      {
         pixmap=xwGFXCreatePixmap(memTemp);
         if (pixmap>=0)
         {
            for (az=0 ; az<tempCount ; az++)
            {
               ay=IRound(tempPos/xcount);
               ax=tempPos-(ay*xcount);
               XCopyArea(fl_display,pixmap,pbf.PBPixmap,fl_get_gc(),(100*az),0,100,100,ax*pbXSize,ay*(pbXSize+pbYSize));

               tempPos++;

               dflagCount--;
               dflag[dposCount]=2;
            }
            XFreePixmap(fl_display,pixmap);
            XCopyArea(fl_display,pbf.PBPixmap,pbf.form->window,fl_get_gc(),0,dOffset,xcount*pbXSize,ycount*(pbXSize+pbYSize),210,10);

            xwGFXPaintPicture(memTemp,204,204,204);

            tempCount=0;
         }
      }

      if (tempCount==0)
      {
         /*xwTime("<-- End of Drawing");*/
         tempCount=-1;
      }
   }

   return;
}
