/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "pbcache.h"

#include "base.h"
#include "error.h"
#include "fileio.h"
#include "gfx.h"
#include "limits.h"
#include "picbrowser.h"
#include "progress.h"
#include "resource.h"

#define TRENNZEICHEN    '/'

static int        refresh;

static int        dirCount;
static int        fileCount;
static int        scanMode;

static char       FileIDA[1024];
static char       FileIDB[1024];
static char       FileIDC[1024];

static char       astr[255];
static char       dirStr[255];
static char       fileStr[255];

/* scan directory's and create cache entrys */
void xwCreatePBCache(char *path)
{
   xwOpenProgress(0,1,1,0,1,1);
   xwSetLabelProgress(xwGR(1,"pf.convert","Scan Directory for Pictures...")," "," ");
   xwSetLabelProgress("",xwGR(1,"pf.drawer","Drawers..."),"");
   xwSetLabelProgress("","",xwGR(1,"pf.files","Files..."));

   xwCheckProgressA();

   strcpy(dirStr,xwGR(1,"pf.drawer","Drawers..."));
   strcat(dirStr," (");
   strcpy(fileStr,xwGR(1,"pf.files","Files..."));
   strcat(fileStr," (");

   /* Scan Counts of Dirs and Files */
   scanMode=0;
   dirCount=1;
   fileCount=0;
   refresh=0;
   xwPBScanDir(path);

   strcpy(astr,dirStr);
   strcat(astr,IntStr(dirCount));
   strcat(astr,")");
   xwSetLabelProgress("",astr,"");
   strcpy(astr,fileStr);
   strcat(astr,IntStr(fileCount));
   strcat(astr,")");
   xwSetLabelProgress("","",astr);
   xwCheckProgressA();

   /* Set Count of Dirs and Files */

   /* Count of Dirs */
   fl_set_slider_bounds(xwGetPW(0),0,dirCount);
   fl_set_slider_step(xwGetPW(0),1);
   fl_set_slider_value(xwGetPW(0),0);
   /* Count of Files */
   fl_set_slider_bounds(xwGetPW(1),0,fileCount);
   fl_set_slider_step(xwGetPW(1),1);
   fl_set_slider_value(xwGetPW(1),0);

   /* Scan and Convert Pictures to PBCache Datas */
   scanMode=1;
   dirCount=1;
   fileCount=0;
   xwPBScanDir(path);

   xwCloseProgress();

   return;
}

/* create pbCach Entrys in Background */
void xwCreatePBCacheTask(char *path)
{
   /* Scan and Convert Pictures to PBCache Datas */
   scanMode=2;
   dirCount=1;
   fileCount=0;
   xwPBScanDir(path);

   return;
}

void xwPBScanDir(char *path)
{
   char           xwPath[2048];
   char           file[256];
   struct stat    attributeA;
   struct stat    attributeB;
   struct dirent  *direntz;
   DIR            *dirz;

   if ( (dirz = opendir(path)) != NULL )
   {
      while ( ((direntz = readdir(dirz)) != NULL) && (xwCheckProgress()==-1) )
      {      
         if (scanMode==1)
         {
            xwCheckProgressA();
         }
         else if (scanMode==0)
         {
            refresh++;
            if (refresh>100)
            {
               strcpy(astr,dirStr);
               strcat(astr,IntStr(dirCount));
               strcat(astr,")");
               xwSetLabelProgress("",astr,"");
               strcpy(astr,fileStr);
               strcat(astr,IntStr(fileCount));
               strcat(astr,")");
               xwSetLabelProgress("","",astr);
               xwCheckProgressA();
               refresh=0;
            }
         }

         if (strcmp(direntz->d_name,".") && strcmp(direntz->d_name,"..") )
         {
            strcpy(xwPath,path);
            if (strlen(xwPath)>1) strcat(xwPath,"/");
            strcat(xwPath,direntz->d_name);
            strcpy(file,direntz->d_name);

            if (stat(xwPath,&attributeA) == 0)
            {
               if (lstat(xwPath,&attributeB) == 0)
               {
                  if (S_ISLNK(attributeB.st_mode))
                  {
                     /* Normal File */
                     if (S_ISREG(attributeA.st_mode))
                     {
                        fileCount++;

                        if (scanMode==1)
                        {
                           fl_set_slider_value(xwGetPW(1),fileCount);

                           /* Picture File */
                           if (xwCheckGFXFile(xwPath)==0)
                           {
                              xwGetFileID(xwPath,FileIDA);
                              strcpy(FileIDB,xwGetFile("","PBCache/"));
                              strcat(FileIDB,FileIDA);
                              xwPBSmallPicture(xwPath,FileIDB);
                           }
                        }
                        else if (scanMode==2)
                        {
                           /* Picture File */
                           if (xwCheckGFXFile(xwPath)==0)
                           {
                              xwGetFileID(xwPath,FileIDA);
                              strcpy(FileIDB,xwGetFile("","PBCache/"));
                              strcat(FileIDB,"TEMP");
                              strcpy(FileIDC,xwGetFile("","PBCache/"));
                              strcat(FileIDC,FileIDA);

                              if (xwExist(FileIDC)==xwFalse)
                              {
                                 xwPBSmallPicture(xwPath,FileIDB);
                                 link(FileIDB,FileIDC);
                                 unlink(FileIDB);
                              }
                           }
                        }
                     }
                  }
                  else
                  {
                     /* Normal File */
                     if (S_ISREG(attributeA.st_mode))
                     {
                        fileCount++;

                        if (scanMode==1)
                        {
                           fl_set_slider_value(xwGetPW(1),fileCount);

                           /* Picture File */
                           if (xwCheckGFXFile(xwPath)==0)
                           {
                              xwGetFileID(xwPath,FileIDA);
                              strcpy(FileIDB,xwGetFile("","PBCache/"));
                              strcat(FileIDB,FileIDA);
                              xwPBSmallPicture(xwPath,FileIDB);
                           }
                        }
                        else if (scanMode==2)
                        {
                           /* Picture File */
                           if (xwCheckGFXFile(xwPath)==0)
                           {
                              xwGetFileID(xwPath,FileIDA);
                              strcpy(FileIDB,xwGetFile("","PBCache/"));
                              strcat(FileIDB,"TEMP");
                              strcpy(FileIDC,xwGetFile("","PBCache/"));
                              strcat(FileIDC,FileIDA);

                              if (xwExist(FileIDC)==xwFalse)
                              {
                                 xwPBSmallPicture(xwPath,FileIDB);
                                 link(FileIDB,FileIDC);
                                 unlink(FileIDB);
                              }
                           }
                        }
                     }
                     /* Normal Drawer */
                     else if ( (S_ISDIR(attributeA.st_mode)) && (scanMode<2) )
                     {
                        dirCount++;

                        if (scanMode==1)
                        {
                           fl_set_slider_value(xwGetPW(0),dirCount);
                        }

                        if ( (file[0]!='.') && (strcmp(file,"nsmail")) && (strcmp(file,"Mail")) && (strcmp(file,"plugins")) )
                        {
                           xwPBScanDir(xwPath);
                        }
                     }
                  }
               }
            }
         }
      }
      closedir(dirz);
   }

   return;
}

/* ------------------------------------------------------------------- */

/* Create FileID */
void xwGetFileID(char *source,char *dest)
{
   static char       ID[1024],IDS[1024],IDBuff[1024];
   struct stat       statp;
   static char       *strptr;

   int               IDNr;

   if (strlen(source)<1023)
   {
      /* Preview */
      strcpy(ID,"");
      strcpy(IDS,source);

      /* Filter Filename */
      strptr = strrchr(IDS,TRENNZEICHEN);
      if (strptr != NULL)
         {
            strptr++;
            strcat(ID,strptr);
         }
      else
         {
            strcat(ID,IDS);
         }
      strcat(ID,"-");

      /* Create Size */
      if (strlen(IDS)>0)
      {
         if (stat(IDS,&statp) == 0)
         {
            /* Size */
            IDNr=statp.st_size;
            sprintf(IDBuff,"%x",IDNr);
            strcat(ID,IDBuff);

            /* INode */
            IDNr=statp.st_ino;
            sprintf(IDBuff,"%x",IDNr);
            strcat(ID,IDBuff);

            /* last modify */
            IDNr=statp.st_mtime;
            sprintf(IDBuff,"%x",IDNr);
            strcat(ID,IDBuff);

            strcat(ID,"PPM");
         }
      }
   }

   strcpy(dest,ID);

   return;
}

/* View Small Picture */
void xwPBSmallPicture(char *source, char *dest)
{
   int         pos,xsize,ysize;
   float       aspect;

   char        astr[1500],bstr[1500];

   /* Convert Picture to XPM */
   if (strlen(source)>0)
   {
      strcpy(bstr,xwGetFile("","imageAA.ppm"));
      if (xwGFXImport(source,bstr)<0)
      {
         xwDisplayMessage(NULL,"xwGUI: image import failed !!!");
         unlink(xwGetFile("","imageAA.ppm"));
      }
      else
      {
         /* Get Source Datas */
         if (checkppm(xwGetFile("","imageAA.ppm"))==0)
         {
            pos=xwGetGFXP();
            xsize=xwGetGFXX();
            ysize=xwGetGFXY();
            aspect=(float) xsize /(float) ysize;

            /* Check High */
            if (((int) (100/aspect))<100)
            {
               xsize=100;
               ysize=(int) (100/aspect);
            }
            /* Check Width */
            else if (((int) (100*aspect))<100)
            {
               xsize=(int) (100*aspect);
               ysize=100;
            }
            else
            {
               xsize=100;
               ysize=100;
            }

            /* Scalling */
            strcpy(astr,xwGetFile("","imageAA.ppm"));
            if (xwGFXLoadSPicture(astr)==xwTrue)
            {
               xwGFXSetTrans(0);
               xwGFXScalePicture(memSPicture,createSTemp,0,0,xsize,ysize,0);
               xwGFXSaveSPicture(dest);
               xwGFXRemoveSPicture();
               unlink(astr);
            }
         }
      }
   }

   return;
}

/* scan cache directory and delete unused files */
void xwCleanPBCache(void)
{
   char           xwPath[1024];
   char           path[1024];
   char           astr[1024];
   char           *strptr;
   struct stat    attribute;
   struct dirent  *direntz;
   DIR            *dirz;

   long           btime;
   struct tm      *btm;
   time_t         btimet;
   int            bdiff;

   /* cache directory */
   strcpy(xwPath,xwGetFile("","PBCache"));

   if ( (dirz = opendir(xwPath)) != NULL )
   {
      while ( (direntz = readdir(dirz)) != NULL)
      {
         if ( strcmp(direntz->d_name,".") && strcmp(direntz->d_name,"..") )
         {
            strcpy(path,xwPath);
            strcat(path,"/");
            strcat(path,direntz->d_name);

            if ( stat(path,&attribute) == 0)
            {
               if (S_ISREG(attribute.st_mode))
               {
                  /* delete unused preview-picture after 30 days */
                  btime = time(0);
                  btm = localtime(&btime);
                  btimet=mktime(btm);

                  bdiff=(int) (difftime(btimet,attribute.st_atime)/86400);

                  if (bdiff>=30)
                  {
                     unlink(path);
                  }
                  else
                  {
                     /* delete wysiwyg cache entrys */
                     strcpy(astr,direntz->d_name);
                     if (strlen(astr)>strlen(wysName))
                     {
                        strptr=astr;
                        strptr=strptr+strlen(wysName);
                        strptr[0]=0x00;
                        if (strcmp(astr,wysName) == 0)
                        {
                           unlink(path);
                        }
                     }
                  }
               }
            }
         }
      }
      closedir(dirz);
   }

   return;
}

/* scan cache directory and delete all files */
void xwDeletePBCache(void)
{
   char           xwPath[1024];
   char           path[1024];
   struct stat    attribute;
   struct dirent  *direntz;
   DIR            *dirz;

   /* cache directory */
   strcpy(xwPath,xwGetFile("","PBCache"));

   if ( (dirz = opendir(xwPath)) != NULL )
   {
      while ( (direntz = readdir(dirz)) != NULL)
      {
         if (strcmp(direntz->d_name,".") && strcmp(direntz->d_name,"..") )
         {
            strcpy(path,xwPath);
            strcat(path,"/");
            strcat(path,direntz->d_name);

            if ( stat(path,&attribute) == 0)
            {
               if (S_ISREG(attribute.st_mode))
               {
                  unlink(path);
               }
            }
         }
      }
      closedir(dirz);
   }

   return;
}

/* delete and wysiwyg entry */
void xwDeletePBEntry(char *source)
{
   char        dest[1024];
   char        IDNr[1024]; /* INode Number */
   struct stat attribute;

   strcpy(dest,xwGetFile("","PBCache"));
   strcat(dest,"/");
   strcat(dest,wysName);
   strcat(dest,"-");

   if (stat(source,&attribute) == 0)
   {
      sprintf(IDNr,"%x",(int) attribute.st_ino);
      strcat(dest,IDNr);

      unlink(dest);
   }

   return;
}

