/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWPAPER_H
#define _XWPAPER_H

/* Paper Size */
#define psA5            1
#define psA4            2
#define psA3            3
#define psExecutiv      4
#define psLetter        5
#define psLegal         6
#define psLedger        7
#define psTabloid       8
#define psPanorama      9
#define psCustom        10

/* Portrait / Landscape */
#define xwPortrait      0
#define xwLandscape     1

typedef struct paperdef
{
   int               ID;
   char              name[40];
   float             width;
   float             height;
} paperdef;

typedef struct paperdatas
{
   /* Paper ID */
   int               page;
   /* Page Size and Aspect Ratio in mm */
   float             pagex;
   float             pagey;
   float             paspect;
   /* Page Borders in mm */
   int               pagel;         /* Left Border */
   int               pager;         /* Right Border */
   int               paget;         /* Top Border */
   int               pageb;         /* Bottom Border */
   /* Landscape */
   int               landscape;
   
} paperdatas;

/* Init Paper */
void xwInitPaper(void);

/* GetPaperXSize */
int xwGetPaperXSize(void);
/* GetPaperYSize */
int xwGetPaperYSize(void);
/* Get Left Border */
int xwGetPaperLB(void);
/* Get Right Border */
int xwGetPaperRB(void);
/* Get Top Border */
int xwGetPaperTB(void);
/* Get Bottom Border */
int xwGetPaperBB(void);
/* Get X-Size - L+R-Borders */
int xwGetPaperXB(void);
/* Get Y-Size - T+B-Borders */
int xwGetPaperYB(void);

/* ### Paper Managment ### */

/* Get First Paper */
char *xwGetPaperName(void);
/* Get Next Paper */
char *xwGetNextPaperName(void);
/* Get Entry Number */
int xwGetEntryNumber(int ID);
/* Get ID Number */
int xwGetIDNumber(int Entry);
/* Get ID Number */
int xwGetID(void);
/* Set ID Number */
void xwSetID(int Entry);

/* Get Paper Width */
float xwGetPaperWidth(int entry);
/* Get Paper Height */
float xwGetPaperHeight(int entry);

/* IsPaperLS */
int xwIsPaperLS(void);
/* Set PaperLS */
void xwSetPaperLS(int mo);

/* Set Paper X-Size */
void xwSetPaperX(float az);
/* Set Paper Y-Size */
void xwSetPaperY(float az);
/* Set Left Border */
void xwSetPaperLB(int az);
/* Set Right Border */
void xwSetPaperRB(int az);
/* Set Top Border */
void xwSetPaperTB(int az);
/* Set Bottom Border */
void xwSetPaperBB(int az);


/* Set Paper Size */
void xwSetPaperSize(int mo,int xx,int yy);
/* Draw Paper */
void xwDrawPaper(void);

#endif