/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWPAGE_H
#define _XWPAGE_H

#include "limits.h"

#include <forms.h>

#define pgRedraw        0  /* ReDraw Paper */
#define pgMove          0  /* Move Paper */
#define pgRecalc        2  /* ReCalc Paper */
#define pgRemove     1234
#define pgNone       9999  /* No Action */

typedef struct pagedata
{
   /* ################################################################ */
   /* Slider Managment */

   /* Slider-Size */
   float             xSLSize;
   float             ySLSize;

   /* Actual Slider Size */
   double            ax,ay;

   /* Page Frame Size */
   int               xPSize;
   int               yPSize;

   int               Flag;

   Pixmap            pixmap;

   /* ################################################################ */
   /* Real WYSIWYG */
   Pixmap            xpixmap;
   int               xflag;
   unsigned int      xpXSize;
   unsigned int      xpYSize;
   float             xdpi;
   
   /* ################################################################ */
   /* Pseudo WYSIWYG */   
   int               xPWSize;
   int               yPWSize;
   Pixmap            PWPixmap;
   
} pagedata;


/* Init Page Datas */
void xwPageInit(void);
/* Free XPixmap */
void xwFreeXPixmap(void);
/* ReDraw Page */
void xwDrawPage(int mi);
/* Scrollbar Initialisation */
void xwSCRB(void);
/* Lock Page */
void xwLockPage(void);
/* UnLock Page */
void xwUnLockPage(void);

#endif