/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "page.h"

#include "base.h"
#include "default.h"
#include "frame.h"
#include "gfx.h"
#include "lowlevel.h"
#include "main_action.h"
#include "main_gui.h"
#include "paper.h"
#include "picture.h"
#include "render.h"
#include "resource.h"
#include "time.h"
#include "wysiwyg.h"
#include "x11.h"

extern struct mainform     mf;

struct pagedata            pd;   /* Page Datas */

/* Init Page Datas */
void xwPageInit(void)
{
   pd.xSLSize=-1;
   pd.ySLSize=-1;

   pd.xPSize=0;
   pd.yPSize=0;

   pd.Flag=0;

   /* REAL WYSIWYG */
   pd.xflag=0;

   return;
}

/* Free XPixmap */
void xwFreeXPixmap(void)
{
   int            az,bz;

   /* Free Real WYSIWYG Pixmap */
   if (pd.xflag==1)
   {
      pd.xflag=0;
      XFreePixmap(fl_display,pd.xpixmap);
   }

   /* Free Pseudo WYSIWYG Pixmaps */
   if (xwGetFrameCount()>-1)
   {
      bz=xwGetFrameCount();
      for (az=0 ; az<=bz ; az++)
      {
         xwClearFramePixmap(az);
      }
   }
   if (xwGetPictureCount()>-1)
   {
      bz=xwGetPictureCount();
      for (az=0 ; az<=bz ; az++)
      {
         xwClearPicturePixmap(az);
      }
   }

   return;
}

/* ReDraw Page */
void xwDrawPage(int mi)
{
   int            mo;

   int            az,bz;
   int            xa,ya;

   if ((pd.Flag==0) && (xwGetPrefValue(xwgAssLock)==0))
   {
      pd.Flag=1;

      mo=mi;
      
      /* Landscape/Portrait Information */
      if (xwIsPaperLS()==xwLandscape)
      {
         fl_set_object_label(mf.PaperLP,"LANDSCAPE");
      }
      else
      {
         fl_set_object_label(mf.PaperLP,"PORTRAIT");
      }

      /* Normal/LOW WYSIWYG/HIGH WYSIWYG */
      if (xwGetPrefValue(xwgWYSIWYG)==wmNormal)
      {
         fl_set_object_label(mf.WYSIWYG,"NORM");
      }
      else if (xwGetPrefValue(xwgWYSIWYG)==wmLWYSIWYG)
      {
         fl_set_object_label(mf.WYSIWYG,"LQ");
      }
      else if (xwGetPrefValue(xwgWYSIWYG)==wmHWYSIWYG)
      {
         fl_set_object_label(mf.WYSIWYG,"HQ");
      }

      pd.xPSize=mf.PaperFrame->w;
      pd.yPSize=mf.PaperFrame->h;

      xwSetPixelSize(xwGetPaperXSize(),xwGetPaperYSize());

      xwSCRB();
      xwSCRB();

      /*                                                           6 */
      if ( (xwGetPrefValue(xwgWYSIWYG)==wmNormal) || (xwGetZoomV()>7) ) /* || ((xwCheckFrameMode()==xwTrue) && (xwCheckEditFrame()==xwTrue)) ) */
      {
         /* No WYSIWYG */

         /* Pixmap experiment */
         pd.pixmap = XCreatePixmap(fl_display,fl_root,pd.xPSize,pd.yPSize,fl_get_visual_depth());

         if ( (mf.PaperFrame->w!=pd.xPSize) || (mf.PaperFrame->h!=pd.yPSize) || (pd.ax==1) || (pd.ay==1) )
         {
            xwDraw(clearPaper,0,0,0,0);
            pd.xPSize=mf.PaperFrame->w;
            pd.yPSize=mf.PaperFrame->h;
         }

         /* Draw Paper */
         xwDrawPaper();

         /* Draw Frames */
         xwDrawFrame();

         XCopyArea(fl_display,pd.pixmap,mf.form->window,fl_get_gc(),0,0,pd.xPSize,pd.yPSize,mf.PaperFrame->x,mf.PaperFrame->y);
         XFreePixmap(fl_display,pd.pixmap);
      }
      else if (xwGetPrefValue(xwgWYSIWYG)==wmHWYSIWYG)
      {
         /* REAL WYSIWYG - HQ */

         xwSetRealMode();
         
         if (mo==pgRecalc)
         {
            /* free old pixmap */
            if (pd.xflag==1)
            {
               XFreePixmap(fl_display,pd.xpixmap);
               pd.xflag=0;
            }

            if (xwIsPaperLS()==xwPortrait)
            {
               xwGFXLandscape(0);
            }
            else
            {
               xwGFXLandscape(1);
            }

            /* render new pixmap */
            pd.xpXSize=(int) (((float) xwGetPaperXB()*xwGetZoom())*xwGetPixelSize());
            pd.xpYSize=(int) (((float) xwGetPaperYB()*xwGetZoom())*xwGetPixelSize());
            pd.xdpi=( ( (float) xwGetPaperXB() * (float) xwGetPixelSize() ) / ((float) xwGetPaperXB()/25.4) )*xwMM();

            if ((pd.xpixmap=xwRender(pd.xdpi,1,xwGetPaperXB(),xwGetPaperYB()))!=-1)
            {
               pd.xflag=1;
            }
            else
            {
               pd.xflag=0;
            }
         }

         /* draw pixmap */
         if (pd.xflag==1)
         {
            /* Pixmap experiment */
            pd.pixmap = XCreatePixmap(fl_display,fl_root,pd.xPSize,pd.yPSize,fl_get_visual_depth());

            if ( (mf.PaperFrame->w!=pd.xPSize) || (mf.PaperFrame->h!=pd.yPSize) || (pd.ax==1) || (pd.ay==1) )
            {
               xwDraw(clearPaper,0,0,0,0);
               pd.xPSize=mf.PaperFrame->w;
               pd.yPSize=mf.PaperFrame->h;
            }

            /* Draw Paper */
            xwDrawPaper();

            /* copy rendert picture */
            if (xwIsPaperLS()==xwPortrait)
            {
               XCopyArea(fl_display,pd.xpixmap,pd.pixmap,fl_get_gc(),0,0,pd.xpXSize,pd.xpYSize,
                         (int) ( (float) xwGetPaperLB()*xwGetPixelSize() ) - xwGetXOffset(),
                         (int) ( (float) xwGetPaperTB()*xwGetPixelSize() ) - xwGetYOffset()
                        );
            }
            else
            {
               XCopyArea(fl_display,pd.xpixmap,pd.pixmap,fl_get_gc(),0,0,pd.xpYSize,pd.xpXSize,
                         (int) ( (float) xwGetPaperBB()*xwGetPixelSize() ) - xwGetXOffset(),
                         (int) ( (float) xwGetPaperLB()*xwGetPixelSize() ) - xwGetYOffset()
                        );
            }

            /* Draw Border Frame */
            xwDraw(drawBorder,xwGetPaperLB(),xwGetPaperTB(),xwGetPaperXB(),xwGetPaperYB());

            /* Draw Frames */
            xwDrawFrame();

            XCopyArea(fl_display,pd.pixmap,mf.form->window,fl_get_gc(),0,0,pd.xPSize,pd.yPSize,mf.PaperFrame->x,mf.PaperFrame->y);
            XFreePixmap(fl_display,pd.pixmap);
         }
         else
         {
            /* Pixmap experiment */
            pd.pixmap = XCreatePixmap(fl_display,fl_root,pd.xPSize,pd.yPSize,fl_get_visual_depth());

            if ( (mf.PaperFrame->w!=pd.xPSize) || (mf.PaperFrame->h!=pd.yPSize) || (pd.ax==1) || (pd.ay==1) )
            {
               xwDraw(clearPaper,0,0,0,0);
               pd.xPSize=mf.PaperFrame->w;
               pd.yPSize=mf.PaperFrame->h;
            }

            /* Draw Paper */
            xwDrawPaper();

            /* Draw Frames */
            xwDrawFrame();

            XCopyArea(fl_display,pd.pixmap,mf.form->window,fl_get_gc(),0,0,pd.xPSize,pd.yPSize,mf.PaperFrame->x,mf.PaperFrame->y);
            XFreePixmap(fl_display,pd.pixmap);
         }
         
         xwGFXLandscape(0);
         xwUnSetRealMode();
      }
      else if (xwGetPrefValue(xwgWYSIWYG)==wmLWYSIWYG)
      {
         /* PSEUDO WYSIWYG (LQ ) */

         xwSetRealMode();

         if (xwIsPaperLS()==xwPortrait)
         {
            xwGFXLandscape(0);
         }
         else
         {
            xwGFXLandscape(1);
         }

         /* Pixmap experiment */
         pd.pixmap = XCreatePixmap(fl_display,fl_root,pd.xPSize,pd.yPSize,fl_get_visual_depth());

         if ( (mf.PaperFrame->w!=pd.xPSize) || (mf.PaperFrame->h!=pd.yPSize) || (pd.ax==1) || (pd.ay==1) )
         {
            xwDraw(clearPaper,0,0,0,0);
            pd.xPSize=mf.PaperFrame->w;
            pd.yPSize=mf.PaperFrame->h;
         }

         /* Draw Paper */
         xwDrawPaper();

         pd.xdpi=( ( (float) xwGetPaperXB() * (float) xwGetPixelSize() ) / ((float) xwGetPaperXB()/25.4) )*xwMM();
         if (xwCheckFrameMode()==xwTrue)
         {
            bz=xwGetFrameCount();

            for (az=0 ; az<=bz ; az++)
            {
               xwGetFramePMDatas(az,&xa,&ya);
               
               pd.xPWSize=(int) ( ((float) xwGetFrameW(az)/(25.4*(float) xwMM())) * pd.xdpi )+1;
               pd.yPWSize=(int) ( ((float) xwGetFrameH(az)/(25.4*(float) xwMM())) * pd.xdpi )+1;

               if ( ((xa!=pd.xPWSize) || (ya!=pd.yPWSize)) || (mo==pgRecalc) )
               {
                  xwSetFramePixmap(az,xwRenderPixmap(pd.xdpi,az,&xa,&ya));
                  xwSetFramePMDatas(az,pd.xPWSize,pd.yPWSize);
               }

               if ((int) xwGetFramePixmap(az)>-1)
               {                  
                  /* copy rendert picture */
                  if (xwIsPaperLS()==xwPortrait)
                  {
                     XCopyArea(fl_display,xwGetFramePixmap(az),pd.pixmap,fl_get_gc(),0,0,
                              pd.xPWSize,
                              pd.yPWSize,
                              (int) ( (float) xwGetFrameX(az)*xwGetPixelSize() ) - xwGetXOffset(),
                              (int) ( (float) xwGetFrameY(az)*xwGetPixelSize() ) - xwGetYOffset()
                              );
                  }
                  else
                  {
                     XCopyArea(fl_display,xwGetFramePixmap(az),pd.pixmap,fl_get_gc(),0,0,
                              pd.yPWSize,
                              pd.xPWSize,
                              (int) ( (float) (xwGetPaperYSize()-(xwGetFrameY(az)+xwGetFrameH(az)))*xwGetPixelSize() ) - xwGetXOffset(),
                              (int) ( (float) xwGetFrameX(az)*xwGetPixelSize() ) - xwGetYOffset()
                              );
                  }
               }
            }
         }
         else
         {
            bz=xwGetPictureCount();

            for (az=0 ; az<=bz ; az++)
            {
               xwGetPicturePMDatas(az,&xa,&ya);
               pd.xPWSize=(int) ( ((float) xwGetPictureW(az)/(25.4*(float) xwMM())) * pd.xdpi )+1;
               pd.yPWSize=(int) ( ((float) xwGetPictureH(az)/(25.4*(float) xwMM())) * pd.xdpi )+1;

               if ( ((xa!=pd.xPWSize) || (ya!=pd.yPWSize)) || ((az==xwGetActivePicture()) && (mo==pgRecalc)) )
               {
                  xwSetPicturePixmap(az,xwRenderPixmap(pd.xdpi,az,&xa,&ya));
                  xwSetPicturePMDatas(az,pd.xPWSize,pd.yPWSize);
               }

               if ((int) xwGetPicturePixmap(az)>-1)
               {
                  /* copy rendert picture */
                  if (xwIsPaperLS()==xwPortrait)
                  {
                     if ( (xwGetPictureR(az)==-90) || (xwGetPictureR(az)==90) )
                     {
                        XCopyArea(fl_display,xwGetPicturePixmap(az),pd.pixmap,fl_get_gc(),0,0,pd.yPWSize,pd.xPWSize,
                                 (int) ( (float) xwGetPictureX(az)*xwGetPixelSize() ) - xwGetXOffset(),
                                 (int) ( (float) xwGetPictureY(az)*xwGetPixelSize() ) - xwGetYOffset()
                                 );
                     }
                     else
                     {
                        XCopyArea(fl_display,xwGetPicturePixmap(az),pd.pixmap,fl_get_gc(),0,0,pd.xPWSize,pd.yPWSize,
                                 (int) ( (float) xwGetPictureX(az)*xwGetPixelSize() ) - xwGetXOffset(),
                                 (int) ( (float) xwGetPictureY(az)*xwGetPixelSize() ) - xwGetYOffset()
                                 );
                     }
                  }
                  else
                  {
                     if ( (xwGetPictureR(az)==-90) || (xwGetPictureR(az)==90) )
                     {
                        XCopyArea(fl_display,xwGetPicturePixmap(az),pd.pixmap,fl_get_gc(),0,0,pd.xPWSize,pd.yPWSize,
                                 (int) ( (float) (xwGetPaperYSize()-(xwGetPictureY(az)+xwGetPictureW(az)))*xwGetPixelSize() ) - xwGetXOffset(),
                                 (int) ( (float) xwGetPictureX(az)*xwGetPixelSize() ) - xwGetYOffset()
                                 );
                     }
                     else
                     {
                        XCopyArea(fl_display,xwGetPicturePixmap(az),pd.pixmap,fl_get_gc(),0,0,pd.yPWSize,pd.xPWSize,
                                 (int) ( (float) (xwGetPaperYSize()-(xwGetPictureY(az)+xwGetPictureH(az)))*xwGetPixelSize() ) - xwGetXOffset(),
                                 (int) ( (float) xwGetPictureX(az)*xwGetPixelSize() ) - xwGetYOffset()
                                 );
                     }
                  }
               }
            }
         }

         /* Draw Border Frame */
         xwDraw(drawBorder,xwGetPaperLB(),xwGetPaperTB(),xwGetPaperXB(),xwGetPaperYB());

         /* Draw Frames */
         xwDrawFrame();

         XCopyArea(fl_display,pd.pixmap,mf.form->window,fl_get_gc(),0,0,pd.xPSize,pd.yPSize,mf.PaperFrame->x,mf.PaperFrame->y);
         XFreePixmap(fl_display,pd.pixmap);
         
         xwGFXLandscape(0);
         xwUnSetRealMode();
      }

      /*fl_redraw_form(mf.form);*/

      /* Draw Picture/Frame Datas */
      xwPrintFrameDatas(xwIsPaperLS(),xwGetPaperXSize(),xwGetPaperYSize());

      /* Create Frame/Picture Choice */
      xwCreateFrameChoice(NULL);

      pd.Flag=0;
   }
   else
   {
      /* printf("Threaded Redraw - not redrawing window\n"); */
   }
   
   return;
}

/* Scrollbar Initialisation */
void xwSCRB(void)
{
   double            SRNew=-1;
   double            SBNew=-1;

   pd.xPSize=mf.PaperFrame->w;
   pd.yPSize=mf.PaperFrame->h;

   xwSetPixelSize(xwGetPaperXSize(),xwGetPaperYSize());

   /* Landscape */
   if (xwIsPaperLS()==xwLandscape)
   {
      /* Calculate Slider Sizes */
      pd.ax= ((float) mf.PaperFrame->w*100)/((float) xwGetPaperYSize()*xwGetPixelSize()) /100;
      if (pd.ax!=pd.xSLSize)
      {
         if (pd.ax>1) pd.ax=1;

         if (pd.xSLSize<0) pd.xSLSize=pd.ax;

         if (1-pd.xSLSize!=0)
         {
            SBNew=(100*xwGetXXOffset())/(1-pd.xSLSize);
            SBNew=((1-pd.ax)*SBNew)/100;
         }
         else
         {
            SBNew=0;
         }
         xwSetXXOffset(SBNew);

         fl_set_scrollbar_value(mf.PaperSB,SBNew);
         fl_set_scrollbar_size(mf.PaperSB,pd.ax);
         fl_set_scrollbar_bounds(mf.PaperSB,0,1-pd.ax);

         if (SBNew!=0) SBNew=( ( ((float) xwGetPaperYSize()*xwGetPixelSize()) /100)*(SBNew*100));
         xwSetXOffset((int) SBNew);

         pd.xSLSize=pd.ax;
      }

      pd.ay= ((float) mf.PaperFrame->h*100)/((float) xwGetPaperXSize()*xwGetPixelSize()) /100;
      if (pd.ay!=pd.ySLSize)
      {
         if (pd.ay>1) pd.ay=1;

         if (pd.ySLSize<0) pd.ySLSize=pd.ay;

         if (1-pd.ySLSize!=0)
         {
            SRNew=(100*xwGetYYOffset())/(1-pd.ySLSize);
            SRNew=((1-pd.ay)*SRNew)/100;
         }
         else
         {
            SRNew=0;
         }
         xwSetYYOffset(SRNew);

         fl_set_scrollbar_value(mf.PaperSR,SRNew);
         fl_set_scrollbar_size(mf.PaperSR,pd.ay);
         fl_set_scrollbar_bounds(mf.PaperSR,0,1-pd.ay);

         if (SRNew!=0) SRNew=( ( ((float) xwGetPaperXSize()*xwGetPixelSize()) /100)*(SRNew*100));
         xwSetYOffset((int) SRNew);

         pd.ySLSize=pd.ay;
      }
   }
   /* Portrait */
   else if (xwIsPaperLS()==xwPortrait)
   {
      /* Calculate Slider Sizes */
      pd.ax= ((float) mf.PaperFrame->w*100)/((float) xwGetPaperXSize()*xwGetPixelSize()) /100;
      if (pd.ax!=pd.xSLSize)
      {
         if (pd.ax>1) pd.ax=1;

         if (pd.xSLSize<0) pd.xSLSize=pd.ax;

         if (1-pd.xSLSize!=0)
         {
            SBNew=(100*xwGetXXOffset())/(1-pd.xSLSize);
            SBNew=((1-pd.ax)*SBNew)/100;
         }
         else
         {
            SBNew=0;
         }
         xwSetXXOffset(SBNew);

         fl_set_scrollbar_value(mf.PaperSB,SBNew);
         fl_set_scrollbar_size(mf.PaperSB,pd.ax);
         fl_set_scrollbar_bounds(mf.PaperSB,0,(1-pd.ax));

         if (SBNew!=0) SBNew=( ( ((float) xwGetPaperXSize()*xwGetPixelSize()) /100)*(SBNew*100));
         xwSetXOffset((int) SBNew);

         pd.xSLSize=pd.ax;
      }

      pd.ay= ((float) mf.PaperFrame->h*100)/((float) xwGetPaperYSize()*xwGetPixelSize()) /100;
      if (pd.ay!=pd.ySLSize)
      {
         if (pd.ay>1) pd.ay=1;

         if (pd.ySLSize<0) pd.ySLSize=pd.ay;

         if (1-pd.ySLSize!=0)
         {
            SRNew=(100*xwGetYYOffset())/(1-pd.ySLSize);
            SRNew=((1-pd.ay)*SRNew)/100;
         }
         else
         {
            SRNew=0;
         }
         xwSetYYOffset(SRNew);

         fl_set_scrollbar_value(mf.PaperSR,SRNew);
         fl_set_scrollbar_size(mf.PaperSR,pd.ay);
         fl_set_scrollbar_bounds(mf.PaperSR,0,1-pd.ay);

         if (SRNew!=0) SRNew=( ( ((float) xwGetPaperYSize()*xwGetPixelSize()) /100)*(SRNew*100));
         xwSetYOffset((int) SRNew);

         pd.ySLSize=pd.ay;
      }
   }

   /*
   fl_check_forms();
   XFlush(fl_get_display());
   XSync(fl_get_display(),0);
   fl_check_forms();
   */

   /*
   fl_redraw_form(mf.form);
   */

   return;
}


/* Lock Page */
void xwLockPage(void)
{
   xwSetPrefValue(xwgAssLock,1);
   
   return;
}

/* UnLock Page */
void xwUnLockPage(void)
{
   xwSetPrefValue(xwgAssLock,0);

   return;
}