/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "oneliner.h"

#include "base.h"
#include "default.h"
#include "main_gui.h"
#include "x11.h"

extern struct mainform     mf;

static int                 olMode=0;
static int                 oldX,oldY;
static int                 newX,newY;
static Pixmap              oldPixmap;
static Pixmap              newPixmap;
static int                 actX,actY;
static int                 actXS,actYS;
static Pixmap              actPixmap;


/* Init OneLiner */
void xwOLInit(void)
{
   /* Pixmap experiment */
   oldPixmap = XCreatePixmap(fl_display,fl_root,80,60,fl_get_visual_depth());
   newPixmap = XCreatePixmap(fl_display,fl_root,80,60,fl_get_visual_depth());

   olMode=0;

   return;
}

/* Remove OneLiner */
void xwOLRemove(void)
{
   XFreePixmap(fl_display,oldPixmap);
   XFreePixmap(fl_display,newPixmap);

   return;
}

/* Reset OneLiner */
void xwOLReset(void)
{
   olMode=0;

   return;
}

/* Get olMode */
int xwOLMode(void)
{
   return(olMode);
}

/* Draw OneLiner */
void xwOneLiner(int kx,int ky,float ax,float ay,float aw,float ah)
{
   if (xwGetPrefValue(xwgOneLiner)==1)
   {

      if (olMode==0)
      {
         olMode=1;
         oldX=kx;
         oldY=ky;

         if (oldX>(mf.PaperFrame->x+mf.PaperFrame->w)-80) oldX=oldX-80;
         if (oldY>(mf.PaperFrame->y+mf.PaperFrame->h)-60) oldY=oldY-60;

         /* Background -> Buffer */
         XCopyArea(fl_display,mf.form->window,oldPixmap,fl_get_gc(),oldX,oldY,80,60,0,0);

         fl_winset(newPixmap);

         fl_drw_box(FL_UP_BOX,0,0,80,60,FL_BLACK,3);
         fl_rectf(3,3,74,54,FL_MCOL);

         /*fl_rectbound(0,0,79,79,FL_YELLOW);*/
         fl_drw_text(FL_ALIGN_CENTER,0,0,79,20,FL_BLACK,FL_NORMAL_STYLE,FL_NORMAL_SIZE,DoubleStr(ax/xwMM(),1));
         fl_drw_text(FL_ALIGN_LEFT,0,19,39,20,FL_BLACK,FL_NORMAL_STYLE,FL_NORMAL_SIZE,DoubleStr(ay/xwMM(),1));
         fl_drw_text(FL_ALIGN_RIGHT,40,19,39,20,FL_BLACK,FL_NORMAL_STYLE,FL_NORMAL_SIZE,DoubleStr(aw/xwMM(),1));
         fl_drw_text(FL_ALIGN_CENTER,0,39,79,20,FL_BLACK,FL_NORMAL_STYLE,FL_NORMAL_SIZE,DoubleStr(ah/xwMM(),1));

         fl_winset(mf.form->window);

         XCopyArea(fl_display,newPixmap,mf.form->window,fl_get_gc(),0,0,80,80,oldX,oldY);
      }
      else
      {
         /* Create Redraw Area */
         newX=kx;
         newY=ky;

         if (newX>(mf.PaperFrame->x+mf.PaperFrame->w)-80) newX=newX-80;
         if (newY>(mf.PaperFrame->y+mf.PaperFrame->h)-60) newY=newY-60;

         actX=oldX;
         actY=oldY;
         actXS=80;
         actYS=60;

         if (newX<actX)
         {
            actXS=(actX+80)-newX;
            actX=newX;
         }
         else if (actX<newX)
         {
            actXS=(newX+80)-actX;
         }

         if (newY<actY)
         {
            actYS=(actY+60)-newY;
            actY=newY;
         }
         else if (actY<newY)
         {
            actYS=(newY+60)-actY;
         }

         /* Buffer */
         actPixmap = XCreatePixmap(fl_display,fl_root,actXS,actYS,fl_get_visual_depth());
         XCopyArea(fl_display,mf.form->window,actPixmap,fl_get_gc(),actX,actY,actXS,actYS,0,0);

         /* Buffered Background */
         XCopyArea(fl_display,oldPixmap,actPixmap,fl_get_gc(),0,0,80,60,oldX-actX,oldY-actY);

         XCopyArea(fl_display,actPixmap,oldPixmap,fl_get_gc(),newX-actX,newY-actY,80,60,0,0);


         /* OneLiner */
         fl_winset(newPixmap);

         fl_drw_box(FL_UP_BOX,0,0,80,60,FL_BLACK,3);
         fl_rectf(3,3,74,54,FL_MCOL);

         fl_drw_text(FL_ALIGN_CENTER,0,0,79,20,FL_BLACK,FL_NORMAL_STYLE,FL_NORMAL_SIZE,DoubleStr(ax/xwMM(),1));
         fl_drw_text(FL_ALIGN_LEFT,0,19,39,20,FL_BLACK,FL_NORMAL_STYLE,FL_NORMAL_SIZE,DoubleStr(ay/xwMM(),1));
         fl_drw_text(FL_ALIGN_RIGHT,40,19,39,20,FL_BLACK,FL_NORMAL_STYLE,FL_NORMAL_SIZE,DoubleStr(aw/xwMM(),1));
         fl_drw_text(FL_ALIGN_CENTER,0,39,79,20,FL_BLACK,FL_NORMAL_STYLE,FL_NORMAL_SIZE,DoubleStr(ah/xwMM(),1));

         fl_winset(mf.form->window);

         /* Copy OneLiner into Buffer */
         XCopyArea(fl_display,newPixmap,actPixmap,fl_get_gc(),0,0,80,60,newX-actX,newY-actY);

         XCopyArea(fl_display,actPixmap,mf.form->window,fl_get_gc(),0,0,actXS,actYS,actX,actY);

         XFreePixmap(fl_display,actPixmap);

         oldX=newX;
         oldY=newY;
      }
   }

   return;
}