/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "nconvert.h"

#include "base.h"
#include "default.h"
#include "gfx.h"
#include "limits.h"
#include "resource.h"

/* check on existing nconvert */
int CheckNConvert(void)
{
   static int        result;              /* result of existent nconvert */
   char              path[4096];          /* System Environment $PATH */
   char              ppath[1024];         /* Search Path */

   char              source[1024];
   char              dest[1024];
   char              nctest[1024];

   char              *strptr;

   struct stat       attributA,attributB;

   result=xwFalse;
   
   strcpy(source,xwGetFile("","nconvert.ppm"));
   strcpy(dest,xwGetFile("","nconvert.png"));

   /* delete test files */
   unlink(source);
   unlink(dest);
   if (xwGFXCreatePaper(100,100)==xwTrue)
   {
      xwGFXSavePaper(source);
      xwGFXRemovePaper();
   }

   strcpy(path,getenv("PATH"));

   if (strlen(path)>0)
   {
      SetStrGet(":");
      strptr=StrGet(path);
      while ( (strlen(strptr)>0) && (result==xwFalse) )
      {
         if (strlen(strptr)<1024)
         {
            strcpy(ppath,strptr);
            strcat(ppath,"/nconvert");

            if ( stat(ppath,&attributA) == 0)
            {
               if (lstat(ppath,&attributB) == 0)
               {
                  if (S_ISLNK(attributB.st_mode))
                  {
                     if (S_ISREG(attributA.st_mode))
                     {
                        /* File */
                        strcpy(nctest,ppath);
                        strcat(nctest," -quiet -out png -o[OUT] [IN]");
                        xwGFXExec(nctest,0,0,0,0,0,source,dest,"");
                        if (xwExist(dest)==0) result=xwTrue;  
                     }
                  }
                  else
                  {
                     if (S_ISREG(attributA.st_mode))
                     {
                        /* File */
                        strcpy(nctest,ppath);
                        strcat(nctest," -quiet -out png -o[OUT] [IN]");
                        xwGFXExec(nctest,0,0,0,0,0,source,dest,"");
                        if (xwExist(dest)==0) result=xwTrue;
                     }
                  }
               }
            }
         }

         strptr=StrGet(NULL);
      }
      SetStrGet("");
   }

   /* delete test files */
   unlink(source);
   unlink(dest);

   return(result);
}
