/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWMAINGUI_H
#define _XWMAINGUI_H

#include <forms.h>

#include <stdio.h>
#include <unistd.h>

/* xwGUI MainWindow Size */
#define xwMainX         690
#define xwMainY         534

/* Geometry Output Fields */
#define geoLeft         1
#define geoRight        2
#define geoTop          3
#define geoBottom       4
#define geoWidth        5
#define geoHeight       6
#define geoDPI          7

/* Draw Object */
#define clearPaper      0
#define drawPaper       1
#define drawBorder      2
#define drawFrame       3
#define drawTFrame      4
#define drawPic         5

typedef struct mainform
{
   /* Main-Form data */
   FL_FORM           *form;
   /* Event Loop */
   FL_OBJECT         *obj;
   int               ready;

   FL_OBJECT         *TitleFrame;
   FL_OBJECT         *PaperFrame;
   FL_OBJECT         *PaperFree;
   FL_OBJECT         *OutputFrame;

   FL_OBJECT         *FPSwitch;
   FL_OBJECT         *SelectFP;
   FL_OBJECT         *Eye;

   FL_OBJECT         *PaperBar;           /* Paper Bar Frame */
   FL_OBJECT         *PaperZoom;          /* Zoom Paper Factor */
   FL_OBJECT         *PaperLP;            /* Landscape/Portrait Display */
   FL_OBJECT         *WYSIWYG;            /* WYSIWYG Display */


   FL_OBJECT         *LMFrame;
   FL_OBJECT         *LeftMouse;
   FL_OBJECT         *RMFrame;
   FL_OBJECT         *RightMouse;

   /*FL_OBJECT         *PaperOrientation;*/   /* Paper Orientation */
   
   FL_OBJECT         *PaperSR;            /* Paper Slider Right */
   FL_OBJECT         *PaperSB;            /* Paper Slider Bottom */
   FL_OBJECT         *PaperFull;          /* Full View */
   
   FL_OBJECT         *Info;
   
   FL_OBJECT         *Load;
   FL_OBJECT         *Save;
   FL_OBJECT         *PicBrowser;

   FL_OBJECT         *PaperPref;
   FL_OBJECT         *GuiPref;
   FL_OBJECT         *PrinterPref;

   FL_OBJECT         *FrameSets;
   FL_OBJECT         *Assistent;
   FL_OBJECT         *MTInk;

   FL_OBJECT         *Trash;
   FL_OBJECT         *DocFile;
   FL_OBJECT         *Exit;

   FL_OBJECT         *Geometry;
   FL_OBJECT         *LeftPosI;
   FL_OBJECT         *LeftPos;
   FL_OBJECT         *RightPosI;
   FL_OBJECT         *RightPos;
   FL_OBJECT         *TopPosI;
   FL_OBJECT         *TopPos;
   FL_OBJECT         *BottomPosI;
   FL_OBJECT         *BottomPos;
   FL_OBJECT         *WidthI;
   FL_OBJECT         *Width;
   FL_OBJECT         *HeightI;
   FL_OBJECT         *Height;
   FL_OBJECT         *DPII;
   FL_OBJECT         *DPI;

   FL_OBJECT         *Landscape;
   FL_OBJECT         *AddFrame;
   FL_OBJECT         *Edit;
   FL_OBJECT         *FPTrash;

   FL_OBJECT         *Back;
   FL_OBJECT         *Front;
   FL_OBJECT         *RotateLeft;
   FL_OBJECT         *RotateRight;

   FL_OBJECT         *Preview;
   FL_OBJECT         *Print;

   /* Help-Text */
   char              helpTxt[80][80];
   
   /* Window Size */
   int               width;
   int               height;
} mainform;

/* Initialize Main GUI */
void xwInitMainGui(void);

/* Oneliner Hilfstexte ausgeben */
void do_tips(int id,void *p);
/* Oneliner Hilftexte verwaltung */
int xwOnliner(FL_OBJECT *obj, int event, FL_Coord mx, FL_Coord my, int key,void *xev);
/* Open Main GUI Wrapper */
void xwOpenMainGui(void);
/* Open Main GUI Textbased */
void xwOpenMainGuiA(void);
/* Open Main GUI Iconbassed */
void xwOpenMainGuiB(void);
/* Close Main GUI */
void xwCloseMainGui(void);

/* Set AppMainGui */
void xwAppMainGui(void);

/* Check MainGui */
int xwCheckMainGui(void);
/* Is MainGui active */
int xwIsMainGui(int az);
/* deactivate Mainform */
void xwDeactivateMain(void);
/* activate Mainform */
void xwActivateMain(void);

/* Lock MainGui */
void xwLockMainGui(void);
/* UnLock MainGui */
void xwUnLockMainGui(void);

/* Get Mainform */
FL_FORM *xwGetMainGui(void);
/* Get Main Window */
Window xwGetMainWindow(void);

/* Set Language for Main GUI */
void xwSetGuiLanguage(void);
/* Redraw GUI */
void xwRedrawMainGui(void);


#endif