/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Pueblic License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "main_gui.h"

#include "assistent.h"
#include "default.h"
#include "frame.h"
#include "handler.h"
#include "lowlevel.h"
#include "main.h"
#include "main_action.h"
#include "page.h"
#include "resource.h"
#include "selectfp.h"
#include "x11.h"

/* Picture View */
#include "pixmaps/main-eye.xpm"

/* Mouse Buttons */
#include "pixmaps/main-leftmouse.xpm"
#include "pixmaps/main-rightmouse.xpm"

/* Icon Import */
#include "pixmaps/main-info.xpm"
#include "pixmaps/main-info2.xpm"

#include "pixmaps/main-load.xpm"
#include "pixmaps/main-save.xpm"
#include "pixmaps/main-picbrowser.xpm"

#include "pixmaps/main-paperpref.xpm"
#include "pixmaps/main-guipref.xpm"
#include "pixmaps/main-printerpref.xpm"

#include "pixmaps/main-trash.xpm"
#include "pixmaps/main-docpref.xpm"
#include "pixmaps/main-exit.xpm"

#include "pixmaps/main-framesets.xpm"
#include "pixmaps/main-assistent.xpm"
#include "pixmaps/main-mtink.xpm"

#include "pixmaps/main-posleft.xpm"
#include "pixmaps/main-posright.xpm"
#include "pixmaps/main-postop.xpm"
#include "pixmaps/main-posbottom.xpm"
#include "pixmaps/main-sizex.xpm"
#include "pixmaps/main-sizey.xpm"
#include "pixmaps/main-dpi.xpm"

#include "pixmaps/main-landscape.xpm"
#include "pixmaps/main-addframe.xpm"
#include "pixmaps/main-edit.xpm"
#include "pixmaps/main-fptrash.xpm"

#include "pixmaps/main-front.xpm"
#include "pixmaps/main-back.xpm"
#include "pixmaps/main-rotateleft.xpm"
#include "pixmaps/main-rotateright.xpm"

#include "pixmaps/main-preview.xpm"
#include "pixmaps/main-printer.xpm"

struct mainform            mf;

#define INTERVAL           600
static int                 timeoutID;

/* Initialize Main GUI */
void xwInitMainGui(void)
{
   mf.form=NULL;

   return;
}

/* Display Onliner */
void do_tips(int id,void *p)
{
   FL_OBJECT   *ob = p;

   fl_show_oneliner(ob->u_vdata,ob->form->x + ob->x,ob->form->y+ob->y+ob->h+1);
   timeoutID = fl_add_timeout(INTERVAL, do_tips,ob);

   return;
}

int xwOnliner(FL_OBJECT *obj, int event, FL_Coord mx, FL_Coord my, int key,void *xev)
{
   if (obj->u_vdata == NULL) return(0);

   if (event == FL_ENTER)
   {
      timeoutID = fl_add_timeout(INTERVAL,do_tips,obj);
   }
   else if ( (event == FL_LEAVE) || (event == FL_PUSH) )
   {
      fl_hide_oneliner();
      if (timeoutID)
      {
         fl_remove_timeout(timeoutID);
         timeoutID = 0;
      }
   }

   return(0);
}

/* GUI Wrapper */
void xwOpenMainGui(void)
{
   if (xwGetPrefValue(xwgGUI)==0)
   {
      xwOpenMainGuiA();
   }
   else
   {
      xwOpenMainGuiB();
   }

   return;
}

/* Open Main GUI A */
void xwOpenMainGuiA(void)
{
   /* Titlebar */
   int   xPosTitle=4;
   int   yPosTitle=4;
   int   xSizeTitle=477;
   int   ySizeTitle=20;

   /* Paperposition */
   int   xPosPaperBar=4;
   int   yPosPaperBar=27;
   int   xPosPaper=4;
   int   yPosPaper=27+22;
   int   xSizePaper=477-20;
   int   ySizePaper=503-(22+20);

   /* Menu-Position */
   int   xPosMenu=484; /* 714 */
   int   yPosMenu=4;
   int   xSizeMenu=202;
   int   ySizeMenu=526;

   int   yy=0;

   /* Help Oneliner Position */
   int   localeIndex=0;

   mf.form = NULL;
   mf.ready = 0;

   mf.form = fl_bgn_form(FL_UP_BOX, 690, 534);

   fl_set_border_width(1);

   /* Titlebar */
   mf.TitleFrame = fl_add_frame(FL_DOWN_FRAME,xPosTitle,yPosTitle,xSizeTitle,ySizeTitle,"");
   fl_set_object_gravity(mf.TitleFrame, FL_NorthWest, FL_NorthEast);

   /* Frame/Picture Mode */
   mf.FPSwitch = fl_add_lightbutton(FL_PUSH_BUTTON,xPosTitle+2,yPosTitle+1,100,18,xwGR(1,"FrameED","FrameED"));
   fl_set_object_gravity(mf.FPSwitch,FL_NorthWest,FL_NorthWest);
   if (xwCheckEditFrame()==-1) fl_set_button(mf.FPSwitch,0);
   if (xwCheckEditFrame()==0) fl_set_button(mf.FPSwitch,1);

   /* select Frame/Picture */
   mf.SelectFP = fl_add_button(FL_NORMAL_BUTTON,xPosTitle+2+102,yPosTitle+1,271-18,18,"");
   fl_set_object_gravity(mf.SelectFP,FL_NorthWest,FL_NorthEast);

   mf.Eye = fl_add_button(FL_NORMAL_BUTTON,xPosTitle+2+2+353,yPosTitle+1,118,18,xwGR(1,"hlp.ViewPicture","Picture Viewer"));
   fl_set_object_gravity(mf.Eye,FL_NorthEast,FL_NorthEast);

   /* Paper Function Bar */
   mf.PaperBar = fl_add_frame(FL_DOWN_FRAME,xPosPaperBar,yPosPaperBar,xSizePaper+20,20,"");
   fl_set_object_gravity(mf.PaperBar,FL_NorthWest,FL_NorthEast);

   /* Paper Zoom */
   mf.PaperZoom = fl_add_choice(FL_DROPLIST_CHOICE,xPosPaperBar+1,yPosPaperBar+1,80,18,"");
   fl_set_object_boxtype(mf.PaperZoom,FL_UP_BOX);
   fl_set_object_gravity(mf.PaperZoom,FL_NorthWest,FL_NorthWest);
   fl_addto_choice(mf.PaperZoom,"100  %%");
   fl_addto_choice(mf.PaperZoom,"125 %%");
   fl_addto_choice(mf.PaperZoom,"150 %%");
   fl_addto_choice(mf.PaperZoom,"175 %%");
   fl_addto_choice(mf.PaperZoom,"200 %%");
   fl_addto_choice(mf.PaperZoom,"250 %%");
   fl_addto_choice(mf.PaperZoom,"300 %%");

   fl_addto_choice(mf.PaperZoom,"400 %%");
   fl_addto_choice(mf.PaperZoom,"500 %%");
   fl_addto_choice(mf.PaperZoom,"600 %%");
   fl_addto_choice(mf.PaperZoom,"700 %%");
   fl_addto_choice(mf.PaperZoom,"800 %%");
   fl_addto_choice(mf.PaperZoom,"900 %%");
   fl_addto_choice(mf.PaperZoom,"1000 %%");

   fl_set_choice(mf.PaperZoom,xwGetZoomV());

   /* Landscape/Portrait Info */
   mf.PaperLP = fl_add_box(FL_DOWN_BOX,xPosPaperBar+1+82,yPosPaperBar+1,80,18,"Portrait");
   fl_set_object_gravity(mf.PaperLP,FL_NorthWest,FL_NorthWest);

   /* WYSIWYG Info */
   mf.WYSIWYG = fl_add_box(FL_DOWN_BOX,xPosPaperBar+1+82+82,yPosPaperBar+1,40,18,"NORM");
   fl_set_object_gravity(mf.WYSIWYG,FL_NorthWest,FL_NorthWest);

   /* Left Mouse Frame */
   mf.LMFrame = fl_add_frame(FL_DOWN_FRAME,xPosPaperBar+2+82+82+42,yPosPaperBar+2,131,16,xwGR(1,"RMRSelection","Resize/Move/Rotate"));
   fl_set_object_gravity(mf.LMFrame,FL_NorthWest,FL_NorthWest);
   fl_set_object_lalign(mf.LMFrame,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
   fl_set_object_lsize(mf.LMFrame,FL_TINY_SIZE);

   /* Left Mouse */
   mf.LeftMouse = fl_add_pixmap(FL_NORMAL_PIXMAP,xPosPaperBar+1+82+82+44+1,yPosPaperBar+2,16,16,"");
   fl_set_pixmap_data(mf.LeftMouse,main_leftmouse_xpm);
   fl_set_object_gravity(mf.LeftMouse,FL_NorthWest,FL_NorthWest);

   /* Right Mouse Frame */
   mf.RMFrame = fl_add_frame(FL_DOWN_FRAME,xPosPaperBar+2+82+82+82+95,yPosPaperBar+2,131,16,xwGR(1,"Selection","Frame/Picture Selection"));
   fl_set_object_gravity(mf.RMFrame,FL_NorthWest,FL_NorthWest);
   fl_set_object_lalign(mf.RMFrame,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
   fl_set_object_lsize(mf.RMFrame,FL_TINY_SIZE);

   /* Right Mouse */
   mf.RightMouse = fl_add_pixmap(FL_NORMAL_PIXMAP,xPosPaperBar+1+82+82+82+97+1,yPosPaperBar+2,16,16,"");
   fl_set_pixmap_data(mf.RightMouse,main_rightmouse_xpm);
   fl_set_object_gravity(mf.RightMouse,FL_NorthWest,FL_NorthWest);

   /* Paperframe */
   mf.PaperFrame = fl_add_frame(FL_DOWN_FRAME,xPosPaper,yPosPaper,xSizePaper,ySizePaper,"");
   fl_set_object_gravity(mf.PaperFrame, FL_NorthWest, FL_SouthEast);
   fl_set_object_posthandler(mf.PaperFrame,xwHandler);

   /* Paperframe */
   mf.PaperFrame = fl_add_frame(FL_DOWN_FRAME,xPosPaper,yPosPaper,xSizePaper,ySizePaper,"");
   fl_set_object_gravity(mf.PaperFrame, FL_NorthWest, FL_SouthEast);
   fl_set_object_posthandler(mf.PaperFrame,xwHandler);
   /*
   mf.PaperFrame = fl_add_free(FL_NORMAL_FREE,xPosPaper,yPosPaper,xSizePaper,ySizePaper,"",xwHandler);
   fl_set_object_gravity(mf.PaperFrame, FL_NorthWest, FL_SouthEast);
   */

   /* Ausgabebereich */
   mf.OutputFrame = fl_add_frame(FL_DOWN_FRAME,xPosMenu,yPosMenu,xSizeMenu,ySizeMenu,"");
   fl_set_object_gravity(mf.OutputFrame, FL_NorthEast, FL_SouthEast);

   /* Paper Sliders */
   mf.PaperSR = fl_add_scrollbar(FL_VERT_BASIC_SCROLLBAR,xPosPaper+xSizePaper+1,yPosPaper-1,20,ySizePaper+2,"");
   fl_set_object_gravity(mf.PaperSR, FL_NorthEast, FL_SouthEast);
   fl_set_scrollbar_bounds(mf.PaperSR,0,0);
   fl_set_scrollbar_value(mf.PaperSR,1);
   /*fl_set_scrollbar_step(mf.PaperSR,100);*/
   fl_set_scrollbar_increment(mf.PaperSR,0.1,0.01);
   fl_set_scrollbar_size(mf.PaperSR,1);
   /* Set Scrollbar Return */
   fl_set_scrollbar_return(mf.PaperSR,FL_RETURN_CHANGED);
   fl_set_object_callback(mf.PaperSR,xwPaperScroller,0);

   /* Paper Sliders */
   mf.PaperSB = fl_add_scrollbar(FL_HOR_BASIC_SCROLLBAR,xPosPaper-1,yPosPaper+ySizePaper+1,xSizePaper+2,20,"");
   fl_set_object_gravity(mf.PaperSB,FL_SouthWest, FL_SouthEast);
   fl_set_scrollbar_bounds(mf.PaperSB,0,0);
   fl_set_scrollbar_value(mf.PaperSB,1);
   /*fl_set_scrollbar_step(mf.PaperSB,100);*/
   fl_set_scrollbar_increment(mf.PaperSB,0.1,0.01);
   fl_set_scrollbar_size(mf.PaperSB,1);
   /* Set Scrollbar Return */
   fl_set_scrollbar_return(mf.PaperSB,FL_RETURN_CHANGED);
   fl_set_object_callback(mf.PaperSB,xwPaperScroller,0);

   /* Full Paper View */
   mf.PaperFull = fl_add_button(FL_NORMAL_BUTTON,xPosPaper+xSizePaper+1,yPosPaper+ySizePaper+1,20,20,"");
   fl_set_object_gravity(mf.PaperFull,FL_SouthEast, FL_SouthEast);
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.Zoom100","Full View"));
   mf.PaperFull->u_vdata = mf.helpTxt[localeIndex];
   fl_set_object_posthandler(mf.PaperFull,xwOnliner);
   localeIndex++;

   mf.Info = fl_add_button(FL_NORMAL_BUTTON,xPosMenu+1,yPosMenu+1+yy,100,20,xwGR(1,"hlp.About","About)"));
   fl_set_object_gravity(mf.Info, FL_NorthEast, FL_NorthEast);

   mf.DocFile = fl_add_button(FL_NORMAL_BUTTON,xPosMenu+1+100,yPosMenu+1+yy,100,20,xwGR(1,"hlp.Manual","Manual"));
   fl_set_object_gravity(mf.DocFile, FL_NorthEast, FL_NorthEast);
   yy=yy+21;

   mf.Load = fl_add_button(FL_NORMAL_BUTTON,xPosMenu+1,yPosMenu+1+yy,100,20,xwGR(1,"hlp.Load","Load"));
   fl_set_object_gravity(mf.Load, FL_NorthEast, FL_NorthEast);

   mf.Save = fl_add_button(FL_NORMAL_BUTTON,xPosMenu+101,yPosMenu+1+yy,100,20,xwGR(1,"hlp.Save","Save"));
   fl_set_object_gravity(mf.Save, FL_NorthEast, FL_NorthEast);
   yy=yy+20;

   mf.PicBrowser = fl_add_button(FL_NORMAL_BUTTON,xPosMenu+1,yPosMenu+1+yy,200,20,xwGR(1,"hlp.PicBrowser","Picture Browser"));
   fl_set_object_gravity(mf.PicBrowser, FL_NorthEast, FL_NorthEast);
   yy=yy+21;

   mf.PaperPref = fl_add_button(FL_NORMAL_BUTTON,xPosMenu+1,yPosMenu+1+yy,200,20,xwGR(1,"hlp.PaperPref","Paper Preferences"));
   fl_set_object_gravity(mf.PaperPref, FL_NorthEast, FL_NorthEast);
   yy=yy+20;

   mf.GuiPref = fl_add_button(FL_NORMAL_BUTTON,xPosMenu+1,yPosMenu+1+yy,200,20,xwGR(1,"hlp.GuiPref","xwGUI Preferences"));
   fl_set_object_gravity(mf.GuiPref, FL_NorthEast, FL_NorthEast);
   yy=yy+20;

   mf.PrinterPref = fl_add_button(FL_NORMAL_BUTTON,xPosMenu+1,yPosMenu+1+yy,200,20,xwGR(1,"hlp.PrinterPref","Printer Preferences"));
   fl_set_object_gravity(mf.PrinterPref, FL_NorthEast, FL_NorthEast);
   yy=yy+21;

   mf.FrameSets = fl_add_button(FL_NORMAL_BUTTON,xPosMenu+1,yPosMenu+1+yy,200,20,xwGR(1,"hlp.FrameSets","FrameSets"));
   fl_set_object_gravity(mf.FrameSets, FL_NorthEast, FL_NorthEast);
   yy=yy+20;
   
   mf.Assistent = fl_add_button(FL_NORMAL_BUTTON,xPosMenu+1,yPosMenu+1+yy,200,20,xwGR(1,"hlp.Assistent","Assistent"));
   fl_set_object_gravity(mf.Assistent, FL_NorthEast, FL_NorthEast);
   yy=yy+20;

   if (strlen(xwGetPrefName(xwgMTInk))>0)
   {
      mf.MTInk = fl_add_button(FL_NORMAL_BUTTON,xPosMenu+1,yPosMenu+1+yy,200,20,"MTInk");
      fl_set_object_gravity(mf.MTInk, FL_NorthEast, FL_NorthEast);
   }
   yy=yy+20;
   
   mf.Trash = fl_add_button(FL_NORMAL_BUTTON,xPosMenu+1,yPosMenu+1+yy,100,20,xwGR(1,"hlp.Trash","Trashcan"));
   fl_set_object_gravity(mf.Trash, FL_NorthEast, FL_NorthEast);
   mf.Exit = fl_add_button(FL_NORMAL_BUTTON,xPosMenu+1+100,yPosMenu+1+yy,100,20,xwGR(1,"hlp.Exit","Exit"));
   fl_set_object_gravity(mf.Exit, FL_NorthEast, FL_NorthEast);
   yy=yy+22;

   /* Geometrybereich */
   fl_set_border_width(1);
   mf.Geometry = fl_add_frame(FL_DOWN_FRAME,xPosMenu+2,yPosMenu+1+yy,xSizeMenu-4,141,"");
   fl_set_object_gravity(mf.Geometry, FL_NorthEast, FL_NorthEast);
   yy=yy+1;

   mf.LeftPosI = fl_add_box(FL_NO_BOX,xPosMenu+4,yPosMenu+1+yy,97,19,xwGR(1,"hlp.LeftPos","LeftPos.:"));
   fl_set_object_lalign(mf.LeftPosI,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
   fl_set_object_gravity(mf.LeftPosI, FL_NorthEast, FL_NorthEast);
   mf.LeftPos = fl_add_box(FL_DOWN_BOX,xPosMenu+23+80,yPosMenu+1+yy,56+40,19,"0");
   fl_set_object_lalign(mf.LeftPos,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
   fl_set_object_lstyle(mf.LeftPos,FL_FIXED_STYLE);
   fl_set_object_lsize(mf.LeftPos,FL_NORMAL_FONT);
   fl_set_object_gravity(mf.LeftPos, FL_NorthEast, FL_NorthEast);
   yy=yy+20;

   mf.RightPosI = fl_add_box(FL_NO_BOX,xPosMenu+4,yPosMenu+1+yy,97,19,xwGR(1,"hlp.RightPos","RightPos.:"));
   fl_set_object_lalign(mf.RightPosI,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
   fl_set_object_gravity(mf.RightPosI, FL_NorthEast, FL_NorthEast);
   mf.RightPos = fl_add_box(FL_DOWN_BOX,xPosMenu+23+80,yPosMenu+1+yy,56+40,19,"0");
   fl_set_object_lalign(mf.RightPos,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
   fl_set_object_lstyle(mf.RightPos,FL_FIXED_STYLE);
   fl_set_object_lsize(mf.RightPos,FL_NORMAL_FONT);
   fl_set_object_gravity(mf.RightPos, FL_NorthEast, FL_NorthEast);
   yy=yy+20;

   mf.TopPosI = fl_add_box(FL_NO_BOX,xPosMenu+4,yPosMenu+1+yy,97,19,xwGR(1,"hlp.TopPos","TopPos.:"));
   fl_set_object_lalign(mf.TopPosI,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
   fl_set_object_gravity(mf.TopPosI, FL_NorthEast, FL_NorthEast);
   mf.TopPos = fl_add_box(FL_DOWN_BOX,xPosMenu+23+80,yPosMenu+1+yy,56+40,19,"0");
   fl_set_object_lalign(mf.TopPos,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
   fl_set_object_lstyle(mf.TopPos,FL_FIXED_STYLE);
   fl_set_object_lsize(mf.TopPos,FL_NORMAL_FONT);
   fl_set_object_gravity(mf.TopPos, FL_NorthEast, FL_NorthEast);
   yy=yy+20;

   mf.BottomPosI = fl_add_box(FL_NO_BOX,xPosMenu+4,yPosMenu+1+yy,97,19,xwGR(1,"hlp.BottomPos","BottomPos.:"));
   fl_set_object_lalign(mf.BottomPosI,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
   fl_set_object_gravity(mf.BottomPosI, FL_NorthEast, FL_NorthEast);
   mf.BottomPos = fl_add_box(FL_DOWN_BOX,xPosMenu+23+80,yPosMenu+1+yy,56+40,19,"0");
   fl_set_object_lalign(mf.BottomPos,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
   fl_set_object_lstyle(mf.BottomPos,FL_FIXED_STYLE);
   fl_set_object_lsize(mf.BottomPos,FL_NORMAL_FONT);
   fl_set_object_gravity(mf.BottomPos, FL_NorthEast, FL_NorthEast);
   yy=yy+20;

   mf.WidthI = fl_add_box(FL_NO_BOX,xPosMenu+4,yPosMenu+1+yy,97,19,xwGR(1,"hlp.WidthI","Width:"));
   fl_set_object_lalign(mf.WidthI,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
   fl_set_object_gravity(mf.WidthI, FL_NorthEast, FL_NorthEast);
   mf.Width = fl_add_box(FL_DOWN_BOX,xPosMenu+23+80,yPosMenu+1+yy,56+40,19,"0");
   fl_set_object_lalign(mf.Width,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
   fl_set_object_lstyle(mf.Width,FL_FIXED_STYLE);
   fl_set_object_lsize(mf.Width,FL_NORMAL_FONT);
   fl_set_object_gravity(mf.Width, FL_NorthEast, FL_NorthEast);
   yy=yy+20;

   mf.HeightI = fl_add_box(FL_NO_BOX,xPosMenu+4,yPosMenu+1+yy,97,19,xwGR(1,"hlp.HeightI","Height:"));
   fl_set_object_lalign(mf.HeightI,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
   fl_set_object_gravity(mf.HeightI, FL_NorthEast, FL_NorthEast);
   mf.Height = fl_add_box(FL_DOWN_BOX,xPosMenu+23+80,yPosMenu+1+yy,56+40,19,"0");
   fl_set_object_lalign(mf.Height,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
   fl_set_object_lstyle(mf.Height,FL_FIXED_STYLE);
   fl_set_object_lsize(mf.Height,FL_NORMAL_FONT);
   fl_set_object_gravity(mf.Height, FL_NorthEast, FL_NorthEast);
   yy=yy+20;

   mf.DPII = fl_add_box(FL_NO_BOX,xPosMenu+4,yPosMenu+1+yy,97,19,xwGR(1,"hlp.DPII","DPI:"));
   fl_set_object_lalign(mf.DPII,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
   fl_set_object_gravity(mf.DPII, FL_NorthEast, FL_NorthEast);
   mf.DPI = fl_add_box(FL_DOWN_BOX,xPosMenu+23+80,yPosMenu+1+yy,56+40,19,"0");
   fl_set_object_lalign(mf.DPI,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
   fl_set_object_lstyle(mf.DPI,FL_FIXED_STYLE);
   fl_set_object_lsize(mf.DPI,FL_NORMAL_FONT);
   fl_set_object_gravity(mf.DPI, FL_NorthEast, FL_NorthEast);
   yy=yy+23;

   /* Landscape / Portrait Switch */
   mf.Landscape = fl_add_button(FL_NORMAL_BUTTON,xPosMenu+1,yPosMenu+1+yy,200,20,xwGR(1,"hlp.PoLs","Portrait<->Landscape"));
   fl_set_object_gravity(mf.Landscape, FL_NorthEast, FL_NorthEast);
   yy=yy+21;

   /* Add Frame */
   mf.AddFrame = fl_add_button(FL_NORMAL_BUTTON,xPosMenu+1,yPosMenu+1+yy,200,20,xwGR(1,"hlp.AddFrame","Add Frame"));
   fl_set_object_gravity(mf.AddFrame, FL_NorthEast, FL_NorthEast);
   yy=yy+20;

   /* Edit */
   mf.Edit = fl_add_button(FL_NORMAL_BUTTON,xPosMenu+1,yPosMenu+1+yy,200,20,xwGR(1,"hlp.Edit","Frame/Picture Edit"));
   fl_set_object_gravity(mf.Edit, FL_NorthEast, FL_NorthEast);
   yy=yy+20;

   /* Frame/Picture Trash */
   mf.FPTrash = fl_add_button(FL_NORMAL_BUTTON,xPosMenu+1,yPosMenu+1+yy,200,20,xwGR(1,"hlp.FPTrash","Frame/Picture Trashcan"));
   fl_set_object_gravity(mf.FPTrash, FL_NorthEast, FL_NorthEast);
   yy=yy+21;

   /* MovePicture to Back */
   mf.Back = fl_add_button(FL_NORMAL_BUTTON,xPosMenu+1,yPosMenu+1+yy,100,20,xwGR(1,"hlp.MoveToBack","MoveToBack"));
   fl_set_object_gravity(mf.Back, FL_NorthEast, FL_NorthEast);

   /* MovePicture to Front */
   mf.Front = fl_add_button(FL_NORMAL_BUTTON,xPosMenu+1+100,yPosMenu+1+yy,100,20,xwGR(1,"hlp.MoveToFront","MoveToFront"));
   fl_set_object_gravity(mf.Front, FL_NorthEast, FL_NorthEast);
   yy=yy+20;

   /* Rotate Left */
   mf.RotateLeft = fl_add_button(FL_NORMAL_BUTTON,xPosMenu+1,yPosMenu+1+yy,100,20,xwGR(1,"hlp.RotateLeft","Rotate Left"));
   fl_set_object_gravity(mf.RotateLeft, FL_NorthEast, FL_NorthEast);

   /* Rotate Right */
   mf.RotateRight = fl_add_button(FL_NORMAL_BUTTON,xPosMenu+1+100,yPosMenu+1+yy,100,20,xwGR(1,"hlp.RotateRight","Rotate Right"));
   fl_set_object_gravity(mf.RotateRight, FL_NorthEast, FL_NorthEast);
   yy=yy+21;

   /* Preview */
   mf.Preview = fl_add_button(FL_NORMAL_BUTTON,xPosMenu+1,yPosMenu+1+yy,200,25,xwGR(1,"hlp.Preview","Preview"));
   fl_set_object_gravity(mf.Preview, FL_NorthEast, FL_NorthEast);
   yy=yy+26;

   /* Print */
   mf.Print = fl_add_button(FL_NORMAL_BUTTON,xPosMenu+1,yPosMenu+1+yy,200,25,xwGR(1,"hlp.Print","Print"));
   fl_set_object_gravity(mf.Print, FL_NorthEast, FL_NorthEast);

   fl_end_form();

   return;
}

/* Open Main GUI B */
void xwOpenMainGuiB(void)
{
   /* Titlebar */
   int   xPosTitle=4;
   int   yPosTitle=4;
   int   xSizeTitle=707;
   int   ySizeTitle=20;

   /* Paperposition */
   int   xPosPaperBar=4;
   int   yPosPaperBar=27;
   int   xPosPaper=4;
   int   yPosPaper=27+22;
   int   xSizePaper=707-20;
   int   ySizePaper=503-(22+20);

   /* Menu-Position */
   int   xPosMenu=714;
   int   yPosMenu=4;
   int   xSizeMenu=122;
   int   ySizeMenu=526;

   /* Help Oneliner Position */
   int   localeIndex=0;

   mf.form = NULL;
   mf.ready = 0;

   mf.form = fl_bgn_form(FL_UP_BOX,840,534);

   fl_set_border_width(1);

   /* Titlebar */
   mf.TitleFrame = fl_add_frame(FL_DOWN_FRAME,xPosTitle,yPosTitle,xSizeTitle,ySizeTitle,"");
   fl_set_object_gravity(mf.TitleFrame, FL_NorthWest, FL_NorthEast);

   /* Frame/Picture Mode */
   mf.FPSwitch = fl_add_lightbutton(FL_PUSH_BUTTON,xPosTitle+2,yPosTitle+1,100,18,xwGR(1,"FrameED","FrameED"));
   fl_set_object_gravity(mf.FPSwitch,FL_NorthWest,FL_NorthWest);
   if (xwCheckEditFrame()==-1) fl_set_button(mf.FPSwitch,0);
   if (xwCheckEditFrame()==0) fl_set_button(mf.FPSwitch,1);
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.PictureFrameEd","Picture/Frame Editor"));
   mf.FPSwitch->u_vdata = mf.helpTxt[localeIndex];
   fl_set_object_posthandler(mf.FPSwitch,xwOnliner);
   localeIndex++;

   /* select Frame/Picture */
   mf.SelectFP = fl_add_button(FL_NORMAL_BUTTON,xPosTitle+2+102,yPosTitle+1,601-18,18,"");
   fl_set_object_gravity(mf.SelectFP,FL_NorthWest,FL_NorthEast);
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.PictureFrameList","Picture/Frame List"));
   mf.SelectFP->u_vdata = mf.helpTxt[localeIndex];
   fl_set_object_posthandler(mf.SelectFP,xwOnliner);
   localeIndex++;

   fl_set_border_width(2);

   mf.Eye = fl_add_pixmapbutton(FL_NORMAL_BUTTON,xPosTitle+2+102+583,yPosTitle+1,18,18,"");
   fl_set_pixmap_data(mf.Eye,main_eye_xpm);
   fl_set_object_color(mf.Eye,FL_BLACK,FL_MCOL);
   fl_set_object_gravity(mf.Eye,FL_NorthEast,FL_NorthEast);
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.ViewPicture","Picture Viewer"));
   mf.Eye->u_vdata = mf.helpTxt[localeIndex];
   fl_set_object_posthandler(mf.Eye,xwOnliner);
   localeIndex++;

   fl_set_border_width(1);

   /* Paper Function Bar */
   mf.PaperBar = fl_add_frame(FL_DOWN_FRAME,xPosPaperBar,yPosPaperBar,xSizePaper+20,20,"");
   fl_set_object_gravity(mf.PaperBar,FL_NorthWest,FL_NorthEast);

   /* Paper Zoom */
   mf.PaperZoom = fl_add_choice(FL_DROPLIST_CHOICE,xPosPaperBar+1,yPosPaperBar+1,80,18,"");
   fl_set_object_boxtype(mf.PaperZoom,FL_UP_BOX);
   fl_set_object_gravity(mf.PaperZoom,FL_NorthWest,FL_NorthWest);
   fl_addto_choice(mf.PaperZoom,"100  %%");
   fl_addto_choice(mf.PaperZoom,"125 %%");
   fl_addto_choice(mf.PaperZoom,"150 %%");
   fl_addto_choice(mf.PaperZoom,"175 %%");
   fl_addto_choice(mf.PaperZoom,"200 %%");
   fl_addto_choice(mf.PaperZoom,"250 %%");
   fl_addto_choice(mf.PaperZoom,"300 %%");

   fl_addto_choice(mf.PaperZoom,"400 %%");
   fl_addto_choice(mf.PaperZoom,"500 %%");
   fl_addto_choice(mf.PaperZoom,"600 %%");
   fl_addto_choice(mf.PaperZoom,"700 %%");
   fl_addto_choice(mf.PaperZoom,"800 %%");
   fl_addto_choice(mf.PaperZoom,"900 %%");
   fl_addto_choice(mf.PaperZoom,"1000 %%");

   fl_set_choice(mf.PaperZoom,xwGetZoomV());
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.PaperZoom","Zoom Paper"));
   mf.PaperZoom->u_vdata = mf.helpTxt[localeIndex];
   fl_set_object_posthandler(mf.PaperZoom,xwOnliner);
   localeIndex++;

   /* Landscape/Portrait Info */
   mf.PaperLP = fl_add_box(FL_DOWN_BOX,xPosPaperBar+1+82,yPosPaperBar+1,80,18,"Portrait");
   fl_set_object_gravity(mf.PaperLP,FL_NorthWest,FL_NorthWest);

   /* WYSIWYG Info */
   mf.WYSIWYG = fl_add_box(FL_DOWN_BOX,xPosPaperBar+1+82+82,yPosPaperBar+1,40,18,"NORM");
   fl_set_object_gravity(mf.WYSIWYG,FL_NorthWest,FL_NorthWest);

   /* Left Mouse Frame */
   mf.LMFrame = fl_add_frame(FL_DOWN_FRAME,xPosPaperBar+2+82+82+42,yPosPaperBar+2,171,16,xwGR(1,"RMRSelection","Resize/Move/Rotate"));
   fl_set_object_gravity(mf.LMFrame,FL_NorthWest,FL_NorthWest);
   fl_set_object_lalign(mf.LMFrame,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
   fl_set_object_lsize(mf.LMFrame,FL_TINY_SIZE);

   /* Left Mouse */
   mf.LeftMouse = fl_add_pixmap(FL_NORMAL_PIXMAP,xPosPaperBar+1+82+82+44+1,yPosPaperBar+2,16,16,"");
   fl_set_pixmap_data(mf.LeftMouse,main_leftmouse_xpm);
   fl_set_object_gravity(mf.LeftMouse,FL_NorthWest,FL_NorthWest);

   /* Right Mouse Frame */
   mf.RMFrame = fl_add_frame(FL_DOWN_FRAME,xPosPaperBar+2+82+82+82+135,yPosPaperBar+2,171,16,xwGR(1,"Selection","Frame/Picture Selection"));
   fl_set_object_gravity(mf.RMFrame,FL_NorthWest,FL_NorthWest);
   fl_set_object_lalign(mf.RMFrame,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
   fl_set_object_lsize(mf.RMFrame,FL_TINY_SIZE);

   /* Right Mouse */
   mf.RightMouse = fl_add_pixmap(FL_NORMAL_PIXMAP,xPosPaperBar+1+82+82+82+137+1,yPosPaperBar+2,16,16,"");
   fl_set_pixmap_data(mf.RightMouse,main_rightmouse_xpm);
   fl_set_object_gravity(mf.RightMouse,FL_NorthWest,FL_NorthWest);

   /* Paperframe */
   mf.PaperFrame = fl_add_frame(FL_DOWN_FRAME,xPosPaper,yPosPaper,xSizePaper,ySizePaper,"");
   fl_set_object_gravity(mf.PaperFrame, FL_NorthWest, FL_SouthEast);
   fl_set_object_posthandler(mf.PaperFrame,xwHandler);

   /* Ausgabebereich */
   mf.OutputFrame = fl_add_frame(FL_DOWN_FRAME,xPosMenu,yPosMenu,xSizeMenu,ySizeMenu,"");
   fl_set_object_gravity(mf.OutputFrame, FL_NorthEast, FL_SouthEast);

   /* Paper Sliders */
   mf.PaperSR = fl_add_scrollbar(FL_VERT_BASIC_SCROLLBAR,xPosPaper+xSizePaper+1,yPosPaper-1,20,ySizePaper+2,"");
   fl_set_object_gravity(mf.PaperSR, FL_NorthEast, FL_SouthEast);
   fl_set_scrollbar_bounds(mf.PaperSR,0,0);
   fl_set_scrollbar_value(mf.PaperSR,1);
   /*fl_set_scrollbar_step(mf.PaperSR,100);*/
   fl_set_scrollbar_increment(mf.PaperSR,0.1,0.01);
   fl_set_scrollbar_size(mf.PaperSR,1);
   /* Set Scrollbar Return */
   fl_set_scrollbar_return(mf.PaperSR,FL_RETURN_CHANGED);
   fl_set_object_callback(mf.PaperSR,xwPaperScroller,0);

   /* Paper Sliders */
   mf.PaperSB = fl_add_scrollbar(FL_HOR_BASIC_SCROLLBAR,xPosPaper-1,yPosPaper+ySizePaper+1,xSizePaper+2,20,"");
   fl_set_object_gravity(mf.PaperSB,FL_SouthWest, FL_SouthEast);
   fl_set_scrollbar_bounds(mf.PaperSB,0,0);
   fl_set_scrollbar_value(mf.PaperSB,1);
   /*fl_set_scrollbar_step(mf.PaperSB,100);*/
   fl_set_scrollbar_increment(mf.PaperSB,0.1,0.01);
   fl_set_scrollbar_size(mf.PaperSB,1);
   /* Set Scrollbar Return */
   fl_set_scrollbar_return(mf.PaperSB,FL_RETURN_CHANGED);
   fl_set_object_callback(mf.PaperSB,xwPaperScroller,0);

   /* Full Paper View */
   mf.PaperFull = fl_add_button(FL_NORMAL_BUTTON,xPosPaper+xSizePaper+1,yPosPaper+ySizePaper+1,20,20,"");
   fl_set_object_gravity(mf.PaperFull,FL_SouthEast, FL_SouthEast);
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.Zoom100","Full View"));
   mf.PaperFull->u_vdata = mf.helpTxt[localeIndex];
   fl_set_object_posthandler(mf.PaperFull,xwOnliner);
   localeIndex++;

   fl_set_border_width(2);

   mf.Info = fl_add_pixmapbutton(FL_NORMAL_BUTTON,xPosMenu+1,yPosMenu+1,120,40,"");
   if (xwGetPrefValue(xwgDepth)>8)
   {
      fl_set_pixmap_data(mf.Info,main_info_xpm);
   }
   else
   {
      fl_set_pixmap_data(mf.Info,main_info2_xpm);
   }
   fl_set_object_color(mf.Info,FL_BLACK,FL_MCOL);
   fl_set_object_gravity(mf.Info, FL_NorthEast, FL_NorthEast);
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.About","About"));
   mf.Info->u_vdata = mf.helpTxt[localeIndex];
   fl_set_object_posthandler(mf.Info,xwOnliner);
   localeIndex++;

   mf.Load = fl_add_pixmapbutton(FL_NORMAL_BUTTON,xPosMenu+1,yPosMenu+42,40,40,"");
   fl_set_pixmap_data(mf.Load,main_load_xpm);
   fl_set_object_color(mf.Load,FL_BLACK,FL_MCOL);
   fl_set_object_gravity(mf.Load, FL_NorthEast, FL_NorthEast);
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.Load","Load"));
   mf.Load->u_vdata = mf.helpTxt[localeIndex];
   fl_set_object_posthandler(mf.Load,xwOnliner);
   localeIndex++;
   mf.Save = fl_add_pixmapbutton(FL_NORMAL_BUTTON,xPosMenu+41,yPosMenu+42,40,40,"");
   fl_set_pixmap_data(mf.Save,main_save_xpm);
   fl_set_object_color(mf.Save,FL_BLACK,FL_MCOL);
   fl_set_object_gravity(mf.Save, FL_NorthEast, FL_NorthEast);
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.Save","Save"));
   mf.Save->u_vdata = mf.helpTxt[localeIndex];
   fl_set_object_posthandler(mf.Save,xwOnliner);
   localeIndex++;
   mf.PicBrowser = fl_add_pixmapbutton(FL_NORMAL_BUTTON,xPosMenu+81,yPosMenu+42,40,40,"");
   fl_set_pixmap_data(mf.PicBrowser,main_picbrowser_xpm);
   fl_set_object_color(mf.PicBrowser,FL_BLACK,FL_MCOL);
   fl_set_object_gravity(mf.PicBrowser, FL_NorthEast, FL_NorthEast);
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.PicBrowser","Picture Browser"));
   mf.PicBrowser->u_vdata = mf.helpTxt[localeIndex];
   fl_set_object_posthandler(mf.PicBrowser,xwOnliner);
   localeIndex++;

   mf.PaperPref = fl_add_pixmapbutton(FL_NORMAL_BUTTON,xPosMenu+1,yPosMenu+82,40,40,"");
   fl_set_pixmap_data(mf.PaperPref,main_paperpref_xpm);
   fl_set_object_color(mf.PaperPref,FL_BLACK,FL_MCOL);
   fl_set_object_gravity(mf.PaperPref, FL_NorthEast, FL_NorthEast);
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.PaperPref","Paper Preferences"));
   mf.PaperPref->u_vdata = mf.helpTxt[localeIndex];
   fl_set_object_posthandler(mf.PaperPref,xwOnliner);
   localeIndex++;
   mf.GuiPref = fl_add_pixmapbutton(FL_NORMAL_BUTTON,xPosMenu+41,yPosMenu+82,40,40,"");
   fl_set_pixmap_data(mf.GuiPref,main_guipref_xpm);
   fl_set_object_color(mf.GuiPref,FL_BLACK,FL_MCOL);
   fl_set_object_gravity(mf.GuiPref, FL_NorthEast, FL_NorthEast);
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.GuiPref","xwGUI Preferences"));
   mf.GuiPref->u_vdata = mf.helpTxt[localeIndex];
   fl_set_object_posthandler(mf.GuiPref,xwOnliner);
   localeIndex++;
   mf.PrinterPref = fl_add_pixmapbutton(FL_NORMAL_BUTTON,xPosMenu+81,yPosMenu+82,40,40,"");
   fl_set_pixmap_data(mf.PrinterPref,main_printerpref_xpm);
   fl_set_object_color(mf.PrinterPref,FL_BLACK,FL_MCOL);
   fl_set_object_gravity(mf.PrinterPref, FL_NorthEast, FL_NorthEast);
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.PrinterPref","Printer Preferences"));
   mf.PrinterPref->u_vdata = mf.helpTxt[localeIndex];
   fl_set_object_posthandler(mf.PrinterPref,xwOnliner);
   localeIndex++;

   mf.FrameSets = fl_add_pixmapbutton(FL_NORMAL_BUTTON,xPosMenu+1,yPosMenu+122,40,40,"");
   fl_set_pixmap_data(mf.FrameSets,main_framesets_xpm);
   fl_set_object_color(mf.FrameSets,FL_BLACK,FL_MCOL);
   fl_set_object_gravity(mf.FrameSets, FL_NorthEast, FL_NorthEast);
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.FrameSets","FrameSets"));
   mf.FrameSets->u_vdata = mf.helpTxt[localeIndex];
   fl_set_object_posthandler(mf.FrameSets,xwOnliner);
   localeIndex++;
   
   mf.Assistent = fl_add_pixmapbutton(FL_NORMAL_BUTTON,xPosMenu+41,yPosMenu+122,40,40,"");
   fl_set_pixmap_data(mf.Assistent,main_assistent_xpm);
   fl_set_object_color(mf.Assistent,FL_BLACK,FL_MCOL);
   fl_set_object_gravity(mf.Assistent, FL_NorthEast, FL_NorthEast);
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.Assistent","Assistent"));
   mf.Assistent->u_vdata = mf.helpTxt[localeIndex];
   fl_set_object_posthandler(mf.Assistent,xwOnliner);
   localeIndex++;   

   if (strlen(xwGetPrefName(xwgMTInk))>0)
   {
      mf.MTInk = fl_add_pixmapbutton(FL_NORMAL_BUTTON,xPosMenu+81,yPosMenu+122,40,40,"");
      fl_set_pixmap_data(mf.MTInk,main_mtink_xpm);
      fl_set_object_color(mf.MTInk,FL_BLACK,FL_MCOL);
      fl_set_object_gravity(mf.MTInk, FL_NorthEast, FL_NorthEast);
      strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.MTInk","MTInk"));
      mf.MTInk->u_vdata = mf.helpTxt[localeIndex];
      fl_set_object_posthandler(mf.MTInk,xwOnliner);
      localeIndex++;
   }

   mf.Trash = fl_add_pixmapbutton(FL_NORMAL_BUTTON,xPosMenu+1,yPosMenu+162,40,40,"");
   fl_set_pixmap_data(mf.Trash,main_trash_xpm);
   fl_set_object_color(mf.Trash,FL_BLACK,FL_MCOL);
   fl_set_object_gravity(mf.Trash, FL_NorthEast, FL_NorthEast);
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.Trash","Trashcan"));
   mf.Trash->u_vdata = mf.helpTxt[localeIndex];
   fl_set_object_posthandler(mf.Trash,xwOnliner);
   localeIndex++;

   mf.DocFile = fl_add_pixmapbutton(FL_NORMAL_BUTTON,xPosMenu+41,yPosMenu+162,40,40,"");
   fl_set_pixmap_data(mf.DocFile,main_docpref_xpm);
   fl_set_object_color(mf.DocFile,FL_BLACK,FL_MCOL);
   fl_set_object_gravity(mf.DocFile, FL_NorthEast, FL_NorthEast);
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.Manual","Manual"));
   mf.DocFile->u_vdata = mf.helpTxt[localeIndex];
   fl_set_object_posthandler(mf.DocFile,xwOnliner);
   localeIndex++;

   mf.Exit = fl_add_pixmapbutton(FL_NORMAL_BUTTON,xPosMenu+81,yPosMenu+162,40,40,"");
   fl_set_pixmap_data(mf.Exit,main_exit_xpm);
   fl_set_object_color(mf.Exit,FL_BLACK,FL_MCOL);
   fl_set_object_gravity(mf.Exit, FL_NorthEast, FL_NorthEast);
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.Exit","Exit"));
   mf.Exit->u_vdata = mf.helpTxt[localeIndex];
   fl_set_object_posthandler(mf.Exit,xwOnliner);
   localeIndex++;

   /* Geometrybereich */
   fl_set_border_width(1);
   mf.Geometry = fl_add_frame(FL_DOWN_FRAME,xPosMenu+2,yPosMenu+163+42,xSizeMenu-4,141,"");
   fl_set_object_gravity(mf.Geometry, FL_NorthEast, FL_NorthEast);


   fl_set_border_width(2);
   mf.LeftPosI = fl_add_pixmap(FL_NORMAL_BITMAP,xPosMenu+4,yPosMenu+165+42,17,17,"");
   fl_set_pixmap_data(mf.LeftPosI,main_posleft_xpm);
   fl_set_object_gravity(mf.LeftPosI, FL_NorthEast, FL_NorthEast);
   fl_set_border_width(1);
   mf.LeftPos = fl_add_box(FL_DOWN_BOX,xPosMenu+23,yPosMenu+164+42,56+40,19,"0");
   fl_set_object_lalign(mf.LeftPos,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
   fl_set_object_lstyle(mf.LeftPos,FL_FIXED_STYLE);
   fl_set_object_lsize(mf.LeftPos,FL_NORMAL_FONT);
   fl_set_object_gravity(mf.LeftPos, FL_NorthEast, FL_NorthEast);

   fl_set_border_width(2);
   mf.RightPosI = fl_add_pixmap(FL_NORMAL_BITMAP,xPosMenu+4,yPosMenu+185+42,17,17,"");
   fl_set_pixmap_data(mf.RightPosI,main_posright_xpm);
   fl_set_object_gravity(mf.RightPosI, FL_NorthEast, FL_NorthEast);
   fl_set_border_width(1);
   mf.RightPos = fl_add_box(FL_DOWN_BOX,xPosMenu+23,yPosMenu+184+42,56+40,19,"0");
   fl_set_object_lalign(mf.RightPos,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
   fl_set_object_lstyle(mf.RightPos,FL_FIXED_STYLE);
   fl_set_object_lsize(mf.RightPos,FL_NORMAL_FONT);
   fl_set_object_gravity(mf.RightPos, FL_NorthEast, FL_NorthEast);

   fl_set_border_width(2);
   mf.TopPosI = fl_add_pixmap(FL_NORMAL_BITMAP,xPosMenu+4,yPosMenu+205+42,17,17,"");
   fl_set_pixmap_data(mf.TopPosI,main_postop_xpm);
   fl_set_object_gravity(mf.TopPosI, FL_NorthEast, FL_NorthEast);
   fl_set_border_width(1);
   mf.TopPos = fl_add_box(FL_DOWN_BOX,xPosMenu+23,yPosMenu+204+42,56+40,19,"0");
   fl_set_object_lalign(mf.TopPos,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
   fl_set_object_lstyle(mf.TopPos,FL_FIXED_STYLE);
   fl_set_object_lsize(mf.TopPos,FL_NORMAL_FONT);
   fl_set_object_gravity(mf.TopPos, FL_NorthEast, FL_NorthEast);

   fl_set_border_width(2);
   mf.BottomPosI = fl_add_pixmap(FL_NORMAL_BITMAP,xPosMenu+4,yPosMenu+225+42,17,17,"");
   fl_set_pixmap_data(mf.BottomPosI,main_posbottom_xpm);
   fl_set_object_gravity(mf.BottomPosI, FL_NorthEast, FL_NorthEast);
   fl_set_border_width(1);
   mf.BottomPos = fl_add_box(FL_DOWN_BOX,xPosMenu+23,yPosMenu+224+42,56+40,19,"0");
   fl_set_object_lalign(mf.BottomPos,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
   fl_set_object_lstyle(mf.BottomPos,FL_FIXED_STYLE);
   fl_set_object_lsize(mf.BottomPos,FL_NORMAL_FONT);
   fl_set_object_gravity(mf.BottomPos, FL_NorthEast, FL_NorthEast);

   fl_set_border_width(2);
   mf.WidthI = fl_add_pixmap(FL_NORMAL_BITMAP,xPosMenu+4,yPosMenu+245+42,17,17,"");
   fl_set_pixmap_data(mf.WidthI,main_sizex_xpm);
   fl_set_object_gravity(mf.WidthI, FL_NorthEast, FL_NorthEast);
   fl_set_border_width(1);
   mf.Width = fl_add_box(FL_DOWN_BOX,xPosMenu+23,yPosMenu+244+42,56+40,19,"0");
   fl_set_object_lalign(mf.Width,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
   fl_set_object_lstyle(mf.Width,FL_FIXED_STYLE);
   fl_set_object_lsize(mf.Width,FL_NORMAL_FONT);
   fl_set_object_gravity(mf.Width, FL_NorthEast, FL_NorthEast);

   fl_set_border_width(2);
   mf.HeightI = fl_add_pixmap(FL_NORMAL_BITMAP,xPosMenu+4,yPosMenu+265+42,17,17,"");
   fl_set_pixmap_data(mf.HeightI,main_sizey_xpm);
   fl_set_object_gravity(mf.HeightI, FL_NorthEast, FL_NorthEast);
   fl_set_border_width(1);
   mf.Height = fl_add_box(FL_DOWN_BOX,xPosMenu+23,yPosMenu+264+42,56+40,19,"0");
   fl_set_object_lalign(mf.Height,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
   fl_set_object_lstyle(mf.Height,FL_FIXED_STYLE);
   fl_set_object_lsize(mf.Height,FL_NORMAL_FONT);
   fl_set_object_gravity(mf.Height, FL_NorthEast, FL_NorthEast);

   fl_set_border_width(2);
   mf.DPII = fl_add_pixmap(FL_NORMAL_BITMAP,xPosMenu+4,yPosMenu+285+42,17,17,"");
   fl_set_pixmap_data(mf.DPII,main_dpi_xpm);
   fl_set_object_gravity(mf.DPII, FL_NorthEast, FL_NorthEast);
   fl_set_border_width(1);
   mf.DPI = fl_add_box(FL_DOWN_BOX,xPosMenu+23,yPosMenu+284+42,56+40,19,"0");
   fl_set_object_lalign(mf.DPI,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
   fl_set_object_lstyle(mf.DPI,FL_FIXED_STYLE);
   fl_set_object_lsize(mf.DPI,FL_NORMAL_FONT);
   fl_set_object_gravity(mf.DPI, FL_NorthEast, FL_NorthEast);


   /* Landscape / Portrait Switch */
   fl_set_border_width(2);
   mf.Landscape = fl_add_pixmapbutton(FL_NORMAL_BUTTON,xPosMenu+1,yPosMenu+163+42+141+2,30,30,"");
   fl_set_pixmap_data(mf.Landscape,main_landscape_xpm);
   fl_set_object_color(mf.Landscape,FL_BLACK,FL_MCOL);
   fl_set_object_gravity(mf.Landscape, FL_NorthEast, FL_NorthEast);
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.PoLs","Portrait<->Landscape"));
   mf.Landscape->u_vdata = mf.helpTxt[localeIndex];
   fl_set_object_posthandler(mf.Landscape,xwOnliner);
   localeIndex++;
   /* Add Frame */
   mf.AddFrame = fl_add_pixmapbutton(FL_NORMAL_BUTTON,xPosMenu+1+30,yPosMenu+163+42+141+2,30,30,"");
   fl_set_pixmap_data(mf.AddFrame,main_addframe_xpm);
   fl_set_object_color(mf.AddFrame,FL_BLACK,FL_MCOL);
   fl_set_object_gravity(mf.AddFrame, FL_NorthEast, FL_NorthEast);
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.AddFrame","Add Frame"));
   mf.AddFrame->u_vdata = mf.helpTxt[localeIndex];
   fl_set_object_posthandler(mf.AddFrame,xwOnliner);
   localeIndex++;
   /* Edit */
   mf.Edit = fl_add_pixmapbutton(FL_NORMAL_BUTTON,xPosMenu+1+60,yPosMenu+163+42+141+2,30,30,"");
   fl_set_pixmap_data(mf.Edit,main_edit_xpm);
   fl_set_object_color(mf.Edit,FL_BLACK,FL_MCOL);
   fl_set_object_gravity(mf.Edit, FL_NorthEast, FL_NorthEast);
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.Edit","Frame/Picture Edit"));
   mf.Edit->u_vdata = mf.helpTxt[localeIndex];
   fl_set_object_posthandler(mf.Edit,xwOnliner);
   localeIndex++;
   /* Frame/Picture Trash */
   mf.FPTrash = fl_add_pixmapbutton(FL_NORMAL_BUTTON,xPosMenu+1+90,yPosMenu+163+42+141+2,30,30,"");
   fl_set_pixmap_data(mf.FPTrash,main_fptrash_xpm);
   fl_set_object_color(mf.FPTrash,FL_BLACK,FL_MCOL);
   fl_set_object_gravity(mf.FPTrash, FL_NorthEast, FL_NorthEast);
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.FPTrash","Frame/Picture Trashcan"));
   mf.FPTrash->u_vdata = mf.helpTxt[localeIndex];
   fl_set_object_posthandler(mf.FPTrash,xwOnliner);
   localeIndex++;

   /* MovePicture to Back */
   mf.Back = fl_add_pixmapbutton(FL_NORMAL_BUTTON,xPosMenu+1,yPosMenu+163+42+141+2+31,30,30,"");
   fl_set_pixmap_data(mf.Back,main_back_xpm);
   fl_set_object_color(mf.Back,FL_BLACK,FL_MCOL);
   fl_set_object_gravity(mf.Back, FL_NorthEast, FL_NorthEast);
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.MoveToBack","MoveToBack"));
   mf.Back->u_vdata = mf.helpTxt[localeIndex];
   fl_set_object_posthandler(mf.Back,xwOnliner);
   localeIndex++;
   /* MovePicture to Front */
   mf.Front = fl_add_pixmapbutton(FL_NORMAL_BUTTON,xPosMenu+1+30,yPosMenu+163+42+141+2+31,30,30,"");
   fl_set_pixmap_data(mf.Front,main_front_xpm);
   fl_set_object_color(mf.Front,FL_BLACK,FL_MCOL);
   fl_set_object_gravity(mf.Front, FL_NorthEast, FL_NorthEast);
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.MoveToFront","MoveToFront"));
   mf.Front->u_vdata = mf.helpTxt[localeIndex];
   fl_set_object_posthandler(mf.Front,xwOnliner);
   localeIndex++;
   /* Rotate Left */
   mf.RotateLeft = fl_add_pixmapbutton(FL_NORMAL_BUTTON,xPosMenu+1+60,yPosMenu+163+42+141+2+31,30,30,"");
   fl_set_pixmap_data(mf.RotateLeft,main_rotateleft_xpm);
   fl_set_object_color(mf.RotateLeft,FL_BLACK,FL_MCOL);
   fl_set_object_gravity(mf.RotateLeft, FL_NorthEast, FL_NorthEast);
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.RotateLeft","Rotate Left"));
   mf.RotateLeft->u_vdata = mf.helpTxt[localeIndex];
   fl_set_object_posthandler(mf.RotateLeft,xwOnliner);
   localeIndex++;
   /* Rotate Right */
   mf.RotateRight = fl_add_pixmapbutton(FL_NORMAL_BUTTON,xPosMenu+1+90,yPosMenu+163+42+141+2+31,30,30,"");
   fl_set_pixmap_data(mf.RotateRight,main_rotateright_xpm);
   fl_set_object_color(mf.RotateRight,FL_BLACK,FL_MCOL);
   fl_set_object_gravity(mf.RotateRight, FL_NorthEast, FL_NorthEast);
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.RotateRight","Rotate Right"));
   mf.RotateRight->u_vdata = mf.helpTxt[localeIndex];
   fl_set_object_posthandler(mf.RotateRight,xwOnliner);
   localeIndex++;

   /* Preview */
   mf.Preview = fl_add_pixmapbutton(FL_NORMAL_BUTTON,xPosMenu+1,yPosMenu+163+42+141+2+31+31,60,40,"");
   fl_set_pixmap_data(mf.Preview,main_preview_xpm);
   fl_set_object_color(mf.Preview,FL_BLACK,FL_MCOL);
   fl_set_object_gravity(mf.Preview, FL_NorthEast, FL_NorthEast);
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.Preview","Preview"));
   mf.Preview->u_vdata = mf.helpTxt[localeIndex];
   fl_set_object_posthandler(mf.Preview,xwOnliner);
   localeIndex++;

   /* Print */
   mf.Print = fl_add_pixmapbutton(FL_NORMAL_BUTTON,xPosMenu+1+60,yPosMenu+163+42+141+2+31+31,60,40,"");
   fl_set_pixmap_data(mf.Print,main_printer_xpm);
   fl_set_object_color(mf.Print,FL_BLACK,FL_MCOL);
   fl_set_object_gravity(mf.Print, FL_NorthEast, FL_NorthEast);
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.Print","Print"));
   mf.Print->u_vdata = mf.helpTxt[localeIndex];
   fl_set_object_posthandler(mf.Print,xwOnliner);
   localeIndex++;

   fl_end_form();

   return;
}

/* Close Main GUI */
void xwCloseMainGui(void)
{
   int            xsize,ysize;

   fl_get_winsize(mf.form->window,&xsize,&ysize);
   /* Set New Winsize */
   xwSetPrefValue(xwgWidth,xsize);
   xwSetPrefValue(xwgHeight,ysize);

   /* Close SelectFP */
   xwCloseFP();

   fl_hide_form(mf.form);

   if (xwGetPrefValue(xwgGUI)!=0)
   {
      fl_free_pixmapbutton_pixmap(mf.Eye);

      fl_free_pixmapbutton_pixmap(mf.LeftMouse);
      fl_free_pixmapbutton_pixmap(mf.RightMouse);

      fl_free_pixmapbutton_pixmap(mf.Info);

      fl_free_pixmapbutton_pixmap(mf.Load);
      fl_free_pixmapbutton_pixmap(mf.Save);
      fl_free_pixmapbutton_pixmap(mf.PicBrowser);

      fl_free_pixmapbutton_pixmap(mf.PaperPref);
      fl_free_pixmapbutton_pixmap(mf.GuiPref);
      fl_free_pixmapbutton_pixmap(mf.PrinterPref);

      fl_free_pixmapbutton_pixmap(mf.FrameSets);
      fl_free_pixmapbutton_pixmap(mf.Assistent);
      if (strlen(xwGetPrefName(xwgMTInk))>0) fl_free_pixmapbutton_pixmap(mf.MTInk);
      
      fl_free_pixmapbutton_pixmap(mf.Trash);
      fl_free_pixmapbutton_pixmap(mf.DocFile);
      fl_free_pixmapbutton_pixmap(mf.Exit);

      fl_free_pixmapbutton_pixmap(mf.LeftPosI);
      fl_free_pixmapbutton_pixmap(mf.RightPosI);
      fl_free_pixmapbutton_pixmap(mf.TopPosI);
      fl_free_pixmapbutton_pixmap(mf.BottomPosI);
      fl_free_pixmapbutton_pixmap(mf.WidthI);
      fl_free_pixmapbutton_pixmap(mf.HeightI);
      fl_free_pixmapbutton_pixmap(mf.DPII);

      fl_free_pixmapbutton_pixmap(mf.Landscape);
      fl_free_pixmapbutton_pixmap(mf.AddFrame);
      fl_free_pixmapbutton_pixmap(mf.Edit);
      fl_free_pixmapbutton_pixmap(mf.FPTrash);

      fl_free_pixmapbutton_pixmap(mf.Back);
      fl_free_pixmapbutton_pixmap(mf.Front);
      fl_free_pixmapbutton_pixmap(mf.RotateLeft);
      fl_free_pixmapbutton_pixmap(mf.RotateRight);

      fl_free_pixmapbutton_pixmap(mf.Preview);
      fl_free_pixmapbutton_pixmap(mf.Print);

      /*
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      fl_free_pixmapbutton_pixmap(mf.);
      */
   }

   fl_free_form(mf.form);

   mf.form=NULL;

   return;
}

/* Set AppMainGui */
void xwAppMainGui(void)
{
   if (mf.form!=NULL)
   {
      fl_set_app_mainform(mf.form);
   }

   return;
}

/* Check MainGui */
int xwCheckMainGui(void)
{
   if (mf.form != NULL)
   {
      /* Scale Window to Pref Size */
      fl_set_form_size(mf.form,xwGetPrefValue(xwgWidth),xwGetPrefValue(xwgHeight));

      /* Minimal Size of xwGUI */
      fl_set_form_minsize(mf.form,xwMainX,xwMainY);

      if (xwGetPrefValue(xwgWinPos)==0)
      {
         fl_prepare_form_window(mf.form,FL_PLACE_POSITION|FL_FREE_SIZE,FL_FULLBORDER,xwInfoA);
      }
      else
      {
         fl_prepare_form_window(mf.form,FL_PLACE_CENTER|FL_FREE_SIZE,FL_FULLBORDER,xwInfoA);
      }

      /* Display Window */
      fl_show_form_window(mf.form);

      /* Exit Handler */
      fl_set_form_atclose(mf.form,close_cb,(void *) "1");

      return(1);
   }
   else
   {
      return(0);
   }
}

/* Is MainGui active */
int xwIsMainGui(int az)
{
   /* check MainGui */
   if (az==0) return(mf.ready);
   /* close MainGui */
   if (az==1) mf.ready=1;

   return(0);
}

/* DeActivate MainForm */
void xwDeactivateMain(void)
{
   fl_deactivate_form(mf.form);
   xwDeactivateFP();

   return;
}

/* Activate MainForm */
void xwActivateMain(void)
{
   fl_activate_form(mf.form);
   xwActivateFP();

   /*fl_add_timeout(200,refreshGUI,0);*/

   return;
}

/* Lock MainGui */
void xwLockMainGui(void)
{
   fl_get_winsize(mf.form->window,&mf.width,&mf.height);

   /* Minimal Size of xwGUI */
   fl_set_form_minsize(mf.form,mf.width,mf.height);
   fl_set_form_maxsize(mf.form,mf.width,mf.height);

   return;
}

/* UnLock MainGui */
void xwUnLockMainGui(void)
{
   /* Minimal Size of xwGUI */
   fl_set_form_minsize(mf.form,xwMainX,xwMainY);
   fl_set_form_maxsize(mf.form,
                       DisplayWidth(fl_get_display(),DefaultScreen(fl_get_display())),
                       DisplayHeight(fl_get_display(),DefaultScreen(fl_get_display()))
                       );
   
   return;
}

/* Get Mainform */
FL_FORM *xwGetMainGui(void)
{
   return(mf.form);
}

/* Get Main Window */
Window xwGetMainWindow(void)
{
   return(mf.form->window);
}

/* Set Language for Main GUI */
void xwSetGuiLanguage(void)
{
   /* Help Oneliner Position */
   int   localeIndex=0;
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.PictureFrameEd","Picture/Frame Editor"));
   localeIndex++;
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.PictureFrameList","Picture/Frame List"));
   localeIndex++;
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.ViewPicture","Picture Viewer"));
   localeIndex++;
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.PaperZoom","Zoom Paper"));
   localeIndex++;
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.Zoom100","Full View"));
   localeIndex++;
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.About","About"));
   localeIndex++;
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.Load","Load"));
   localeIndex++;
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.Save","Save"));
   localeIndex++;
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.PicBrowser","Picture Browser"));
   localeIndex++;
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.PaperPref","Paper Preferences"));
   localeIndex++;
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.GuiPref","xwGUI Preferences"));
   localeIndex++;
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.PrinterPref","Printer Preferences"));
   localeIndex++;
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.FrameSets","FrameSets"));
   localeIndex++;
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.Assistent","Assistent"));
   localeIndex++;
   if (strlen(xwGetPrefName(xwgMTInk))>0)
   {
      strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.MTInk","MTInk"));
      localeIndex++;
   }
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.Trash","Trashcan"));
   localeIndex++;
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.Manual","Manual"));
   localeIndex++;
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.Exit","Exit"));
   localeIndex++;
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.PoLs","Portrait<->Landscape"));
   localeIndex++;
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.AddFrame","Add Frame"));
   localeIndex++;
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.Edit","Frame/Picture Edit"));
   localeIndex++;
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.FPTrash","Frame/Picture Trashcan"));
   localeIndex++;
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.MoveToBack","MoveToBack"));
   localeIndex++;
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.MoveToFront","MoveToFront"));
   localeIndex++;
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.RotateLeft","Rotate Left"));
   localeIndex++;
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.RotateRight","Rotate Right"));

   localeIndex++;
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.Preview","Preview"));
   localeIndex++;
   strcpy(mf.helpTxt[localeIndex],xwGR(1,"hlp.Print","Print"));
   localeIndex++;

   /* Mouse Help Texts */

   /* Left Mouse Frame */
   fl_hide_object(mf.LMFrame);
   fl_set_object_label(mf.LMFrame,xwGR(1,"RMRSelection","Resize/Move/Rotate"));
   fl_show_object(mf.LMFrame);

   /* Right Mouse Frame */
   fl_hide_object(mf.RMFrame);
   fl_set_object_label(mf.RMFrame,xwGR(1,"Selection","Frame/Picture Selection"));
   fl_show_object(mf.RMFrame);

   return;
}

/* Redraw GUI */
void xwRedrawMainGui(void)
{
   if (mf.form!=NULL)
   {
      fl_redraw_object(mf.TitleFrame); 
      fl_redraw_object(mf.PaperFrame);
      /*fl_redraw_object(mf.PaperFree);*/
      fl_redraw_object(mf.OutputFrame);
      fl_redraw_object(mf.FPSwitch);
      fl_redraw_object(mf.SelectFP);
      fl_redraw_object(mf.Eye);
      
      fl_redraw_object(mf.PaperBar);
      fl_redraw_object(mf.PaperZoom);
      fl_redraw_object(mf.PaperLP);
      fl_redraw_object(mf.WYSIWYG);
      
      fl_redraw_object(mf.LMFrame);
      fl_redraw_object(mf.LeftMouse);
      fl_redraw_object(mf.RMFrame);
      fl_redraw_object(mf.RightMouse);
      
      fl_redraw_object(mf.PaperSR);
      fl_redraw_object(mf.PaperSB);
      fl_redraw_object(mf.PaperFull);

      fl_redraw_object(mf.Info);
      fl_redraw_object(mf.Load);
      fl_redraw_object(mf.Save);
      fl_redraw_object(mf.PicBrowser);
      
      fl_redraw_object(mf.PaperPref);
      fl_redraw_object(mf.GuiPref);
      fl_redraw_object(mf.PrinterPref);
      
      fl_redraw_object(mf.FrameSets);
      fl_redraw_object(mf.Assistent);
      fl_redraw_object(mf.MTInk);
      
      fl_redraw_object(mf.Trash);
      fl_redraw_object(mf.DocFile);
      fl_redraw_object(mf.Exit);
      
      fl_redraw_object(mf.Geometry);
      fl_redraw_object(mf.LeftPosI);
      fl_redraw_object(mf.LeftPos);
      fl_redraw_object(mf.RightPosI);
      fl_redraw_object(mf.RightPos);
      fl_redraw_object(mf.TopPosI);
      fl_redraw_object(mf.TopPos);
      fl_redraw_object(mf.BottomPosI);
      fl_redraw_object(mf.BottomPos);
      fl_redraw_object(mf.WidthI);
      fl_redraw_object(mf.Width);
      fl_redraw_object(mf.HeightI);
      fl_redraw_object(mf.Height);
      fl_redraw_object(mf.DPII);
      fl_redraw_object(mf.DPI);
      
      fl_redraw_object(mf.Landscape);
      fl_redraw_object(mf.AddFrame);
      fl_redraw_object(mf.Edit);
      fl_redraw_object(mf.FPTrash);
      
      fl_redraw_object(mf.Back);
      fl_redraw_object(mf.Front);
      fl_redraw_object(mf.RotateLeft);
      fl_redraw_object(mf.RotateRight);
      
      fl_redraw_object(mf.Preview);
      fl_redraw_object(mf.Print);
   }
   
   return;
}
