/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWMAIN_ACTION_H
#define _XWMAIN_ACTION_H

#include <forms.h>
#include <string.h>
#include <unistd.h>

#ifndef rotateLeft
#define rotateLeft      0
#endif
#ifndef rotateRight
#define rotateRight     1
#endif



typedef struct printform
{
   /* Main-Form data */
   FL_FORM           *form;
   /* Event Loop */
   FL_OBJECT         *obj;
   int               ready;
   
   FL_OBJECT         *printer;
   
   FL_OBJECT         *dpiout;
   FL_OBJECT         *sheets;
   
   FL_OBJECT         *tofile;
   FL_OBJECT         *file;
   
   FL_OBJECT         *print;
   FL_OBJECT         *cancel;
   
   int               paperXSize;             /* PaperSize */
   int               paperYSize;
   int               fileSize;
} printform;


/* GUI Dispatcher */
void xwMGEvent(FL_OBJECT *obj);

/* Select Frame/Picture Editor */
void xwSelectFPEd(void);

/* Paper Zoom */
void xwZoom(int az);
/* Scrollbar Result */
void xwPaperScroller(FL_OBJECT *obj,long data);

/* Load Pixmap or Frameset */
void xwLoad(void);
/* Save FrameSet */
void xwSave(void);
/* Picture Browser */
void xwPicBrowser(void);

/* Paper Pref */
void xwPaperPref(void);
/* xwGUI Pref */
void xwGuiPref(void);
/* Printer Pref */
void xwPrinterPref(void);

/* FrameSet */
void xwFrameSets(void);
/* Assistent */
void xwAssistents();

/* Trash */
void xwTrash(void);

/* EXIT */
void xwExit(void);

/* Landscape switch */
void xwAcLandscape(void);
/* Add Frame */
void xwAdd(void);
/* Editor */
void xwEdit(void);
/* Frame/Picture Trashcan */
void xwFPTrash(void);


/* Move To Back */
void xwBack(void);
/* Move To Front */
void xwFront(void);
/* Rotate */
void xwRotate(int direction);

/* Resize Frame/Picture */
void xwResize(int mode);
/* Move Frame/Picture */
void xwMove(int xpos,int ypos);

/* Preview */
void xwPreview(void);
/* Print */
void xwPrint(void);

#endif

