/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "main.h"

/* xwGUI Includes */
#include "assistent.h"
#include "base.h"
#include "default.h"
#include "error.h"
#include "exit.h"
#include "fileio.h"
#include "fileselect.h"
#include "font.h"
#include "frame.h"
#include "gfx.h"
#include "gimp_plugin.h"
#include "handler.h"
#include "help.h"
#include "interpreter.h"
#include "io.h"
#include "language.h"
#include "main_action.h"
#include "main_gui.h"
#include "mtink.h"
#include "nconvert.h"
#include "oneliner.h"
#include "page.h"
#include "paper.h"
#include "pbcache.h"
#include "picbrowser.h"
#include "picture.h"
#include "pref_printer.h"
#include "prtmanager.h"
#include "resource.h"
#include "selectfp.h"
#include "time.h"
#include "variable.h"
#include "x11.h"


/*#include "driver_turboprint.h"*/

Atom              xwGUIAtom=NULL;
Window            xwGUIWindow;

int main(int argc, char *argv[])
{
   /* selected Widget */
   FL_OBJECT   *obj;
   char        aPath[1024],bPath[1024];

   int               x,y;
   unsigned int      width,height;
   unsigned int      border_width;
   unsigned int      depth;
   Window            root;


   xwInitMainGui();
   xwGFXInit();
   xwPageInit();

   /* Init Interpreter */
   xwInitInterpreter();

   /* Init FileIO */
   xwInitFileIO();

   /* Prozess sauber abtrennen */
   signal(SIGCHLD,SIG_IGN);

   /* Background Color */
   /*fl_set_icm_color(FL_COL1,215,215,215);*/
   fl_set_icm_color(FL_COL1,204,204,204); /* 191 */

   fl_set_icm_color(FL_INACTIVE_COL,180,180,180);

   fl_set_icm_color(FL_TOP_BCOL,255,255,255);
   fl_set_icm_color(FL_LEFT_BCOL,255,255,255);

   /* Frame Colors 215 */
   fl_set_icm_color(FL_MCOL,230,230,230);

   fl_set_scrollbar_type(FL_PLAIN_SCROLLBAR);

   fl_initialize(&argc, argv, "Xwgui", 0, 0);

   if (fl_get_display()!=NULL)
   {
      /* Get Display Depth */
      if (XGetGeometry(fl_get_display(),RootWindow(fl_get_display(),DefaultScreen(fl_get_display())),&root,&x,&y,&width,&height,&border_width,&depth)!=False)
      {
         xwSetPrefValue(xwgDepth,depth);
      }

      /* check xwgui atom */
      xwGUIAtom=XInternAtom(fl_get_display(),"XWGUI2",False);
      if ( (xwGUIWindow=XGetSelectionOwner(fl_get_display(),xwGUIAtom)) != None )
      {
         xwDisplayMessage(NULL,"xwGUI is already started.\nThis xwGUI Process goes down.\n");
         XRaiseWindow(fl_get_display(),xwGUIWindow);
         XFlush(fl_get_display());
         exit(0);
      }

      /* Check Install Path */
      xwInstallPath("xwgui2");
      xwSetDrawer(".xwgui2");

      /* Load Resource */
      xwInitResource(xwGetIP("Xwgui"));

      /* Init Default Settings */
      xwSetPrefValue(xwgReset,0);
      xwSetPrefName(xwgReset,"");

      /* check nconvert */
      if (CheckNConvert()==xwTrue)
      {
         xwSetPrefValue(xwgConvert,1);
      }

      /* check mtink */
      CheckMTInk();

      /* Create xwGUI Home-Directory */
      mkdir(xwGetFile("",""),S_IRWXU);
      mkdir(xwGetFile("","Locale-FrameSets"),S_IRWXU);
      mkdir(xwGetFile("","PBCache"),S_IRWXU);
      mkdir(xwGetFile("","etc"),S_IRWXU);
      strcpy(aPath,xwGetFile("","Globale-FrameSets"));
      strcpy(bPath,xwGetIP("FrameSets"));
      symlink(bPath,aPath);

      /* Init Fileselect */
      xwSetFSPath(getenv("HOME"));
      /* Fileselector Custom Button */
      xwSetFSCustom(".xwgui2",xwGetFile("",""));

      /* Init Picture Browser */
      xwSetPBPath(getenv("HOME"));

      /* Init Gimp PlugIn */
      xwInitGimp();

      /* Argument Check */
      if (argc == 2)
      {
         /* Gimp PlugIn Check */
         xwCheckGimp(argv[1]);

         /* Expert Mode */
         if (strcmp(argv[1],"-expert") == 0)
         {
            xwSetPrefValue(xwgExpert,1);
            printf("xwGUI is now started in Expert-Mode !!!\n");
         }
      }

      /* Init Paper */
      xwInitPaper();
      /* Init Frame */
      xwInitFrames();
      /* Init Pictures */
      xwInitPicture();

      /* Init Variable */
      xwInitVarDef();

      /* Initialize PrtManager Datas */
      xwInitPrtManager();

      /* Load Preference File */
      if (xwExist(xwGetFile("","xwgui.rc"))==0)
      {
         xwInterpret(xwGetFile("","xwgui.rc"),NULL);
      }
      else
      {
         /* Initial First Use in Selected Language */
         xwSelectLanguage();
      }

      /* Interpret Selected Driver File */
      if (strlen(xwGetPrefDriver())>0)
      {
         xwInterpret(xwGetPrefDriver(),NULL);
         xwCreatePrinterIndex();
         xwSetDefaults(xwGetPrinterNumber(xwGetPrefPrinter()));
         xwLoadPrinterSetting(xwGetPrefDriver(),xwGetPrefPrinter(),xwGetPrefSetting());
      }

      /* initialize font support */
      xwFontInit(0);

      /* Open Assistent */
      if (xwGetPrefValue(xwgAssistent)==0)
      {
         /*xwDeactivateMain();*/
         xwSetPrefValue(xwgAssLock,1);
         if (xwAssistent(1)==assExit)
         {
            xwGUIExit();
            exit(0);
         }
         xwSetPrefValue(xwgAssLock,0);

         /*xwActivateMain();*/
      }

      xwOpenMainGui();

      /* Open Layer Window */
      if (xwGetPrefValue(xwgLayer)>0) xwOpenFP();

      if (xwCheckMainGui()==1)
      {
         /* xwGUIAtom */
         XSetSelectionOwner(fl_get_display(),xwGUIAtom,xwGetMainWindow(),CurrentTime);

         /* load FrameSet */
         if ((strlen(xwGetPrefName(xwgFrameSet))>0) && (xwGetPrefValue(xwgAssistent)!=0))
         {
            /* load frameset */
            xwInterpret(xwGetPrefName(xwgFrameSet),NULL);

            /* Picture Editor */
            xwDeActivateFrameEd();
         }

         /* Gimp Mode */
         if (xwGimpMode()==0)
         {
            /* Load Picture */
            xwFPLoad(xwGetFile("","gimp.data"));
         }

         /* ReDraw Page */
         xwDrawPage(pgRecalc);

         /* Start OneLiner */
         xwOLInit();

         while (xwIsMainGui(0)==0)
         {
            obj = fl_do_forms();

            /* Main Action */
            xwMGEvent(obj);
         }

         /* Remove OneLiner */
         xwOLRemove();
      }

      /* Exit Manager */
      xwGUIExit();

   }
   else
   {
      printf("xwGUI 2: Can't open Display !!! Check your X11-Configuration and Access Rights !!!\n");
   }

   return 0;
}