/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWLOWLEVEL_H
#define _XWLOWLEVEL_H

/* Geometry Output Fields */
#define geoLeft         1
#define geoRight        2
#define geoTop          3
#define geoBottom       4
#define geoWidth        5
#define geoHeight       6
#define geoDPI          7

/* Draw Object */
#define drawNone     1234
#define clearPaper      0
#define drawPaper       1
#define drawBorder      2
#define drawFrame       3
#define drawTFrame      4
#define drawPic         5
#define drawAPic        6
#define drawTitlebar    7
#define drawBand        8
#define drawFP          9
#define drawAFP        10

/* Low-Level Pixel Size */
typedef struct pixelsize
{
   float             xsize;
   float             ysize;
   float             psize;
} pixelsize;

/* Output Geometry Datas */
void xwGeoPrint(int mo,const char *source);
/* Draw Frame */
void xwDraw(int mo,float x,float y,float w,float h);
/* Get X-Papersize */
int xwGetXSize(void);
/* Get Y-Papersize */
int xwGetYSize(void);
/* SetPixelSize */
void xwSetPixelSize(float x,float y);
/* Get Pixel Size */
float xwGetPixelSize(void);
/* Set Zoom Factor */
void xwSetZoom(float zoom);
/* Get Zoom Factor */
float xwGetZoom(void);
/* Set Zoom Value */
void xwSetZoomV(int az);
/* Get Zoom Value */
int xwGetZoomV(void);
/* Set GFX-Offset */
void xwSetXOffset(int az);
void xwSetYOffset(int az);
/* Get GFX-Offset */
int xwGetXOffset(void);
int xwGetYOffset(void);
/* Set GFX-Offset */
void xwSetXXOffset(float az);
void xwSetYYOffset(float az);
/* Get GFX-Offset */
float xwGetXXOffset(void);
float xwGetYYOffset(void);

#endif