/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "lowlevel.h"

#include "main_gui.h"
#include "page.h"
#include "paper.h"
#include "wysiwyg.h"

extern struct mainform     mf;

static struct pixelsize    ps;

extern struct pagedata     pd;

static float               psZoom=1;   /* Zoom Factor */
static float               psXXOffset=0;
static float               psYYOffset=0;
static int                 psXOffset=0;
static int                 psYOffset=0;

/* Output Geometry Datas */
void xwGeoPrint(int mo,const char *source)
{
   if (mo==geoLeft) fl_set_object_label(mf.LeftPos,source);
   if (mo==geoRight) fl_set_object_label(mf.RightPos,source);
   if (mo==geoTop) fl_set_object_label(mf.TopPos,source);
   if (mo==geoBottom) fl_set_object_label(mf.BottomPos,source);
   if (mo==geoWidth) fl_set_object_label(mf.Width,source);
   if (mo==geoHeight) fl_set_object_label(mf.Height,source);
   if (mo==geoDPI) fl_set_object_label(mf.DPI,source);

   return;
}

/* Draw Frame */
void xwDraw(int mo,float x,float y,float w,float h)
{
   int         xx,yy,ww,hh;
   int         lineStyle;

   /* Portrait / Landscape */
   /* For Frames Only */
   if (xwIsPaperLS()==xwLandscape)
   {
      /* Position Converting */
      xx=(xwGetPaperYSize())-(y+h);
      yy=x;

      ww=h;
      hh=w;
   }
   else
   {
      xx=x;
      yy=y;
      ww=w;
      hh=h;
   }

   /* Calculate Real Position */
   xx=(xx*ps.psize);
   yy=(yy*ps.psize);
   ww=(ww*ps.psize);
   hh=(hh*ps.psize);

   /* WYSIWYG Mode */
   if (xwAskRealMode()==1)
   {
      /* Frame/Picture Borders */
      if ((mo==drawFrame) ||(mo==drawPic))
      {
         mo=drawFP;
      }
      
      /* active Frame/Picture Borders */
      else if ((mo==drawTFrame) || (mo==drawAPic))
      {
         mo=drawAFP;
      }
      /* Picture Titlebar */
      else if (mo==drawTitlebar)
      {
         mo=drawNone;
      }
   }

   /* Clear Outputfield */
   if (mo==clearPaper)
   {
      fl_winset(pd.pixmap);
      fl_set_clipping(0,0,mf.PaperFrame->w,mf.PaperFrame->h);
      fl_rectf(0,0,mf.PaperFrame->w,mf.PaperFrame->h,FL_COL1);
      fl_unset_clipping();
   }
   /* Paper */
   else if (mo==drawPaper)
   {
      fl_winset(pd.pixmap);
      fl_set_clipping(0,0,mf.PaperFrame->w,mf.PaperFrame->h);
      fl_rectf(-psXOffset,-psYOffset,ww,hh,FL_WHITE);
      fl_unset_clipping();
   }
   /* Paper Borders */
   else if (mo==drawBorder)
   {
      fl_winset(pd.pixmap);
      fl_set_clipping(0,0,mf.PaperFrame->w,mf.PaperFrame->h);
      fl_rect(xx-psXOffset,yy-psYOffset,ww,hh,FL_MCOL);
      fl_unset_clipping();
   }
   /* inactive Frame */
   else if (mo==drawFrame)
   {
      fl_winset(pd.pixmap);
      fl_set_clipping(0,0,mf.PaperFrame->w,mf.PaperFrame->h);
      fl_rectbound(xx-psXOffset,yy-psYOffset,ww,hh,FL_COL1); /* MCOL */
      fl_unset_clipping();
   }
   /* active Frame */
   else if (mo==drawTFrame) 
   {
      fl_winset(pd.pixmap);
      fl_set_clipping(0,0,mf.PaperFrame->w,mf.PaperFrame->h);
      fl_rectbound(xx-psXOffset,yy-psYOffset,ww,hh,FL_MCOL); /* COL1 */
      fl_unset_clipping();
   }
   /* inactive Picture */
   else if (mo==drawPic)
   {
      fl_winset(pd.pixmap);
      fl_set_clipping(0,0,mf.PaperFrame->w,mf.PaperFrame->h);
      fl_rectbound(xx-psXOffset,yy-psYOffset,ww,hh,FL_DARKGOLD);
      fl_unset_clipping();
   }
   /* active Picture */
   else if (mo==drawAPic)
   {
      fl_winset(pd.pixmap);
      fl_set_clipping(0,0,mf.PaperFrame->w,mf.PaperFrame->h);
      fl_rectbound(xx-psXOffset,yy-psYOffset,ww,hh,FL_WHEAT);
      fl_unset_clipping();
   }
   /* Picture Titlebar */
   else if (mo==drawTitlebar)
   {
      fl_winset(pd.pixmap);
      fl_set_clipping(0,0,mf.PaperFrame->w,mf.PaperFrame->h);
      fl_rectbound(xx-psXOffset,yy-psYOffset,ww,hh,FL_BLUE);
      fl_unset_clipping();
   }
   /* Frame/Picture Band */
   else if (mo==drawBand)
   {
      fl_winset(mf.form->window);
      fl_set_clipping(mf.PaperFrame->x,mf.PaperFrame->y,mf.PaperFrame->w,mf.PaperFrame->h);
      fl_drawmode(GXxor);
      lineStyle=fl_get_linestyle();
      fl_linestyle(FL_DASH);
      fl_rect(mf.PaperFrame->x+xx-psXOffset,mf.PaperFrame->y+yy-psYOffset,ww,hh,FL_INACTIVE_COL); /* FL_WHITE */
      fl_linestyle(lineStyle);
      fl_drawmode(GXcopy);
      fl_unset_clipping();
   } 
   /* InAktiv Frame/Picture */
   else if (mo==drawFP)
   {
      fl_winset(pd.pixmap);
      fl_drawmode(GXxor);
      lineStyle=fl_get_linestyle();
      fl_linestyle(FL_DOT);
      fl_rect(xx-psXOffset,yy-psYOffset,ww,hh,FL_INACTIVE_COL); /* FL_WHITE */
      fl_linestyle(lineStyle);
      fl_drawmode(GXcopy);  
   }
   /* Aktiv Frame/Picture */
   else if (mo==drawAFP)
   {
      fl_winset(pd.pixmap);
      fl_rect(xx-psXOffset,yy-psYOffset,ww,hh,FL_BLACK);
      fl_rect(xx-psXOffset+6,yy-psYOffset+6,ww-12,hh-12,FL_BLACK);
           
      /* TOP */
      fl_rect(xx-psXOffset,yy-psYOffset,6,6,FL_BLACK);
      fl_rectf(xx-psXOffset+1,yy-psYOffset+1,5,5,FL_WHITE);

      fl_rect(xx-psXOffset+((ww/2)-3),yy-psYOffset,6,6,FL_BLACK);
      fl_rectf(xx-psXOffset+((ww/2)-2),yy-psYOffset+1,5,5,FL_WHITE);      

      fl_rect(xx-psXOffset+ww-6,yy-psYOffset,6,6,FL_BLACK);
      fl_rectf(xx-psXOffset+ww-5,yy-psYOffset+1,5,5,FL_WHITE); 
      
      /* MIDLE */
      fl_rect(xx-psXOffset,yy-psYOffset+((hh/2)-3),6,6,FL_BLACK);
      fl_rectf(xx-psXOffset+1,yy-psYOffset+((hh/2)-2),5,5,FL_WHITE);      
      
      fl_rect(xx-psXOffset+ww-6,yy-psYOffset+((hh/2)-3),6,6,FL_BLACK);
      fl_rectf(xx-psXOffset+ww-5,yy-psYOffset+((hh/2)-2),5,5,FL_WHITE); 
      
      /* Bottom */
      fl_rect(xx-psXOffset,yy-psYOffset+(hh-6),6,6,FL_BLACK);
      fl_rectf(xx-psXOffset+1,yy-psYOffset+(hh-5),5,5,FL_WHITE);

      fl_rect(xx-psXOffset+((ww/2)-3),yy-psYOffset+(hh-6),6,6,FL_BLACK);
      fl_rectf(xx-psXOffset+((ww/2)-2),yy-psYOffset+(hh-5),5,5,FL_WHITE);      

      fl_rect(xx-psXOffset+ww-6,yy-psYOffset+(hh-6),6,6,FL_BLACK);
      fl_rectf(xx-psXOffset+ww-5,yy-psYOffset+(hh-5),5,5,FL_WHITE);       
            
      /*
      fl_rect((xx-psXOffset)+1,(yy-psYOffset)+1,ww-2,hh-2,FL_WHITE);
      fl_rect((xx-psXOffset)+2,(yy-psYOffset)+2,ww-4,hh-4,FL_WHITE);
      */
   }   
   fl_winset(mf.form->window);
   
   return;
}

/* Get X-Papersize */
int xwGetXSize(void)
{
   if (mf.form!=NULL)
   {
      return(mf.PaperFrame->w-1);
   }
   else
   {
      return(DisplayWidth(fl_display,DefaultScreen(fl_get_display()))-120);
   }       
}

/* Get Y-Papersize */
int xwGetYSize(void)
{
   if (mf.form!=NULL)
   {
      return(mf.PaperFrame->h-1);
   }
   else
   {
      return(DisplayHeight(fl_display,DefaultScreen(fl_get_display()))-120);  
   }
}

/* SetPixelSize */
void xwSetPixelSize(float x,float y)
{
   float          Aspect;
   int            ax,ay;
   
   if (xwIsPaperLS()==xwPortrait)
   {
      Aspect=(float) x/y;

      ax=(int) (((xwGetYSize()*psZoom)*Aspect)+0.5);
      ay=(int) ((xwGetYSize()*psZoom)+0.5);
      ps.psize=(float) ((float) ax/(float) x);

      if (ax>(int) ((xwGetXSize()*psZoom)+0.5))
      {
         ax=(int) ((xwGetXSize()*psZoom)+0.5);
         ay=(int) (((xwGetXSize()*psZoom)/Aspect)+0.5);
         ps.psize=(float) ((float) ay/(float) y);
      }
   }
   else
   {
      Aspect=(float) x/y;

      ax=(int) (((xwGetXSize()*psZoom)*Aspect)+0.5);
      ay=(int) ((xwGetXSize()*psZoom)+0.5);
      ps.psize=(float) ((float) ax/(float) x);

      if (ax>((xwGetYSize()*psZoom)+0.5))
      {
         ax=(int) ((xwGetYSize()*psZoom)+0.5);
         ay=(int) (((xwGetYSize()*psZoom)/Aspect)+0.5);
         ps.psize=(float) ((float) ay/(float) y);
      }
   }

   return;
}

/* Get Pixel Size */
float xwGetPixelSize(void)
{
   return(ps.psize);
}

/* Set Zoom Factor */
void xwSetZoom(float zoom)
{
   psZoom=zoom;
   
   return;
}

/* Get Zoom Factor */
float xwGetZoom(void)
{
   return(psZoom);
}

/* Set Zoom Value */
void xwSetZoomV(int az)
{
   if (az==1) psZoom=1.00;
   else if (az==2) psZoom=1.25;
   else if (az==3) psZoom=1.50;
   else if (az==4) psZoom=1.75;
   else if (az==5) psZoom=2.00;
   else if (az==6) psZoom=2.50;
   else if (az==7) psZoom=3.00;
   else if (az==8) psZoom=4.00;
   else if (az==9) psZoom=5.00;
   else if (az==10) psZoom=6.00;
   else if (az==11) psZoom=7.00;
   else if (az==12) psZoom=8.00;
   else if (az==13) psZoom=9.00;
   else if (az==14) psZoom=10.00;
   return;
}

/* Get Zoom Value */
int xwGetZoomV(void)
{
   if (psZoom==1.00) return(1);
   else if (psZoom==1.25) return(2);
   else if (psZoom==1.50) return(3);
   else if (psZoom==1.75) return(4);
   else if (psZoom==2.00) return(5);
   else if (psZoom==2.50) return(6);
   else if (psZoom==3.00) return(7);
   else if (psZoom==4.00) return(8);
   else if (psZoom==5.00) return(9);
   else if (psZoom==6.00) return(10);
   else if (psZoom==7.00) return(11);
   else if (psZoom==8.00) return(12);
   else if (psZoom==9.00) return(13);
   else if (psZoom==10.00) return(14);
   return(1);
}

/* Set GFX-Offset */
void xwSetXOffset(int az)
{
   psXOffset=az;
   
   return;
}
void xwSetYOffset(int az)
{
   psYOffset=az;
   
   return;
}

/* Set GFX-Offset */
void xwSetXXOffset(float az)
{
   psXXOffset=az;
   
   return;
}
void xwSetYYOffset(float az)
{
   psYYOffset=az;
   
   return;
}

/* Get GFX-Offset */
int xwGetXOffset(void)
{
   return(psXOffset);
}
int xwGetYOffset(void)
{
   return(psYOffset);
}   
/* Get GFX-Offset */
float xwGetXXOffset(void)
{
   return(psXXOffset);
}
float xwGetYYOffset(void)
{
   return(psYYOffset);
}   
