/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWLIMITS_H
#define _XWLIMITS_H

/* Debugging Output Messages */
#ifndef xwDebug
/*#define xwDebug "True"*/
#endif

/* Color from Inputfields - active/deactive background colors */
/* on debian and mandrake systems faills this feature */
#ifndef xwWhiteInput
/*#define xwWhiteInput "True"*/
#endif

#ifndef xwTrue
#define xwTrue        0
#endif
#ifndef xwFalse
#define xwFalse      -1
#endif

#ifndef rotateLeft
#define rotateLeft      0
#endif
#ifndef rotateRight
#define rotateRight     1
#endif

/* ### Frame Limits ### */

/* Min. Size of Frame - 10 mm */
#ifndef frameMinSize
#define frameMinSize    5
#endif
/* Max. Count of Frames */ 
#ifndef frameMaxFrames
#define frameMaxFrames  1000
#endif

/* ### Picture Limits ### */

/* Height of the Titleborder - 5 mm */
#ifndef picTitle
#define picTitle        5
#endif
/* Min. Size of Picture - 10 mm */
#ifndef picMinSize
#define picMinSize      5
#endif
/* Max. Count of Pictures */
#ifndef picMaxPictures
#define picMaxPictures  1000
#endif

/* ### Picture Lines */

#ifndef picMaxLines
#define picMaxLines     100000
#endif

#endif