/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "language.h"

#include "base.h"
#include "default.h"
#include "resource.h"
#include "handler.h"
#include "limits.h"
#include "main.h"
#include "main_gui.h"

#include "pixmaps/de.xpm"
#include "pixmaps/en.xpm"
#include "pixmaps/fr.xpm"
#include "pixmaps/it.xpm"

/* Display Error Message */
void xwSelectLanguage(void)
{
   FL_FORM           *laForm;
   FL_OBJECT         *laPixmap[20];
   FL_OBJECT         *laObj;

   int               laReady;

   /* Language Datas */
   int               langAnz=0;

   int               count;
   char              lang[1024],name[256],astr[1024];

   strcpy(lang,xwGR(1,"lang","en"));

   langAnz=atoi(xwGR(1,"langcount","0"));
   
   if (langAnz>0)
   {
      laForm = fl_bgn_form(FL_UP_BOX,300,(40*langAnz)+10);
      fl_set_border_width(1);

      for (count=1 ; count<=langAnz ; count++)
      {
         strcpy(astr,"langname");
         strcat(astr,IntStr(count));
         strcpy(name,xwGR(1,astr,"English"));
         
         strcpy(astr,"langcode");
         strcat(astr,IntStr(count));
         strcpy(lang,xwGR(1,astr,"en"));

         /* 51 x 36 */
         laPixmap[count] = fl_add_pixmapbutton(FL_NORMAL_BUTTON,5,5+(count*40)-40,55,40,name);
         
         fl_set_object_lalign(laPixmap[count],FL_ALIGN_RIGHT);
         fl_set_object_lsize(laPixmap[count],FL_MEDIUM_SIZE);
         fl_set_object_lstyle(laPixmap[count],FL_BOLD_STYLE);

         if (strcmp(lang,"de") == 0) fl_set_pixmap_data(laPixmap[count],de_xpm); 
         else if (strcmp(lang,"en") == 0) fl_set_pixmap_data(laPixmap[count],en_xpm); 
         else if (strcmp(lang,"fr") == 0) fl_set_pixmap_data(laPixmap[count],fr_xpm); 
         else if (strcmp(lang,"it") == 0) fl_set_pixmap_data(laPixmap[count],it_xpm); 
      }
   
      fl_end_form();

      if (xwGetPrefValue(xwgWinPos)==0)
      {
         fl_prepare_form_window(laForm,FL_PLACE_MOUSE,FL_TRANSIENT,"xwGUI Language Selection");
      }
      else
      {
         fl_prepare_form_window(laForm,FL_PLACE_CENTER,FL_TRANSIENT,"xwGUI Language Selection");
      }

      fl_set_form_dblbuffer(laForm,0);
      fl_show_form_window(laForm);

      fl_set_app_mainform(laForm);

      /* Exit Handler */
      fl_set_form_atclose(laForm,nclose_cb,(void *) "1");

      laReady=0;
      while (laReady==0)
      {
         laObj=fl_do_forms();

         for (count=1 ; count<=langAnz ; count++)
         {
            if (laObj==laPixmap[count])
            {
               laReady=count;
            }
         }     
      }

      /* Set Correct Language */
      strcpy(astr,"langcode");
      strcat(astr,IntStr(laReady));
      xwSetLang(xwGR(1,astr,"en"));      

      fl_hide_form(laForm);

      for (count=1 ; count<=langAnz ; count++)
      {
         fl_free_pixmapbutton_pixmap(laPixmap[count]);
      }

      fl_free_form(laForm);
   }
   
   return;
}
