/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "itimer.h"

int iTimerFlag = 0; /* tell if zhe timer is on */

typedef void  *(timeOutFunc_t)(void);

static struct itimerval    ti,oti;
static timeOutFunc_t       *func;
static long                timeout = 0;

typedef void (*signalHandler_t)(int);
static signalHandler_t oldSignal;

static void timeOutAlarm(int code)
{
   if ( func != (timeOutFunc_t*)NULL )
   {
      func();
   }
   setTimer(timeout, NULL);
}

void resetTimer()
{
   memset((void*)&ti,0,sizeof(ti));
   memset((void*)&oti,0,sizeof(oti));
   setitimer(ITIMER_REAL ,&ti, &oti);

   func = (timeOutFunc_t*)NULL;
   if ( oldSignal != (signalHandler_t) NULL )
   {
      signal(SIGALRM, oldSignal);
      oldSignal = (signalHandler_t)0;
   }
   iTimerFlag = 0;

}

void setTimer(long time,timeOutFunc_t *function)
{
   if ( function != (timeOutFunc_t*)NULL )
   {
      func = function;
      oldSignal = signal(SIGALRM, timeOutAlarm);
   }
   timeout = time;
   iTimerFlag = 1;
   
   /* on Linux we dont need to set signal again */
#ifdef linux
   if ( function != (timeOutFunc_t*)NULL )
   {
      signal(SIGALRM, timeOutAlarm);
   }
#else
   signal(SIGALRM, timeOutAlarm);
#endif 
   memset((void*)&ti,0,sizeof(ti));
   memset((void*)&oti,0,sizeof(oti));

   ti.it_value.tv_sec  = time/1000;
   ti.it_value.tv_usec = (time%1000)*1000;
   setitimer( ITIMER_REAL ,&ti, &oti);
}
