/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "io.h"

#include "base.h"
#include "default.h"
#include "font.h"
#include "frame.h"
#include "help.h"
#include "main.h"
#include "paper.h"
#include "picture.h"
#include "pref_printer.h"
#include "resource.h"

/* write xwGUI Pref File */
void xwSaveRC(void)
{
   FILE           *fh;

/*
   char           astr[4];
   int            az,bz,cz;

   fh=fopen(xwGetFile("","ASC-II-Tabelle"),"w");
   if (fh!=NULL)
   {
      cz=0;

      strcpy(astr," ");

      for (az=0 ; az<=15 ; az++)
      {
         for (bz=0 ; bz<=15 ; bz++)
         {
            astr[0]=cz;
            fputs(astr,fh);

            cz++;
         }
         fputs("\n",fh);
      }

      fclose(fh);
   }
*/

   fh=fopen(xwGetFile("","xwgui.rc"),"w");
   if (fh!= NULL)
   {
      fputs("# xwGUI Pref File\n",fh);
      fputs("# written by xwGUI\n",fh);
      fputs("# (c) by Stefan Kraus\n",fh);
      fputs("# License: GPL\n\n",fh);

      fputs("PREF\n",fh);
      fputs(" # xwGUI Version Info\n",fh);
      fputs(" VERSION ",fh);
      fputs(IntStr(xwInfoC),fh);
      fputs("\n\n",fh);

      fputs(" # Window Size\n",fh);
      fputs(" SIZE ",fh);
      fputs(IntStr(xwGetPrefValue(xwgWidth)),fh);
      fputs(" ",fh);
      fputs(IntStr(xwGetPrefValue(xwgHeight)),fh);
      fputs("\n\n",fh);

      fputs(" # Layer Position\n",fh);
      fputs(" LAYER ",fh);
      fputs(IntStr(xwGetPrefValue(xwgLayerXPos)),fh);
      fputs(" ",fh);
      fputs(IntStr(xwGetPrefValue(xwgLayerYPos)),fh);
      fputs(" ",fh);
      fputs(IntStr(xwGetPrefValue(xwgLayer)),fh);
      fputs("\n\n",fh);

      /* ##### Paper Setting ##### */

      /* Paper Section */
      fputs(" # Paper Settings\n",fh);
      fputs(" PAPER\n",fh);

      /* 1/10 mm Resolution */
      if (xwMM()==10)
      {
         fputs("  # 1/10mm Resolution\n  1/10mm\n\n",fh);
      }

      /* Landscape */
      if (xwIsPaperLS()==xwLandscape)
      {
         fputs("  # Landscape Paper Orientation\n  LANDSCAPE\n\n",fh);
      }

      /* Border Datas */
      fputs("  # Border Datas\n",fh);
      fputs("  BORDER ",fh);
      fputs(IntStr(xwGetPaperLB()),fh);
      fputs(" ",fh);
      fputs(IntStr(xwGetPaperRB()),fh);
      fputs(" ",fh);
      fputs(IntStr(xwGetPaperTB()),fh);
      fputs(" ",fh);
      fputs(IntStr(xwGetPaperBB()),fh);
      fputs("\n\n",fh);

      /* PaperSize ( ID ) */
      fputs("  # Paper Size ( ID )\n",fh);
      fputs("  PAPERID ",fh);
      fputs(IntStr(xwGetID()),fh);
      fputs("\n\n",fh);

      fputs(" END\n\n",fh);


      /* ##### xwGUI Setting ##### */

      /* xwGUI Section */
      fputs(" # xwGUI Settings\n",fh);
      fputs(" XWGUI\n",fh);

      /* Assistent */
      if (xwGetPrefValue(xwgAssistent)!=0)
      {
         fputs("  # disable Assistent on startup\n",fh);
         fputs("  NOASSISTENT\n\n",fh);
      }

      /* FrameSet */
      if (strlen(xwGetPrefName(xwgFrameSet))>0)
      {
         fputs("  # load frameset on startup\n",fh);
         fputs("  FRAMESET \"",fh);
         fputs(xwGetPrefName(xwgFrameSet),fh);
         fputs("\"\n\n",fh);
      }

      /* Picture Browser Path */
      if (strlen(xwGetPrefName(xwgBrowserPath))>0)
      {
         fputs("  # picture browser path\n",fh);
         fputs("  PICBROWSER \"",fh);
         fputs(xwGetPrefName(xwgBrowserPath),fh);
         fputs("\"\n\n",fh);
      }

      /* GUI Design */
      if (xwGetPrefValue(xwgGUI)!=0)
      {
         fputs("  # GUI Design\n",fh);
         fputs("  ICONLAYOUT\n\n",fh);
      }

      fputs("  # Language\n",fh);
      fputs("  LANGUAGE ",fh);
      fputs(xwGetLang(),fh);
      fputs("\n\n",fh);

      if (xwGetPrefValue(xwgWinPos)!=0)
      {
         fputs("  # Window Position\n",fh);
         fputs("  CENTER\n\n",fh);
      }

      if (xwGetPrefValue(xwgOneLiner)!=0)
      {
         fputs("  # Geometry Information\n",fh);
         fputs("  GEOINFO\n\n",fh);
      }

      if (xwGetPrefValue(xwgWYSIWYG)==1)
      {
         fputs("  # Pseudo WYSIWYG Mode\n",fh);
         fputs("  PSEUDOWYSIWYG\n\n",fh);
      }
      else if (xwGetPrefValue(xwgWYSIWYG)==2)
      {
         fputs("  # WYSIWYG Mode\n",fh);
         fputs("  WYSIWYG\n\n",fh);
      }

      fputs("  # Image Quality\n",fh);
      fputs("  IMAGEQUALITY ",fh);
      fputs(IntStr(xwGetPrefValue(xwgImgQuality)),fh);
      fputs("\n\n",fh);

      if (xwGetPrefValue(xwgScalling)!=0)
      {
         fputs("  # Scalling Quality\n",fh);
         fputs("  INTERPOLATION\n",fh);
      }

      fputs("  # Picture Viewer\n",fh);
      fputs("  VIEWER ",fh);
      fputs(xwGetPrefName(xwgPicViewer),fh);
      fputs("\n\n",fh);

      /* Help Browser */
      fputs("  # Help Browser\n",fh);
      fputs("  HELPBROWSER \"",fh);
      fputs(xwGetHelpBrowser(),fh);
      fputs("\"\n\n",fh);

      /* ##### Font Settings #### */
      fputs("  # Font Settings\n",fh);
      fputs("  FONTAFM \"",fh);
      fputs(xwGetPrefName(xwgAFM),fh);
      fputs("\"\n",fh);
      fputs("  FONTTYPE1 \"",fh);
      fputs(xwGetPrefName(xwgType1),fh);
      fputs("\"\n",fh);
      fputs("  FONTENCDIR \"",fh);
      fputs(xwGetPrefName(xwgEnc),fh);
      fputs("\"\n",fh);
      fputs("  FONTENCFILE \"",fh);
      fputs(xwGetPrefName(xwgEncFile),fh);
      fputs("\"\n",fh);
      
      

      fputs(" END\n\n",fh);


      /* ##### Printer Setting ##### */

      /* Printer Section */
      fputs(" # Printer Settings\n",fh);
      fputs(" PRINTER\n",fh);

      /* Driver File */
      fputs("  # Driver File\n",fh);
      fputs("  DRIVERFILE \"",fh);
      fputs(xwGetPrefDriver(),fh);
      fputs("\"\n\n",fh);

      /* Selected Printer */
      fputs("  # Selected Printer\n",fh);
      fputs("  PRINTER \"",fh);
      fputs(xwGetPrefPrinter(),fh);
      fputs("\"\n\n",fh);

      /* Setting File */
      fputs("  # Setting File\n",fh);
      fputs("  SETTINGFILE \"",fh);
      fputs(xwGetPrefSetting(),fh);
      fputs("\"\n\n",fh);

      fputs(" END\n\n",fh);


      fputs("END\n",fh);

      fclose(fh);
   }

   return;
}

/* write xwGUI FrameSets File */
void xwSaveFrameSet(char *dest)
{
   FILE           *fh;
   int            loop;
   int            az;

   char           astr[1024];

   /* Check Save Mode */
   if ( (xwGetPictureCount()==-1) && (xwGetFrameCount()>-1) )
   {
      /* Save FrameSet */

      fh=fopen(dest,"w");
      if (fh!= NULL)
      {
         fputs("# xwGUI FrameSet File\n",fh);
         fputs("# written by xwGUI\n",fh);
         fputs("# (c) by Stefan Kraus\n",fh);
         fputs("# License: GPL\n\n",fh);

         fputs("FRAMESET\n",fh);

         /* ##### Paper Setting ##### */

         /* Paper Section */
         fputs(" # Paper Settings\n",fh);
         fputs(" PAPER\n",fh);

         /* 1/10 mm Resolution */
         if (xwMM()==10)
         {
            fputs("  # 1/10mm Resolution \n  1/10mm\n\n",fh);
         }

         /* Landscape */
         if (xwIsPaperLS()==xwLandscape)
         {
            fputs("  # Landscape Paper Orientation\n  LANDSCAPE\n\n",fh);
         }

         /* Border Datas */
         fputs("  # Border Datas\n",fh);
         fputs("  BORDER ",fh);
         fputs(IntStr(xwGetPaperLB()),fh);
         fputs(" ",fh);
         fputs(IntStr(xwGetPaperRB()),fh);
         fputs(" ",fh);
         fputs(IntStr(xwGetPaperTB()),fh);
         fputs(" ",fh);
         fputs(IntStr(xwGetPaperBB()),fh);
         fputs("\n\n",fh);

         /* PaperSize ( ID ) */
         fputs("  # Paper Size ( ID )\n",fh);
         fputs("  PAPERID ",fh);
         fputs(IntStr(xwGetID()),fh);
         fputs("\n\n",fh);

         fputs(" END\n\n",fh);

         for (loop=0 ; loop<=xwGetFrameCount() ; loop++)
         {
            fputs(" # Frame definition\n",fh);
            fputs(" FRAME\n",fh);

            /* Frame Geometry */
            fputs("  # Frame Geometry\n",fh);
            fputs("  GEO ",fh);
            fputs(IntStr(xwGetFrameX(loop)),fh);
            fputs(" ",fh);
            fputs(IntStr(xwGetFrameY(loop)),fh);
            fputs(" ",fh);
            fputs(IntStr(xwGetFrameW(loop)),fh);
            fputs(" ",fh);
            fputs(IntStr(xwGetFrameH(loop)),fh);
            fputs("\n\n",fh);

            /* Bordersize */
            fputs("  # Bordersize\n",fh);
            fputs("  BORDER ",fh);
            fputs(DoubleStr((float) xwGetFrameB(loop),1),fh);
            fputs("\n",fh);

            /* Transparency */
            if (xwGetFrameBC(loop)==1)
            {
               fputs("  # Transparency\n",fh);
               fputs("  TRANSPARENCY\n",fh);
            }

            /* Framesize */
            fputs("  # Framesize\n",fh);
            fputs("  FRAME ",fh);
            fputs(DoubleStr((float) xwGetFrameF(loop),1),fh);
            fputs("\n",fh);

            /* Color */
            fputs("  # Frame Color\n",fh);
            fputs("  COLOR ",fh);
            fputs(IntStr(xwGetFrameC(loop)),fh);
            fputs("\n",fh);

            /* BorderType */
            fputs("  # BorderType\n",fh);
            fputs("  BORDERTYPE ",fh);
            fputs(IntStr(xwGetFrameBT(loop)),fh);
            fputs("\n",fh);
            
            /* Position */
            fputs("  # Picture Position in Frame\n",fh);
            strcpy(astr,"  POSITION ");
            strcat(astr,IntStr(xwGetPicPosition(loop)));
            strcat(astr,"\n\n");
            fputs(astr,fh);

            /* Fontname */
            fputs("  # Fontname\n",fh);
            strcpy(astr,"  FONTNAME \"");
            strcat(astr,xwGetFontName(loop));
            strcat(astr,"\"\n");
            fputs(astr,fh);

            /* FontSize */
            fputs("  # Fontsize\n",fh);
            strcpy(astr,"  FONTSIZE ");
            strcat(astr,IntStr(xwGetFontSize(loop)));
            strcat(astr,"\n");
            fputs(astr,fh);

            /* FontLine */
            fputs("  # FontLine ( Underline )\n",fh);
            strcpy(astr,"  FONTLINE ");
            strcat(astr,IntStr(xwGetFontLine(loop)));
            strcat(astr,"\n");
            fputs(astr,fh);

            /* Font Direction */
            fputs("  # Font Direction\n",fh);
            strcpy(astr,"  FONTDIRECTION ");
            strcat(astr,IntStr(xwGetFontDirection(loop)));
            strcat(astr,"\n");
            fputs(astr,fh);

            /* Font Mode */
            fputs("  # Font Mode\n",fh);
            strcpy(astr,"  FONTMODE ");
            strcat(astr,IntStr(xwGetFontMode(loop)));
            strcat(astr,"\n");
            fputs(astr,fh);

            /* Font Color */
            fputs("  # Font Color\n",fh);
            strcpy(astr,"  FONTCOLOR ");
            strcat(astr,IntStr(xwGetFontColor(loop)));
            strcat(astr,"\n");
            fputs(astr,fh);

            /* Font Text */
            if (xwGetFontText(loop)!=NULL)
            {
               fputs("  # Font Text\n",fh);
               strcpy(astr,"  FONTTEXT ");
               strcat(astr,IntStr(strlen(xwGetFontText(loop))));
               strcat(astr,"\n");
               fputs(astr,fh);

               fwrite(xwGetFontText(loop),1,strlen(xwGetFontText(loop)),fh);
               /*fputs(xwGetFontText(loop),fh);*/
               fputs("\n\n",fh);
            }

            fputs(" END\n",fh);
         }

         fputs("END\n",fh);

         fclose(fh);
      }
   }
   else
   {
      /* Save Page */

      fh=fopen(dest,"w");
      if (fh!= NULL)
      {
         fputs("# xwGUI Page File\n",fh);
         fputs("# written by xwGUI\n",fh);
         fputs("# (c) by Stefan Kraus\n",fh);
         fputs("# License: GPL\n\n",fh);

         fputs("PAGE\n",fh);

         /* ##### Paper Setting ##### */

         /* Paper Section */
         fputs(" # Paper Settings\n",fh);
         fputs(" PAPER\n",fh);

         /* 1/10 mm Resolution */
         if (xwMM()==10)
         {
            fputs("  # 1/10mm Resolution \n  1/10mm\n\n",fh);
         }

         /* Landscape */
         if (xwIsPaperLS()==xwLandscape)
         {
            fputs("  # Landscape Paper Orientation\n  LANDSCAPE\n\n",fh);
         }

         /* Border Datas */
         fputs("  # Border Datas\n",fh);
         fputs("  BORDER ",fh);
         fputs(IntStr(xwGetPaperLB()),fh);
         fputs(" ",fh);
         fputs(IntStr(xwGetPaperRB()),fh);
         fputs(" ",fh);
         fputs(IntStr(xwGetPaperTB()),fh);
         fputs(" ",fh);
         fputs(IntStr(xwGetPaperBB()),fh);
         fputs("\n\n",fh);

         /* PaperSize ( ID ) */
         fputs("  # Paper Size ( ID )\n",fh);
         fputs("  PAPERID ",fh);
         fputs(IntStr(xwGetID()),fh);
         fputs("\n\n",fh);

         fputs(" END\n\n",fh);

         /* ##### Frames/Picture Settings ##### */

         /* frame mode ? */
         if (xwGetFrameCount()>-1)
         {
            for (loop=0 ; loop<=xwGetFrameCount() ; loop++)
            {
               fputs(" # Frame definition\n",fh);
               fputs(" FRAME\n",fh);

               /* Frame Geometry */
               fputs("  # Frame Geometry\n",fh);
               strcpy(astr,"  GEO ");
               strcat(astr,IntStr(xwGetFrameX(loop)));
               strcat(astr," ");
               strcat(astr,IntStr(xwGetFrameY(loop)));
               strcat(astr," ");
               strcat(astr,IntStr(xwGetFrameW(loop)));
               strcat(astr," ");
               strcat(astr,IntStr(xwGetFrameH(loop)));
               strcat(astr,"\n\n");
               fputs(astr,fh);

               /* Bordersize */
               fputs("  # Bordersize\n",fh);
               strcpy(astr,"  BORDER ");
               strcat(astr,DoubleStr((float) xwGetFrameB(loop),1));
               strcat(astr,"\n\n");
               fputs(astr,fh);

               /* Transparency */
               if (xwGetFrameBC(loop)==1)
               {
                  fputs("  # Transparency\n",fh);
                  fputs("  TRANSPARENCY\n",fh);
               }
               
               /* Framesize */
               fputs("  # Framesize\n",fh);
               strcpy(astr,"  FRAME ");
               strcat(astr,DoubleStr((float) xwGetFrameF(loop),1));
               strcat(astr,"\n\n");
               fputs(astr,fh);

               /* Color */
               fputs("  # Frame Color\n",fh);
               strcpy(astr,"  COLOR ");
               strcat(astr,IntStr(xwGetFrameC(loop)));
               strcat(astr,"\n\n");
               fputs(astr,fh);

               /* BorderType */
               fputs("  # BorderType\n",fh);
               fputs("  BORDERTYPE ",fh);
               fputs(IntStr(xwGetFrameBT(loop)),fh);
               fputs("\n",fh);

               /* Position */
               fputs("  # Picture Position in Frame\n",fh);
               strcpy(astr,"  POSITION ");
               strcat(astr,IntStr(xwGetPicPosition(loop)));
               strcat(astr,"\n\n");
               fputs(astr,fh);

               /* Fontname */
               fputs("  # Fontname\n",fh);
               strcpy(astr,"  FONTNAME \"");
               strcat(astr,xwGetFontName(loop));
               strcat(astr,"\"\n");
               fputs(astr,fh);

               /* FontSize */
               fputs("  # Fontsize\n",fh);
               strcpy(astr,"  FONTSIZE ");
               strcat(astr,IntStr(xwGetFontSize(loop)));
               strcat(astr,"\n");
               fputs(astr,fh);

               /* FontLine */
               fputs("  # FontLine ( Underline )\n",fh);
               strcpy(astr,"  FONTLINE ");
               strcat(astr,IntStr(xwGetFontLine(loop)));
               strcat(astr,"\n");
               fputs(astr,fh);

               /* Font Direction */
               fputs("  # Font Direction\n",fh);
               strcpy(astr,"  FONTDIRECTION ");
               strcat(astr,IntStr(xwGetFontDirection(loop)));
               strcat(astr,"\n");
               fputs(astr,fh);

               /* Font Mode */
               fputs("  # Font Mode\n",fh);
               strcpy(astr,"  FONTMODE ");
               strcat(astr,IntStr(xwGetFontMode(loop)));
               strcat(astr,"\n");
               fputs(astr,fh);

               /* Font Color */
               fputs("  # Font Color\n",fh);
               strcpy(astr,"  FONTCOLOR ");
               strcat(astr,IntStr(xwGetFontColor(loop)));
               strcat(astr,"\n");
               fputs(astr,fh);

               /* Font Text */
               if (xwGetFontText(loop)!=NULL)
               {
                  fputs("  # Font Text\n",fh);
                  strcpy(astr,"  FONTTEXT ");
                  strcat(astr,IntStr(strlen(xwGetFontText(loop))));
                  strcat(astr,"\n");
                  fputs(astr,fh);

                  fwrite(xwGetFontText(loop),1,strlen(xwGetFontText(loop)),fh);
                  /*fputs(xwGetFontText(loop),fh);*/
                  fputs("\n\n",fh);
               }

               /* Picture */
               if (xwGetFramePicture(loop)>-1)
               {
                  az=xwGetFramePicture(loop);
                  fputs("  # Picture Datas\n",fh);
                  fputs("  PICTURE\n",fh);

                  /* Picture File */
                  fputs("   # Picture File\n",fh);
                  strcpy(astr,"   FILE \"");
                  strcat(astr,xwGetPictureFile(az));
                  strcat(astr,"\"\n\n");
                  fputs(astr,fh);

                  /* Picture Geometry */
                  fputs("   # Picture Geometry\n",fh);
                  strcpy(astr,"   GEO ");
                  strcat(astr,IntStr(xwGetPictureX(az)));
                  strcat(astr," ");
                  strcat(astr,IntStr(xwGetPictureY(az)));
                  strcat(astr," ");
                  strcat(astr,IntStr(xwGetPictureW(az)));
                  strcat(astr," ");
                  strcat(astr,IntStr(xwGetPictureH(az)));
                  strcat(astr,"\n\n");
                  fputs(astr,fh);

                  /* Picture Rotation */
                  fputs("   # Picture Rotation\n",fh);
                  strcpy(astr,"   ROTATION ");
                  strcat(astr,IntStr(xwGetPictureR(az)));
                  strcat(astr,"\n\n");
                  fputs(astr,fh);

                  /* Transparency Mode */
                  if (xwGetFramePTM(loop)==1)
                  {
                     fputs("   # Picture Transparency Mode\n",fh);
                     fputs("   NEGATIVETRANS\n\n",fh);
                  }

                  /* Picture Datas */
                  fputs("   # Picture Borders, Color and Transparency\n",fh);
                  strcpy(astr,"   BORDERS ");
                  strcat(astr,DoubleStr(xwGetFramePB(loop),1));
                  strcat(astr," ");
                  strcat(astr,DoubleStr(xwGetFramePF(loop),1));
                  strcat(astr," ");
                  strcat(astr,IntStr(xwGetFramePC(loop)));
                  strcat(astr," ");
                  strcat(astr,IntStr(xwGetFramePT(loop)));
                  strcat(astr,"\n\n");
                  fputs(astr,fh);

                  /* Transparency */
                  if (xwGetFramePBC(loop)==1)
                  {
                     fputs("  # Transparency\n",fh);
                     fputs("  TRANSPARENCY\n",fh);
                  }

                  fputs("  END\n\n",fh);
               }

               fputs(" END\n\n",fh);
            }
         }
         else
         {
            if (xwGetPictureCount()>-1)
            {
               for (loop=0 ; loop<=xwGetPictureCount() ; loop++)
               {
                  az=loop;
                  fputs(" # Picture Datas\n",fh);
                  fputs(" PICTURE\n",fh);

                  /* Picture File */
                  fputs("  # Picture File\n",fh);
                  strcpy(astr,"  FILE \"");
                  strcat(astr,xwGetPictureFile(az));
                  strcat(astr,"\"\n\n");
                  fputs(astr,fh);

                  /* Picture Geometry */
                  fputs("  # Picture Geometry\n",fh);
                  strcpy(astr,"  GEO ");
                  strcat(astr,IntStr(xwGetPictureX(az)));
                  strcat(astr," ");
                  strcat(astr,IntStr(xwGetPictureY(az)));
                  strcat(astr," ");
                  strcat(astr,IntStr(xwGetPictureW(az)));
                  strcat(astr," ");
                  strcat(astr,IntStr(xwGetPictureH(az)));
                  strcat(astr,"\n\n");
                  fputs(astr,fh);

                  /* Picture Rotation */
                  fputs("  # Picture Rotation\n",fh);
                  strcpy(astr,"  ROTATION ");
                  strcat(astr,IntStr(xwGetPictureR(az)));
                  strcat(astr,"\n\n");
                  fputs(astr,fh);

                  /* Transparency Mode */
                  if (xwGetPictureTM(loop)==1)
                  {
                     fputs("   # Picture Transparency Mode\n",fh);
                     fputs("   NEGATIVETRANS\n\n",fh);
                  }

                  /* Picture Datas */
                  fputs("  # Picture Borders, Color and Transparency\n",fh);
                  strcpy(astr,"  BORDERS ");
                  strcat(astr,DoubleStr(xwGetPictureB(az),1));
                  strcat(astr," ");
                  strcat(astr,DoubleStr(xwGetPictureF(az),1));
                  strcat(astr," ");
                  strcat(astr,IntStr(xwGetPictureC(az)));
                  strcat(astr," ");
                  strcat(astr,IntStr(xwGetPictureT(az)));
                  strcat(astr,"\n\n");
                  fputs(astr,fh);

                  /* Transparency */
                  if (xwGetPictureBC(loop)==1)
                  {
                     fputs("  # Transparency\n",fh);
                     fputs("  TRANSPARENCY\n",fh);
                  }

                  fputs(" END\n\n",fh);
               }
            }
         }

         fputs("END\n",fh);

         fclose(fh);
      }

   }

   return;
}

/* #################################################################################################
   ##                                                                                 ##
   ## Data File Managment                                                             ##
   ##                                                                                 ##
   ################################################################################################# */
   

