/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWINTERPRETER_H
#define _XWINTERPRETER_H

#include <forms.h>

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>

typedef struct ipCommand
{
   int               oldLevel;
   int               newLevel;
   int               token;
   const char        command[40];
   const char        parm[40];

} ipCommand;

typedef struct ipDataInfo
{
   int               Level;               /* actual Level */
   char              String[10][1024];    /* Text Parameters */   
   int               iValue[10];          /* Integer Values */
   float             fValue[10];          /* Float Values */
} ipDataInfo;

/* Token Table */
void xwTable(int iCNr);
/* Init Interpreter - creates an Offset table for SpeedUp */
void xwInitInterpreter(void);
int xwInitSort(const void *ipA,const void *ipB);

/* Interpreter */
int xwInterpret(const char *file,FL_FORM *errForm);
/* Measure Correction */
int xwMC(int source);

#endif