/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "help.h"

#include "base.h"
#include "resource.h"

static char       HelpBrowser[1024]="netscape";

char              helpTZ[]=" ";
char              helpTZZ[]="[]";

/* Display Help */
void xwDisplayHelp(char *file)
{
   char           buffer[1024];
   char           command[1024];
   char           helpFile[1024];
   char           HBrowser[1024];
   int            flag;

   const char     *strptr;

   /* help text file */
   strcpy(helpFile,"help.");
   strcat(helpFile,file);
   strcpy(buffer,xwGR(1,helpFile,""));
   strcpy(helpFile,xwGetIP(NULL));
   strcat(helpFile,"/");
   strcat(helpFile,buffer);

   /* correct netscape command */
   if (strcmp(HelpBrowser,"netscape") == 0)
   {
      strcpy(HBrowser,"if netscape -remote \"openURL(file://[HTML])\"; then :;else netscape file://[HTML] ;fi");
   }
   else
   {
      strcpy(HBrowser,HelpBrowser);
   }

   /* include helptext */
   flag=0;
   strcpy(command,"");
   strptr=strtok(HBrowser,helpTZZ);
   while (strptr != NULL)
   {
      strcpy(buffer,strptr);

      if (strcmp(buffer,"HTML") == 0)
      {
          strcpy(buffer,helpFile);
         flag=1;
      }

      if (strlen(buffer)>0)
      {
         strcat(command,buffer);
      }

      strptr = strtok(NULL,helpTZZ);
   }
   if (flag==0)
   {
      strcat(command," ");
      strcat(command,helpFile);
   }

   /*printf("%s\n",command);*/

   fl_exe_command(command,0);

   return;
}

/* Set Help Browser */
void xwSetHelpBrowser(char *browser)
{
   strcpy(HelpBrowser,browser);
   return;
}

/* Get Help Browser */
char *xwGetHelpBrowser(void)
{
   return(HelpBrowser);
}