/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWHANDLER_H
#define _XWHANDLER_H

#include <forms.h>
#include <time.h>
#include <signal.h>

#ifndef rotateLeft
#define rotateLeft      0
#endif
#ifndef rotateRight
#define rotateRight     1
#endif

#define hdMove          0

/* convert 1/10mm -> mm */
#define mm              10

/* Lock Handler */
void xwLockHandler(void);
/* UnLock Handler */
void xwUnLockHandler(void);
/* Handle Mouse & Resize Events */
int xwHandler(FL_OBJECT *obj, int event, FL_Coord mx, FL_Coord my, int key,void *xev);
/* Picture Mode */
void xwPicMode(int ax,int ay);
/* Frame Edit Mode */
void xwFrmEditMode(int ax,int ay);

/* Set Correct Datas */
void xwSetHandlerGeo(void);
/* Set Cursor */
void xwSetCursor(int a);

/* ############################################################################# */

/* Refreshing Main-GUI */
int refreshGUI(XEvent *ev,void *data);


/* Exit Handler */
int close_cb(FL_FORM *frm,void *data);
int nclose_cb(FL_FORM *frm,void *data);
/* Signal Handler */
void sig_handler(int signr);



#endif