/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "handler.h"

#include "base.h"
#include "default.h"
#include "exit.h"
#include "font.h"
#include "frame.h"
#include "io.h"
#include "lowlevel.h"
#include "main_gui.h"
#include "oneliner.h"
#include "page.h"
#include "paper.h"
#include "pbcache.h"
#include "picture.h"
#include "resource.h"
#include "selectfp.h"
#include "variable.h"
#include "wysiwyg.h"

#include <stdio.h>

extern struct mainform     mf;


static int        xwHandlerLock=0;

static int        wX=0,wY=0;                       /* Window Size for Resizing Check */

static int        xwBorder;                        /* BorderSize */

static int        xwActual;                        /* Actual Frame/Picture */
static int        xwCount;                         /* Count Frame/Picture */

/* Mouse Datas */
static int        xwHX,xwHY,xwHW,xwHH,xwHXO,xwHYO; /* Picture/Frame Datas */
static int        xwRH,xwRW;                       /* Real Picture Size */
static float      xwRA;                            /* Real Picture Aspect */

static int        xwMouseMode=0;                   /* Mouse Switch
                                                       0 - First Mouseklick
                                                       1 - Mousemove
                                                       2 - Mouse Release  */
static int        xwFPModi=-1;                     /* Frame/Picture Mode
                                                      -1 - None
                                                       0 - Picture Mode
                                                       1 - Frame/Picture Mode
                                                       2 - Frame Edit Mode */
static int        xwFPMode=0;                      /* Frame/Picture Mode */

static int        xwSelect;                        /* Selected Frame/Picture */

static int        xwHM=0;                          /* Handler Mouse Mode - Only One Click */

static int        mmx,mmy;
static int        eevent;
static int        kkey;

/* Lock Handler */
void xwLockHandler(void)
{
   while (xwHandlerLock!=0)
   {
      usleep(1000);
   }
   
   xwHandlerLock=1;

   return;
}

/* UnLock Handler */
void xwUnLockHandler(void)
{
   xwHandlerLock=0;
   
   return;
}

int xwHandler(FL_OBJECT *obj, int event, FL_Coord mx, FL_Coord my, int key,void *xev)
{
   int            ax,ay;      /* Mouseposition on Paper */
   int            az;  
   
   if (xwHandlerLock==0)
   {
      mmx=mx;
      mmy=my;
      eevent=event;
      kkey=key;

      /* Lock Handler */
      xwHandlerLock=1;

      /* print events */
      
      /*printf("Event Nr.: %i\n",eevent);*/
      /*printf("%i %i\n",xwGetXOffset(),xwGetYOffset());*/
      
    
      /* Redraw Page */
      if (eevent==FL_DRAW)
      {
         if ( (mf.form->w!=wX) || (mf.form->h!=wY) )
         {
            /* Move Frame/Picture */
            if ((xwFPMode==1) && (xwGetPrefValue(xwgWYSIWYG)==wmLWYSIWYG))
            { 
               xwDrawPage(pgRedraw);
            }
            else
            {
               xwDrawPage(pgRecalc);
            }
            wX=mf.form->w;
            wY=mf.form->h;
         }
         else
         {
            xwDrawPage(pgRedraw);
         }
         fl_add_timeout(200,refreshGUI,0);
      }
      
      /* Release Event */
      else if (eevent==FL_RELEASE)
      {
         if ((kkey<2) && (xwMouseMode==1))
         {
            xwOLReset();
            /*fl_hide_oneliner();*/
            /* Move Frame/Picture */
            if ((xwFPMode==1) && (xwGetPrefValue(xwgWYSIWYG)==wmLWYSIWYG))
            { 
               xwDrawPage(pgRedraw);
            }
            else
            {
               xwDrawPage(pgRecalc);
            }
            xwMouseMode=0;
            xwFPMode=0;
            xwHM=0;
            xwMouseMode=0;
            /*xwDrawPage(pgRecalc);*/
         }
         else
         {
            xwDrawPage(pgRedraw);
         }         
      }
      
      /* Enter */
      else if (eevent==FL_LEAVE) 
      { 
         fl_set_cursor(mf.form->window,FL_DEFAULT_CURSOR);
         xwDrawPage(pgRedraw);
      }
      
      /* DBLClick */
      /*
      else if (eevent==FL_DBLCLICK)
      {
         eevent=FL_MOUSE;
         kkey=3;
      }
      */
      
      /* Mouse Actions */
      else if ( (eevent==FL_MOUSE) || (eevent==FL_MOTION) )
      {
         if ((mx>=mf.PaperFrame->x) && (mx<=mf.PaperFrame->x+mf.PaperFrame->w) && (my>=mf.PaperFrame->y) && (my<=mf.PaperFrame->y+mf.PaperFrame->h))
         {

            /* Check Mouse-Position */
            if (xwIsPaperLS()==xwPortrait)
            {
               ax=(int) ((((float) mx-(float) mf.PaperFrame->x)/xwGetPixelSize())+(xwGetXOffset()/xwGetPixelSize()));
               ay=(int) ((((float) my-(float) mf.PaperFrame->y)/xwGetPixelSize())+(xwGetYOffset()/xwGetPixelSize()));
            }
            else
            {
               ay=(int) ((float) xwGetPaperYSize()) - ((((float) mx-(float) mf.PaperFrame->x)/xwGetPixelSize())+(xwGetXOffset()/xwGetPixelSize()));
               ax=(int) ((((float) my-(float) mf.PaperFrame->y)/xwGetPixelSize())+(xwGetYOffset()/xwGetPixelSize()));
            }


            /* Border Size */
            xwBorder=((int) (6/xwGetPixelSize()));
            if (xwBorder<1) xwBorder=1;

            /* ### Picture Mode ### */
            if ( (xwCheckFrameMode()!=0) && (xwCheckEditFrame()!=0) && (xwMouseMode==0) )
            {
               xwActual=xwGetActivePicture();
               xwCount=xwGetPictureCount();

               /* exist an Picture */
               if ( (xwActual>-1) && (xwCount>-1) )
               {
                  xwFPModi=0; /* Picture Mode */

                  /* Picture Rotated */
                  if ( (xwGetPictureR(xwActual)==90) || (xwGetPictureR(xwActual)==-90) )
                  {
                     xwHX=xwGetPictureX(xwActual);
                     xwHY=xwGetPictureY(xwActual);
                     xwHW=xwGetPictureH(xwActual);
                     xwHH=xwGetPictureW(xwActual);
                     xwRW=xwGetPictureRH(xwActual); /* For Aspect Calculation */
                     xwRH=xwGetPictureRW(xwActual);
                     xwRA=(float) xwRW/(float) xwRH;
                  }
                  else
                  {
                     /* Normal Picture */
                     xwHX=xwGetPictureX(xwActual);
                     xwHY=xwGetPictureY(xwActual);
                     xwHW=xwGetPictureW(xwActual);
                     xwHH=xwGetPictureH(xwActual);
                     xwRW=xwGetPictureRW(xwActual); /* For Aspect Calculation */
                     xwRH=xwGetPictureRH(xwActual);
                     xwRA=(float) xwRW/(float) xwRH;
                  }
               }
               else
               {
                  xwHX=-1000;
                  xwHY=-1000;
                  xwHW=-1000;
                  xwHH=-1000;
                  xwRW=-1000;
                  xwRH=-1000;
                  xwRA=1;
                  xwFPModi=-1;
               }
            }

            /* ### Frame Picture Mode  ### */
            else if ( (xwCheckFrameMode()==0) && (xwCheckEditFrame()!=0) && (xwMouseMode==0) )
            {
               xwActual=xwGetActiveFrame();
               xwCount=xwGetFrameCount();

               if ( (xwActual>-1) && (xwCount>-1) )
               {
                  xwFPModi=1;

                  /* Frame Datas */
                  xwHX=xwGetFrameX(xwActual);
                  xwHY=xwGetFrameY(xwActual);
                  xwHW=xwGetFrameW(xwActual);
                  xwHH=xwGetFrameH(xwActual);
               }
               else
               {
                  xwHX=-1000;
                  xwHY=-1000;
                  xwHW=-1000;
                  xwHH=-1000;
                  xwFPModi=-1;
               }
            }

            /* ### Frame Edit Mode ### */
            else if ( (xwCheckFrameMode()==0) && (xwCheckEditFrame()==0) && (xwMouseMode==0) )
            {
               xwActual=xwGetActiveFrame();
               xwCount=xwGetFrameCount();

               if ( (xwActual>-1) && (xwCount>-1) )
               {
                  xwFPModi=2;

                  /* Frame Datas */
                  xwHX=xwGetFrameX(xwActual);
                  xwHY=xwGetFrameY(xwActual);
                  xwHW=xwGetFrameW(xwActual);
                  xwHH=xwGetFrameH(xwActual);
               }
               else
               {
                  xwHX=-1000;
                  xwHY=-1000;
                  xwHW=-1000;
                  xwHH=-1000;
                  xwFPModi=-1;
               }
            }

             /* Release Key - None Button pressed */
            if (kkey==0)
            {
               /* xwDrawPage(pgRedraw); */
            
               /* Picture Mode */
               if (xwFPModi==0)
               {
                  /* Move */
                  if ( (ax>=xwHX+xwBorder) && (ax<=(xwHX+xwHW)-xwBorder) && (ay>=xwHY+xwBorder) && (ay<=(xwHY+xwHH)-xwBorder) )
                  {
                     fl_set_cursor(mf.form->window,XC_fleur);
                     xwFPMode=1;
                  }
                  /* Top-Right */
                  else if ( (ax>=xwHX+(xwHW/2)) && (ax<=(xwHX+xwHW)-xwBorder) && (ay>=xwHY-xwBorder) && (ay<=xwHY+xwBorder) )
                  {
                     xwSetCursor(0);
                     xwFPMode=2;
                  }
                  /* Right-Top */
                  else if ( (ax>=(xwHX+xwHW)-xwBorder) && (ax<=xwHX+xwHW+xwBorder) && (ay>=xwHY+xwBorder) && (ay<=xwHY+(xwHH/2)) )
                  {
                     xwSetCursor(1);
                     xwFPMode=3;
                  }
                  /* Right-Buttom */
                  else if ( (ax>=(xwHX+xwHW)-xwBorder) && (ax<=xwHX+xwHW+xwBorder) && (ay>=xwHY+(xwHH/2)) && (ay<=(xwHY+xwHH)-xwBorder) )
                  {
                     xwSetCursor(1);
                     xwFPMode=4;
                  }
                  /* Buttom-Right */
                  else if ( (ax>=xwHX+(xwHW/2)) && (ax<=(xwHX+xwHW)-xwBorder) && (ay>=(xwHY+xwHH)-xwBorder) && (ay<=xwHY+xwHH+xwBorder) )
                  {
                     xwSetCursor(0);
                     xwFPMode=5;
                  }
                  /* Buttom-Left */
                  else if ( (ax>=xwHX) && (ax<=xwHX+(xwHW/2)) && (ay>=(xwHY+xwHH)-xwBorder) && (ay<=xwHY+xwHH+xwBorder) )
                  {
                     xwSetCursor(0);
                     xwFPMode=6;
                  }
                  /* Left-Buttom */
                  else if ( (ax>=xwHX-xwBorder) && (ax<=xwHX+xwBorder) && (ay>=xwHY+(xwHH/2)) && (ay<=(xwHY+xwHH)-xwBorder) )
                  {
                     xwSetCursor(1);
                     xwFPMode=7;
                  }
                  /* Left-Top */
                  else if ( (ax>=xwHX-xwBorder) && (ax<=xwHX+xwBorder) && (ay>=xwHY+xwBorder) && (ay<=xwHY+(xwHH/2)) )
                  {
                     xwSetCursor(1);
                     xwFPMode=8;
                  }
                  /* Top-Left */
                  else if ( (ax>xwHX+xwBorder) && (ax<=xwHX+(xwHW/2)) && (ay>=xwHY-xwBorder) && (ay<=xwHY+xwBorder) )
                  {
                     xwSetCursor(0);
                     xwFPMode=9;
                  }
                  else
                  {
                     fl_set_cursor(mf.form->window,FL_DEFAULT_CURSOR);
                     xwFPMode=0;
                  }
               }

               /* Frame Picture Mode */
               else if (xwFPModi==1)
               {
                  /* Check Frame */
                  xwSelect=xwGetSelectFrame(ax,ay);

                  /* Rotate Picture */
                  if (xwSelect==xwActual)
                  {
                     fl_set_cursor(mf.form->window,XC_exchange);
                     xwFPMode=1;
                  }

                  /* Move Picture */
                  else if ( (xwSelect!=xwActual) && (xwSelect>-1) )
                  {
                     fl_set_cursor(mf.form->window,XC_hand1);
                     xwFPMode=2;
                  }

                  /* Normal Cursor */
                  else if (xwSelect==-1)
                  {
                     fl_set_cursor(mf.form->window,FL_DEFAULT_CURSOR);
                     xwFPMode=0;
                  }
               }

               /* Frame Edit Mode */
               else if (xwFPModi==2)
               {
                  /* Move */
                  if ( (ax>=xwHX+xwBorder) && (ax<=(xwHX+xwHW)-xwBorder) && (ay>=xwHY+xwBorder) && (ay<=(xwHY+xwHH)-xwBorder) )
                  {
                     fl_set_cursor(mf.form->window,XC_fleur);
                     xwFPMode=1;
                  }
                  /* Top */
                  else if ( (ax>=xwHX+xwBorder) && (ax<=(xwHX+xwHW)-xwBorder) && (ay>=xwHY-xwBorder) && (ay<=xwHY+xwBorder) )
                  {
                     xwSetCursor(0);
                     xwFPMode=2;
                  }
                  /* Right-Top Corner */
                  else if ( (ax>=(xwHX+xwHW)-xwBorder) && (ax<=xwHX+xwHW+xwBorder) && (ay>=xwHY-xwBorder) && (ay<=xwHY+xwBorder) )
                  {
                     xwSetCursor(2);
                     xwFPMode=3;
                  }
                  /* Right */
                  else if ( (ax>=(xwHX+xwHW)-xwBorder) && (ax<=xwHX+xwHW+xwBorder) && (ay>=xwHY+xwBorder) && (ay<=(xwHY+xwHH)-xwBorder) )
                  {
                     xwSetCursor(1);
                     xwFPMode=4;
                  }
                  /* Bottom-Right Corner */
                  else if ( (ax>=(xwHX+xwHW)-xwBorder) && (ax<=xwHX+xwHW+xwBorder) && (ay>=(xwHY+xwHH)-xwBorder) && (ay<=xwHY+xwHH+xwBorder) )
                  {
                     xwSetCursor(3);
                     xwFPMode=5;
                  }
                  /* Bottom */
                  else if ( (ax>=xwHX+xwBorder) && (ax<=(xwHX+xwHW)-xwBorder) && (ay>=(xwHY+xwHH)-xwBorder) && (ay<=xwHY+xwHH+xwBorder) )
                  {
                     xwSetCursor(0);
                     xwFPMode=6;
                  }
                  /* Bottom-Left Corner */
                  else if ( (ax>=xwHX-xwBorder) && (ax<=xwHX+xwBorder) && (ay>=(xwHY+xwHH)-xwBorder) && (ay<=xwHY+xwHH+xwBorder) )
                  {
                     xwSetCursor(4);
                     xwFPMode=7;
                  }
                  /* Left */
                  else if ( (ax>=xwHX-xwBorder) && (ax<=xwHX+xwBorder) && (ay>=xwHY+xwBorder) && (ay<=(xwHY+xwHH)-xwBorder) )
                  {
                     xwSetCursor(1);
                     xwFPMode=8;
                  }
                  /* Top-Left Corner */
                  else if ( (ax>=xwHX-xwBorder) && (ax<=xwHX+xwBorder) && (ay>=xwHY-xwBorder) && (ay<=xwHY+xwBorder) )
                  {
                     xwSetCursor(5);
                     xwFPMode=9;
                  }
                  else
                  {
                     fl_set_cursor(mf.form->window,FL_DEFAULT_CURSOR);
                     xwFPMode=0;
                  }
               }

               if (xwMouseMode==1)
               {
                  xwMouseMode=0;
                  xwFPMode=0;
                  xwDrawPage(pgRecalc);
                  xwHM=0;
               }
               if (xwMouseMode>1) xwMouseMode=0;
            }

            /* Mouse Function - Left Mousekey */
            else if ( (kkey==1) && (ax>-9999) && (ay>-9999) )
            {
               /* Picture Mode */
               if (xwFPModi==0)
               {
                  xwPicMode(ax,ay);
               }

               /* Frame Picture Mode */
               else if ( (xwFPModi==1) && (xwHM==0) )
               {
                  /* ### Rotate Picture ### */
                  if (xwFPMode==1)
                  {
                     xwHM=1;
                     xwRotatePicInFrame(rotateRight);
                     xwDrawPage(pgRecalc);

                     xwMouseMode=1;
                  }

                  /* ### Exchange Picture ### */
                  if (xwFPMode==2)
                  {
                     xwHM=1;
                     xwExchangeFrame(xwActual,xwSelect);
                     xwDrawPage(pgRecalc);
                     xwActualizeFP();
                     xwMouseMode=1;
                  }
               }

               /* Frame Edit Mode */
               else if (xwFPModi==2)
               {
                  xwFrmEditMode(ax,ay);
               }
            }

            /* Mouse Function - Right Mousekey */
            else if ( (kkey==3) && (ax>-9999) && (ay>-9999) )
            {
               /* Picture Mode */
               if ( (xwFPModi==0) && (xwMouseMode==0) )
               {
                  for (az=0 ; az<=xwCount ; az++)
                  {
                     /* Picture Rotated */
                     if ( (xwGetPictureR(az)==90) || (xwGetPictureR(az)==-90) )
                     {
                        xwHX=xwGetPictureX(az);
                        xwHY=xwGetPictureY(az);
                        xwHW=xwGetPictureH(az);
                        xwHH=xwGetPictureW(az);
                     }
                     else
                     {
                        /* Normal Picture */
                        xwHX=xwGetPictureX(az);
                        xwHY=xwGetPictureY(az);
                        xwHW=xwGetPictureW(az);
                        xwHH=xwGetPictureH(az);
                     }

                     /* Check Geometry */
                     if ( (ax>=xwHX) && (ax<=(xwHX+xwHW)) && (ay>=xwHY) && (ay<=(xwHY+xwHH)) )
                     {
                        xwSetActivePicture(az);
                     }
                  }

                  /* Redraw Page */
                  xwDrawPage(pgRedraw);
                  xwActualizeFP();

                  /* Draw Picture/Frame Datas */
                  xwPrintFrameDatas(xwIsPaperLS(),xwGetPaperXSize(),xwGetPaperYSize());

                  xwMouseMode=2;
               }

               /* Frame Picture Mode */
               else if ( (xwFPModi==1) && (xwMouseMode==0) )
               {
                  xwSetActiveFrame(xwGetSelectFrame(ax,ay));

                  /* Redraw Page */
                  xwDrawPage(pgRedraw); /* calc */
                  xwActualizeFP();

                  /* Draw Picture/Frame Datas */
                  xwPrintFrameDatas(xwIsPaperLS(),xwGetPaperXSize(),xwGetPaperYSize());

                  xwMouseMode=2;
               }

               /* Frame Edit Mode */
               else if ( (xwFPModi==2) && (xwMouseMode==0) )
               {
                  xwSetActiveFrame(xwGetSelectFrame(ax,ay));

                  /* Redraw Page */
                  xwDrawPage(pgRedraw);
                  xwActualizeFP();

                  /* Draw Picture/Frame Datas */
                  xwPrintFrameDatas(xwIsPaperLS(),xwGetPaperXSize(),xwGetPaperYSize());

                  xwMouseMode=2;
               }

            }
         }
         else
         {
            fl_set_cursor(mf.form->window,FL_DEFAULT_CURSOR);
         }
      }
      
      /* UnLock Handler */
      xwHandlerLock=0;
   }
   else
   {
      /*printf("xwGUI2: Handler Threaded !!! ( Main Event Handler)\n");*/
   }
   
   return(0);
}

/* Picture Mode */
void xwPicMode(int ax,int ay)
{
   /* Move */
   if (xwFPMode==1)
   {
      /* Mouse Offset */
      if (xwMouseMode==0)
      {
         xwHXO=ax-xwHX;
         xwHYO=ay-xwHY;
      }
      else
      {
         /* Erase last Band */
         xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
      }

      /* Calculate new Position */
      xwHX=ax-xwHXO;
      xwHY=ay-xwHYO;

      /* Position Check */
      if (xwHX<xwGetPaperLB()) xwHX=xwGetPaperLB();
      if (xwHX+xwHW>xwGetPaperXSize()-xwGetPaperRB()) xwHX=xwGetPaperXSize()-(xwGetPaperRB()+xwHW);
      if (xwHY<xwGetPaperTB()) xwHY=xwGetPaperTB();
      if (xwHY+xwHH>xwGetPaperYSize()-xwGetPaperBB()) xwHY=xwGetPaperYSize()-(xwGetPaperBB()+xwHH);

      /* Draw Picture/Frame Datas */
      xwSetHandlerGeo();
      xwPrintFrameDatas(xwIsPaperLS(),xwGetPaperXSize(),xwGetPaperYSize());
      xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
      xwMouseMode=1;
   }

   /* Resize Top-Right */
   else if ( (xwFPMode==2) || (xwFPMode==3) )
   {
      /* Mouse Offset */
      if (xwMouseMode==1)
      {
         /* Erase last Band */
         xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
      }

      if (xwFPMode==2)
      {
         /* Calculate new Position and Size */
         xwHH=(xwHY+xwHH)-ay;
         xwHW=(int) ((float) xwHH*xwRA);
         xwHY=ay;
      }
      else if (xwFPMode==3)
      {
         /* Calculate new Position and Size */
         xwHY=xwHY+xwHH;
         xwHW=ax-xwHX;
         xwHH=(int) ((float) xwHW/xwRA);
         xwHY=xwHY-xwHH;
      }

      /* Position and Size Check */

      /* Max X-Size */
      if (xwHX+xwHW>xwGetPaperXSize()-xwGetPaperRB())
      {
         xwHW=xwGetPaperXSize()-(xwGetPaperRB()+xwHX);
         xwHY=xwHY+xwHH;
         xwHH=(int) ((float) xwHW/xwRA);
         xwHY=xwHY-xwHH;
      }

      /* Max Y-Size */
      if (xwHY<xwGetPaperTB())
      {
         xwHH=(xwHY+xwHH)-xwGetPaperTB();
         xwHW=(int) ((float) xwHH*xwRA);
         xwHY=xwGetPaperTB();
      }

      /* Min X-Size */
      if (xwHW<=(picMinSize*xwMM()))
      {
         xwHW=(picMinSize*xwMM());
         xwHY=xwHY+xwHH;
         xwHH=(int) ((float) xwHW/xwRA);
         xwHY=xwHY-xwHH;
      }

      /* Min Y-Size */
      if (xwHH<=(picMinSize*xwMM()))
      {
         xwHY=xwHY-((picMinSize*xwMM())-xwHH);
         xwHH=(picMinSize*xwMM());
         xwHW=(int) ((float) xwHH*xwRA);
      }

      /* Draw Picture/Frame Datas */
      xwSetHandlerGeo();
      xwPrintFrameDatas(xwIsPaperLS(),xwGetPaperXSize(),xwGetPaperYSize());
      xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
      xwMouseMode=1;
   }

   /* Resize Bottom-Right */
   else if ( (xwFPMode==4) || (xwFPMode==5) )
   {
      /* Mouse Offset */
      if (xwMouseMode==1)
      {
         /* Erase last Band */
         xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
      }

      if (xwFPMode==4)
      {
         /* Calculate new Position and Size */
         xwHW=ax-xwHX;
         xwHH=(int) ((float) xwHW/xwRA);
      }
      else if (xwFPMode==5)
      {
         /* Calculate new Position and Size */
         xwHH=ay-xwHY;
         xwHW=(int) ((float) xwHH*xwRA);
      }

      /* Lowest Size */
      if (xwHW<(picMinSize*xwMM()))
      {
         xwHW=(picMinSize*xwMM());
         xwHH=(int) ( (float) xwHW / xwRA );
      }
      if (xwHH<(picMinSize*xwMM()))
      {
         xwHH=(picMinSize*xwMM());
         xwHW=(int) ( (float) xwHH * xwRA );
      }

      /* Highest Size */
      if (xwHX+xwHW>xwGetPaperXSize()-xwGetPaperRB())
      {
         xwHW=xwGetPaperXSize()-(xwHX+xwGetPaperRB());
         xwHH=(int) ( (float) xwHW / xwRA );
      }
      if (xwHY+xwHH>xwGetPaperYSize()-xwGetPaperBB())
      {
         xwHH=xwGetPaperYSize()-(xwHY+xwGetPaperBB());
         xwHW=(int) ( (float) xwHH * xwRA );
      }

      /* Draw Picture/Frame Datas */
      xwSetHandlerGeo();
      xwPrintFrameDatas(xwIsPaperLS(),xwGetPaperXSize(),xwGetPaperYSize());
      xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
      xwMouseMode=1;
   }

   /* Resize Bottom-Left */
   else if ( (xwFPMode==6) || (xwFPMode==7) )
   {
      /* Mouse Offset */
      if (xwMouseMode==1)
      {
         /* Erase last Band */
         xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
      }

      if (xwFPMode==6)
      {
         /* Calculate new Position and Size */
         xwHX=xwHX+xwHW;
         xwHH=ay-xwHY;
         xwHW=(int) ((float) xwHH*xwRA);
         xwHX=xwHX-xwHW;
      }
      else if (xwFPMode==7)
      {
         /* Calculate new Position and Size */
         xwHX=xwHX+xwHW;
         xwHW=xwHX-ax;
         xwHH=(int) ((float) xwHW/xwRA);
         xwHX=xwHX-xwHW;
      }

      /* Lowest Size */
      if (xwHW<picMinSize*xwMM())
      {
         xwHX=xwHX+xwHW;
         xwHW=picMinSize*xwMM();
         xwHH=(int) ( (float) xwHW / xwRA );
         xwHX=xwHX-xwHW;
      }
      if (xwHH<picMinSize*xwMM())
      {
         xwHX=xwHX+xwHW;
         xwHH=picMinSize*xwMM();
         xwHW=(int) ( (float) xwHH * xwRA );
         xwHX=xwHX-xwHW;
      }

      /* Highest Size */
      if (xwHX<xwGetPaperLB())
      {
         xwHX=xwHX+xwHW;
         xwHW=xwHX-xwGetPaperLB();
         xwHH=(int) ( (float) xwHW / xwRA );
         xwHX=xwHX-xwHW;
      }
      if (xwHY+xwHH>xwGetPaperYSize()-xwGetPaperBB())
      {
         xwHX=xwHX+xwHW;
         xwHH=xwGetPaperYSize()-(xwHY+xwGetPaperBB());
         xwHW=(int) ( (float) xwHH * xwRA );
         xwHX=xwHX-xwHW;
      }

      /* Draw Picture/Frame Datas */
      xwSetHandlerGeo();
      xwPrintFrameDatas(xwIsPaperLS(),xwGetPaperXSize(),xwGetPaperYSize());
      xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
      xwMouseMode=1;
   }

   /* Resize Top-Left */
   else if ( (xwFPMode==8) || (xwFPMode==9) )
   {
      /* Mouse Offset */
      if (xwMouseMode==1)
      {
         /* Erase last Band */
         xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
      }

      if (xwFPMode==8)
      {
         /* Calculate new Position and Size */
         xwHX=xwHX+xwHW;
         xwHY=xwHY+xwHH;
         xwHW=xwHX-ax;
         xwHH=(int) ((float) xwHW/xwRA);
         xwHX=xwHX-xwHW;
         xwHY=xwHY-xwHH;
      }
      else if (xwFPMode==9)
      {
         /* Calculate new Position and Size */
         xwHX=xwHX+xwHW;
         xwHY=xwHY+xwHH;
         xwHH=xwHY-ay;
         xwHW=(int) ((float) xwHH*xwRA);
         xwHX=xwHX-xwHW;
         xwHY=xwHY-xwHH;
      }

      /* Lowest Size */
      if (xwHW<picMinSize*xwMM())
      {
         xwHX=xwHX+xwHW;
         xwHY=xwHY+xwHH;
         xwHW=picMinSize*xwMM();
         xwHH=(int) ( (float) xwHW/xwRA);
         xwHX=xwHX-xwHW;
         xwHY=xwHY-xwHH;
      }
      if (xwHH<picMinSize*xwMM())
      {
         xwHX=xwHX+xwHW;
         xwHY=xwHY+xwHH;
         xwHH=picMinSize*xwMM();
         xwHW=(int) ( (float) xwHH*xwRA);
         xwHX=xwHX-xwHW;
         xwHY=xwHY-xwHH;
      }

      /* Highest Size */
      if (xwHY<xwGetPaperTB())
      {
         xwHX=xwHX+xwHW;
         xwHY=xwHY+xwHH;
         xwHH=xwHY-xwGetPaperTB();
         xwHW=(int) ( (float) xwHH*xwRA);
         xwHX=xwHX-xwHW;
         xwHY=xwHY-xwHH;
      }
      if (xwHX<xwGetPaperLB())
      {
         xwHX=xwHX+xwHW;
         xwHY=xwHY+xwHH;
         xwHW=xwHX-xwGetPaperLB();
         xwHH=(int) ( (float) xwHW/xwRA);
         xwHX=xwHX-xwHW;
         xwHY=xwHY-xwHH;
      }

      /* Draw Picture/Frame Datas */
      xwSetHandlerGeo();
      xwPrintFrameDatas(xwIsPaperLS(),xwGetPaperXSize(),xwGetPaperYSize());
      xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
      xwMouseMode=1;
   }

   if (xwFPMode==1)
   {
      /* Landscape */
      if (xwIsPaperLS()==xwLandscape)
      {
         xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
         xwOneLiner(mmx,mmy,xwHX,xwGetPaperYSize()-(xwHY+xwHH),xwHY,xwGetPaperXSize()-(xwHX+xwHW));
         xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
      }
      else
      {
         xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
         xwOneLiner(mmx,mmy,xwHY,xwHX,xwGetPaperXSize()-(xwHX+xwHW),xwGetPaperYSize()-(xwHY+xwHH));
         xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
      }
   }
   else if (xwFPMode!=0)
   {
      /* Landscape */
      if (xwIsPaperLS()==xwLandscape)
      {
         xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
         xwOneLiner(mmx,mmy,xwHX,xwGetPaperYSize()-(xwHY+xwHH),xwHH,xwHW);
         xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
      }
      else
      {
         xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
         xwOneLiner(mmx,mmy,xwHY,xwHX,xwHW,xwHH);
         xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
      }
   }

   return;
}

/* Frame Edit Mode */
void xwFrmEditMode(int ax,int ay)
{
   /* Move */
   if (xwFPMode==1)
   {
      /* Mouse Offset */
      if (xwMouseMode==0)
      {
         xwHXO=ax-xwHX;
         xwHYO=ay-xwHY;
      }
      else
      {
         /* Erase last Band */
         xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
      }

      /* Calculate new Position */
      xwHX=ax-xwHXO;
      xwHY=ay-xwHYO;

      /* Left Position */
      if (xwHX<xwGetPaperLB())
      {
         xwHX=xwGetPaperLB();
      }
      /* Top Position */
      if (xwHY<xwGetPaperTB())
      {
         xwHY=xwGetPaperTB();
      }
      /* Right Position */
      if (xwHX+xwHW>xwGetPaperXSize()-xwGetPaperRB())
      {
         xwHX=xwGetPaperXSize()-(xwGetPaperRB()+xwHW);
      }
      /* Bottom Position */
      if (xwHY+xwHH>xwGetPaperYSize()-xwGetPaperBB())
      {
         xwHY=xwGetPaperYSize()-(xwGetPaperBB()+xwHH);
      }
   }

   /* Top */
   else if (xwFPMode==2)
   {
      /* Mouse Offset */
      if (xwMouseMode==1)
      {
         /* Erase last Band */
         xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
      }

      /* Y /\ */
      xwHH=xwHY+xwHH;
      xwHY=ay;
      if (xwHY<xwGetPaperTB())
      {
         xwHY=xwGetPaperTB();
      }
      if (xwHY>xwHH-(frameMinSize*xwMM()))
      {
         xwHY=xwHH-(frameMinSize*xwMM());
      }
      xwHH=xwHH-xwHY;
   }

   /* Top-Right */
   else if (xwFPMode==3)
   {
      /* Mouse Offset */
      if (xwMouseMode==1)
      {
         /* Erase last Band */
         xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
      }

      /* Y /\ */
      xwHH=xwHY+xwHH;
      xwHY=ay;
      if (xwHY<xwGetPaperTB())
      {
         xwHY=xwGetPaperTB();
      }
      if (xwHY>xwHH-(frameMinSize*xwMM()))
      {
         xwHY=xwHH-(frameMinSize*xwMM());
      }
      xwHH=xwHH-xwHY;

      /* X > */
      xwHW=ax-xwHX;
      if (xwHW<(frameMinSize*xwMM()))
      {
         xwHW=(frameMinSize*xwMM());
      }
      if (xwHX+xwHW>xwGetPaperXSize()-xwGetPaperRB())
      {
         xwHW=(xwGetPaperXSize()-xwGetPaperRB())-xwHX;
      }
   }

   /* Right */
   else if (xwFPMode==4)
   {
      /* Mouse Offset */
      if (xwMouseMode==1)
      {
         /* Erase last Band */
         xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
      }

      /* X > */
      xwHW=ax-xwHX;
      if (xwHW<(frameMinSize*xwMM()))
      {
         xwHW=(frameMinSize*xwMM());
      }
      if (xwHX+xwHW>xwGetPaperXSize()-xwGetPaperRB())
      {
         xwHW=(xwGetPaperXSize()-xwGetPaperRB())-xwHX;
      }
   }

   /* Bottom-Right */
   else if (xwFPMode==5)
   {
      /* Mouse Offset */
      if (xwMouseMode==1)
      {
         /* Erase last Band */
         xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
      }

      /* X > */
      xwHW=ax-xwHX;
      if (xwHW<(frameMinSize*xwMM()))
      {
         xwHW=(frameMinSize*xwMM());
      }
      if (xwHX+xwHW>xwGetPaperXSize()-xwGetPaperRB())
      {
         xwHW=(xwGetPaperXSize()-xwGetPaperRB())-xwHX;
      }
      /* Y \/ */
      xwHH=ay-xwHY;
      if (xwHH<(frameMinSize*xwMM()))
      {
         xwHH=(frameMinSize*xwMM());
      }
      if (xwHY+xwHH>xwGetPaperYSize()-xwGetPaperBB())
      {
         xwHH=(xwGetPaperYSize()-xwGetPaperBB())-xwHY;
      }
   }

   /* Bottom */
   else if (xwFPMode==6)
   {
      /* Mouse Offset */
      if (xwMouseMode==1)
      {
         /* Erase last Band */
         xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
      }

      /* Y \/ */
      xwHH=ay-xwHY;
      if (xwHH<(frameMinSize*xwMM()))
      {
         xwHH=(frameMinSize*xwMM());
      }
      if (xwHY+xwHH>xwGetPaperYSize()-xwGetPaperBB())
      {
         xwHH=(xwGetPaperYSize()-xwGetPaperBB())-xwHY;
      }
   }

   /* Bottom-Left */
   else if (xwFPMode==7)
   {
      /* Mouse Offset */
      if (xwMouseMode==1)
      {
         /* Erase last Band */
         xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
      }

      /* X < */
      xwHW=xwHX+xwHW;
      xwHX=ax;
      if (xwHX<xwGetPaperLB())
      {
         xwHX=xwGetPaperLB();
      }
      if (xwHX>xwHW-(frameMinSize*xwMM()))
      {
         xwHX=xwHW-(frameMinSize*xwMM());
      }
      xwHW=xwHW-xwHX;

      /* Y \/ */
      xwHH=ay-xwHY;
      if (xwHH<(frameMinSize*xwMM()))
      {
         xwHH=(frameMinSize*xwMM());
      }
      if (xwHY+xwHH>xwGetPaperYSize()-xwGetPaperBB())
      {
         xwHH=(xwGetPaperYSize()-xwGetPaperBB())-xwHY;
      }
   }

   /* Left */
   else if (xwFPMode==8)
   {
      /* Mouse Offset */
      if (xwMouseMode==1)
      {
         /* Erase last Band */
         xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
      }

      /* X < */
      xwHW=xwHX+xwHW;
      xwHX=ax;
      if (xwHX<xwGetPaperLB())
      {
         xwHX=xwGetPaperLB();
      }
      if (xwHX>xwHW-(frameMinSize*xwMM()))
      {
         xwHX=xwHW-(frameMinSize*xwMM());
      }
      xwHW=xwHW-xwHX;
   }

   /* Top-Left */
   else if (xwFPMode==9)
   {
      /* Mouse Offset */
      if (xwMouseMode==1)
      {
         /* Erase last Band */
         xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
      }

      /* X < */
      xwHW=xwHX+xwHW;
      xwHX=ax;
      if (xwHX<xwGetPaperLB())
      {
         xwHX=xwGetPaperLB();
      }
      if (xwHX>xwHW-(frameMinSize*xwMM()))
      {
         xwHX=xwHW-(frameMinSize*xwMM());
      }
      xwHW=xwHW-xwHX;

      /* Y /\ */
      xwHH=xwHY+xwHH;
      xwHY=ay;
      if (xwHY<xwGetPaperTB())
      {
         xwHY=xwGetPaperTB();
      }
      if (xwHY>xwHH-(frameMinSize*xwMM()))
      {
         xwHY=xwHH-(frameMinSize*xwMM());
      }
      xwHH=xwHH-xwHY;
   }

   /* Set Frame */
   xwSetFrameGeo(xwActual,xwHX,xwHY,xwHW,xwHH);
   /* Draw Picture/Frame Datas */
   xwPrintFrameDatas(xwIsPaperLS(),xwGetPaperXSize(),xwGetPaperYSize());
   xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
   xwMouseMode=1;

   if (xwFPMode==1)
   {
      /* Landscape */
      if (xwIsPaperLS()==xwLandscape)
      {
         xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
         xwOneLiner(mmx,mmy,xwHX,xwGetPaperYSize()-(xwHY+xwHH),xwHY,xwGetPaperXSize()-(xwHX+xwHW));
         xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
      }
      else
      {
         xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
         xwOneLiner(mmx,mmy,xwHY,xwHX,xwGetPaperXSize()-(xwHX+xwHW),xwGetPaperYSize()-(xwHY+xwHH));
         xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
      }
   }
   else if (xwFPMode!=0)
   {
      /* Landscape */
      if (xwIsPaperLS()==xwLandscape)
      {
         xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
         xwOneLiner(mmx,mmy,xwHX,xwGetPaperYSize()-(xwHY+xwHH),xwHH,xwHW);
         xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
      }
      else
      {
         xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
         xwOneLiner(mmx,mmy,xwHY,xwHX,xwHW,xwHH);
         xwDraw(drawBand,xwHX,xwHY,xwHW,xwHH);
      }
   }

   return;
}

/* Set Correct Datas */
void xwSetHandlerGeo(void)
{
   /* Round Values */
   /*
   xwHX=((int) (xwHX/mm))*mm;
   xwHY=((int) (xwHY/mm))*mm;
   xwHW=((int) (xwHW/mm))*mm;
   xwHH=((int) (xwHH/mm))*mm;
   */

   /* Picture Mode */

   /* Picture Rotated */
   if ( (xwGetPictureR(xwActual)==90) || (xwGetPictureR(xwActual)==-90) )
   {
      xwSetPictureGeo(xwActual,xwHX,xwHY,xwHH,xwHW);
   }
   else
   {
      /* Normal Picture */
      xwSetPictureGeo(xwActual,xwHX,xwHY,xwHW,xwHH);
   }

   return;
}

/* Set Cursor */
void xwSetCursor(int a)
{
   if (a==0)
   {
      /* Vertical Arrow */
      if (xwIsPaperLS()==xwPortrait)
      {
         fl_set_cursor(mf.form->window,XC_sb_v_double_arrow);
      }
      else
      {
         fl_set_cursor(mf.form->window,XC_sb_h_double_arrow);
      }
   }
   /* Horizontal Arrow */
   else if (a==1)
   {
      if (xwIsPaperLS()==xwPortrait)
      {
         fl_set_cursor(mf.form->window,XC_sb_h_double_arrow);
      }
      else
      {
         fl_set_cursor(mf.form->window,XC_sb_v_double_arrow);
      }
   }
   /* Right-Top-Corner */
   else if (a==2)
   {
      if (xwIsPaperLS()==xwPortrait)
      {
         fl_set_cursor(mf.form->window,XC_top_right_corner);
      }
      else
      {
         fl_set_cursor(mf.form->window,XC_bottom_right_corner);
      }
   }
   /* Right-Bottom-Corner */
   else if (a==3)
   {
      if (xwIsPaperLS()==xwPortrait)
      {
         fl_set_cursor(mf.form->window,XC_bottom_right_corner);
      }
      else
      {
         fl_set_cursor(mf.form->window,XC_bottom_left_corner);
      }
   }
   /* Left-Bottom-Corner */
   else if (a==4)
   {
      if (xwIsPaperLS()==xwPortrait)
      {
         fl_set_cursor(mf.form->window,XC_bottom_left_corner);
      }
      else
      {
         fl_set_cursor(mf.form->window,XC_top_left_corner);
      }
   }
   /* Left-Top-Corner */
   else if (a==5)
   {
      if (xwIsPaperLS()==xwPortrait)
      {
         fl_set_cursor(mf.form->window,XC_top_left_corner);
      }
      else
      {
         fl_set_cursor(mf.form->window,XC_top_right_corner);
      }
   }

   return;
}

/* ############################################################################# */

/* Refreshing Main-GUI */
int refreshGUI(XEvent *ev,void *data)
{
   if ((mf.form!=NULL) &&
       (xwHandlerLock==0) &&
       (xwOLMode()==0) &&
       (xwMouseMode==0))
   {
      xwDrawPage(pgRedraw);
   }
   
   return(0);
}

/* Exit Handler */
int close_cb(FL_FORM *frm,void *data)
{
   /* Remove OneLiner */
   xwOLRemove();

   /* Exit Manager */
   xwGUIExit();

   exit(0);

   return(FL_IGNORE);
}

int nclose_cb(FL_FORM *frm,void *data)
{
  long a;
  a=(long) data;
  a=(long) frm;

  return(FL_IGNORE);
}

/* Signal Handler */
void sig_handler(int signr)
{
   printf("SIGNAL #%d %s",signr," !!!\n");
   if (signr == SIGPIPE)
   {
      printf("Ignorr Broken Pipe Signal !!!\n");
   }
}
