/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "gimp_plugin.h"

#include "base.h"
#include "handler.h"
#include "resource.h"

static int        gimpmode;

/* Check Argument */
void xwCheckGimp(char *argument) /*fold00*/
{
   char           data[256];
   FILE           *fh;
   
   int            size;
   unsigned char  buf[8192];
   
   /* GimpMode not activated */
   gimpmode=-1;
   
   strcpy(data,argument);
   data[5]=0x00;
   strUpper(data);
   
   /* Gimp Mode */
   if (strcmp(data,"-GIMP") == 0) 
   {
      /* GimpMode activated */
      gimpmode=0;
   
      /* Copy Gimp Datas to Gimp-Data-File */
      if ( (fh=fopen(xwGetFile("","gimp.data"),"w")) != NULL )
      {
         signal(SIGPIPE,sig_handler);
         while ( (size=fread(buf,1,sizeof(buf),stdin)) > 0)
         {
            fwrite(buf,1,size,fh);
         }
         fclose(fh);
      }      
   }
   
   return;
}

/* Init Gimp Mode */
void xwInitGimp(void) /*fold00*/
{
   gimpmode=-1;
   return;
}

/* Ask Gimp Mode */
int xwGimpMode(void) /*fold00*/
{
   return(gimpmode);
}