/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWGFX_H
#define _XWGFX_H

#include <forms.h>

#include <math.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <time.h>

#ifndef memPaper
#define memPaper        0
#endif
#ifndef memTemp
#define memTemp         1
#endif
#ifndef memPicture
#define memPicture      2
#endif
#ifndef createTemp
#define createTemp      3
#endif
#ifndef memShared
#define memShared       4
#endif
#ifndef memSTemp
#define memSTemp        5
#endif
#ifndef memSPicture
#define memSPicture     6
#endif
#ifndef createSTemp
#define createSTemp     7
#endif

/* Draw Border Modes */
#ifndef gfxQuad
#define gfxQuad         0
#endif
#ifndef gfxCircle
#define gfxCircle       1
#endif
#ifndef gfxCircleCLR
#define gfxCircleCLR    2
#endif 

#ifndef gfxDrawer
#define gfxDrawer       0
#endif
#ifndef gfxParent
#define gfxParent       1
#endif
#ifndef gfxError
#define gfxError        2
#endif

/* Internal Datas       Orientation
   
           0                  0
   -90          +90         4   1
       -180 -180             3 2    */
typedef struct gfxdef
{
   char              ID[20];
   int               rot[5];
   char              command[256];
} gfxdef;

typedef struct rgbColor
{
   unsigned char     r;
   unsigned char     g;
   unsigned char     b;
} rgbColor;

typedef struct rgbIColor
{
   int               r;
   int               g;
   int               b;
} rgbIColor;

typedef struct rgbFColor
{
   float             r;
   float             g;
   float             b;
} rgbFColor;

typedef struct sharedMemory
{
   int               com;
   int               result[100];
   unsigned char     mem[INT_MAX];
} sharedMemory;

typedef struct gfxLines
{
   int               pos[100000];
} gfxLines;

/* Initialize GFX */
void xwGFXInit(void);
/* Set GFX Landscape */
void xwGFXLandscape(int mo);

/* ################################################################### */
/* Paper Routines */

/* Get Paper Memory */
int xwGFXCreatePaper(int w,int h);
/* Remove Paper Memory */
void xwGFXRemovePaper(void);
/* Save Paper Memory */
int xwGFXSavePaper(char *dest);

/* ################################################################### */
/* Shared Routines */

/* Get Shared Memory */
int xwGFXCreateShared(int w,int h);
/* Clear Shared Memory */
void xwGFXClearShared(void);
/* Remove Shared Memory */
void xwGFXRemoveShared(void);
/* Set Communicate Shared Memory */
void xwGFXSharedSetCom(int com);
/* Get Communicate Shared Memory */
int xwGFXSharedGetCom(void);
/* Reset Result Data */
void xwGFXSharedResetResult(void);
/* Set Result Data */
void xwGFXSharedSetResult(int entry,int result);
/* Get Result Data */
int xwGFXSharedGetResult(int entry);
/* Save Shared Memory */
int xwGFXSaveShared(char *dest);

/* ################################################################### */
/* Temp Routines */

/* Get Temp Memory */
int xwGFXCreateTemp(int w,int h);
/* Remove Temp Memory */
void xwGFXRemoveTemp(void);
/* Move Temp To Picture */
void xwGFXTempToPicture(void);
/* Save Temp Datas */
void xwGFXSaveTemp(void);
/* Get Temp Datas */
void xwGFXLoadTemp(void);
/* Get Temp Datas */
int xwGFXGetTempX(void);
/* Get Temp Datas */
int xwGFXGetTempY(void);

/* ################################################################### */
/* Picture Routines */

/* Get Picture Memory */
int xwGFXCreatePicture(int w,int h);
/* Remove Picture Memory */
void xwGFXRemovePicture(void);
/* Load Picture */
int xwGFXLoadPicture(char *source);
/* Save Picture Memory */
int xwGFXSavePicture(char *dest);
/* Get Picture Datas */
int xwGFXGetPictureX(void);
/* Get Picture Datas */
int xwGFXGetPictureY(void);

/* ################################################################### */
/* Second Temp Routines */

/* Get Temp Memory */
int xwGFXCreateSTemp(int w,int h);
/* Remove Temp Memory */
void xwGFXRemoveSTemp(void);
/* Move Temp To Picture */
void xwGFXSTempToSPicture(void);
/* Get Temp Datas */
int xwGFXGetSTempX(void);
/* Get Temp Datas */
int xwGFXGetSTempY(void);

/* ################################################################### */
/* Second Picture Routines */

/* Get Picture Memory */
int xwGFXCreateSPicture(int w,int h);
/* Remove Picture Memory */
void xwGFXRemoveSPicture(void);
/* Load Picture */
int xwGFXLoadSPicture(char *source);
/* Save Picture Memory */
int xwGFXSaveSPicture(char *dest);
/* Get Picture Datas */
int xwGFXGetSPictureX(void);
/* Get Picture Datas */
int xwGFXGetSPictureY(void);

/* ################################################################### */
/* Pixel Manipulations */

/* Set Text Color */
void xwGFXSetTextColor(int r,int g,int b);
/* Ignore Paper Color */
void xwGFXIgnorePaper(int mo);
/* Set Mask Color */
void xwGFXSetMaskColor(int rA,int gA,int bA,int rB,int gB,int bB,int rC,int gC,int bC);
/* Set Mask Color */
void xwGFXSetMaskLColor(int cA,int cB,int cC);
/* Get Mask Color */
int xwGFXGetMaskLColor(void);
/* Mask Mode */
void xwGFXUseMask(int mo);
/* Set Picture Mask */
void xwGFXSetPicMask(int mo,int x,int y,int w,int h);


/* Set Transparenzy Value */ 
void xwGFXSetTrans(int trans);
/* Set Transparency Mode */
void xwGFXSetTransMode(int mo);
/* Calc Transparenzy */ 
/*int xwGFXCalcTrans(int pa,int pb);*/
void xwGFXCalcTrans(int ir,int ig,int ib,int or,int og,int ob);


/* Copy Pixel */
void xwGFXCopyPixel(int in,int x, int y,int out,int xx,int yy);
/* Get RGB-Value */
void xwGFXGetPixel(int in,int x,int y);
/* Set RGB-Value */
void xwGFXSetPixel(int out,int x,int y,int r,int g,int b);

/* ################################################################### */
/* Picture Manipulations */

/* Rotate Picture */
void xwGFXRotatePicture(int rot);
/* Copy Picture */
void xwGFXCopyPicture(int in,int out,int x,int y);
/* Copy Area */
void xwGFXCopyArea(int in,int x,int y,int w,int h,int out,int xx,int yy);
/* Copy Special for PicBrowser ( Pic -> Raw ) */
void xwGFXCopySpecial(int x,int y,int w,int h,int r,int g,int b);
/* Special Scale Render-Engine for Up-Scale */
void xwGFXRenderRGB(int count,int pos,int ra,int ga,int ba,int rb,int gb, int bb);
/* Scale Picture */
void xwGFXScalePicture(int in,int out,int x,int y,int w,int h,int rot);
/* Set Draw Border Mode */
void xwGFXSetDrawBorderMode(int mo);
/* Draw Border */
void xwGFXDrawBorder(int out,int bw,int r,int g,int b);
/* Draw Border RGB */
void xwGFXDrawBorderRGB(int out,int bw,int rgb);
/* Create Button */
void xwGFXCreateButton(int in);
/* Draw Image */
void xwGFXDrawImage(int out,int type,int x, int y);
/* RePaint Paper with Defined Color */
void xwGFXPaintPicture(int out,int r,int g,int b);
/* ################################################################### */
/* Picture to XPM */
 
/* Generate XPM-Data - Result PIXMAP */
Pixmap xwGFXCreatePixmap(int in);




/* Preview */
void xwGFXPreview(float dpi);
/* Convert PPM to PNG */
void xwGFXPPMTOPNG(const char *source,const char *dest);

/* #################################################################################################
   Special GFX Routines 
   ################################################################################################# */
/* Import Picture */
int xwGFXImport(const char *source, const char *dest);
/* Convert To PNG */
int xwGFXPNG(const char *source,const char *dest);
/* Convert To XPM */
int xwGFXXPM(const char *source,const char *dest);
/* Insert Variable in Convert String */
int xwGFXExec(const char *command,int xpos,int ypos, int xsize,int ysize,int rot,const char *source,const char *dest,const char *format);

#endif