/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "frameset.h"

#include "base.h"
#include "default.h"
#include "frame.h"
#include "handler.h"
#include "help.h"
#include "limits.h"
#include "main_gui.h"
#include "paper.h"
#include "resource.h"

struct framesetsform    fsf;

/* Selected Form */
static int              fsfMode=1;

/* Selected Format */
static int              fsfFormat=1;
/* Distance in mm */
static float            fsfDist=1;
/* Horizontal Size in mm */
static float            fsfHSize=50;
/* Verticval Size in mm */
static float            fsfVSize=50;
/* Horizontal Count */
static int              fsfHCount=2;
/* Vertical Count */
static int              fsfVCount=2;

/* FrameSets GUI */
void xwFrameSetsGUI(void) /*fold00*/
{
   int            az,bz,cz,dz;

   /* Frame Datas */
   int            xcount,ycount;
   int            xpos,ypos;
   int            xsize,ysize;
   int            xydist;

   fsf.form = NULL;
   fsf.ready = 0;

   fsf.form = fl_bgn_form(FL_UP_BOX, 320, 265);
   fl_set_border_width(1);

   /* Ground Frame */
   fsf.FrameA = fl_add_frame(FL_DOWN_FRAME,5,5,310,230,"");

   fsf.Mode = fl_add_choice(FL_DROPLIST_CHOICE,10,10,300,20,"");
   fl_set_object_boxtype(fsf.Mode,FL_UP_BOX);
   fl_set_choice_fontstyle(fsf.Mode,FL_FIXED_STYLE);
   fl_set_choice_fontsize(fsf.Mode,FL_NORMAL_SIZE);
   fl_addto_choice(fsf.Mode,xwGR(1,"frms.GFDefault","generate frames by setting"));
   fl_addto_choice(fsf.Mode,xwGR(1,"frms.GFSize","generate frames by size"));
   fl_addto_choice(fsf.Mode,xwGR(1,"frms.GFCount","generate frames by count"));
   fl_set_choice(fsf.Mode,fsfMode);

   fsf.FrameB = fl_add_frame(FL_DOWN_FRAME,11,31,298,198,"");

   /* FrameSets by Setting */
   fsf.BrowserA = fl_add_browser(FL_HOLD_BROWSER,15,35,290,165,"");
   fl_set_browser_fontstyle(fsf.BrowserA,FL_FIXED_STYLE);
   fl_set_browser_fontsize(fsf.BrowserA,FL_NORMAL_SIZE);
   fl_addto_browser(fsf.BrowserA,"@c 90 mm x  90 mm");
   fl_addto_browser(fsf.BrowserA,"@c 90 mm x 130 mm");
   fl_addto_browser(fsf.BrowserA,"@c130 mm x  90 mm");
   fl_addto_browser(fsf.BrowserA,"@c100 mm x 150 mm");
   fl_addto_browser(fsf.BrowserA,"@c150 mm x 100 mm");
   fl_addto_browser(fsf.BrowserA,"@c130 mm x 180 mm");
   fl_addto_browser(fsf.BrowserA,"@c180 mm x 130 mm");
   fl_addto_browser(fsf.BrowserA,"@c180 mm x 270 mm");
   fl_addto_browser(fsf.BrowserA,"@c270 mm x 180 mm");
   fl_addto_browser(fsf.BrowserA,"@c200 mm x 300 mm");
   fl_addto_browser(fsf.BrowserA,"@c300 mm x 200 mm");
   fl_select_browser_line(fsf.BrowserA,fsfFormat);
   fsf.DistanceA = fl_add_input(FL_FLOAT_INPUT,195,205,110,20,xwGR(1,"frms.Distance","Distance (mm):"));
   fl_set_object_lstyle(fsf.DistanceA,FL_FIXED_STYLE);
   fl_set_object_lsize(fsf.DistanceA,FL_NORMAL_SIZE);
#ifdef xwWhiteInput
   fl_set_object_color(fsf.DistanceA,FL_WHITE,FL_WHITE);
#endif
   fl_set_input(fsf.DistanceA,DoubleStr(fsfDist,1));
   fl_hide_object(fsf.BrowserA);
   fl_hide_object(fsf.DistanceA);
   
   
   /* FrameSets by Size */
   fsf.HSizeB = fl_add_input(FL_FLOAT_INPUT,195,35,110,20,xwGR(1,"frms.Width","Width (mm):"));
   fl_set_object_lstyle(fsf.HSizeB,FL_FIXED_STYLE);
   fl_set_object_lsize(fsf.HSizeB,FL_NORMAL_SIZE);
#ifdef xwWhiteInput
   fl_set_object_color(fsf.HSizeB,FL_WHITE,FL_WHITE);
#endif
   fl_set_input(fsf.HSizeB,DoubleStr(fsfHSize,1));
   fsf.VSizeB = fl_add_input(FL_FLOAT_INPUT,195,60,110,20,xwGR(1,"frms.Height","Height (mm):"));
   fl_set_object_lstyle(fsf.VSizeB,FL_FIXED_STYLE);
   fl_set_object_lsize(fsf.VSizeB,FL_NORMAL_SIZE);
#ifdef xwWhiteInput
   fl_set_object_color(fsf.VSizeB,FL_WHITE,FL_WHITE);
#endif
   fl_set_input(fsf.VSizeB,DoubleStr(fsfVSize,1));
   fsf.DistanceB = fl_add_input(FL_FLOAT_INPUT,195,85,110,20,xwGR(1,"frms.Distance","Distance (mm):"));
   fl_set_object_lstyle(fsf.DistanceB,FL_FIXED_STYLE);
   fl_set_object_lsize(fsf.DistanceB,FL_NORMAL_SIZE);
#ifdef xwWhiteInput
   fl_set_object_color(fsf.DistanceB,FL_WHITE,FL_WHITE);
#endif
   fl_set_input(fsf.DistanceB,DoubleStr(fsfDist,1));
   fl_hide_object(fsf.HSizeB);
   fl_hide_object(fsf.VSizeB);
   fl_hide_object(fsf.DistanceB);
   
   /* FrameSets by Count */
   fsf.HCountC = fl_add_input(FL_INT_INPUT,195,35,110,20,xwGR(1,"frms.HCount","Horizontal Count:"));
   fl_set_object_lstyle(fsf.HCountC,FL_FIXED_STYLE);
   fl_set_object_lsize(fsf.HCountC,FL_NORMAL_SIZE);
#ifdef xwWhiteInput
   fl_set_object_color(fsf.HCountC,FL_WHITE,FL_WHITE);
#endif
   fl_set_input(fsf.HCountC,IntStr(fsfHCount));
   fsf.VCountC = fl_add_input(FL_INT_INPUT,195,60,110,20,xwGR(1,"frms.VCount","Vertical Count:"));
   fl_set_object_lstyle(fsf.VCountC,FL_FIXED_STYLE);
   fl_set_object_lsize(fsf.VCountC,FL_NORMAL_SIZE);
#ifdef xwWhiteInput
   fl_set_object_color(fsf.VCountC,FL_WHITE,FL_WHITE);
#endif
   fl_set_input(fsf.VCountC,IntStr(fsfVCount));
   fsf.DistanceC = fl_add_input(FL_FLOAT_INPUT,195,85,110,20,xwGR(1,"frms.Distance","Distance (mm):"));
   fl_set_object_lstyle(fsf.DistanceC,FL_FIXED_STYLE);
   fl_set_object_lsize(fsf.DistanceC,FL_NORMAL_SIZE);
#ifdef xwWhiteInput
   fl_set_object_color(fsf.DistanceC,FL_WHITE,FL_WHITE);
#endif
   fl_set_input(fsf.DistanceC,DoubleStr(fsfDist,1));
   fl_hide_object(fsf.HCountC);
   fl_hide_object(fsf.VCountC);
   fl_hide_object(fsf.DistanceC);
   
   fsf.OK = fl_add_button(FL_NORMAL_BUTTON,5,240,100,20,xwGR(1,"frms.OK","OK"));
   fsf.Cancel = fl_add_button(FL_NORMAL_BUTTON,110,240,100,20,xwGR(1,"frms.Cancel","Cancel"));
   fsf.HELP = fl_add_button(FL_NORMAL_BUTTON,215,240,100,20,xwGR(1,"help.HELP","Help"));

   fl_end_form();

   if (xwGetPrefValue(xwgWinPos)==0)
   {
      fl_prepare_form_window(fsf.form,FL_PLACE_MOUSE,FL_TRANSIENT,xwGR(1,"frms.FrameSets","FrameSets"));
   }
   else
   {
      fl_prepare_form_window(fsf.form,FL_PLACE_CENTER,FL_TRANSIENT,xwGR(1,"frms.FrameSets","FrameSets"));
   }

   fl_set_form_dblbuffer(fsf.form,0);
   fl_show_form_window(fsf.form);

   fl_set_app_mainform(fsf.form);

   /* Exit Handler */
   fl_set_form_atclose(fsf.form,nclose_cb,(void *) "1");

   xwSetFSGui(fsfMode);

   while (fsf.ready==0)
   {
      fsf.obj = fl_do_forms();

      /* ### FrameSets by Setting ### */
      if (fsfMode==1)
      {
         /* Browser */
         if (fsf.obj == fsf.BrowserA)
         {
            if ((az=fl_get_browser(fsf.BrowserA))>0)
            {
               fsfFormat=az;
            }
         }
         /* Distance */
         fsfDist=atof(fl_get_input(fsf.DistanceA));
         if (fsfDist<1) fsfDist=1;
         if (fsfDist>20*xwMM()) fsfDist=20*xwMM();
         fl_set_input(fsf.DistanceA,DoubleStr(fsfDist,1));
      }

      /* ### FrameSets by Size ### */
      else if (fsfMode==2)
      {
         /* Width */
         fsfHSize=atof(fl_get_input(fsf.HSizeB));
         if (fsfHSize<10) fsfHSize=10;
         fl_set_input(fsf.HSizeB,DoubleStr(fsfHSize,1));
         /* Height */
         fsfVSize=atof(fl_get_input(fsf.VSizeB));
         if (fsfVSize<10) fsfVSize=10;
         fl_set_input(fsf.VSizeB,DoubleStr(fsfVSize,1));
         /* Distance */
         fsfDist=atof(fl_get_input(fsf.DistanceB));
         if (fsfDist<1) fsfDist=1;
         if (fsfDist>20*xwMM()) fsfDist=20*xwMM();
         fl_set_input(fsf.DistanceB,DoubleStr(fsfDist,1));
      }

      /* ### FrameSets by Count ### */
      else if (fsfMode==3)
      {
         /* Width */
         fsfHCount=atoi(fl_get_input(fsf.HCountC));
         if (fsfHCount<1) fsfHCount=1;
         if (fsfHCount>40) fsfHCount=40;
         fl_set_input(fsf.HCountC,IntStr(fsfHCount));
         /* Height */
         fsfVCount=atoi(fl_get_input(fsf.VCountC));
         if (fsfVCount<1) fsfVCount=1;
         if (fsfVCount>40) fsfVCount=40;
         fl_set_input(fsf.VCountC,IntStr(fsfVCount));
         /* Distance */
         fsfDist=atof(fl_get_input(fsf.DistanceC));
         if (fsfDist<1) fsfDist=1;
         if (fsfDist>20*xwMM()) fsfDist=20*xwMM();
         fl_set_input(fsf.DistanceC,DoubleStr(fsfDist,1));
      }

      /* OK */
      if (fsf.obj == fsf.OK)
      {
         fsf.ready=-1;
      }

      /* Cancel */
      else if (fsf.obj == fsf.Cancel)
      {
         fsf.ready=1;
      }

      /* Help */
      else if (fsf.obj == fsf.HELP)
      {
         xwDisplayHelp(HelpFrameSets);
      }

      /* Select Form */
      else if (fsf.obj == fsf.Mode)
      {
         if ((az=fl_get_choice(fsf.Mode))>0)
         {
            fsfMode=az;
            xwSetFSGui(fsfMode);
         }
      }

   }

   fl_hide_form(fsf.form);
   fl_free_form(fsf.form);

   fl_set_app_mainform(xwGetMainGui());

   /* Create FrameSets */
   if (fsf.ready==-1)
   {
      /* Frame Datas */
      /*
      float          xsize,ysize;
      float          xydist;
      */
      xsize= (int) ((fsfHSize*(float) xwMM())+0.5);
      ysize= (int) ((fsfVSize*(float) xwMM())+0.5);
      xydist=(int) ((fsfDist *(float) xwMM())+0.5);


      /* ### FrameSets by Setting ### */
      if (fsfMode==1)
      {
         if (fsfFormat==1)
         {
            xsize=90*xwMM();
            ysize=90*xwMM();
         }
         else if (fsfFormat==2)
         {
            xsize= 90*xwMM();
            ysize=130*xwMM();
         }
         else if (fsfFormat==3)
         {
            xsize=130*xwMM();
            ysize= 90*xwMM();
         }
         else if (fsfFormat==4)
         {
            xsize=100*xwMM();
            ysize=150*xwMM();
         }
         else if (fsfFormat==5)
         {
            xsize=150*xwMM();
            ysize=100*xwMM();
         }
         else if (fsfFormat==6)
         {
            xsize=130*xwMM();
            ysize=180*xwMM();
         }
         else if (fsfFormat==7)
         {
            xsize=180*xwMM();
            ysize=130*xwMM();
         }
         else if (fsfFormat==8)
         {
            xsize=180*xwMM();
            ysize=270*xwMM();
         }
         else if (fsfFormat==9)
         {
            xsize=270*xwMM();
            ysize=180*xwMM();
         }
         else if (fsfFormat==10)
         {
            xsize=200*xwMM();
            ysize=300*xwMM();
         }
         else if (fsfFormat==11)
         {
            xsize=300*xwMM();
            ysize=200*xwMM();
         }

         /* Landscape */
         if (xwIsPaperLS()==xwLandscape)
         {
            az=xsize;
            xsize=ysize;
            ysize=az;
         }

         xcount=xwGetPaperXB()/xsize;
         if ((xcount*xsize)+((xcount-1)*xydist)>xwGetPaperXB()) xcount--;
         xpos=((xwGetPaperXB()-((xcount*xsize)+((xcount-1)*xydist)))/2)+xwGetPaperLB();

         ycount=xwGetPaperYB()/ysize;
         if ((ycount*ysize)+((ycount-1)*xydist)>xwGetPaperYB()) ycount--;
         ypos=((xwGetPaperYB()-((ycount*ysize)+((ycount-1)*xydist)))/2)+xwGetPaperTB();

         dz=0;
         for (az=1 ; az<=ycount ; az++)
         {
            cz=0;
            for (bz=1 ; bz<=xcount ; bz++)
            {
               xwAddFrame();
               xwSetFrameGeo(xwGetActiveFrame(),xpos+cz,ypos+dz,xsize,ysize);
               cz=cz+xsize+xydist;
            }
            dz=dz+ysize+xydist;
         }

      }

      /* ### FrameSets by Size ### */
      else if (fsfMode==2)
      {
         /* Landscape */
         if (xwIsPaperLS()==xwLandscape)
         {
            az=xsize;
            xsize=ysize;
            ysize=az;
         }
      
         xcount=xwGetPaperXB()/xsize;
         while ((xcount*xsize)+((xcount-1)*xydist)>xwGetPaperXB())
         {
            xcount--;
         }
         xpos=((xwGetPaperXB()-((xcount*xsize)+((xcount-1)*xydist)))/2)+xwGetPaperLB();

         ycount=xwGetPaperYB()/ysize;
         while ((ycount*ysize)+((ycount-1)*xydist)>xwGetPaperYB())
         {
            ycount--;
         }
         ypos=((xwGetPaperYB()-((ycount*ysize)+((ycount-1)*xydist)))/2)+xwGetPaperTB();

         dz=0;
         for (az=1 ; az<=ycount ; az++)
         {
            cz=0;
            for (bz=1 ; bz<=xcount ; bz++)
            {
               xwAddFrame();
               xwSetFrameGeo(xwGetActiveFrame(),xpos+cz,ypos+dz,xsize,ysize);
               cz=cz+xsize+xydist;
            }
            dz=dz+ysize+xydist;
         }
      }

      /* ### FrameSets by Count ### */
      else if (fsfMode==3)
      {
         /* Landscape */
         if (xwIsPaperLS()==xwLandscape)
         {
            xcount=fsfVCount;
            ycount=fsfHCount;
         }
         else
         {
            xcount=fsfHCount;
            ycount=fsfVCount;
         }
      
         xsize=(int) (((xwGetPaperXB()-((xcount-1)*xydist))/xcount)+0.5);
         xpos=xwGetPaperLB()+(int) (((float) xwGetPaperXB()-((((float) xcount-1)*(float) xydist)+((float) xcount*(float) xsize)))/2)+0.5;
         
         ysize=(int) (((xwGetPaperYB()-((ycount-1)*xydist))/ycount)+0.5);
         ypos=xwGetPaperTB()+ ((xwGetPaperYB()-(((ycount-1)*xydist)+(ycount*ysize)))/2);

         dz=0;
         for (az=1 ; az<=ycount ; az++)
         {
            cz=0;
            for (bz=1 ; bz<=xcount ; bz++)
            {
               xwAddFrame();
               xwSetFrameGeo(xwGetActiveFrame(),xpos+cz,ypos+dz,xsize,ysize);
               cz=cz+xsize+xydist;
            }
            dz=dz+ysize+xydist;
         }
      }

   }

   return;
}

/* set active widgets */
void xwSetFSGui(int nr) /*fold00*/
{
   /* Hide Widgets */
   fl_hide_object(fsf.BrowserA);
   fl_hide_object(fsf.DistanceA);
   fl_hide_object(fsf.HSizeB);
   fl_hide_object(fsf.VSizeB);
   fl_hide_object(fsf.DistanceB);
   fl_hide_object(fsf.HCountC);
   fl_hide_object(fsf.VCountC);
   fl_hide_object(fsf.DistanceC);

   if (nr==1)
   {
      fl_show_object(fsf.BrowserA);
      fl_show_object(fsf.DistanceA);
      fl_select_browser_line(fsf.BrowserA,fsfFormat);
      fl_set_input(fsf.DistanceA,DoubleStr(fsfDist,1));
   }
   else if (nr==2)
   {
      fl_show_object(fsf.HSizeB);
      fl_show_object(fsf.VSizeB);
      fl_show_object(fsf.DistanceB);
      fl_set_input(fsf.HSizeB,DoubleStr(fsfHSize,1));
      fl_set_input(fsf.VSizeB,DoubleStr(fsfVSize,1));
      fl_set_input(fsf.DistanceB,DoubleStr(fsfDist,1));
   }
   else if (nr==3)
   {
      fl_show_object(fsf.HCountC);
      fl_show_object(fsf.VCountC);
      fl_show_object(fsf.DistanceC);
      fl_set_input(fsf.HCountC,IntStr(fsfHCount));
      fl_set_input(fsf.VCountC,IntStr(fsfVCount));
      fl_set_input(fsf.DistanceC,DoubleStr(fsfDist,1));
   }

   return;
}