/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWFRAME_H
#define _XWFRAME_H

#include <forms.h>
#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

/* Geometry Position */
#ifndef frmCenter
#define frmCenter 0
#endif
#ifndef frmNWPos
#define frmNWPos  1
#endif
#ifndef frmNEPos
#define frmNEPos  2
#endif
#ifndef frmSWPos
#define frmSWPos  3
#endif
#ifndef frmSEPos
#define frmSEPos  4
#endif

/* Frame Border */
#ifndef frmQBorder
#define frmQBorder   0
#endif
#ifndef frmCBorder
#define frmCBorder   1
#endif
#ifndef frmABorder   
#define frmABorder   2
#endif

typedef struct framedatas
{
   /* Framedatas */
   int         xpos;       /* in millimeters */
   int         ypos;       /* in millimeters */
   int         xsize;      /* in millimeters */
   int         ysize;      /* in millimeters */

/* ################################################################### */
/* WYSIWYG Pixmap */

   int         pFlag;      /* 0 - No Pixmap / 1 - Pixmap */
   int         pXSize;
   int         pYSize;
   Pixmap      pPixmap;

/* ################################################################### */
/* Special Features */
   
   /* BorderSize */
   double      borderSize; /* in millimeters */
   /* Frame Border Background Color */
   int         borderColor;
   /* FrameSize */
   double      frameSize;  /* in millimeters */
   /* Color */
   int         color;
   
   /* Horizontal Line */
   double      hline;      /* in millimeters */
   int         hcolor;
   
   /* Vertical Line */
   double      vline;      /* in millimeters */
   int         vcolor;
      
   /* BorderType - 0 QuadBorder - 1 CycleBorder - 2 AllBorders */
   int         borderType;   
      
   /* Picture Position */
   int         pos;

   /* Picture BorderSize */
   double      pborderSize;
   /* Picture Border Background Mode - 0 - Paper - 1 - Transparenz */
   int         pborderColor;
   /* Picture FrameSize */
   double      pframeSize;
   /* Picture Frame Color */
   int         pframeColor;
   /* Picture Transparency */
   int         ptransparenz;

   /* Transparenz Mode */
   int         ptransMode;

/* ################################################################### */

   /* Fontname */
   char        fontName[1024];
   /* Fontsize */
   int         fontSize;
   /* Underline */
   int         fontLine;
   /* Write Direction 0 - east / 1 - south / 2 - west / 3 - north */
   int         fontDirection;
   /* Write Mode 0 - left / 1 - middle / 2 . right */
   int         fontMode;
   /* Font Color */
   int         fontColor;
   
   /* Text */
   char        *fontText;

/* ################################################################### */

   /* Picturenumber ( -1 = no picture ) */
   int         picNr;      /* initialized with -1 */
   
   /* Framename */
   char        name[50];

   /* Special Features */

} framedatas;

/* Init Frame Settings */
void xwInitFrames(void);
/* Free Frame Settings */
void xwFreeFrames(int fNr);
/* Swap Frame */
void xwSwapFrame(int fNrA,int fNrB);

/* ################################################################### */
/* Pixmap Verwaltung */

/* Set Pixmap */
void xwSetFramePixmap(int fNr,Pixmap pixmap);
/* Clear Pixmap */
void xwClearFramePixmap(int fNr);
/* Get Pixmap */
Pixmap xwGetFramePixmap(int fNr);
/* Get Pixmap Datas */
void xwGetFramePMDatas(int fNr,int *w,int *h);
/* Set Pixmap Datas */
void xwSetFramePMDatas(int fNr,int w,int h);

/* ################################################################### */


/* Check Edit Frame */
int xwCheckEditFrame(void);
/* Check Edit Frame */
int xwCheckFrameMode(void);

/* Check and Load Picture */
int xwFPLoad(const char *filename);
/* Draw Frames */
void xwDrawFrame(void);
/* Print any Picture Information */
void xwPrintFrameDatas(int mode,int xsize,int ysize);
/* Create Frame Choice */
void xwCreateFrameChoice(FL_OBJECT *gd);

/*
   Get Frame Datas
*/

/* Get Active Frame */
int xwGetActiveFrame(void);
/* Get Count of Frame */
int xwGetFrameCount(void);
/* Get Active Frame XPos */
int xwGetFrameX(int fNr);
/* Get Frame YPos */
int xwGetFrameY(int fNr);
/* Get Frame XSize */
int xwGetFrameW(int fNr);
/* Get Frame YSize */
int xwGetFrameH(int fNr);
/* Get Select Frame Number */
int xwGetSelectFrame(int xpos,int ypos);
/* Get Frame Picture */
int xwGetFramePicture(int fNr);

/*
   Set Frame Datas
*/

/* Set Active Frame Nr. */
void xwSetActiveFrame(int fNr);
/* Set Active Frame with Picture Nr */
void xwSetActivePicFrame(int fNr);
/* Set Frame Geometry */
void xwSetFrameGeo(int fNr,int xpos,int ypos,int xsize,int ysize);
/* Activate Frame Editor */
void xwActivateFrameEd(void);
/* DeActivate Frame Editor */
void xwDeActivateFrameEd(void);

/* ################################################################### */
/* Border Datas */

/* Get Border Size */
double xwGetFrameB(int fNr);
/* Get Border Color */
int xwGetFrameBC(int fNr);
/* Get Frame Size */
double xwGetFrameF(int fNr);
/* Get Border Color */
int xwGetFrameC(int fNr);
/* Get Border Type */
int xwGetFrameBT(int fNr);
/* Get Picture Border Size */
double xwGetFramePB(int fNr);
/* Get Picture Border Color */
int xwGetFramePBC(int fNr);
/* Get Picture Frame Size */
double xwGetFramePF(int fNr);
/* Get Picture Frame Color */
int xwGetFramePC(int fNr);
/* Get Picture Transparency */
int xwGetFramePT(int fNr);
/* Get Picture Transparency Mode */
int xwGetFramePTM(int fNr);

/*
   Set Border Datas
*/
/* Set Border Size */
void xwSetFrameB(int fNr,double size);
/* Set Border Color */
void xwSetFrameBC(int fNr,int mo);
/* Set Frame Size */
void xwSetFrameF(int fNr,double size);
/* Set Border Color */
void xwSetFrameC(int fNr,int rgb);
/* Set Border Type */
void xwSetFrameBT(int fNr,int mo);
/* Set Picture Border Size */
void xwSetFramePB(int fNr,double size);
/* Set Picture Border Color */
void xwSetFramePBC(int fNr,int mo);
/* Set Picture Frame Size */
void xwSetFramePF(int fNr,double size);
/* Set Picture Border Color */
void xwSetFramePC(int fNr,int rgb);
/* Set Picture Transparency */
void xwSetFramePT(int fNr,int trans);
/* Set Transparency Mode */
void xwSetFramePTM(int fNr,int mo);

/* ################################################################### */
/* Horizontal & Vertical Lines */

/* Get Horizontal Line */
double xwGetHLine(int fNr);
/* Get Horizontal Line Color */
int xwGetHColor(int fNr);
/* Get Vertical Line */
double xwGetVLine(int fNr);
/* Get Vertical Line Color */
int xwGetVColor(int fNr);
/* Set Horizontal Line */
void xwSetHLine(int fNr,double size);
/* Set Horizontal Line Color */
void xwSetHColor(int fNr,int rgb);
/* Set Vertical Line */
void xwSetVLine(int fNr,double size);
/* Set Vertical Line Color */
void xwSetVColor(int fNr,int rgb);

/* ################################################################### */
/* Text & Font Routines */

/* Get Fontname */
char *xwGetFontName(int fNr);
/* Set Fontname */
void xwSetFontName(int fNr,char *fontname);
/* Get Fontsize */
int xwGetFontSize(int fNr);
/* Set Fontsize */
void xwSetFontSize(int fNr,int size);
/* Get Fontline ( 0 - None / 1 - Underline ) */ 
int xwGetFontLine(int fNr);
/* Set Fontline ( 0 - None / 1 - Underline ) */
void xwSetFontLine(int fNr,int line);
/* Get Font-Direction */
int xwGetFontDirection(int fNr);
/* Set Font-Direction */
void xwSetFontDirection(int fNr,int direction);
/* Get Font Mode */
int xwGetFontMode(int fNr);
/* Set Font Mode */
void xwSetFontMode(int fNr,int mo);
/* Get Font Color */
int xwGetFontColor(int fNr);
/* Set Font Color */
void xwSetFontColor(int fNr,int rgb);
/* Get Font Text */
char *xwGetFontText(int fNr);
/* Set Font Text */
void xwSetFontText(int fNr,char *txt);
/* Set Raw Font Text */
void xwSetRawFontText(int fNr,int size,FILE *fh);


/* ################################################################### */
/* Picture Position */

/* Get Picture Position */
int xwGetPicPosition(int fNr);
/* Set Picture Position */
void xwSetPicPosition(int fNr,int pos);

/*
   Page Information Routines
*/

/* Get lowest X-Frame-Position */
int xwGetLowXFrame(void);
/* Get lowest Y-Frame-Position */
int xwGetLowYFrame(void);
/* Get highest X-Frame-Position */
int xwGetHighXFrame(void);
/* Get highest Y-Frame-Position */
int xwGetHighYFrame(void);
/*
   Frame Creation and Modification
*/

/* Add Frame */
void xwAddFrame(void);
/* Frame Trashcan */
void xwFPFrameTrash(void);

/* Reorg Picture Entrys - az -actual frame */
void xwReorgPic(int az);

/* MoveFrameToBack */
void xwMoveFrameToBack(void);
/* MoveFrameToFront */
void xwMoveFrameToFront(void);
/* Rotate Frame Picture */
void xwRotatePicInFrame(int direction);

/* Resize Frame */
void  xwFrameResize(int mode);
/* Exchange Frames */
void xwExchangeFrame(int az,int bz);

/* Move Frame */
void  xwFrameMove(int xpos,int ypos);

/* View Frame Picture */
void xwViewFramePicture(void);

#endif