/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWFONT_H
#define _XWFONT_H

#include <forms.h>

#include <t1lib.h>

#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>

#define  xwfNone           0
#define  xwfUnderline      1

#define  xwfFontTest       "1aA2bB3cC4dD5eE6fF7gG8hH9iI$&%?jJkKlLmMnNoOpPqQrRsStTuUvVwWxXyYzZ"

#define  xwfSelect         0
#define xwfConfig          1

typedef struct fontentry
{
   char              name[256];
   int               ID;
   int               FNT;
} fontentry;

typedef struct fontform
{
   /* Main-Form data */
   FL_FORM           *form;
   /* Event Loop */
   FL_OBJECT         *obj;
   int               ready;
   
   FL_OBJECT         *tab;
   
   FL_OBJECT         *OK;
   
   FL_OBJECT         *Abort;
} fontform;

typedef struct fontformA
{
   /* Main-Form data */
   FL_FORM           *form;
   /* Event Loop */
   FL_OBJECT         *obj;
   int               ready;
   
   FL_OBJECT         *Box;
   
   FL_OBJECT         *FontBrowser;
   FL_OBJECT         *FontSize;
   FL_OBJECT         *Underline;
   
   FL_OBJECT         *FontBorder;
   FL_OBJECT         *FontView;
   
   FL_OBJECT         *FontText;
} fontformA;

typedef struct fontformB
{
   /* Main-Form data */
   FL_FORM           *form;
   /* Event Loop */
   FL_OBJECT         *obj;
   int               ready;
   
   FL_OBJECT         *Box;
   
   FL_OBJECT         *browser;
   
   FL_OBJECT         *afmDir;
   FL_OBJECT         *afmSelect;
   
   FL_OBJECT         *typeDir;
   FL_OBJECT         *typeSelect;
   
   FL_OBJECT         *encDir;
   FL_OBJECT         *encSelect;
   
   FL_OBJECT         *encFile;
   FL_OBJECT         *encFileSelect;
   
   FL_OBJECT         *fontbase;
} fontformB;

typedef struct fontlistform
{
   /* Main-Form data */
   FL_FORM           *form;
   /* Event Loop */
   FL_OBJECT         *obj;
   int               ready;
   
   FL_OBJECT         *browser;
   FL_OBJECT         *OK;
} fontlistform;

/* Init Font Support */
void xwFontInit(int mo);

/* Open Font */
void xwOpenFont(void);
/* Remove all T1 Datas */
void xwRemoveFont(void);

/* Font Editor */
int xwRenderText(int font,int size,int dpi,int flag,char *txt);

/* Font Selector */
int xwFontSelect(int mo,char *fontname,int *size,int *flag);
/* Refresh Handler */
int xwFontSelectHandler(FL_OBJECT *obj,int event,FL_Coord mx,FL_Coord my,int key,void *xev);
/* draw font example */
void xwDrawFont(void);
void xwTabFormA(FL_OBJECT *obj,void *d);
void xwTabFormB(FL_OBJECT *obj,void *d);

/* get font ID */
int xwGetFontID(char *font);
/* display fontlist */
int xwDisplayFontList(FL_OBJECT *obj,char *font);
/* remove fontlist */
void xwRemoveFontList(void);

/* add fontentry */
void xwAddFontList(char *font,int ID);
/*  get list of fonts */
void xwGetFontList(int mo);
/* sort fontlist */
int xwFontSort(const void *z1,const void *z2);

#endif