/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "font.h"

#include "base.h"
#include "default.h"
#include "fileselect.h"
#include "gfx.h"
#include "handler.h"
#include "interpreter.h"
#include "limits.h"
#include "main_gui.h"
#include "resource.h"

static struct fontentry *fe[2048];
int                     feAnz;

struct fontform         ff;
struct fontformA        ffa;
struct fontformB        ffb;
struct fontlistform     flf;

static char             feFontName[256];
static int              feFontSize;
static int              feUnderline;

static int              xwFontSelectHandlerLock;

static char             feFontText[1024];

static int              t1Lib=0;
static int              t1DPI=0;

/* Init Font Support */
void xwFontInit(int mo)
{
   DIR               *dirz;
   struct dirent     *direntz;
   struct stat       attribut;
   struct stat       attribB;

   FILE              *fh;

   char              pathA[1024],pathB[1024];
   char              fontname[256];
   char              *strptr;

   int               count;
   int               afmCount;

   strcpy(feFontText,"1aA2bB3cC4dD5eE6fF7gG8hH9iI$&%?jJkKlLmMnNoOpPqQrRsStTuUvVwWxXyYzZ");

   /* initialize font-list */
   for (count=0 ; count<2048 ; count++)
   {
      fe[count]=NULL;
   }
   feAnz=-1;

   /* create FontDataBase */
   strcpy(pathA,xwGetPrefName(xwgAFM));

   fh=fopen(xwGetFile("","etc/FontDataBase"),"w");
   if (fh!=NULL)
   {
      afmCount=0;
      for (count=0 ; count<2 ; count++)
      {
         if ( (dirz = opendir(pathA)) != NULL )
         {
            while ( (direntz = readdir(dirz)) != NULL)
            {
               strcpy(pathB,pathA);
               strcat(pathB,"/");
               strcat(pathB,direntz->d_name);

               strcpy(fontname,"");
               if ( stat(pathB,&attribut) == 0)
               {
                  if (lstat(pathB,&attribB) == 0)
                  {
                     if (S_ISLNK(attribB.st_mode))
                     {
                        if (S_ISREG(attribut.st_mode))
                        {
                           /* afm files */
                           strcpy(fontname,direntz->d_name);
                        }
                     }
                     else
                     {
                        if (S_ISREG(attribut.st_mode))
                        {
                           /* afm files */
                           strcpy(fontname,direntz->d_name);
                        }
                     }
                  }
               }

               /* check font name */
               if (strlen(fontname)>4)
               {
                  strptr=fontname;
                  strptr=strptr+(strlen(fontname)-4);

                  if (strcmp(strptr,".afm") == 0)
                  {
                     if (count==0)
                     {
                        afmCount++;
                     }
                     else if (count==1)
                     {
                        fputs(fontname,fh);
                        fputs("\n",fh);
                     }
                  }
               }

            }
            closedir(dirz);

            if (count==0)
            {
               fputs(IntStr(afmCount),fh);
               fputs("\n",fh);
            }
         }
      }
      fclose(fh);
   }

   /* create t1config file */
   fh=fopen(xwGetFile("","etc/t1lib.config"),"w");
   if (fh!=NULL)
   {
      fputs("This is a configuration file for t1lib\n\n",fh);

      fputs("FONTDATABASE=",fh);
      fputs(xwGetFile("","etc/FontDataBase"),fh);
      fputs("\n",fh);

      fputs("ENCODING=",fh);
      fputs(xwGetPrefName(xwgEnc),fh);
      fputs(":.\n",fh);

      fputs("AFM=",fh);
      fputs(xwGetPrefName(xwgAFM),fh);
      fputs(":.\n",fh);

      fputs("TYPE1=",fh);
      fputs(xwGetPrefName(xwgType1),fh);
      fputs(":.\n",fh);

      fclose(fh);
   }

   /* create font list */
   xwGetFontList(mo);

   if (mo==0)
   {      
      xwOpenFont();   
      
      T1_SetFontDataBase(xwGetFile("","etc/FontDataBase"));
      T1_SetFileSearchPath(T1_AFM_PATH,xwGetPrefName(xwgAFM));
      T1_SetFileSearchPath(T1_PFAB_PATH,xwGetPrefName(xwgType1));
      T1_SetFileSearchPath(T1_ENC_PATH,xwGetPrefName(xwgEnc));   
               
      xwRemoveFont();
   }  
    
   return;
}

/* Open Font */
void xwOpenFont(void)
{
   if (t1Lib==0)
   {
      /* pad bitmaps to 16 bits, the default being 8 bits */
      T1_SetBitmapPad(8);

      /* initialize t1lib */
      if (T1_InitLib(NO_LOGFILE)!=NULL)
      {
         t1Lib=1;
      }
   }
   
   return;
}

/* Remove all T1 Datas */
void xwRemoveFont(void)
{
   int            count;
   
   if (t1Lib>0)
   {
      T1_CloseLib();
      t1Lib=0;
   
      for (count=0 ; count<=feAnz ; count++)
      {
         fe[count]->FNT=0;
      }
   }
   
   return;
}


/* get bitmap from Font */
int xwRenderText(int font,int size,int dpi,int flag,char *txt)
{
   char              astr[1024];

   GLYPH             *glyph;

   int               fontSize;
   int               fontBase;

   int               w,h;
   int               x,y;

   int               row;
   int               pitch;

   div_t             calc;
   int               bytes;

   unsigned char     byte;

   char              **enc;

   if ((txt!=NULL) && (strlen(txt)>0) && (feAnz>=font))
   {
      strcpy(astr,"T1LIB_CONFIG=");
      strcat(astr,xwGetFile("","etc/t1lib.config"));
      putenv(astr);

      xwOpenFont();

      if (dpi!=t1DPI)
      {
         xwRemoveFont();
         xwOpenFont();
      }  

      /* initialize t1lib */
      if (t1Lib==1)
      {    
         T1_SetDeviceResolutions(dpi,dpi);
         t1DPI=dpi;

         if (fe[font]->FNT==0)
         {
            /* encoding */
            if (T1_LoadFont(font)==0)
            {
               if (strlen(xwGetPrefName(xwgEncFile))>0)
               {
                  enc=T1_LoadEncoding(xwGetPrefName(xwgEncFile));
                  if (enc!=NULL)
                  {
                     T1_ReencodeFont(font,enc);
                     fe[font]->FNT=1;
                  }
                  else
                  {
                     printf("xwGUI2: encoding failed !!!\n");
                  }
               }
            }
            else
            {
               printf("xwGUI2: can't load font\n");
            }
         }
         else
         {
            T1_SetDeviceResolutions(dpi,dpi);
            
            /* encoding */
            if (T1_LoadFont(font)==0)
            {
               if (strlen(xwGetPrefName(xwgEncFile))>0)
               {            
                  enc=T1_LoadEncoding(xwGetPrefName(xwgEncFile));
                  if (enc!=NULL)
                  {
                     T1_ReencodeFont(font,enc);
                     fe[font]->FNT=1;
                  }
                  else
                  {
                     printf("xwGUI2: encoding failed !!!\n");
                  }
               }
            }
            else
            {
               printf("xwGUI2: can't load font\n");
            }
            
         }

         glyph=T1_SetString(font,"|hHiIjJxXpP",0,0,T1_KERNING,size,NULL);
         if (glyph!=NULL)
         {
            fontSize=glyph->metrics.ascent-glyph->metrics.descent;      /* height of glyph */
            fontBase=glyph->metrics.descent;                            /* baseline position */

            if (flag==xwfUnderline)
            {
               glyph=T1_SetString(font,txt,0,0,T1_KERNING|T1_UNDERLINE,size,NULL);
            }
            else
            {
               glyph=T1_SetString(font,txt,0,0,T1_KERNING,size,NULL);
            }

            /* calculate size of RGB Bitmap */
            w=glyph->metrics.rightSideBearing-glyph->metrics.leftSideBearing;    /* width of Bitmap */
            h=glyph->metrics.ascent-glyph->metrics.descent;                      /* height of bitmap */
            x=glyph->metrics.leftSideBearing;                                    /* left position offset */
            y=(fontSize+fontBase)-glyph->metrics.ascent;                         /* top position offset */

            /* reserve picture bitmap */
            if (xwGFXCreatePicture(glyph->metrics.advanceX,fontSize)==xwTrue)
            {
               calc=div(w,8);
               bytes=calc.quot;
               if (calc.rem>0) bytes++;

               /*T1_DumpGlyph(glyph);*/

               for (row=0 ; row<h ; row++)
               {
                  for (pitch=0 ; pitch<bytes ; pitch++)
                  {
                     byte=glyph->bits[(row*bytes)+pitch];

                     if (byte>=128) { byte=byte-128; xwGFXSetPixel(memPicture,x+7+(pitch*8),y+row,0,0,0); }
                     if (byte>= 64) { byte=byte- 64; xwGFXSetPixel(memPicture,x+6+(pitch*8),y+row,0,0,0); }
                     if (byte>= 32) { byte=byte- 32; xwGFXSetPixel(memPicture,x+5+(pitch*8),y+row,0,0,0); }
                     if (byte>= 16) { byte=byte- 16; xwGFXSetPixel(memPicture,x+4+(pitch*8),y+row,0,0,0); }
                     if (byte>=  8) { byte=byte-  8; xwGFXSetPixel(memPicture,x+3+(pitch*8),y+row,0,0,0); }
                     if (byte>=  4) { byte=byte-  4; xwGFXSetPixel(memPicture,x+2+(pitch*8),y+row,0,0,0); }
                     if (byte>=  2) { byte=byte-  2; xwGFXSetPixel(memPicture,x+1+(pitch*8),y+row,0,0,0); }
                     if (byte>=  1) { byte=byte-  1; xwGFXSetPixel(memPicture,x+  (pitch*8),y+row,0,0,0); }
                  }
               }
            }
            else
            {
               return(xwFalse);
            }
         }
         else
         {
            return(xwFalse);
         }

         /* close library and remove all data */
         /* T1_CloseLib(); */
      }
      else
      {
         printf("xwGUI2: Can't initialize Type1 library !!!\n");

         return(xwFalse);
      }

      return(xwTrue);
   }
   else
   {
      return(xwFalse);
   }
}

/* Font Selector */
int xwFontSelect(int mo,char *fontname,int *size,int *flag)
{
   int               fNr;

   xwGFXCreateTemp(626,221);

   strcpy(feFontName,fontname);
   feFontSize=*size;
   feUnderline=*flag;

   /* first gui for font selection */
   ffa.form = NULL;

   ffa.form = fl_bgn_form(FL_NO_BOX,638,460);

   fl_set_border_width(1);

   ffa.Box=fl_add_box(FL_FLAT_BOX,0,0,638,460,"");

   /* 628 /2 = 314 - 6 = 311 */
   ffa.FontBrowser=fl_add_browser(FL_HOLD_BROWSER,5,5,628,175,"");
   fl_set_browser_fontstyle(ffa.FontBrowser,FL_FIXED_STYLE);
   fNr=xwDisplayFontList(ffa.FontBrowser,feFontName);
   if (fNr>-1)
      strcpy(feFontName,fe[fNr]->name);
   else
      strcpy(feFontName,"");

   /* Fontsize */
   ffa.FontSize=fl_add_counter(FL_NORMAL_COUNTER,109,185,200,20,xwGR(1,"fnt.Size","FontSize:"));
   fl_set_counter_precision(ffa.FontSize,0);
   fl_set_counter_bounds(ffa.FontSize,8,200);
   fl_set_counter_step(ffa.FontSize,1,10);
   fl_set_counter_value(ffa.FontSize,feFontSize);
   fl_set_object_lalign(ffa.FontSize,FL_ALIGN_LEFT);
   
   /* Underline */
   ffa.Underline=fl_add_lightbutton(FL_PUSH_BUTTON,329,185,200,20,xwGR(1,"fnt.Underline","Underline"));
   if (feUnderline>0) fl_set_button(ffa.Underline,1);

   /* Font Border */
   ffa.FontBorder=fl_add_frame(FL_DOWN_FRAME,5+1,210+1,628-2,223-2,"");
   xwFontSelectHandlerLock=0;
   fl_set_object_posthandler(ffa.FontBorder,xwFontSelectHandler);

   /* Font Text */
   ffa.FontText=fl_add_input(FL_NORMAL_INPUT,5,433,628,20,"");
   fl_set_input_return(ffa.FontText,FL_RETURN_CHANGED);
   fl_set_input(ffa.FontText,feFontText);

   fl_end_form();
   fl_set_form_callback(ffa.form,xwTabFormA,0);

   /* second gui for configuration */
   ffb.form = NULL;

   ffb.form = fl_bgn_form(FL_NO_BOX,638,455);

   fl_set_border_width(1);

   ffb.Box=fl_add_box(FL_FLAT_BOX,0,0,638,455,"");

   /* 130 */
   ffb.browser=fl_add_browser(FL_HOLD_BROWSER,5,5,628,320,"");
   fl_set_browser_fontstyle(ffb.browser,FL_FIXED_STYLE);

   ffb.afmDir=fl_add_input(FL_NORMAL_INPUT,110,5+330,503,20,xwGR(1,"fnt.AFMDir","AFM-Directory:"));
   fl_set_input_return(ffb.afmDir,FL_RETURN_CHANGED);
   fl_set_input(ffb.afmDir,xwGetPrefName(xwgAFM));
   ffb.afmSelect=fl_add_button(FL_NORMAL_BUTTON,613,5+330,20,20,"@6<");

   ffb.typeDir=fl_add_input(FL_NORMAL_INPUT,110,30+330,503,20,xwGR(1,"fnt.TypeDir","Type1-Directory:"));
   fl_set_input_return(ffb.typeDir,FL_RETURN_CHANGED);
   fl_set_input(ffb.typeDir,xwGetPrefName(xwgType1));
   ffb.typeSelect=fl_add_button(FL_NORMAL_BUTTON,613,30+330,20,20,"@6<");

   ffb.encDir=fl_add_input(FL_NORMAL_INPUT,110,55+330,503,20,xwGR(1,"fnt.EncDir","Encoding-Directory:"));
   fl_set_input_return(ffb.encDir,FL_RETURN_CHANGED);
   fl_set_input(ffb.encDir,xwGetPrefName(xwgEnc));
   ffb.encSelect=fl_add_button(FL_NORMAL_BUTTON,613,55+330,20,20,"@6<");


   ffb.encFile=fl_add_input(FL_NORMAL_INPUT,110,80+330,503,20,xwGR(1,"fnt.EncFile","Encoding-File:"));
   fl_set_input_return(ffb.encFile,FL_RETURN_CHANGED);
   fl_set_input(ffb.encFile,xwGetPrefName(xwgEncFile));
   ffb.encFileSelect=fl_add_button(FL_NORMAL_BUTTON,613,80+330,20,20,"@6<");

   ffb.fontbase=fl_add_button(FL_NORMAL_BUTTON,219,105+330,200,20,xwGR(1,"fnt.useconfig","Use Configuration"));

   fl_end_form();
   fl_set_form_callback(ffb.form,xwTabFormB,0);

   /* main gui */
   ff.form = NULL;
   ff.form = fl_bgn_form(FL_UP_BOX,650,520);

   fl_set_border_width(1);

   ff.tab=fl_add_tabfolder(FL_TOP_TABFOLDER,5,5,640,485,"");
   fl_addto_tabfolder(ff.tab,xwGR(1,"fnt.Selection","Selection"),ffa.form);
   fl_addto_tabfolder(ff.tab,xwGR(1,"fnt.Setting","Settings"),ffb.form);

   /* 325 */
   ff.OK=fl_add_button(FL_NORMAL_BUTTON,215,495,100,20,xwGR(1,"fnt.OK","OK"));
   ff.Abort=fl_add_button(FL_NORMAL_BUTTON,335,495,100,20,xwGR(1,"fnt.Abort","Cancel"));

   fl_end_form();

   if (xwGetPrefValue(xwgWinPos)==0)
   {
      fl_prepare_form_window(ff.form,FL_PLACE_MOUSE,FL_TRANSIENT,"");
   }
   else
   {
      fl_prepare_form_window(ff.form,FL_PLACE_CENTER,FL_TRANSIENT,"");
   }

   /* Starts in Config Mode */
   if (mo==xwfConfig)
   {
      fl_set_folder(ff.tab,ffb.form);
   }

   /* Display Window */
   fl_show_form_window(ff.form);

   fl_set_app_mainform(ff.form);

   /* Exit Handler */
   fl_set_form_atclose(ff.form,nclose_cb,(void *) "1");

   ff.ready=0;
   while (ff.ready==0)
   {
      ff.obj=fl_do_forms();

      /* OK */
      if (ff.obj==ff.OK)
      {
         ff.ready=-1;
      }
      /* Abort */
      else if (ff.obj==ff.Abort)
      {
         ff.ready=1;
      }
   }

   fl_hide_form(ff.form);
   fl_free_form(ff.form);
   fl_free_form(ffa.form);
   fl_free_form(ffb.form);
   ff.form=NULL;

   /*fl_set_app_mainform(xwGetMainGui());*/

   xwGFXRemoveTemp();

   if (ff.ready==-1)
   {
      strcpy(fontname,feFontName);
      *size=feFontSize;
      *flag=feUnderline;
      return(xwTrue);
   }
   else
   {
      return(xwFalse);
   }
   
   return(xwTrue);
}

/* Refresh Handler */
int xwFontSelectHandler(FL_OBJECT *obj,int event,FL_Coord mx,FL_Coord my,int key,void *xev) /*fold00*/
{
   if (xwFontSelectHandlerLock==0)
   {
      xwFontSelectHandlerLock=1;

      if (event==FL_DRAW)
      {
         xwDrawFont();
      }

      xwFontSelectHandlerLock=0;
   }

   return(0);
}

/* draw font example */
void xwDrawFont(void)
{
   Pixmap         pixmap;

   fl_winset(ffa.form->window);

   fl_rectf(6,236-25,626,221,FL_WHITE);

   xwGFXCreateTemp(626,221);

   xwGFXSetTextColor(0,0,0);
   if (xwRenderText(xwGetFontID(feFontName),feFontSize,72,feUnderline,feFontText)==xwTrue)
   {
      /* Set Transparenz */
      xwGFXSetTrans(0);

      /* Set Transparenz Mode */
      xwGFXSetTransMode(0);

      xwGFXCopyPicture(memPicture,memTemp,0,0);

      pixmap=xwGFXCreatePixmap(memTemp);

      XCopyArea(fl_display,pixmap,ffa.form->window,fl_get_gc(),0,0,626,221,6,236-25);

      fl_free_pixmap(pixmap); /* ??? */

      xwGFXRemovePicture();
   }

   return;
}

void xwTabFormA(FL_OBJECT *obj,void *d)
{
   /* Font Type */
   if (obj==ffa.FontBrowser)
   {
      if (fl_get_browser(ffa.FontBrowser)>0)
      {
         strcpy(feFontName,fl_get_browser_line(ffa.FontBrowser,fl_get_browser(ffa.FontBrowser)));
         xwDrawFont();
      }
   }

   /* FontSize */
   else if (obj==ffa.FontSize)
   {
      feFontSize=fl_get_counter_value(ffa.FontSize);
      xwDrawFont();
   }
   
   /* Underline */
   else if (obj==ffa.Underline)
   {
      feUnderline=fl_get_button(ffa.Underline);
      xwDrawFont();   
   }
   
   /* Font Text */
   else if (obj==ffa.FontText)
   {
      strcpy(feFontText,fl_get_input(ffa.FontText));
      xwDrawFont();
   }

   return;
}

void xwTabFormB(FL_OBJECT *obj,void *d)
{
   char           astr[1024];
   char           bstr[1024];
   char           cstr[1024];

   char           *strptr;

   int            fNr;
      
   /* AFM */
   if (obj==ffb.afmDir)
   {
      strcpy(astr,fl_get_input(ffb.afmDir));
      if (strlen(astr)>0) xwSetPrefName(xwgAFM,astr);
   }
   /* AFM Select */
   else if (obj==ffb.afmSelect)
   {
      fl_deactivate_form(ff.form);

      xwSetFSPath(xwGetPrefName(xwgAFM));
      xwSetFSPattern("afm");
      strcpy(astr,xwGR(1,"frm.SelectAFMPath","Select an AFM-Path, please..."));
      strcpy(bstr,xwGR(1,"frm.OK","OK"));
      strcpy(cstr,xwGR(1,"frm.Abort","Abort"));

      strptr=xwFileSelect(fsPath,"",astr,bstr,cstr);
      if ((strptr!=NULL) && (strlen(strptr)))
      {
         fl_set_input(ffb.afmDir,strptr);
         xwSetPrefName(xwgAFM,strptr);
      }

      fl_activate_form(ff.form);
   }
   /* Type1 */
   else if (obj==ffb.typeDir)
   {
      strcpy(astr,fl_get_input(ffb.typeDir));
      if (strlen(astr)>0) xwSetPrefName(xwgType1,astr);
   }
   /* Type1 Select */
   else if (obj==ffb.typeSelect)
   {
      fl_deactivate_form(ff.form);

      xwSetFSPath(xwGetPrefName(xwgType1));
      xwSetFSPattern("pfa,pfb");
      strcpy(astr,xwGR(1,"frm.SelectType1Path","Select an Type1-Path, please..."));
      strcpy(bstr,xwGR(1,"frm.OK","OK"));
      strcpy(cstr,xwGR(1,"frm.Abort","Abort"));

      strptr=xwFileSelect(fsPath,"",astr,bstr,cstr);
      if ((strptr!=NULL) && (strlen(strptr)))
      {
         fl_set_input(ffb.typeDir,strptr);
         xwSetPrefName(xwgType1,strptr);
      }

      fl_activate_form(ff.form);
   }
   /* Enc */
   else if (obj==ffb.encDir)
   {
      strcpy(astr,fl_get_input(ffb.encDir));
      if (strlen(astr)>0) xwSetPrefName(xwgEnc,astr);
   }
   /* ENC Select */
   else if (obj==ffb.encSelect)
   {
      fl_deactivate_form(ff.form);

      xwSetFSPath(xwGetPrefName(xwgEnc));
      xwSetFSPattern("enc,enc.gz");
      strcpy(astr,xwGR(1,"frm.SelectEncPath","Select an Encoding-Path, please..."));
      strcpy(bstr,xwGR(1,"frm.OK","OK"));
      strcpy(cstr,xwGR(1,"frm.Abort","Abort"));

      strptr=xwFileSelect(fsPath,"",astr,bstr,cstr);
      if ((strptr!=NULL) && (strlen(strptr)))
      {
         fl_set_input(ffb.encDir,strptr);
         xwSetPrefName(xwgEnc,strptr);
      }

      fl_activate_form(ff.form);
   }
   /* EncFile */
   else if (obj==ffb.encFile)
   {
      strcpy(astr,fl_get_input(ffb.encFile));
      if (strlen(astr)>0) xwSetPrefName(xwgEncFile,astr);
   }
   /* EncFile Select */
   else if (obj==ffb.encFileSelect)
   {
      fl_deactivate_form(ff.form);

      xwSetFSPath(xwGetPrefName(xwgEnc));
      xwSetFSPattern("enc,enc.gz");
      strcpy(astr,xwGR(1,"frm.SelectEncFile","Select an Encoding-File, please..."));
      strcpy(bstr,xwGR(1,"frm.OK","OK"));
      strcpy(cstr,xwGR(1,"frm.Abort","Abort"));

      strptr=xwFileSelect(fsFile,"",astr,bstr,cstr);
      if ((strptr!=NULL) && (strlen(strptr)))
      {
         strptr=strrchr(strptr,'/');
         strptr++;

         fl_set_input(ffb.encFile,strptr);
         xwSetPrefName(xwgEncFile,strptr);
      }

      fl_activate_form(ff.form);
   }
   /* FontBase */
   else if (obj==ffb.fontbase)
   {
      fl_deactivate_form(ff.form);
      xwRemoveFontList();
      fl_clear_browser(ffb.browser);
      xwFontInit(1);
      fNr=xwDisplayFontList(ffa.FontBrowser,feFontName);
      if (fNr>-1)
         strcpy(feFontName,fe[fNr]->name);
      else
         strcpy(feFontName,"");
         
      xwOpenFont();   
       
      /* Update T1Lib Datas */
      /* 
      T1_AddFontDataBase(T1_APPEND_PATH,xwGetFile("","etc/FontDataBase"));
      T1_AddToFileSearchPath(T1_AFM_PATH,T1_APPEND_PATH,xwGetPrefName(xwgAFM));
      T1_AddToFileSearchPath(T1_PFAB_PATH,T1_APPEND_PATH,xwGetPrefName(xwgType1));
      T1_AddToFileSearchPath(T1_ENC_PATH,T1_APPEND_PATH,xwGetPrefName(xwgEnc));
      */
      
      T1_SetFontDataBase(xwGetFile("","etc/FontDataBase"));
      T1_SetFileSearchPath(T1_AFM_PATH,xwGetPrefName(xwgAFM));
      T1_SetFileSearchPath(T1_PFAB_PATH,xwGetPrefName(xwgType1));
      T1_SetFileSearchPath(T1_ENC_PATH,xwGetPrefName(xwgEnc));   
               
      xwRemoveFont();
      
      fl_activate_form(ff.form);
   }

   return;
}

/* get font ID */
int xwGetFontID(char *font)
{
   int               ID;
   int               count;

   ID=0;
   if (feAnz>-1)
   {
      for (count=0 ; count<=feAnz ; count++)
      {
         if ((strlen(font)>0) && (strcmp(fe[count]->name,font) == 0))
         {
            ID=fe[count]->ID;
         }
      }
   }

   return(ID);
}

/* display fontlist */
int xwDisplayFontList(FL_OBJECT *obj,char *font)
{
   int               count;
   int               brw;

   fl_clear_browser(obj);

   brw=-1;
   for (count=0 ; count<=feAnz ; count++)
   {   
      fl_add_browser_line(obj,fe[count]->name);

      if ((strlen(font)>0) && (strcmp(fe[count]->name,font) == 0))
      {
         fl_select_browser_line(obj,count+1);
         brw=count;
         fl_set_browser_topline(obj,count+1);
      }
   }
   if ((feAnz>-1) && (brw==-1))
   {
      brw=0;
      fl_select_browser_line(obj,brw+1);
      fl_set_browser_topline(obj,brw+1);
   }

   return(brw);
}

/* remove fontlist */
void xwRemoveFontList(void)
{
   int               count;

   /* remove old font list */
   if (feAnz>-1)
   {
      for (count=0 ; count<=feAnz ; count++)
      {
         free(fe[count]);
         fe[count]=NULL;
      }
   }
   feAnz=-1;

   return;
}

/* add fontentry */
void xwAddFontList(char *font,int ID)
{
   feAnz++;
   if (feAnz<2048)
   {
      fe[feAnz]=malloc(sizeof(fontentry));
      if (fe[feAnz]!=NULL)
      {
         fe[feAnz]->ID=ID;
         strcpy(fe[feAnz]->name,font);
         fe[feAnz]->FNT=0;
      }
   }
   else
   {
      feAnz--;
   }

   return;
}

/*  get list of fonts */
void xwGetFontList(int mo)
{
   char              astr[1024];
   char              bstr[1024];
   int               count;
   FILE              *fh;

   xwRemoveFont();

   strcpy(astr,"T1LIB_CONFIG=");
   strcat(astr,xwGetFile("","etc/t1lib.config"));
   putenv(astr);

   /* remove old font list */
   if (feAnz>-1)
   {
      for (count=0 ; count<=feAnz ; count++)
      {
         free(fe[count]);
         fe[count]=NULL;
      }
   }
   feAnz=-1;

   /* load existing fontlist */
   strcpy(bstr,xwGetFile("","etc/fontbase.list"));
   if ( (xwExist(bstr)==xwTrue) && (mo==0) )
   {
      xwInterpret(bstr,NULL);
   }
   else
   {
      if (mo==0)
      {
         flf.form = NULL;

         flf.form = fl_bgn_form(FL_UP_BOX,600,400);

         fl_set_border_width(1);

         flf.browser=fl_add_browser(FL_NORMAL_BROWSER,5,5,590,365,"");
         fl_set_browser_fontstyle(flf.browser,FL_FIXED_STYLE);
      
         /* 319 */
         flf.OK=fl_add_button(FL_NORMAL_BUTTON,250,375,100,20,"OK");
         fl_hide_object(flf.OK);

         fl_end_form();

         if (xwGetPrefValue(xwgWinPos)==0)
         {
            fl_prepare_form_window(flf.form,FL_PLACE_MOUSE,FL_TRANSIENT,xwGR(1,"fnt.getname","Create Font List..."));
         }
         else
         {
            fl_prepare_form_window(flf.form,FL_PLACE_CENTER,FL_TRANSIENT,xwGR(1,"fnt.getname","Create Font List..."));
         }

         /* Display Window */
         fl_show_form_window(flf.form);

         fl_set_app_mainform(flf.form);

         /* Exit Handler */
         fl_set_form_atclose(flf.form,nclose_cb,(void *) "1");
      }
      
      /* initialize t1lib */
      if (T1_InitLib(NO_LOGFILE)!=NULL) T1_CloseLib();
      if (T1_InitLib(NO_LOGFILE)!=NULL)
      {
         strcpy(astr,"Number of Fonts: ");
         strcat(astr,IntStr(T1_Get_no_fonts()));
         
         if (mo==0)
         {
            fl_addto_browser(flf.browser,astr);
         }
         else
         {
            fl_addto_browser(ffb.browser,astr);
         }         
         
         for(count=0 ; count<T1_Get_no_fonts() ; count++)
         {
            flf.obj=fl_check_forms();
         
            if (T1_LoadFont(count)==0)
            {
               if (T1_GetFontName(count)!=NULL)
               {
                  fe[count]=malloc(sizeof(fontentry));
                  if (fe[count]!=NULL)
                  {
                     fe[count]->ID=count;
                     strcpy(fe[count]->name,T1_GetFontName(count));
                     strcpy(astr,IntStr(count+1));
                     strcat(astr," ");
                     strcat(astr,fe[count]->name);
                     if (mo==0)
                     {
                        fl_addto_browser(flf.browser,astr);
                     }
                     else
                     {
                        fl_addto_browser(ffb.browser,astr);
                     }                     
                     
                     feAnz++;
                  }
               }
               T1_DeleteFont(count);
            }
         }

         /* close library and remove all data */
         T1_CloseLib();
      }

      if (feAnz>=0);
      {
         /* sort fontlist */
         qsort(fe,feAnz+1,sizeof(fe[0]),xwFontSort);

         /* save fontlist for SpeedUp */
         fh=fopen(xwGetFile("","etc/fontbase.list"),"w");
         if (fh!=NULL)
         {
            fputs("# xwGUI FontBase File\n",fh);
            fputs("# written by xwGUI\n",fh);
            fputs("# (c) by Stefan Kraus\n",fh);
            fputs("# License: GPL\n\n",fh);
            fputs("FONTFILE\n",fh);

            for (count=0 ; count<=feAnz ; count++)
            {
               fputs(" FONT ",fh);
               fputs("\"",fh);
               fputs(fe[count]->name,fh);
               fputs("\" ",fh);
               fputs(IntStr(fe[count]->ID),fh);
               fputs("\n",fh);
            }

            fputs("END\n",fh);

            fclose(fh);
         }
      }
      
      if (mo==0)
      {
         fl_addto_browser(flf.browser,"---------------------------------------------------------------------------------------------");
      }
      else
      {
         fl_addto_browser(ffb.browser,"---------------------------------------------------------------------------------------------");
      }
      strcpy(astr,xwGR(1,"fnt.count","Count of Fonts:"));
      strcat(astr," ");
      if (feAnz>=0)
      {
         strcat(astr,IntStr(feAnz+1));
      }
      else
      {
         strcat(astr,"0");
      }
      if (mo==0)
      {
         fl_addto_browser(flf.browser,astr);      
         fl_addto_browser(flf.browser,xwGR(1,"fnt.ready","Ready"));
         
         fl_show_object(flf.OK);
         
         flf.ready=0;
         while (flf.ready==0)
         {
            flf.obj=fl_do_forms();

            /* OK */
            if (flf.obj==flf.OK)
            {
               flf.ready=-1;
            }
         }

         fl_hide_form(flf.form);
         fl_free_form(flf.form);
         flf.form=NULL;
      }
      else
      {
         fl_addto_browser(ffb.browser,astr);      
         fl_addto_browser(ffb.browser,xwGR(1,"fnt.ready","Ready"));
      }
   }

   xwOpenFont();

   return;
}

/* sort fontlist */
int xwFontSort(const void *z1,const void *z2)
{
   char              **Z1=(const char **) z1;
   char              **Z2=(const char **) z2;
   char              aas[256],bbs[256];

   strcpy(aas,*Z1);
   strcpy(bbs,*Z2);

   return(strcmp(aas,bbs));
}