/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWFILESELECT_H
#define _XWFILESELECT_H

#include <forms.h>

#include <string.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>
#include <ctype.h>

#ifndef fsFile
#define fsFile       0
#endif
#ifndef fsPath
#define fsPath       1
#endif
#ifndef fsFileAll
#define fsFileAll    2
#endif
#ifndef fsPathAll
#define fsPathAll    3
#endif

#ifndef fsLock
#define fsLock       0
#endif
#ifndef fsView
#define fsView       1
#endif

#ifndef fsLine
#define fsLine       "................................................................................"
#endif

typedef struct fileform
{
   /* Main-Form data */
   FL_FORM           *form;
   /* Event Loop */
   FL_OBJECT         *obj;
   int               ready;
   
   FL_OBJECT         *History;
   
   FL_OBJECT         *DirBrowser;
   FL_OBJECT         *DirInput;
   FL_OBJECT         *FileBrowser;
   FL_OBJECT         *FileInput;
   
   FL_OBJECT         *Root;
   FL_OBJECT         *Home;
   FL_OBJECT         *CButton;
   
   FL_OBJECT         *FTBrowser;
   
   FL_OBJECT         *MakeDir;
   FL_OBJECT         *Delete;
   
   FL_OBJECT         *FileSort;
   FL_OBJECT         *PointFile;
   
   FL_OBJECT         *OK;
   
   FL_OBJECT         *Abort;
} fileform;

/* Global Area */

/* Set Path */
void xwSetFSPath(const char *path);
/* Set Pattern */
void xwSetFSPattern(const char *pattern);
/* Set Custom Button */
void xwSetFSCustom(const char *name,const char *path);
/* Fileselector Window */
char *xwFileSelect(int mo,char *file,char *comment,char *ok,char *abort);

/* Private Area */

/* Display History */
void xwDisplayFSHistory(int mo,const char *path);
/* Display Patterns */
void xwDisplayFSPattern(void);
/* Display Directory */
void xwDisplayFSDir(void);
/* read Directory */
void xwFSDirScan(void);
/* Datatype scanner */
int xwFSCheckType(const char *file);
/*  Compare for Sort */
int xwFSDirSort(const void *Z1,const void *Z2);
/* create File entry */
const char *xwCreateFSEntry(const char *file,int size);



#endif

