/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "fileselect.h"

#include "default.h"
#include "error.h"
#include "handler.h"
#include "limits.h"
#include "main_gui.h"
#include "resource.h"

static struct fileform     ff;

static char                xwPath[1024]="/";    /* actual Path */
static int                 xwHCount=-1;         /* count of History entrys */
static char                xwHistory[10][1024]; /* History */
static char                xwFile[1024]="";     /* selected File */
static char                xwPattern[1024]="";  /* Pattern String */
static int                 xwView=2;            /* View all Patterns */

static char                xwCPath[1024]="";    /* Custom Path */
static char                xwCName[1024]="";    /* Custom Name */

static int                 xwSort=1;            /* Sort a..b..c / c..b..a */
static int                 xwPointfile=0;       /* DotFile view */

/* Directory Buffer */
static char                *dbuf[4096];
static int                 dentrys=-1;

/* Global Area */

/* Set Path */
void xwSetFSPath(const char *path) /*fold00*/
{
   if (path!=NULL) strcpy(xwPath,path);
   
   return;
}
/* Set Pattern */
void xwSetFSPattern(const char *pattern) /*fold00*/
{
   if (pattern!=NULL) strcpy(xwPattern,pattern);

   return;
}
/* Set Custom Button */
void xwSetFSCustom(const char *name,const char *path) /*fold00*/
{
   if (strlen(name)>0) strcpy(xwCName,name);
   if (strlen(path)>0) strcpy(xwCPath,path);
   
   return;
}

/* Fileselector Window */
char *xwFileSelect(int mo,char *file,char *comment,char *ok,char *abort) /*fold00*/
{
   static char       dest[1024];
   int               brwline;
   char              brwstr[1024];
   char              puffer[1024];
   int               a;
   const char        *strptr;

   char              astr[100],bstr[100],cstr[100];
   char              mkPath[1024];        

   if (file!=NULL) strcpy(xwFile,file);

   ff.form = NULL;

   ff.form = fl_bgn_form(FL_UP_BOX,650,520);

   fl_set_border_width(1);

   ff.History=fl_add_choice(FL_DROPLIST_CHOICE,5,5,490,20,"");
   fl_set_object_boxtype(ff.History,FL_UP_BOX);
   xwDisplayFSHistory(fsView,NULL);

   ff.DirBrowser=fl_add_browser(FL_SELECT_BROWSER,5,25,490,100,"");
   fl_set_browser_fontstyle(ff.DirBrowser,FL_FIXED_STYLE);
   ff.DirInput=fl_add_input(FL_NORMAL_INPUT,55,125,440,20,xwGR(1,"fs.Path","Path:"));
   fl_set_object_lstyle(ff.DirInput,FL_FIXED_STYLE);
#ifdef xwWhiteInput
   fl_set_object_color(ff.DirInput,FL_WHITE,FL_WHITE);
#endif
   fl_set_input(ff.DirInput,xwPath);
   ff.FileBrowser=fl_add_browser(FL_HOLD_BROWSER,5,145,490,348,"");
   fl_set_browser_fontstyle(ff.FileBrowser,FL_FIXED_STYLE);
   ff.FileInput=fl_add_input(FL_NORMAL_INPUT,55,495,440,20,xwGR(1,"fs.File","File:"));
   fl_set_object_lstyle(ff.FileInput,FL_FIXED_STYLE);
#ifdef xwWhiteInput
   fl_set_object_color(ff.FileInput,FL_WHITE,FL_WHITE);
#endif
   fl_set_input(ff.FileInput,xwFile);

   ff.Root=fl_add_button(FL_NORMAL_BUTTON,500,5,145,20,"/");
   ff.Home=fl_add_button(FL_NORMAL_BUTTON,500,27,145,20,"Home");

   if (strlen(xwCPath)==0)
   {
      ff.FTBrowser=fl_add_browser(FL_HOLD_BROWSER,500,52,145,460-(55+47 +25+30),"");
      fl_set_browser_fontstyle(ff.FTBrowser,FL_FIXED_STYLE);
   }
   else
   {
      ff.CButton=fl_add_button(FL_NORMAL_BUTTON,500,49,145,20,xwCName);
      ff.FTBrowser=fl_add_browser(FL_HOLD_BROWSER,500,74,145,460-(55+47+22 +25+30),"");
      fl_set_browser_fontstyle(ff.FTBrowser,FL_FIXED_STYLE);     
   }
   
   ff.MakeDir=fl_add_button(FL_NORMAL_BUTTON,500,360,145,20,xwGR(1,"fs.MakeDir","MakeDir"));
   
   ff.Delete=fl_add_button(FL_NORMAL_BUTTON,500,385,145,20,xwGR(1,"fs.FileDelete","Delete"));
     
   ff.FileSort=fl_add_choice(FL_DROPLIST_CHOICE,500,415,145,20,"");
   fl_set_object_boxtype(ff.FileSort,FL_UP_BOX);
   fl_addto_choice(ff.FileSort,xwGR(1,"fs.upsort","Upsorted"));
   fl_addto_choice(ff.FileSort,xwGR(1,"fs.downsort","Downsorted"));
   fl_set_choice(ff.FileSort,xwSort);

   ff.PointFile=fl_add_lightbutton(FL_PUSH_BUTTON,500,440,145,20,"DotFiles"); /* ".[file]"); */
   fl_set_button(ff.PointFile,xwPointfile);

   ff.OK=fl_add_button(FL_NORMAL_BUTTON,500,470,145,20,ok);
   ff.Abort=fl_add_button(FL_NORMAL_BUTTON,500,495,145,20,abort);

   fl_end_form();

   if (xwGetPrefValue(xwgWinPos)==0)
   {
      fl_prepare_form_window(ff.form,FL_PLACE_MOUSE,FL_TRANSIENT,comment);
   }
   else
   {
      fl_prepare_form_window(ff.form,FL_PLACE_CENTER,FL_TRANSIENT,comment);
   }   
   
   /* Display Window */
   fl_show_form_window(ff.form);
   
   fl_set_app_mainform(ff.form);
   
   /* Exit Handler */
   fl_set_form_atclose(ff.form,nclose_cb,(void *) "1");

   /* View All Files */
   if ( (mo==fsFileAll) || (mo==fsPathAll) )
   {
      xwView=1;
   }

   xwDisplayFSPattern();
   xwDisplayFSDir();

   strcpy(dest,"");

   ff.ready=0;
   while (ff.ready==0)
   {
      ff.obj= fl_do_forms();

      /* Dir Input */
      strptr = fl_get_input(ff.DirInput);
      strcpy(puffer,strptr);
      if  ( strcmp(puffer,xwPath)!=0 )
      {
         strcpy(xwPath,puffer);
         xwDisplayFSDir();
      }
      
      /* File Input */
      strptr = fl_get_input(ff.FileInput);
      strcpy(puffer,strptr);
      if  ( strcmp(puffer,xwFile)!=0 ) strcpy(xwFile,puffer);

      /* Exit */
      if (ff.obj==ff.Abort) ff.ready=1;

      /* OK */
      if (ff.obj==ff.OK)
      {
         strcpy(dest,xwPath);
         if ( (mo == fsFile) || (mo == fsFileAll) )
         {
            if (strlen(xwPath)>1) strcat(dest,"/");
            if (strlen(xwFile)>1) strcat(dest,xwFile);
         }
         xwDisplayFSHistory(fsLock,xwPath);
         ff.ready=1;
      }

      /* History */
      if (ff.obj==ff.History)
      { 
         if (fl_get_choice(ff.History)>0)
         {
            strcpy(xwPath,xwHistory[fl_get_choice(ff.History)-1]);
            xwDisplayFSDir();
         }
      }

      /* DirBrowser */
      if (ff.obj==ff.DirBrowser)
      {
         brwline = fl_get_browser(ff.DirBrowser);
         strcpy(xwPath,"/");
         if (brwline > 1)
         {
            for (a=2 ; a<=brwline ; a++)
            {
               strptr = fl_get_browser_line(ff.DirBrowser,a);
               strcat(xwPath,strptr);
               strcat(xwPath,"/");
            }
         }
         xwPath[strlen(xwPath)-1]='\0';
         if (strlen(xwPath)==0) strcpy(xwPath,"/");
         
         xwDisplayFSDir();
      }

      /* FileBrowser */
      if (ff.obj==ff.FileBrowser)
      {
         brwline = fl_get_browser(ff.FileBrowser);
         if (brwline > 0)
         {
            strptr = fl_get_browser_line(ff.FileBrowser,brwline);
            strcpy(brwstr,strptr);

            /* Path-Selection */
            if (strcmp(brwstr,"@C12<DIR.> .."))
            {
               /* File or Drawer Entry */
               strcpy(puffer,brwstr);
               puffer[8]='\0';
               if ( (strcmp(puffer,"@C12<DIR") == 0) || (strcmp(puffer,"@C10<DIR") == 0) )
               {
                  /* Drawer */
                  if (strlen(xwPath)>1) strcat(xwPath,"/");
                  strptr=&brwstr[11];
                  strcat(xwPath,strptr);
                  xwDisplayFSDir();

                  /* File Input */
                  strcpy(xwFile,"");
                  fl_set_input(ff.FileInput,xwFile);
               }
               else
               {
                  /* File */
                  strcpy(xwFile,&brwstr[10]);

                  /* delete last characters */
                  while ( (strlen(xwFile)>0) && (xwFile[strlen(xwFile)-1]!=' ') )
                  {
                     xwFile[strlen(xwFile)-1]='\0';
                  }
                  /* delete last space-character */
                  xwFile[strlen(xwFile)-1]='\0';

                  /* File Input */
                  fl_set_input(ff.FileInput,xwFile);
               }
            }
            else
            {
               /* Parent */
               a=strlen(xwPath)-1;
               while ( (a>-1) && (xwPath[a]!='/') )
               {
                  xwPath[a]='\0';
                  a--;
               }
               xwPath[a]='\0';

               if (strlen(xwPath)==0) strcpy(xwPath,"/");

               xwDisplayFSDir();
            }
         }
      }

      /* Root */
      if (ff.obj==ff.Root)
      {
         strcpy(xwPath,"/");
         xwDisplayFSDir();
      }

      /* Home */
      if (ff.obj==ff.Home)
      {
         strcpy(xwPath,getenv("HOME"));
         xwDisplayFSDir();
      }

      /* Custom */
      if (ff.obj==ff.CButton)
      {
         strcpy(xwPath,xwCPath);
         xwDisplayFSDir();
      }

      /* FTBrowser */
      if (ff.obj==ff.FTBrowser)
      {
         xwView = fl_get_browser(ff.FTBrowser);
         xwDisplayFSDir();
      }

      /* MakeDir */
      if (ff.obj==ff.MakeDir)
      {
         strcpy(astr,xwGR(1,"fs.GetMakeDir","Type in the name of the new directory:"));
         strcpy(bstr,xwGR(1,"fs.MakeDir","Create Directory"));
         strcpy(cstr,xwGR(1,"fs.Abort","Abort"));
      
         strptr=xwGetMessage(ff.form,astr,bstr,cstr,"");
         if (strlen(strptr)>0)
         {
            strcpy(mkPath,xwPath);
            if (strlen(xwPath)>1) strcat(mkPath,"/");
            strcat(mkPath,strptr);
            mkdir(mkPath,S_IRWXU);
            xwDisplayFSDir();
         }
      }

      /* Delete */
      if (ff.obj==ff.Delete)
      {
         /* Delete File */
         if (strlen(xwFile)>0)
         {
            strcpy(astr,xwGR(1,"fs.DeleteFile","You will delete following file:"));
            strcat(astr,"\n\n");
            strcat(astr,xwFile);
            if (xwAskMessage(ff.form,astr)==xwYesMessage)
            {
               strcpy(mkPath,xwPath);
               if (strlen(xwPath)>1) strcat(mkPath,"/");
               strcat(mkPath,xwFile);
               unlink(mkPath);
               xwDisplayFSDir();
               
               /* File Input */
               strcpy(xwFile,"");
               fl_set_input(ff.FileInput,xwFile);
            }
         }
         else
         {
            /* Delete Drawer */
            strcpy(astr,xwGR(1,"fs.DeleteDrawer","You will delete following drawer:"));
            strcat(astr,"\n\n");
            strcat(astr,xwPath);
            if (xwAskMessage(ff.form,astr)==xwYesMessage)
            {
               strcpy(mkPath,xwPath);
            
               /* Parent */
               a=strlen(xwPath)-1;
               while ( (a>-1) && (xwPath[a]!='/') )
               {
                  xwPath[a]='\0';
                  a--;
               }
               xwPath[a]='\0';
               
               rmdir(mkPath);
               xwDisplayFSDir();
            } 
         }
      }

      /* Sort */
      if (ff.obj==ff.FileSort)
      {
         xwSort = fl_get_choice(ff.FileSort);
         xwDisplayFSDir();
      }

      /* PointFile */
      if (ff.obj==ff.PointFile)
      {
         xwPointfile = fl_get_button(ff.PointFile);
         xwDisplayFSDir();
      }

   }

   fl_hide_form(ff.form);
   fl_free_form(ff.form);
   ff.form=NULL;

   fl_set_app_mainform(xwGetMainGui());

   xwView=2;

   return(dest);
}

/* Private Area */

/* Display History */
void xwDisplayFSHistory(int mo,const char *path) /*fold00*/
{
   int            a,b=0;

   /* Path Managment */
   if (path!=NULL)
   {
      /* exist path */
      if (xwHCount>-1)
      {
         /* search xwPath in History */
         b=-1;
         for (a=0 ; a<=xwHCount ; a++)
         {
            if (strcmp(xwPath,xwHistory[a]) == 0) b=a;
         }
         
         /* Path found */
         if (b>-1)
         {
            for (a=b ; a>0 ; a--)
            {
               strcpy(xwHistory[a],xwHistory[a-1]);
            }
            strcpy(xwHistory[0],xwPath);
         }
         else
         {
            /* new Path */
            if (xwHCount>8) xwHCount=8;
            for (a=xwHCount+1 ; a>0 ; a--)
            {
               strcpy(xwHistory[a],xwHistory[a-1]);
            }
            strcpy(xwHistory[0],xwPath);
            xwHCount++;
         }
      }
      else
      {
         xwHCount=0;
         strcpy(xwHistory[0],xwPath); 
      }
   }
   
   /* Set Path */
   if (mo==fsView)
   {
      fl_clear_choice(ff.History);
   
      if (xwHCount>-1)
      {
         for (a=0 ; a<=xwHCount ; a++)
         {
            fl_addto_choice(ff.History,xwHistory[a]);
         }
      }
   }
   
   return;
}

/* Display Patterns */
void xwDisplayFSPattern(void) /*fold00*/
{
   char           *strptr;
   char           tz[]=",";

   fl_freeze_form(ff.form);
   
   fl_addto_browser(ff.FTBrowser,"*");
   fl_addto_browser(ff.FTBrowser,"*.[filetypes]");
   strptr = strtok(xwPattern,tz);
   while (strptr != NULL)
   {
      fl_addto_browser(ff.FTBrowser,strptr);

      strptr = strtok(NULL,tz);
   }

   fl_select_browser_line(ff.FTBrowser,xwView);

   fl_unfreeze_form(ff.form);

   return;
}

/* ----------------------------------------------------------------------------- */

/* Display Directory */
void xwDisplayFSDir(void) /*fold00*/
{
   char              path[1024];
   char              *strptr;
   int               a;

   fl_freeze_form(ff.form);

   /* Path Browser */
   fl_clear_browser(ff.DirBrowser);

   strcpy(path,xwPath);

   fl_addto_browser(ff.DirBrowser,"/");
   if (strlen(path)>1)
   {
      strptr = strtok(path,"/");
      while (strptr != NULL)
      {
         fl_addto_browser(ff.DirBrowser,strptr);
         strptr = strtok(NULL,"/");
      }
   }

   /* Path Input */
   fl_set_input(ff.DirInput,xwPath);

   /* File Browser */
   fl_clear_browser(ff.FileBrowser);

   /* Scan Directory */
   dentrys=-1;

   /* Scan Directory */
   xwFSDirScan();

   /* sort directory */
   if (dentrys > -1) qsort(dbuf,dentrys+1,sizeof(dbuf[0]),xwFSDirSort);

   /* copy direntrys into browser */
   for (a=0 ; a<=dentrys ; a++)
   {
      fl_add_browser_line(ff.FileBrowser,dbuf[a]);

      free(dbuf[a]);
      dbuf[a] = NULL;
   }
   dentrys=-1;

   /* File Input */
   fl_set_input(ff.FileInput,xwFile);

   fl_unfreeze_form(ff.form);

   return;
}

/* read Directory */
void xwFSDirScan(void) /*fold00*/
{
   DIR               *dirz;
   struct dirent     *direntz;
   struct stat       attribut;
   struct stat       attribB;

   char              fname[256];

   int               pointlock=0;

   char              path[1024];

   strcpy(fname,"@C12<DIR.> ..");
   dentrys++;
   dbuf[dentrys] = (char*) malloc(strlen(fname)+1);
   if (dbuf[dentrys] != NULL) strcpy(dbuf[dentrys],fname);

   if ( (dirz = opendir(xwPath)) != NULL )
   {
      while ( (direntz = readdir(dirz)) != NULL)
      {
         if ( strcmp(direntz->d_name,".") && strcmp(direntz->d_name,"..") )
         {
            pointlock=0;
            if ( *direntz->d_name == '.' )
            {
               if (xwPointfile==0) pointlock=1;
            }

            /* File Correct for Filebox */
            if (pointlock == 0)
            {
               strcpy(path,xwPath);
               strcat(path,"/");
               strcat(path,direntz->d_name);

               strcpy(fname,"");
               if ( stat(path,&attribut) == 0)
               {
                  if (lstat(path,&attribB) == 0)
                  {
                     if (S_ISLNK(attribB.st_mode))
                     {
                        if (S_ISREG(attribut.st_mode))
                        {
                           /* Dateityp erkennung */
                           if (xwFSCheckType(direntz->d_name) != 0)
                           {
                              strcpy(fname,"@C4<FILE> ");
                              strcat(fname,xwCreateFSEntry(direntz->d_name,attribut.st_size));
                           }
                        }
                        else if (S_ISDIR(attribut.st_mode))
                        {
                           strcpy(fname,"@C10<DIR.> ");
                           strcat(fname,direntz->d_name);
                        }
                     }
                     else
                     {
                        if (S_ISREG(attribut.st_mode))
                        {
                           /* Dateityp erkennung */
                           if (xwFSCheckType(direntz->d_name) != 0)
                           {
                              strcpy(fname,"@C0<FILE> ");
                              strcat(fname,xwCreateFSEntry(direntz->d_name,attribut.st_size));
                           }
                        }
                        else if (S_ISDIR(attribut.st_mode))
                        {
                           strcpy(fname,"@C12<DIR.> ");
                           strcat(fname,direntz->d_name);
                        }

                     }
                  }
               }

               /* write into array */
               if (strlen(fname) > 0)
               {
                  if (dentrys<4095)
                  {
                     dentrys++;
                     dbuf[dentrys] = (char*) malloc(strlen(fname)+1);
                     if (dbuf[dentrys] != NULL) strcpy(dbuf[dentrys],fname);
                  }
               }
            }
         }
      }

      closedir(dirz);
   }

   return;
}

/* Datatype scanner */
int xwFSCheckType(const char *file) /*fold00*/
{
   char              puffer[1024];
   char              pattern[1024];
   int               a,b;
   int               fexist=0;

   const char        *strptr;

   /* Modify Filename */
   strcpy(puffer,file);
   a=1;
   if ( strlen(puffer) > 0)
   {
      for ( a=1 ; a <= (int) strlen(puffer) ; a++ )
      {
          puffer[a-1] = toupper(puffer[a-1]);
      }
   }

   /* accecpt all files */
   if (xwView==1) return(1);

   /* Check all Patterns */
   if (xwView==2)
   {
      fexist=0;

      for ( b=3 ; b <= fl_get_browser_maxline(ff.FTBrowser) ; b++ )
      {
         strptr = fl_get_browser_line(ff.FTBrowser,b);
         strcpy(pattern,strptr);

         for ( a=1 ; a <= (int) strlen(pattern) ; a++ )
         {
            pattern[a-1] = toupper(pattern[a-1]);
         }

         if ( strcmp( &puffer[strlen(puffer)-strlen(pattern)],pattern ) == 0 ) fexist++;
      }

      if (fexist>0) return(1);
   }

   /* Check an Pattern */
   if (xwView>2)
   {
      strptr = fl_get_browser_line(ff.FTBrowser,xwView);
      strcpy(pattern,strptr);

      for ( a=1 ; a <= (int) strlen(pattern) ; a++ )
      {
          pattern[a-1] = toupper(pattern[a-1]);
      }

      if (strcmp(&puffer[strlen(puffer)-strlen(pattern)],pattern) == 0) return(1);
   }

   return(0);
}

/* ----------------------------------------------------------------------------- */



/* ----------------------------------------------------------------------------- */

/* Compare for Sort */
int xwFSDirSort(const void *Z1,const void *Z2) /*fold00*/
{
   const char        **z1=(const char **) Z1;
   const char        **z2=(const char **) Z2;
   const char        *strptr;
   unsigned int      zpos;
   char              aas[1024],bbs[1024],ccs[1024];

   strcpy(aas,*z1);
   strcpy(bbs,*z2);

   zpos=0;
   while ( (zpos<strlen(aas)) && (aas[zpos]!='<') ) zpos++;
   strptr = &aas[zpos];
   strcpy(ccs,strptr);
   strcpy(aas,"<");
   strcat(aas,ccs);

   zpos=0;
   while ( (zpos<strlen(bbs)) && (bbs[zpos]!='<') ) zpos++;
   strptr = &bbs[zpos];
   strcpy(ccs,strptr);
   strcpy(bbs,"<");
   strcat(bbs,ccs);

   if (xwSort>2) xwSort=1;
   if (xwSort==1) return(strcmp(aas,bbs));
   if (xwSort==2) return(strcmp(bbs,aas));

   return(0);
}

/* create File entry */
const char *xwCreateFSEntry(const char *file,int size) /*fold00*/
{
   static char    buffer[1024];
   char           sbuffer[50];

   /* File Entry 73 */
   strcpy(buffer,file);
   strcat(buffer," ");
   strcat(buffer,fsLine);
   /* buffer[70]='\0'; */

   sprintf(sbuffer,"%d",size);

   buffer[70-(strlen(sbuffer))]='\0';
   strcat(buffer,sbuffer);

   return(buffer);
}