/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWFILEIO_H
#define _XWFILEIO_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>

#ifndef WRONG_ORDER
#define WRONG_ORDER 0             /* INTEL Reihenfolge     */
#endif
#ifndef GOOD_ORDER
#define GOOD_ORDER  1             /* Motorola Reihenfolge  */
#endif

#ifndef INTEL
#define INTEL        0
#endif
#ifndef MOTOROLA
#define MOTOROLA     1
#endif

/* Min. Size of Frame - 7 mm */
/*#define frameMinSize      7*/

/* Picture Datas */
typedef struct picresolution
{
   int         xsize;
   int         ysize;
   int         depth;
   int         image;
   int         ID;
} picresolution;

/* Initialize FileIO */
void xwInitFileIO(); 

/* Byte, Word oder Long einlesen */
int readValue(const char *source,int fpos, int size, int fileOrder);
/* Text einlesen */
const char *readtext(const char *source,int fpos,int a);

/* check and get GFX Datas */
int xwCheckGFXFile(const char *source);
/* check xwgui files */
int xwCheckXWGFile(const char *source);

/* Get ID of Image - Specially for PPM-File Format */
int xwGetGFXID(void);
/* Get X-Size of Image */
int xwGetGFXX(void);
/* Get Y-Size of Image */
int xwGetGFXY(void);
/* Get Image Position */
int xwGetGFXP(void);

/* check GIF-Format */
int checkgif(const char *source);
/* check TIF-Format */
int checktiff(const char *source);
/* check PPM-Format */
int checkppm(const char *source);
/* check BMP-Format */
int checkbmp(const char *source);
/* check JPG-Format */
int checkjpg(const char *source);
/* check PNG-Format */
int checkpng(const char *source);
/* check XWD-Format */
int checkxwd(const char *source);

/* Check FrameSet Files */
int checkfrms(const char *source);

#endif

