/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "exit.h"

#include "ass-cover.h"
#include "default.h"
#include "font.h"
#include "frame.h"
#include "io.h"
#include "main_gui.h"
#include "page.h"
#include "pbcache.h"
#include "picture.h"
#include "resource.h"
#include "variable.h"

/* Exit Manager */
void xwGUIExit(void)
{
   if (xwGetPrefValue(xwgAssLock)==0)
   {
      /* Free WYSIWYG Pixmap */
      xwFreeXPixmap();

      /* Close Main GUI */
      xwCloseMainGui();
   }
   
   /* Save Pref File */
   xwSaveRC();

   /* Free Resource */
   xwFreeResource();

   /* Free Variables */
   xwDInitVarDef();

   /* Free Frames */
   xwFreeFrames(-1);

   /* Free Pictures */
   xwFreePicture(-1);

   /* clear pbcache */
   xwCleanPBCache();

   /* remove fontlist */
   xwRemoveFontList();

   /* Remove all T1 Datas */
   xwRemoveFont();

   /* Remove Cover Memory */
   assFreeCoverMem();

   /* Delete PrintOut File */
   unlink(xwGetFile("","prtout.ppm"));

   /* Delete Gimp Picture File */
   unlink(xwGetFile("","gimp.data"));

   return;
}