/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWERROR_H
#define _XWERROR_H

#include <forms.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>

#ifndef xwOKMessage
#define xwOKMessage  1
#endif
#ifndef xwYesMessage
#define xwYesMessage 2
#endif
#ifndef xwNoMessage
#define xwNoMessage  3
#endif

/* Display Error Message */
void xwDisplayMessage(FL_FORM *form,const char *message);
/* Display Ask Message */
int xwAskMessage(FL_FORM *form,const char *message);
/* Get an Answer Message */
char *xwGetMessage(FL_FORM *form,const char *message,const char *ok,const char *abort,const char *ig);

/* ######### SPECIAL ERROR MESSAGE SYSTEM ########## */

/* Reset Error Log */
void xwResetError(void);
/* Write Message in Error Log */
void xwWriteError(char *message);
/* Display Error Log */
void xwDisplayError(void);

#endif