/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "error.h"

#include "default.h"
#include "limits.h"
#include "resource.h"
#include "handler.h"

FL_FORM           *errForm;
FL_OBJECT         *errMessage;
FL_OBJECT         *errInput;
FL_OBJECT         *errOK;
FL_OBJECT         *errYES;
FL_OBJECT         *errNO;
FL_OBJECT         *errObj;
int               errReady;

/* Display Error Message */
void xwDisplayMessage(FL_FORM *form,const char *message) /*fold00*/
{
   if (form!=NULL) fl_deactivate_form(form);

   errForm = fl_bgn_form(FL_UP_BOX, 600,100);
   fl_set_border_width(1);

   errMessage = fl_add_browser(FL_NORMAL_BROWSER,5,5,590,65,"");
   fl_set_browser_fontstyle(errMessage,FL_FIXED_STYLE);
   fl_set_browser_fontsize(errMessage,FL_NORMAL_SIZE);
   fl_add_browser_line(errMessage,message);

   errOK=fl_add_button(FL_NORMAL_BUTTON,250,75,100,20,xwGR(1,"err.OK","OK"));

   fl_end_form();

   if (xwGetPrefValue(xwgWinPos)==0)
   {
      fl_prepare_form_window(errForm,FL_PLACE_MOUSE,FL_TRANSIENT,xwGR(1,"err.Message","Message..."));
   }
   else
   {
      fl_prepare_form_window(errForm,FL_PLACE_CENTER,FL_TRANSIENT,xwGR(1,"err.Message","Message..."));
   }

   fl_set_form_dblbuffer(errForm,0);
   fl_show_form_window(errForm);

   fl_set_app_mainform(errForm);

   /* Exit Handler */
   fl_set_form_atclose(errForm,nclose_cb,(void *) "1");

   errReady=0;
   while (errReady==0)
   {
      if (errOK==fl_do_forms()) errReady=1;
   }

   fl_hide_form(errForm);
   fl_free_form(errForm);

   if (form!=NULL)
   {
      fl_activate_form(form);
      fl_set_app_mainform(form);
   }

   return;
}

/* Display Ask Message */
int xwAskMessage(FL_FORM *form,const char *message) /*fold00*/
{
   if (form!=NULL) fl_deactivate_form(form);

   errForm = fl_bgn_form(FL_UP_BOX, 600,100);
   fl_set_border_width(1);

   errMessage = fl_add_browser(FL_NORMAL_BROWSER,5,5,590,65,"");
   fl_set_browser_fontstyle(errMessage,FL_FIXED_STYLE);
   fl_set_browser_fontsize(errMessage,FL_NORMAL_SIZE);
   fl_add_browser_line(errMessage,message);

   errYES=fl_add_button(FL_NORMAL_BUTTON,195,75,100,20,xwGR(1,"err.YES","Yes"));
   errNO=fl_add_button(FL_NORMAL_BUTTON,305,75,100,20,xwGR(1,"err.NO","No"));

   fl_end_form();

   if (xwGetPrefValue(xwgWinPos)==0)
   {
      fl_prepare_form_window(errForm,FL_PLACE_MOUSE,FL_TRANSIENT,xwGR(1,"err.Message","Message..."));
   }
   else
   {
      fl_prepare_form_window(errForm,FL_PLACE_CENTER,FL_TRANSIENT,xwGR(1,"err.Message","Message..."));
   }

   fl_set_form_dblbuffer(errForm,0);
   fl_show_form_window(errForm);

   fl_set_app_mainform(errForm);

   /* Exit Handler */
   fl_set_form_atclose(errForm,nclose_cb,(void *) "1");

   errReady=0;
   while (errReady==0)
   {
      errObj=fl_do_forms();

      if (errObj==errYES)
      {
         errReady=xwYesMessage;
      }
      if (errObj==errNO)
      {
         errReady=xwNoMessage;
      }
   }

   fl_hide_form(errForm);
   fl_free_form(errForm);

   if (form!=NULL)
   {
      fl_activate_form(form);
      fl_set_app_mainform(form);
   }

   return(errReady);
}

/* Get an Answer Message */
char *xwGetMessage(FL_FORM *form,const char *message,const char *ok,const char *abort,const char *ig) /*fold00*/
{
   static char       entry[1024];
   const char        *strptr;

   if (form!=NULL) fl_deactivate_form(form);

   /* Init Input Field */
   if (strlen(ig)<1023)
   {
      strcpy(entry,ig);
   }
   else
   {
      strcpy(entry,"");
   }

   errForm = fl_bgn_form(FL_UP_BOX, 600,100);
   fl_set_border_width(1);

   errMessage = fl_add_browser(FL_NORMAL_BROWSER,5,5,590,45,"");
   fl_set_browser_fontstyle(errMessage,FL_FIXED_STYLE);
   fl_set_browser_fontsize(errMessage,FL_NORMAL_SIZE);
   fl_add_browser_line(errMessage,message);

   errInput=fl_add_input(FL_NORMAL_INPUT,5,50,590,20,"");
   fl_set_object_lstyle(errInput,FL_FIXED_STYLE);
#ifdef xwWhiteInput
   fl_set_object_color(errInput,FL_WHITE,FL_WHITE);
#endif
   fl_set_input(errInput,entry);

   errYES=fl_add_button(FL_NORMAL_BUTTON,145,75,150,20,ok);
   errNO=fl_add_button(FL_NORMAL_BUTTON,305,75,150,20,abort);

   fl_end_form();

   if (xwGetPrefValue(xwgWinPos)==0)
   {
      fl_prepare_form_window(errForm,FL_PLACE_MOUSE,FL_TRANSIENT,xwGR(1,"err.Message","Message..."));
   }
   else
   {
      fl_prepare_form_window(errForm,FL_PLACE_CENTER,FL_TRANSIENT,xwGR(1,"err.Message","Message..."));
   }

   fl_set_form_dblbuffer(errForm,0);
   fl_show_form_window(errForm);

   fl_set_app_mainform(errForm);

   /* Exit Handler */
   fl_set_form_atclose(errForm,nclose_cb,(void *) "1");

   errReady=0;
   while (errReady==0)
   {
      errObj=fl_do_forms();

      strptr = fl_get_input(errInput);
      if ( (strlen(strptr)>0) && (strlen(strptr)<1024) ) strcpy(entry,strptr);

      if (errObj==errYES)
      {
         errReady=xwYesMessage;
      }
      if (errObj==errNO)
      {
         strcpy(entry,"");
         errReady=xwNoMessage;
      }
   }

   fl_hide_form(errForm);
   fl_free_form(errForm);

   if (form!=NULL)
   {
      fl_activate_form(form);
      fl_set_app_mainform(form);
   }

   return(entry);
}

/* ######### SPECIAL ERROR MESSAGE SYSTEM ########## */

/* Reset Error Log */
void xwResetError(void) /*fold00*/
{
   unlink(xwGetFile("","error.log"));

   return;
}

/* Write Message in Error Log */
void xwWriteError(char *message) /*fold00*/
{
   FILE           *fh;

   fh=fopen(xwGetFile("","error.log"),"a");
   if (fh!= NULL)
   {
      fputs(message,fh);

      fclose(fh);
   }

   return;
}

/* Display Error Log */
void xwDisplayError(void) /*fold00*/
{
   FILE           *fh;
   char           message[1024];

   fh=fopen(xwGetFile("","error.log"),"r");
   if (fh!=NULL)
   {
      errForm = fl_bgn_form(FL_UP_BOX, 600,500);
      fl_set_border_width(1);

      errMessage = fl_add_browser(FL_NORMAL_BROWSER,5,5,590,465,"");
      fl_set_browser_fontstyle(errMessage,FL_FIXED_STYLE);
      fl_set_browser_fontsize(errMessage,FL_NORMAL_SIZE);

      /* read error log */
      while (fgets(message,1024,fh) != NULL)
      {
         fl_add_browser_line(errMessage,message);
      }
      fclose(fh);

      errOK=fl_add_button(FL_NORMAL_BUTTON,250,475,100,20,xwGR(1,"err.OK","OK"));

      fl_end_form();

      if (xwGetPrefValue(xwgWinPos)==0)
      {
         fl_prepare_form_window(errForm,FL_PLACE_MOUSE,FL_TRANSIENT,xwGR(1,"err.Message","Message..."));
      }
      else
      {
         fl_prepare_form_window(errForm,FL_PLACE_CENTER,FL_TRANSIENT,xwGR(1,"err.Message","Message..."));
      }

      fl_set_form_dblbuffer(errForm,0);
      fl_show_form_window(errForm);

      fl_set_app_mainform(errForm);

      /* Exit Handler */
      fl_set_form_atclose(errForm,nclose_cb,(void *) "1");

      errReady=0;
      while (errReady==0)
      {
         if (errOK==fl_do_forms()) errReady=1;
      }

      fl_hide_form(errForm);
      fl_free_form(errForm);
   }

   return;
}

