/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWEDITOR_H
#define _XWEDITOR_H

#include <forms.h>

#include <math.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#define edDrawOffset  13
#define edDrawBox    248

typedef struct editorform
{
   /* ################################################################ */
   /* Edit Frame/Picture Settings */

   /* Main-Form data */
   FL_FORM           *form;
   /* Event Loop */
   FL_OBJECT         *obj;
   int               ready;
   
   FL_OBJECT         *OK;
   FL_OBJECT         *CANCEL;
   FL_OBJECT         *HELP;
   
   FL_OBJECT         *FrameA;
   FL_OBJECT         *FrameB;
   FL_OBJECT         *FrameC;
   
   /* Frame Section */
   FL_OBJECT         *FrameSection;
   FL_OBJECT         *FBSize;          /* Frame Border Size */
   FL_OBJECT         *FBColor;         /* Frame Border Color */
   FL_OBJECT         *FBLineSize;      /* Frame Line Size */
   FL_OBJECT         *FBLColor;        /* Frame Line Color */
   FL_OBJECT         *FBLQuadBorder;   /* Frame Quad Border */
   FL_OBJECT         *FBLCircleBorder; /* Frame Circle Border */
   FL_OBJECT         *FBLAllBorder;    /* Frame All Borders */
   
   FL_OBJECT         *FHLine;          /* Frame Horizontal Line */
   FL_OBJECT         *FHLineColor;     /* Frame Horizontal Line Color */
   FL_OBJECT         *FVLine;          /* Frame Vertical Line */
   FL_OBJECT         *FVLineColor;     /* Frame Vertical Line Color */
   FL_OBJECT         *FOrientation;    /* Picture Orientation in Frame */
  
   /* Picture Section */
   FL_OBJECT         *PictureSection;
   FL_OBJECT         *PBSize;          /* Picture Border Size */
   FL_OBJECT         *PBColor;         /* Picture Border Color */
   FL_OBJECT         *PBLineSize;      /* Picture Line Size */
   FL_OBJECT         *PBLineColor;     /* Picture Line Color */
   FL_OBJECT         *PTransMode;      /* Picture Transparenz Mode */
   FL_OBJECT         *PTransparenz;    /* Picture Transparenz */
  
   /* Font Selection */
   FL_OBJECT         *FNTName;         /* Font Name */
   FL_OBJECT         *FNTSize;         /* Font Size */
   FL_OBJECT         *FNTUnderline;    /* Font Underline */
   FL_OBJECT         *FNTColor;        /* Font Color */
   FL_OBJECT         *FNTSelect;       /* Font Selection */
  
   FL_OBJECT         *FNTEast;         /* Write Direction */
   FL_OBJECT         *FNTSouth;
   FL_OBJECT         *FNTWest;
   FL_OBJECT         *FNTNorth;
   
   FL_OBJECT         *FNTLeft;         /* Text Position */
   FL_OBJECT         *FNTMiddle;
   FL_OBJECT         *FNTRight;
   
   FL_OBJECT         *FNTEditor;
  
   /* ################################################################ */
   /* Edit Color Form */
   
   FL_FORM           *ECform;
   FL_OBJECT         *ECobj;
   int               ECready;
   
   FL_OBJECT         *ECFrame;
   
   FL_OBJECT         *ECOK;
   
   FL_OBJECT         *ECred;
   FL_OBJECT         *ECgreen;
   FL_OBJECT         *ECblue;
   FL_OBJECT         *ECcolor;
   
   
   
} editorform;

   
   
   
/* Editor 690 500 */
void xwEditor(void);  

/* ################################################################### */
/* Build GFX-Output */
 
/* Refresh Handler */
int xwEdHandler(FL_OBJECT *obj,int event,FL_Coord mx,FL_Coord my,int key,void *xev);
/* Display Actual Settings */
void xwEdView(void);
/* Set Picture Position in Frame */
void xwSetPicInFrame(int w,int h,int wr,int hr);
/* Draw Filled Box */
void xwDrawFBox(int x,int y,int w,int h,int col);
/* Draw Box */
void xwDrawBox(int x,int y,int w,int h,int col,int t);
/* Draw Circle */
void xwDrawCircle(int x,int y,int w,int h,int col,int t);


#endif