/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "driver_xwtools.h"

#include "base.h"
#include "default.h"
#include "handler.h"
#include "resource.h"
#include "variable.h"

struct descform     df;

/* Description Datas */
char              xwHost[1024];     /* HOST */
char              xwSpool[1024];    /* SPOOL */
char              xwDevice[1024];
char              xwDesc[1024];     /* DEVICE - xw_epsC400.desc -> epsC400 */
char              xwComment[1024];

/* xwTools - Progressbar */
void xwToolsProgress(FL_OBJECT *obj) /*fold00*/
{
   FILE           *fh;
   char           progresscontent[1024];
   char           *strptr;
   char           puffer[1024];
   int            prgAct;
   int            prgMax;

   /* Open Progress File */
   if ( (fh=fopen(xwGetFile("","xwtools.progress"),"rb")) != NULL )
   {
      if (fgets(progresscontent,1023,fh) != NULL)
      {
         progresscontent[strlen(progresscontent)]=0x00;

         if (strlen(progresscontent)>0)
         {
            strptr=strchr(progresscontent,'/');
            if (strptr!=NULL)
            {
               strptr[0]='\0';
               strcpy(puffer,progresscontent);
               strTrim(puffer);
               prgAct=atoi(puffer);

               strptr=strptr+1;
               strcpy(puffer,strptr);
               strTrim(puffer);
               prgMax=atoi(puffer);

               if (obj!=NULL)
               {
                  fl_set_slider_bounds(obj,0,prgMax);
                  fl_set_slider_value(obj,prgAct);
               }
            }
         }
      }
      fclose(fh);
   }

   return;
}

/* Get Spool Printers */
void xwToolsInfo(void) /*fold00*/
{
   DIR               *dirz;
   struct dirent     *direntz;
   struct stat       attribut;
   struct stat       attribB;

   char              path[1024];
   char              fname[1024];
   char              dname[1024];
   char              buffer[1024];
   int               fcount;
   int               selectDesc;

   char              *strptr;

   df.form=NULL;

   fcount=-1;
   selectDesc=1;

   /* Get List of available Description Files */
   if ( (dirz = opendir(xwToolsPath)) != NULL )
   {
      while ( (direntz = readdir(dirz)) != NULL)
      {
         if (strlen(xwToolsPath)<1024)
         {
            strcpy(path,xwToolsPath);
            strcat(path,"/");
            strcat(path,direntz->d_name);

            strcpy(fname,"");
            if ( stat(path,&attribut) == 0)
            {
               if (lstat(path,&attribB) == 0)
               {
                  if (S_ISLNK(attribB.st_mode))
                  {
                     if (S_ISREG(attribut.st_mode))
                     {
                        if (strlen(path)<1024) strcpy(fname,path);
                     }
                  }
                  else
                  {
                     if (S_ISREG(attribut.st_mode))
                     {
                        if (strlen(path)<1024) strcpy(fname,path);
                     }
                  }
               }
            }

            /* Descrition File ??? */
            if (strlen(fname)>0)
            {
               strcpy(dname,fname);
               strUpper(dname);

               if (strlen(dname)>5)
               {
                  strptr=dname;
                  strptr=strptr+(strlen(dname)-5);
                  if (strcmp(strptr,".DESC") == 0)
                  {
                     fcount++;

                     /* save first eintry */
                     if (fcount==0) strcpy(buffer,fname);

                     /* More as one Printers ??? */
                     else if (fcount==1)
                     {
                        /* open gui */
                        df.form = fl_bgn_form(FL_UP_BOX, 600,200);
                        fl_set_border_width(1);

                        df.DESC = fl_add_text(FL_NORMAL_TEXT,5,5,140,20,xwGR(1,"xwt.DESC","Description:"));
                        df.DEVICE = fl_add_text(FL_NORMAL_TEXT,145,5,140,20,xwGR(1,"xwt.DEVICE","Device:"));
                        df.COMMENT = fl_add_text(FL_NORMAL_TEXT,285,5,140,20,xwGR(1,"xwt.COMMENT","Comment:"));

                        df.Browser = fl_add_browser(FL_HOLD_BROWSER,5,25,590,145,"");
                        fl_set_browser_fontstyle(df.Browser,FL_FIXED_STYLE);
                        fl_set_browser_fontsize(df.Browser,FL_NORMAL_SIZE);

                        /* add entrys */
                        fl_add_browser_line(df.Browser,xwBuildBrowserLine(buffer));
                        fl_add_browser_line(df.Browser,xwBuildBrowserLine(fname));

                        fl_select_browser_line(df.Browser,selectDesc);

                        df.OK=fl_add_button(FL_NORMAL_BUTTON,250,175,100,20,xwGR(1,"xwt.OK","OK"));

                        fl_end_form();

                        if (xwGetPrefValue(xwgWinPos)==0)
                        {
                           fl_prepare_form_window(df.form,FL_PLACE_MOUSE,FL_FULLBORDER,xwGR(1,"err.Message","Message..."));
                        }
                        else
                        {
                           fl_prepare_form_window(df.form,FL_PLACE_CENTER,FL_FULLBORDER,xwGR(1,"err.Message","Message..."));
                        }

                        fl_set_form_dblbuffer(df.form,0);
                        fl_show_form_window(df.form);

                        /* Exit Handler */
                        fl_set_form_atclose(df.form,nclose_cb,(void *) "1");
                     }

                     /* Next Entrys */
                     else if (fcount>1)
                     {
                        /* add entrys */
                        fl_add_browser_line(df.Browser,xwBuildBrowserLine(fname));
                     }

                  }
                  else
                  {
                     strcpy(fname,"");
                  }
               }
            }
         }
      }
      closedir(dirz);
   }

   /* Select Description */
   if (fcount>0)
   {
      df.ready=0;
      while (df.ready==0)
      {
         df.obj=fl_do_forms();

         /* Exit */
         if (df.obj==df.OK)
         {
            df.ready=-1;
         }

         /* Select Entry */
         else if (df.obj==df.Browser)
         {
            if (fl_get_browser(df.Browser)>0)
            {
               selectDesc=fl_get_browser(df.Browser);
               if (selectDesc>0)
               {
                  if (fl_get_browser_line(df.Browser,selectDesc)!=NULL)
                  {
                     strcpy(buffer,fl_get_browser_line(df.Browser,selectDesc));
                     strptr=strchr(buffer,' ');
                     if (strptr!=NULL)
                     {
                        strptr[0]=0x00;

                        strcpy(fname,xwToolsPath);
                        strcat(fname,"xw_");
                        strcat(fname,buffer);
                        strcat(fname,".desc");
                     }
                  }
               }
            }
         }
      }

      fl_hide_form(df.form);
      fl_free_form(df.form);
   }
   else
   {
      strcpy(fname,buffer);
   }

   /* Result */
   if (strlen(fname)>0)
   {
      printf("Description: %s\n\n",fname);
      xwReadDescription(fname);

      xwSetVarDef("xwHost",xwHost);
      xwSetVarDef("xwSpool",xwSpool);
      xwSetVarDef("xwDevice",xwDesc);
   }

   return;
}

/* build browser line */
char *xwBuildBrowserLine(char *file) /*fold00*/
{
   static char    line[1024];
   char           *strptr;

   xwReadDescription(file);

   if (strlen(xwDesc)>0)
   {
      /* Description */
      strcpy(line,xwDesc);
      strcat(line,xwSpaces);
      strptr=line;
      strptr=strptr+20;
      strptr[0]=0x00;

      /* Device */
      strcat(line,xwDevice);
      strcat(line,xwSpaces);
      strptr=line;
      strptr=strptr+40;
      strptr[0]=0x00;

      /* Comment */
      strcat(line,xwComment);
   }

   return(line);
}

/* read description file */
void xwReadDescription(char *file) /*fold00*/
{
   FILE           *FH;
   char           line[1024];
   char           buffer[1024];
   int            bug;
   char           *strptr;

   if ( (FH=fopen(file,"rb")) != NULL )
   {
      bug=0;
      while ( (fgets(line,1024,FH) != NULL) && (bug==0) )
      {
         /* remove newline character */
         if (strlen(line)>0)
         {
            if (line[strlen(line)-1]==0x0a)
            {
               line[strlen(line)-1]=0x00;
            }
         }

         if (strlen(line)>0)
         {
            strTrim(line);
            strcpy(buffer,line);

            /* XW_PrintHost */
            /* XW_SpoolDir */
            /* XW_dev */
            /* XW_Comment */
            if (strlen(buffer)>12)
            {
               strptr=buffer;
               strptr=strptr+12;
               strptr[0]=0x00;
               if (strcmp(buffer,"XW_PrintHost") == 0)
               {
                  strcpy(xwHost,strptr+1);
                  strTrim(xwHost);
               }
               else
               {
                  strcpy(buffer,line);
                  strptr=buffer;
                  strptr=strptr+11;
                  strptr[0]=0x00;
                  if (strcmp(buffer,"XW_SpoolDir") == 0)
                  {
                     strcpy(xwSpool,strptr+1);
                     strTrim(xwSpool);
                  }
                  else
                  {
                     strcpy(buffer,line);
                     strptr=buffer;
                     strptr=strptr+6;
                     strptr[0]=0x00;
                     if (strcmp(buffer,"XW_dev") == 0)
                     {
                        strcpy(xwDevice,strptr+1);
                        strTrim(xwDevice);
                     }
                     else
                     {
                        strcpy(buffer,line);
                        strptr=buffer;
                        strptr=strptr+10;
                        strptr[0]=0x00;
                        if (strcmp(buffer,"XW_Comment") == 0)
                        {
                           strcpy(xwComment,strptr+1);
                           strTrim(xwComment);
                        }

                     }
                  }
               }
            }
         }
      }

      fclose(FH);

      /* Description isolation */
      strptr=strrchr(file,'/');
      if (strptr!=NULL)
      {
         strptr=strptr+4;
         strcpy(xwDesc,strptr);
         strptr=xwDesc;
         strptr=strptr+(strlen(xwDesc)-5);
         strptr[0]=0x00;
      }
   }

   return;
}