/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWDRIVER_TURBOPRINT_H
#define _XWDRIVER_TURBOPRINT_H

#include <forms.h>

#include <signal.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <dirent.h>

/* Remove All */
void tpRemove(void);

/* Get TurboPrint Version */
int tpGetVersion(void);

/* List Printers */
void tpListPrinter(FL_OBJECT *obj);
/* List Quality */
void tpListQuality(FL_OBJECT *obj);
/* List Paper */
void tpListPaper(FL_OBJECT *obj);
/* List Media */
void tpListMedia(FL_OBJECT *obj);

/* Paper Settings */
void tpSetPaperSize(void);
/* Set Correct Paper Size */
void tpSetCorrectPaperSize(int xsize,int ysize);

/* Get Paper Datas */
void xwGetPaperDatas(char *source);

/* Get Printer */
void tpGetPrinter(FL_OBJECT *obj);
/* Get Quality */
void tpGetQuality(FL_OBJECT *obj);
/* Get Paper */
void tpGetPaper(FL_OBJECT *obj);
/* Get Media */
void tpGetMedia(FL_OBJECT *obj);

/* Create TurboPrint Script */
void tpPrintScript(void);

#endif