/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "driver_lp.h"

#include "base.h"

/* Create LP Widget */
void xwCreateLPWidget(char *content,FL_OBJECT *obj)
{
   FILE           *fh;
   char           puffer[1024];
   char           entry[1024];
   char           *strptr;
   int            cNr;
   int            count;

   strcpy(puffer,"");

   if ( (fh=fopen("/etc/printcap","rb")) != NULL )
   {
      cNr=0;
      count=0;
      while (fgets(puffer,1024,fh) != NULL)
      {
         strTrim(puffer);

         if ( (strlen(puffer)>0) && (puffer[0] != '#') && (puffer[0] != ':') && (puffer[0] != '\n') )
         {
         
            strptr=strchr(puffer,'|');
            if (strptr!=NULL)
            {
               /* delete last 3 characters */
               strptr=puffer;
               strptr=strptr+(strlen(puffer)-3);
               strptr[0]=0x00;
            }
            else
            {
               /* delete last 2 characters - needed by CUPS */
               strptr=puffer;
               strptr=strptr+(strlen(puffer)-2);
               strptr[0]=0x00;
            }
                        
            /* Get First Entry */
            strptr=strchr(puffer,'|');
            if (strptr!=NULL)
            {
               strptr[0]=0x00;
               strcpy(entry,puffer);

               /* LP Printer Found */
               if (strcmp(entry,"lp") == 0)
               {
                  if (content!=NULL) cNr=count+1;
                  strptr=strptr+1;
                  strcpy(puffer,strptr);
                  strptr=strchr(puffer,'|');
                  if (strptr!=NULL)
                  {
                     strptr[0]=0x00;
                     strcpy(entry,puffer);
                  }
                  else
                  {
                     strcpy(entry,puffer);
                     strcpy(puffer,"lp|");
                     strcat(puffer,entry);
                     strcpy(entry,"lp");
                  }
               }
            }
            else
            {
               strcpy(entry,puffer);
               strcpy(puffer,"");
            }

            count++;
            if (strcmp(entry,content) == 0) cNr=count;

            strcat(entry,":");
            if (strptr!=NULL) strptr[0]=0x7C;

            /* Get Comment */
            if (strlen(puffer)>0)
            {
               strptr=strrchr(puffer,'|');
               strptr=strptr+1;
               strcat(entry,strptr);
            }

            fl_add_browser_line(obj,entry);
            if (cNr>0) fl_select_browser_line(obj,cNr);
         }
      }

      fclose(fh);
   }

   return;
}