/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWDEFAULT_H
#define _XWDEFAULT_H

#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>

/* Default Size */
#ifndef xwgSizeX
#define xwgSizeX        690;
#endif
#ifndef xwgSizeY
#define xwgSizeY        534;
#endif

#ifndef xwgReset
#define xwgReset        12345678
#endif
#ifndef xwgWidth
#define xwgWidth        0
#endif
#ifndef xwgHeight
#define xwgHeight       1
#endif
#ifndef xwgVersion
#define xwgVersion      2
#endif
#ifndef xwgWinPos
#define xwgWinPos       3
#endif
#ifndef xwgPicViewer
#define xwgPicViewer    4
#endif
#ifndef xwgOneLiner
#define xwgOneLiner     5
#endif
#ifndef xwgLayerXPos
#define xwgLayerXPos    6
#endif
#ifndef xwgLayerYPos
#define xwgLayerYPos    7
#endif
#ifndef xwgLayer
#define xwgLayer        8
#endif
#ifndef xwgMM
#define xwgMM           9
#endif
#ifndef xwgGUI
#define xwgGUI          10
#endif
#ifndef xwgWYSIWYG
#define xwgWYSIWYG      11
#endif
#ifndef xwgImgQuality
#define xwgImgQuality   12
#endif
#ifndef xwgDepth
#define xwgDepth        13
#endif
#ifndef xwgConvert
#define xwgConvert      14
#endif
#ifndef xwgScalling
#define xwgScalling     15
#endif
/* deactivated */
#ifndef xwgUsermode
#define xwgUsermode     16
#endif

#ifndef xwgAssistent
#define xwgAssistent    17
#endif

#ifndef xwgEnc
#define xwgEnc          18
#endif
#ifndef xwgAFM
#define xwgAFM          19
#endif
#ifndef xwgType1
#define xwgType1        20
#endif 
#ifndef xwgEncFile
#define xwgEncFile      21
#endif

#ifndef xwgFrameSet
#define xwgFrameSet     22
#endif

#ifndef xwgBrowserPath  
#define xwgBrowserPath  23
#endif

#ifndef xwgExpert
#define xwgExpert       24
#endif

#ifndef xwgAssLock
#define xwgAssLock      25
#endif

#ifndef xwgMTInk
#define xwgMTInk        26
#endif


#ifndef xwgPrinter
#define xwgPrinter      1000
#endif

typedef struct defaults
{
   int            xwVersion;
   int            xwWidth;
   int            xwHeight;

   /* Layer-Position */
   int            xwLayerXPos;
   int            xwLayerYPos;
   int            xwLayer;

   /* 0 = mm / 1 = 1/10 mm */
   int            xwMM;
   
   /* 0 = GUI A Textbased / 1 = GUI B Iconbased */
   int            xwGUI;

   /* 0 = Mouse orientate / 1 = Center Window */
   int            xwWinPos;

   /* 0 = OneLiner Off / 1 = OneLiner On */
   int            xwOneLiner;

   /* 0 = WYSIWYG Off / 1 = WYSIWYG On */
   int            xwWYSIWYG;


   char           xwPicViewer[1024];

   char           xwPrinter[128];

   /* Image Quality - Lowest 1 <---> 5 Highest */
   int            xwImgQuality;

   /* Display Depth */
   int            xwDepth;

   /* Converter / 0 - ImageMagic / 1 - nconvert */
   int            xwConvert;

   /* Scalling / 0 - Pixel Sampling / 1 - Interpolation for Scale Uo Process */
   int            xwScalling;

   /* Usermode / 0 - Anfnger / 1 - Fortgeschrittener / 2 - Experte */
   int            xwUsermode;
   
   /* StartUp with Assistent */
   int            xwAssistent;
   
   /* Type1 Datas */
   char           xwEnc[1024];
   char           xwAFM[1024];
   char           xwType1[1024];
   
   /* Enc File */
   char           xwEncFile[1024];

   /* FrameSet */
   char           xwFrameSet[1024];

   /* BrowserPath */
   char           xwBrowserPath[1024];

   /* Expert Mode */
   int            xwExpert;

   /* Assistent Lock */
   int            xwAssLock;

   /* MTInk Path */
   char           xwMTInk[1024];

} defaults;


/* Get Pref Value */
int xwGetPrefValue(int ID);
/* Set Pref Value */
void xwSetPrefValue(int ID,int value);
/* Get Pref Name */
char *xwGetPrefName(int ID);
/* Set Pref Name */
void xwSetPrefName(int ID,const char *name);


#endif