/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "default.h"

#include "main.h"
#include "resource.h"

static struct defaults df;

/* Get Pref Value */
int xwGetPrefValue(int ID) /*fold00*/
{
   /* xwgWidth */
   if (ID==xwgWidth) return(df.xwWidth);
   /* xwgHeight */
   else if (ID==xwgHeight) return(df.xwHeight);
   /* xwgVersion */
   else if (ID==xwgVersion) return(df.xwVersion);
   /* xwgWinPos */
   else if (ID==xwgWinPos) return(df.xwWinPos);
   /* xwgOneLiner */
   else if (ID==xwgOneLiner) return(df.xwOneLiner);
   /* xwgLayerXPos */
   else if (ID==xwgLayerXPos) return(df.xwLayerXPos);
   /* xwgLayerYPos */
   else if (ID==xwgLayerYPos) return(df.xwLayerYPos);
   /* xwgLayer */
   else if (ID==xwgLayer) return(df.xwLayer);
   /* xwgMM */
   else if (ID==xwgMM) return(df.xwMM);
   /* xwgGUI */
   else if (ID==xwgGUI) return(df.xwGUI);
   /* xwgWYSIWYG */
   else if (ID==xwgWYSIWYG) return(df.xwWYSIWYG);
   /* xwgImgQuality */
   else if (ID==xwgImgQuality) return(df.xwImgQuality);
   /* xwgDepth */
   else if (ID==xwgDepth) return(df.xwDepth);
   /* xwgConvert */
   else if (ID==xwgConvert) return(df.xwConvert);
   /* xwgScalling */
   else if (ID==xwgScalling) return(df.xwScalling);
   /* xwgUsermode */
   else if (ID==xwgUsermode) return(df.xwUsermode);
   /* xwgAssistent */
   else if (ID==xwgAssistent) return(df.xwAssistent);
   /* xwgExpert */
   else if (ID==xwgExpert) return(df.xwExpert);
   /* xwgAssLock */
   else if (ID==xwgAssLock) return(df.xwAssLock);

   return(-1);
};

/* Set Pref Value */
void xwSetPrefValue(int ID,int value) /*fold00*/
{
   /* xwgReset */
   if (ID==xwgReset)
   {
      df.xwWidth=xwgSizeX;
      df.xwHeight=xwgSizeY;
      df.xwVersion=xwInfoC;
      df.xwWinPos=0;
      df.xwOneLiner=0;
      df.xwLayerXPos=0;
      df.xwLayerYPos=0;
      df.xwLayer=0;
      df.xwMM=10;                /* 1 = mm / 10 = 1/10 mm */
      df.xwGUI=0;
      df.xwWYSIWYG=0;            /* Mormal Display Mode */
      df.xwImgQuality=5;         /* Highest Quality ( 216 Colors ) */
      df.xwConvert=0;            /* Converter / 0 - ImageMagic / 1 - nconvert */
      df.xwScalling=0;           /* Scalling / 0 - Pixel Sampling / 1 - Interpolation */
      df.xwUsermode=0;           /* Usermode / 0 - Anfnger / 1 - Fortgeschrittener / 2 - Experte */
      df.xwAssistent=0;          /* Assistent on StartUp / 0 - Yes / 1 - No */
      df.xwExpert=0;             /* Expertmode / 0 - aus / 1- eingeschaltet */
      df.xwAssLock=0;            /* Lock Assistent / 0 -aus / 1- - eingeschaltet */
   }
   /* xwgWidth */
   else if (ID==xwgWidth) df.xwWidth=value;
   /* xwgHeight */
   else if (ID==xwgHeight) df.xwHeight=value;
   /* xwgVersion */
   else if (ID==xwgVersion) df.xwVersion=value;
   /* xwgWinPos */
   else if (ID==xwgWinPos) df.xwWinPos=value;
   /* xwgOneLiner */
   else if (ID==xwgOneLiner) df.xwOneLiner=value;
   /* xwgLayerXPos */
   else if (ID==xwgLayerXPos) df.xwLayerXPos=value;
   /* xwgLayerYPos */
   else if (ID==xwgLayerYPos) df.xwLayerYPos=value;
   /* xwgLayer */
   else if (ID==xwgLayer) df.xwLayer=value;
   /* xwgMM */
   else if (ID==xwgMM) df.xwMM=value;
   /* xwgGUI */
   else if (ID==xwgGUI) df.xwGUI=value;
   /* xwgWYSIWYG */
   else if (ID==xwgWYSIWYG) df.xwWYSIWYG=value;
   /* xwgImgQuality */
   else if (ID==xwgImgQuality) df.xwImgQuality=value;
   /* xwgDepth */
   else if (ID==xwgDepth) df.xwDepth=value;
   /* xwgConvert */
   else if (ID==xwgConvert) df.xwConvert=value;
   /* xwgScalling */
   else if (ID==xwgScalling) df.xwScalling=value;
   /* xwgUsermode */
   else if (ID==xwgUsermode) df.xwUsermode=value;
   /* xwgAssistent */
   else if (ID==xwgAssistent) df.xwAssistent=value;
   /* xwgExpert */
   else if (ID==xwgExpert) df.xwExpert=value;
   /* xwgAssLock */
   else if (ID==xwgAssLock) df.xwAssLock=value;

   return;
}

/* Get Pref Name */
char *xwGetPrefName(int ID) /*fold00*/
{
   /* xwgPrinter */
   if (ID==xwgPrinter) return(df.xwPrinter);
   /* xwgPicViewer */
   else if (ID==xwgPicViewer) return(df.xwPicViewer);
   /* xwgEnc */
   else if (ID==xwgEnc) return(df.xwEnc);
   /* xwgAFM */
   else if (ID==xwgAFM) return(df.xwAFM);
   /* xwgType1 */
   else if (ID==xwgType1) return(df.xwType1);
   /* xwgEncFile */
   else if (ID==xwgEncFile) return(df.xwEncFile);
   /* xwgFrameSet */
   else if (ID==xwgFrameSet) return(df.xwFrameSet);
   /* xwgBrowserPath */
   else if (ID==xwgBrowserPath) return(df.xwBrowserPath);
   /* xwgMTInk */
   else if (ID==xwgMTInk) return(df.xwMTInk);

   return("");
};

/* Set Pref Name */
void xwSetPrefName(int ID,const char *name) /*fold00*/
{
   /* xwgReset */
   if (ID==xwgReset)
   {

      strcpy(df.xwPicViewer,"xv");
      strcpy(df.xwPrinter,"");
      strcpy(df.xwEnc,xwGetIP("Encoding"));
      strcpy(df.xwAFM,"/usr/X11R6/lib/X11/fonts/Type1");
      strcpy(df.xwType1,"/usr/X11R6/lib/X11/fonts/Type1");
      strcpy(df.xwEncFile,"IsoLatin1.enc");
      strcpy(df.xwFrameSet,"");
      strcpy(df.xwBrowserPath,"");
      strcpy(df.xwMTInk,"");
   }

   /*
   if (strlen(name)>0)
   {
   */
      /* xwgPicViewer */
      if ( (ID==xwgPicViewer) && (strlen(name)<1024) ) strcpy(df.xwPicViewer,name);
      /* xwgPrinter */
      else if ( (ID==xwgPrinter) && (strlen(name)<128) ) strcpy(df.xwPrinter,name);
      /* xwgEnc */
      else if ( (ID==xwgEnc) && (strlen(name)<1024) ) strcpy(df.xwEnc,name);
      /* xwgAFM */
      else if ( (ID==xwgAFM) && (strlen(name)<1024) ) strcpy(df.xwAFM,name);
      /* xwgType1 */
      else if ( (ID==xwgType1) && (strlen(name)<1024) ) strcpy(df.xwType1,name);
      /* xwgEncFile */
      else if ( (ID==xwgEncFile) && (strlen(name)<1024) ) strcpy(df.xwEncFile,name);
      /* xwgFrameSet */
      else if ( (ID==xwgFrameSet) && (strlen(name)<1024) ) strcpy(df.xwFrameSet,name);
      /* xwgBrowserPath */
      else if ( (ID==xwgBrowserPath) && (strlen(name)<1024) ) strcpy(df.xwBrowserPath,name);
      /* xwgMTInk */
      else if ( (ID==xwgMTInk) && (strlen(name)<1024) ) strcpy(df.xwMTInk,name);
      

   /*
   }
   */

   return;
}

