/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWCOLOR_H
#define _XWCOLOR_H

#include <forms.h>

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#define getRed          0
#define getGreen        1
#define getBlue         2

typedef struct colorform
{
   FL_FORM           *form;
   FL_OBJECT         *obj;
   int               ready;

   FL_OBJECT         *Frame;

   FL_OBJECT         *OK;

   FL_OBJECT         *red;
   FL_OBJECT         *green;
   FL_OBJECT         *blue;

   FL_OBJECT         *redv;
   FL_OBJECT         *greenv;
   FL_OBJECT         *bluev;

   FL_OBJECT         *color;

   FL_OBJECT         *col[16];

   FL_OBJECT         *colMem;
} colorform;

int xwColorMixer(FL_FORM *form,int col,int rgb);
/* Get RGB Value */
int xwGetRGBV(int R,int G,int B);
/* Split RGB Value */
void xwSplitRGBV(int rgbv);
/* Get RGB Split Value */
int xwGetRGBSV(int mo);
/* Set RGB Value */
void xwSetRGBC(int no,int rgbv);




#endif