/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "color.h"

#include "base.h"
#include "default.h"
#include "handler.h"
#include "main_gui.h"
#include "resource.h"

static colorform     ed;

static int           redMem=0;
static int           greenMem=0;
static int           blueMem=0;

static int           red;
static int           green;
static int           blue;

int xwColorMixer(FL_FORM *form,int col,int rgbv)
{
   int            rgb;
   int            R,G,B;
   char           astr[256];
   int            az,bz;

   /* split RGB Value */
   rgb=rgbv;

   R=rgb/65536;
   rgb=rgb-(R*65536);
   G=rgb/256;
   rgb=rgb-(G*256);
   B=rgb;

   /* deactivate form */
   if (form!=NULL) fl_deactivate_form(form);

   ed.form = fl_bgn_form(FL_UP_BOX,300,106+24);
   fl_set_border_width(1);

   ed.Frame = fl_add_frame(FL_DOWN_FRAME,6,6,288,70+24,"");

   ed.OK = fl_add_button(FL_NORMAL_BUTTON,10,81+24,280,20,xwGR(1,"ed.OK","OK"));

   ed.red = fl_add_slider(FL_HOR_FILL_SLIDER,10,10,200,20,"");
   fl_set_object_color(ed.red,FL_INDIANRED,FL_RED);
   fl_set_slider_value(ed.red,(double) R/255);

   ed.redv = fl_add_input(FL_INT_INPUT,210,10,40,20,"");
   fl_set_input_maxchars(ed.redv,3);
   fl_set_input_return(ed.redv,FL_RETURN_CHANGED);
   fl_set_input(ed.redv,IntStr(R));

   ed.green = fl_add_slider(FL_HOR_FILL_SLIDER,10,30,200,20,"");
   fl_set_object_color(ed.green,FL_PALEGREEN,FL_GREEN);
   fl_set_slider_value(ed.green,(double) G/255);

   ed.greenv = fl_add_input(FL_INT_INPUT,210,30,40,20,"");
   fl_set_input_maxchars(ed.greenv,3);
   fl_set_input_return(ed.greenv,FL_RETURN_CHANGED);
   fl_set_input(ed.greenv,IntStr(G));

   ed.blue = fl_add_slider(FL_HOR_FILL_SLIDER,10,50,200,20,"");
   fl_set_object_color(ed.blue,FL_SLATEBLUE,FL_BLUE);
   fl_set_slider_value(ed.blue,(double) B/255);

   ed.bluev = fl_add_input(FL_INT_INPUT,210,50,40,20,"");
   fl_set_input_maxchars(ed.bluev,3);
   fl_set_input_return(ed.bluev,FL_RETURN_CHANGED);
   fl_set_input(ed.bluev,IntStr(B));

   ed.color = fl_add_box(FL_BORDER_BOX,250,10,40,60,"");
   fl_set_object_color(ed.color,col,col);
   fl_mapcolor(col,R,G,B);

   /* Color Defaults 230 */
   ed.col[0] = fl_add_button(FL_NORMAL_BUTTON,10,74,15,20,"");
   fl_set_object_color(ed.col[0],FL_INDIANRED,FL_INDIANRED);
   ed.col[1] = fl_add_button(FL_NORMAL_BUTTON,25,74,15,20,"");
   fl_set_object_color(ed.col[1],FL_RED,FL_RED);
   ed.col[2] = fl_add_button(FL_NORMAL_BUTTON,40,74,15,20,"");
   fl_set_object_color(ed.col[2],FL_PALEGREEN,FL_PALEGREEN);
   ed.col[3] = fl_add_button(FL_NORMAL_BUTTON,55,74,15,20,"");
   fl_set_object_color(ed.col[3],FL_GREEN,FL_GREEN);
   ed.col[4] = fl_add_button(FL_NORMAL_BUTTON,70,74,15,20,"");
   fl_set_object_color(ed.col[4],FL_SLATEBLUE,FL_SLATEBLUE);
   ed.col[5] = fl_add_button(FL_NORMAL_BUTTON,85,74,15,20,"");
   fl_set_object_color(ed.col[5],FL_BLUE,FL_BLUE);
   ed.col[6] = fl_add_button(FL_NORMAL_BUTTON,100,74,15,20,"");
   fl_set_object_color(ed.col[6],FL_DARKCYAN,FL_DARKCYAN);
   ed.col[7] = fl_add_button(FL_NORMAL_BUTTON,115,74,15,20,"");
   fl_set_object_color(ed.col[7],FL_CYAN,FL_CYAN);
   ed.col[8] = fl_add_button(FL_NORMAL_BUTTON,130,74,15,20,"");
   fl_set_object_color(ed.col[8],FL_WHEAT,FL_WHEAT);
   ed.col[9] = fl_add_button(FL_NORMAL_BUTTON,145,74,15,20,"");
   fl_set_object_color(ed.col[9],FL_YELLOW,FL_YELLOW);
   ed.col[10] = fl_add_button(FL_NORMAL_BUTTON,160,74,15,20,"");
   fl_set_object_color(ed.col[10],FL_ORCHID,FL_ORCHID);
   ed.col[11] = fl_add_button(FL_NORMAL_BUTTON,175,74,15,20,"");
   fl_set_object_color(ed.col[11],FL_MAGENTA,FL_MAGENTA);
   ed.col[12] = fl_add_button(FL_NORMAL_BUTTON,190,74,15,20,"");
   fl_set_object_color(ed.col[12],FL_BLACK,FL_BLACK);
   ed.col[13] = fl_add_button(FL_NORMAL_BUTTON,205,74,15,20,"");
   fl_set_object_color(ed.col[13],FL_INACTIVE_COL,FL_INACTIVE_COL); /* 180 */
   ed.col[14] = fl_add_button(FL_NORMAL_BUTTON,220,74,15,20,"");
   fl_set_object_color(ed.col[14],FL_COL1,FL_COL1); /* 204 */
   ed.col[15] = fl_add_button(FL_NORMAL_BUTTON,235,74,15,20,"");
   fl_set_object_color(ed.col[15],FL_WHITE,FL_WHITE);

   ed.colMem = fl_add_button(FL_NORMAL_BUTTON,250,74,40,20,"");
   fl_set_object_color(ed.colMem,col+10,col+1);
   fl_mapcolor(col+10,redMem,greenMem,blueMem);

   fl_end_form();

   if (xwGetPrefValue(xwgWinPos)==0)
   {
      fl_prepare_form_window(ed.form,FL_PLACE_MOUSE,FL_TRANSIENT,"Color-Editor");
   }
   else
   {
      fl_prepare_form_window(ed.form,FL_PLACE_CENTER,FL_TRANSIENT,"Color-Editor");
   }

   fl_set_form_dblbuffer(ed.form,0);
   fl_show_form_window(ed.form);

   fl_set_app_mainform(ed.form);

   /* Exit Handler */
   fl_set_form_atclose(ed.form,nclose_cb,(void *) "1");

   ed.ready=0;
   while (ed.ready==0)
   {
      ed.obj=fl_do_forms();

      /* OK */
      if (ed.obj==ed.OK)
      {
         redMem=R;
         greenMem=G;
         blueMem=B;

         ed.ready=1;
      }

      /* Color Selection */
      else if ( (ed.obj == ed.red) || (ed.obj == ed.green) || (ed.obj == ed.blue) )
      {
         R=(255*fl_get_slider_value(ed.red));
         G=(255*fl_get_slider_value(ed.green));
         B=(255*fl_get_slider_value(ed.blue));
         fl_mapcolor(col,R,G,B);
         fl_redraw_object(ed.color);

         fl_set_input(ed.redv,IntStr(R));
         fl_set_input(ed.greenv,IntStr(G));
         fl_set_input(ed.bluev,IntStr(B));
      }

      /* RGB Input */
      else if (ed.obj==ed.redv)
      {
         strcpy(astr,fl_get_input(ed.redv));
         R=atoi(astr);
         if (R<0) R=0;
         else if (R>255) R=255;
         fl_mapcolor(col,R,G,B);
         fl_redraw_object(ed.color);
         fl_set_input(ed.redv,IntStr(R));
         fl_set_slider_value(ed.red,(double) R/255);
      }
      else if (ed.obj==ed.greenv)
      {
         strcpy(astr,fl_get_input(ed.greenv));
         G=atoi(astr);
         if (G<0) G=0;
         else if (G>255) G=255;
         fl_mapcolor(col,R,G,B);
         fl_redraw_object(ed.color);
         fl_set_input(ed.greenv,IntStr(G));
         fl_set_slider_value(ed.green,(double) G/255);
      }
      else if (ed.obj==ed.bluev)
      {
         strcpy(astr,fl_get_input(ed.bluev));
         B=atoi(astr);
         if (B<0) B=0;
         else if (B>255) B=255;
         fl_mapcolor(col,R,G,B);
         fl_redraw_object(ed.color);
         fl_set_input(ed.bluev,IntStr(B));
         fl_set_slider_value(ed.blue,(double) B/255);
      }
      else if (ed.obj==ed.colMem)
      {
         R=redMem;
         G=greenMem;
         B=blueMem;

         fl_mapcolor(col,R,G,B);
         fl_redraw_object(ed.color);
         fl_set_input(ed.redv,IntStr(R));
         fl_set_input(ed.greenv,IntStr(G));
         fl_set_input(ed.bluev,IntStr(B));
         fl_set_slider_value(ed.red,(double) R/255);
         fl_set_slider_value(ed.green,(double) G/255);
         fl_set_slider_value(ed.blue,(double) B/255);
      }
      else
      {
         bz=-1;
         for (az=0 ; az<16 ; az++)
         {
            if (ed.obj==ed.col[az]) bz=az;
         }

         if (bz>-1)
         {
            if      (bz== 0) { R=198; G=113; B=113; }
            else if (bz== 1) { R=255; G=  0; B=  0; }
            else if (bz== 2) { R=113; G=198; B=113; }
            else if (bz== 3) { R=  0; G=255; B=  0; }
            else if (bz== 4) { R=113; G=113; B=198; }
            else if (bz== 5) { R=  0; G=  0; B=255; }
            else if (bz== 6) { R= 40; G=170; B=175; }
            else if (bz== 7) { R=  0; G=255; B=255; }
            else if (bz== 8) { R=255; G=231; B=155; }
            else if (bz== 9) { R=255; G=255; B=  0; }
            else if (bz==10) { R=205; G=105; B=201; }
            else if (bz==11) { R=255; G=  0; B=255; }
            else if (bz==12) { R=  0; G=  0; B=  0; }
            else if (bz==13) { R=180; G=180; B=180; }
            else if (bz==14) { R=204; G=204; B=204; }
            else if (bz==15) { R=255; G=255; B=255; }

            fl_mapcolor(col,R,G,B);
            fl_redraw_object(ed.color);
            fl_set_input(ed.redv,IntStr(R));
            fl_set_input(ed.greenv,IntStr(G));
            fl_set_input(ed.bluev,IntStr(B));
            fl_set_slider_value(ed.red,(double) R/255);
            fl_set_slider_value(ed.green,(double) G/255);
            fl_set_slider_value(ed.blue,(double) B/255);
         }
      }
   }

   fl_hide_form(ed.form);
   fl_free_form(ed.form);

   ed.form=NULL;

   /* activate form */
   if (form!=NULL) fl_activate_form(form);

   xwAppMainGui();

   /* calculate RGB Value */
   rgb=(R*65536)+(G*256)+B;

   return(rgb);
}

/* Get RGB Value */
int xwGetRGBV(int R,int G,int B)
{
   int      rgb;

   rgb=(R*65536)+(G*256)+B;

   return(rgb);
}

/* Split RGB Value */
void xwSplitRGBV(int rgbv)
{
   int      rgb;

   rgb=rgbv;

   red=rgb/65536;
   rgb=rgb-(red*65536);
   green=rgb/256;
   rgb=rgb-(green*256);
   blue=rgb;

   return;
}

/* Get RGB Split Value */
int xwGetRGBSV(int mo)
{
   if (mo==getRed) return(red);
   else if (mo==getGreen) return(green);
   else if (mo==getBlue) return(blue);

   return(0);
}

/* Set RGB Value */
void xwSetRGBC(int no,int rgbv)
{
   int      rgb;
   int      R,G,B;

   rgb=rgbv;

   R=rgb/65536;
   rgb=rgb-(R*65536);
   G=rgb/256;
   rgb=rgb-(G*256);
   B=rgb;

   fl_mapcolor(no,R,G,B);

   return;
}
